package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VpcId,
  SecurityGroupId,
  Integer,
  ClientVpnEndpointId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClientVpnEndpointRequest(
    clientVpnEndpointId: ClientVpnEndpointId,
    serverCertificateArn: Option[String] = None,
    connectionLogOptions: Option[zio.aws.ec2.model.ConnectionLogOptions] = None,
    dnsServers: Option[zio.aws.ec2.model.DnsServersOptionsModifyStructure] =
      None,
    vpnPort: Option[Integer] = None,
    description: Option[String] = None,
    splitTunnel: Option[Boolean] = None,
    securityGroupIds: Option[Iterable[SecurityGroupId]] = None,
    vpcId: Option[VpcId] = None,
    selfServicePortal: Option[zio.aws.ec2.model.SelfServicePortal] = None,
    clientConnectOptions: Option[zio.aws.ec2.model.ClientConnectOptions] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest = {
    import ModifyClientVpnEndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
      .builder()
      .clientVpnEndpointId(
        ClientVpnEndpointId.unwrap(clientVpnEndpointId): java.lang.String
      )
      .optionallyWith(
        serverCertificateArn.map(value => value: java.lang.String)
      )(_.serverCertificateArn)
      .optionallyWith(connectionLogOptions.map(value => value.buildAwsValue()))(
        _.connectionLogOptions
      )
      .optionallyWith(dnsServers.map(value => value.buildAwsValue()))(
        _.dnsServers
      )
      .optionallyWith(
        vpnPort.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.vpnPort)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(splitTunnel.map(value => value: java.lang.Boolean))(
        _.splitTunnel
      )
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(selfServicePortal.map(value => value.unwrap))(
        _.selfServicePortal
      )
      .optionallyWith(clientConnectOptions.map(value => value.buildAwsValue()))(
        _.clientConnectOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly =
    zio.aws.ec2.model.ModifyClientVpnEndpointRequest.wrap(buildAwsValue())
}
object ModifyClientVpnEndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ModifyClientVpnEndpointRequest =
      zio.aws.ec2.model.ModifyClientVpnEndpointRequest(
        clientVpnEndpointId,
        serverCertificateArn.map(value => value),
        connectionLogOptions.map(value => value.asEditable),
        dnsServers.map(value => value.asEditable),
        vpnPort.map(value => value),
        description.map(value => value),
        splitTunnel.map(value => value),
        securityGroupIds.map(value => value),
        vpcId.map(value => value),
        selfServicePortal.map(value => value),
        clientConnectOptions.map(value => value.asEditable)
      )
    def clientVpnEndpointId: ClientVpnEndpointId
    def serverCertificateArn: Option[String]
    def connectionLogOptions
        : Option[zio.aws.ec2.model.ConnectionLogOptions.ReadOnly]
    def dnsServers
        : Option[zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly]
    def vpnPort: Option[Integer]
    def description: Option[String]
    def splitTunnel: Option[Boolean]
    def securityGroupIds: Option[List[SecurityGroupId]]
    def vpcId: Option[VpcId]
    def selfServicePortal: Option[zio.aws.ec2.model.SelfServicePortal]
    def clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectOptions.ReadOnly]
    def getClientVpnEndpointId: ZIO[Any, Nothing, ClientVpnEndpointId] =
      ZIO.succeed(clientVpnEndpointId)
    def getServerCertificateArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serverCertificateArn", serverCertificateArn)
    def getConnectionLogOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] =
      AwsError.unwrapOptionField("connectionLogOptions", connectionLogOptions)
    def getDnsServers: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly
    ] = AwsError.unwrapOptionField("dnsServers", dnsServers)
    def getVpnPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("vpnPort", vpnPort)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getSplitTunnel: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("splitTunnel", splitTunnel)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSelfServicePortal
        : ZIO[Any, AwsError, zio.aws.ec2.model.SelfServicePortal] =
      AwsError.unwrapOptionField("selfServicePortal", selfServicePortal)
    def getClientConnectOptions
        : ZIO[Any, AwsError, zio.aws.ec2.model.ClientConnectOptions.ReadOnly] =
      AwsError.unwrapOptionField("clientConnectOptions", clientConnectOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ) extends zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly {
    override val clientVpnEndpointId: ClientVpnEndpointId =
      zio.aws.ec2.model.primitives
        .ClientVpnEndpointId(impl.clientVpnEndpointId())
    override val serverCertificateArn: Option[String] =
      scala.Option(impl.serverCertificateArn()).map(value => value: String)
    override val connectionLogOptions
        : Option[zio.aws.ec2.model.ConnectionLogOptions.ReadOnly] = scala
      .Option(impl.connectionLogOptions())
      .map(value => zio.aws.ec2.model.ConnectionLogOptions.wrap(value))
    override val dnsServers
        : Option[zio.aws.ec2.model.DnsServersOptionsModifyStructure.ReadOnly] =
      scala
        .Option(impl.dnsServers())
        .map(value =>
          zio.aws.ec2.model.DnsServersOptionsModifyStructure.wrap(value)
        )
    override val vpnPort: Option[Integer] = scala
      .Option(impl.vpnPort())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val splitTunnel: Option[Boolean] =
      scala.Option(impl.splitTunnel()).map(value => value: Boolean)
    override val securityGroupIds: Option[List[SecurityGroupId]] = scala
      .Option(impl.securityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.primitives.SecurityGroupId(item)
        }.toList
      )
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
    override val selfServicePortal
        : Option[zio.aws.ec2.model.SelfServicePortal] = scala
      .Option(impl.selfServicePortal())
      .map(value => zio.aws.ec2.model.SelfServicePortal.wrap(value))
    override val clientConnectOptions
        : Option[zio.aws.ec2.model.ClientConnectOptions.ReadOnly] = scala
      .Option(impl.clientConnectOptions())
      .map(value => zio.aws.ec2.model.ClientConnectOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ModifyClientVpnEndpointRequest
  ): zio.aws.ec2.model.ModifyClientVpnEndpointRequest.ReadOnly = new Wrapper(
    impl
  )
}
