package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateTagSpecificationRequest(
    resourceType: Option[zio.aws.ec2.model.ResourceType] = None,
    tags: Option[Iterable[zio.aws.ec2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest = {
    import LaunchTemplateTagSpecificationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateTagSpecificationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest =
      zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest(
        resourceType.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceType: Option[zio.aws.ec2.model.ResourceType]
    def tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]]
    def getResourceType: ZIO[Any, AwsError, zio.aws.ec2.model.ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ec2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest
  ) extends zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly {
    override val resourceType: Option[zio.aws.ec2.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ec2.model.ResourceType.wrap(value))
    override val tags: Option[List[zio.aws.ec2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateTagSpecificationRequest
  ): zio.aws.ec2.model.LaunchTemplateTagSpecificationRequest.ReadOnly =
    new Wrapper(impl)
}
