package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LaunchTemplateLicenseConfigurationRequest(
    licenseConfigurationArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest = {
    import LaunchTemplateLicenseConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest
      .builder()
      .optionallyWith(
        licenseConfigurationArn.map(value => value: java.lang.String)
      )(_.licenseConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly =
    zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest
      .wrap(buildAwsValue())
}
object LaunchTemplateLicenseConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest =
      zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest(
        licenseConfigurationArn.map(value => value)
      )
    def licenseConfigurationArn: Option[String]
    def getLicenseConfigurationArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("licenseConfigurationArn", licenseConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest
  ) extends zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly {
    override val licenseConfigurationArn: Option[String] =
      scala.Option(impl.licenseConfigurationArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.LaunchTemplateLicenseConfigurationRequest
  ): zio.aws.ec2.model.LaunchTemplateLicenseConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
