package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FleetSpotMaintenanceStrategies(
    capacityRebalance: Option[zio.aws.ec2.model.FleetSpotCapacityRebalance] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategies = {
    import FleetSpotMaintenanceStrategies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategies
      .builder()
      .optionallyWith(capacityRebalance.map(value => value.buildAwsValue()))(
        _.capacityRebalance
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.FleetSpotMaintenanceStrategies.ReadOnly =
    zio.aws.ec2.model.FleetSpotMaintenanceStrategies.wrap(buildAwsValue())
}
object FleetSpotMaintenanceStrategies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.FleetSpotMaintenanceStrategies =
      zio.aws.ec2.model.FleetSpotMaintenanceStrategies(
        capacityRebalance.map(value => value.asEditable)
      )
    def capacityRebalance
        : Option[zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly]
    def getCapacityRebalance: ZIO[
      Any,
      AwsError,
      zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly
    ] = AwsError.unwrapOptionField("capacityRebalance", capacityRebalance)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategies
  ) extends zio.aws.ec2.model.FleetSpotMaintenanceStrategies.ReadOnly {
    override val capacityRebalance
        : Option[zio.aws.ec2.model.FleetSpotCapacityRebalance.ReadOnly] = scala
      .Option(impl.capacityRebalance())
      .map(value => zio.aws.ec2.model.FleetSpotCapacityRebalance.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.FleetSpotMaintenanceStrategies
  ): zio.aws.ec2.model.FleetSpotMaintenanceStrategies.ReadOnly = new Wrapper(
    impl
  )
}
