package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.DateTime
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ElasticInferenceAcceleratorAssociation(
    elasticInferenceAcceleratorArn: Option[String] = None,
    elasticInferenceAcceleratorAssociationId: Option[String] = None,
    elasticInferenceAcceleratorAssociationState: Option[String] = None,
    elasticInferenceAcceleratorAssociationTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation = {
    import ElasticInferenceAcceleratorAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
      .builder()
      .optionallyWith(
        elasticInferenceAcceleratorArn.map(value => value: java.lang.String)
      )(_.elasticInferenceAcceleratorArn)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationId.map(value =>
          value: java.lang.String
        )
      )(_.elasticInferenceAcceleratorAssociationId)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationState.map(value =>
          value: java.lang.String
        )
      )(_.elasticInferenceAcceleratorAssociationState)
      .optionallyWith(
        elasticInferenceAcceleratorAssociationTime.map(value =>
          DateTime.unwrap(value): Instant
        )
      )(_.elasticInferenceAcceleratorAssociationTime)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly =
    zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation
      .wrap(buildAwsValue())
}
object ElasticInferenceAcceleratorAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation =
      zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation(
        elasticInferenceAcceleratorArn.map(value => value),
        elasticInferenceAcceleratorAssociationId.map(value => value),
        elasticInferenceAcceleratorAssociationState.map(value => value),
        elasticInferenceAcceleratorAssociationTime.map(value => value)
      )
    def elasticInferenceAcceleratorArn: Option[String]
    def elasticInferenceAcceleratorAssociationId: Option[String]
    def elasticInferenceAcceleratorAssociationState: Option[String]
    def elasticInferenceAcceleratorAssociationTime: Option[DateTime]
    def getElasticInferenceAcceleratorArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "elasticInferenceAcceleratorArn",
        elasticInferenceAcceleratorArn
      )
    def getElasticInferenceAcceleratorAssociationId
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationId",
      elasticInferenceAcceleratorAssociationId
    )
    def getElasticInferenceAcceleratorAssociationState
        : ZIO[Any, AwsError, String] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationState",
      elasticInferenceAcceleratorAssociationState
    )
    def getElasticInferenceAcceleratorAssociationTime
        : ZIO[Any, AwsError, DateTime] = AwsError.unwrapOptionField(
      "elasticInferenceAcceleratorAssociationTime",
      elasticInferenceAcceleratorAssociationTime
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ) extends zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly {
    override val elasticInferenceAcceleratorArn: Option[String] = scala
      .Option(impl.elasticInferenceAcceleratorArn())
      .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationId: Option[String] =
      scala
        .Option(impl.elasticInferenceAcceleratorAssociationId())
        .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationState: Option[String] =
      scala
        .Option(impl.elasticInferenceAcceleratorAssociationState())
        .map(value => value: String)
    override val elasticInferenceAcceleratorAssociationTime: Option[DateTime] =
      scala
        .Option(impl.elasticInferenceAcceleratorAssociationTime())
        .map(value => zio.aws.ec2.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.ElasticInferenceAcceleratorAssociation
  ): zio.aws.ec2.model.ElasticInferenceAcceleratorAssociation.ReadOnly =
    new Wrapper(impl)
}
