package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.VpcId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DisableVpcClassicLinkDnsSupportRequest(
    vpcId: Option[VpcId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest = {
    import DisableVpcClassicLinkDnsSupportRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest
      .builder()
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest.ReadOnly =
    zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest
      .wrap(buildAwsValue())
}
object DisableVpcClassicLinkDnsSupportRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest =
      zio.aws.ec2.model
        .DisableVpcClassicLinkDnsSupportRequest(vpcId.map(value => value))
    def vpcId: Option[VpcId]
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest
  ) extends zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest.ReadOnly {
    override val vpcId: Option[VpcId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.ec2.model.primitives.VpcId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DisableVpcClassicLinkDnsSupportRequest
  ): zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest.ReadOnly =
    new Wrapper(impl)
}
