package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpnConnectionsResponse(
    vpnConnections: Option[Iterable[zio.aws.ec2.model.VpnConnection]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse = {
    import DescribeVpnConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse
      .builder()
      .optionallyWith(
        vpnConnections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.vpnConnections)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpnConnectionsResponse.wrap(buildAwsValue())
}
object DescribeVpnConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeVpnConnectionsResponse =
      zio.aws.ec2.model.DescribeVpnConnectionsResponse(
        vpnConnections.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def vpnConnections: Option[List[zio.aws.ec2.model.VpnConnection.ReadOnly]]
    def getVpnConnections
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.VpnConnection.ReadOnly]] =
      AwsError.unwrapOptionField("vpnConnections", vpnConnections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse
  ) extends zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly {
    override val vpnConnections
        : Option[List[zio.aws.ec2.model.VpnConnection.ReadOnly]] = scala
      .Option(impl.vpnConnections())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.VpnConnection.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse
  ): zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
