package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeVpcEndpointServiceConfigurationsResponse(
    serviceConfigurations: Option[
      Iterable[zio.aws.ec2.model.ServiceConfiguration]
    ] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse = {
    import DescribeVpcEndpointServiceConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse
      .builder()
      .optionallyWith(
        serviceConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serviceConfigurations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly =
    zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeVpcEndpointServiceConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse =
      zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse(
        serviceConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def serviceConfigurations
        : Option[List[zio.aws.ec2.model.ServiceConfiguration.ReadOnly]]
    def nextToken: Option[String]
    def getServiceConfigurations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.ServiceConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("serviceConfigurations", serviceConfigurations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse
  ) extends zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly {
    override val serviceConfigurations
        : Option[List[zio.aws.ec2.model.ServiceConfiguration.ReadOnly]] = scala
      .Option(impl.serviceConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ServiceConfiguration.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse
  ): zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
