package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.FleetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeFleetInstancesResponse(
    activeInstances: Option[Iterable[zio.aws.ec2.model.ActiveInstance]] = None,
    nextToken: Option[String] = None,
    fleetId: Option[FleetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse = {
    import DescribeFleetInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse
      .builder()
      .optionallyWith(
        activeInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activeInstances)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(
        fleetId.map(value => FleetId.unwrap(value): java.lang.String)
      )(_.fleetId)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly =
    zio.aws.ec2.model.DescribeFleetInstancesResponse.wrap(buildAwsValue())
}
object DescribeFleetInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeFleetInstancesResponse =
      zio.aws.ec2.model.DescribeFleetInstancesResponse(
        activeInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        fleetId.map(value => value)
      )
    def activeInstances: Option[List[zio.aws.ec2.model.ActiveInstance.ReadOnly]]
    def nextToken: Option[String]
    def fleetId: Option[FleetId]
    def getActiveInstances
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ActiveInstance.ReadOnly]] =
      AwsError.unwrapOptionField("activeInstances", activeInstances)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFleetId: ZIO[Any, AwsError, FleetId] =
      AwsError.unwrapOptionField("fleetId", fleetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse
  ) extends zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly {
    override val activeInstances
        : Option[List[zio.aws.ec2.model.ActiveInstance.ReadOnly]] = scala
      .Option(impl.activeInstances())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ActiveInstance.wrap(item)
        }.toList
      )
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
    override val fleetId: Option[FleetId] = scala
      .Option(impl.fleetId())
      .map(value => zio.aws.ec2.model.primitives.FleetId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeFleetInstancesResponse
  ): zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
