package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeElasticGpusResponse(
    elasticGpuSet: Option[Iterable[zio.aws.ec2.model.ElasticGpus]] = None,
    maxResults: Option[Integer] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse = {
    import DescribeElasticGpusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
      .builder()
      .optionallyWith(
        elasticGpuSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.elasticGpuSet)
      .optionallyWith(
        maxResults.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly =
    zio.aws.ec2.model.DescribeElasticGpusResponse.wrap(buildAwsValue())
}
object DescribeElasticGpusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.DescribeElasticGpusResponse =
      zio.aws.ec2.model.DescribeElasticGpusResponse(
        elasticGpuSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def elasticGpuSet: Option[List[zio.aws.ec2.model.ElasticGpus.ReadOnly]]
    def maxResults: Option[Integer]
    def nextToken: Option[String]
    def getElasticGpuSet
        : ZIO[Any, AwsError, List[zio.aws.ec2.model.ElasticGpus.ReadOnly]] =
      AwsError.unwrapOptionField("elasticGpuSet", elasticGpuSet)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ) extends zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly {
    override val elasticGpuSet
        : Option[List[zio.aws.ec2.model.ElasticGpus.ReadOnly]] = scala
      .Option(impl.elasticGpuSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.ElasticGpus.wrap(item)
        }.toList
      )
    override val maxResults: Option[Integer] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ec2.model.primitives.Integer(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.DescribeElasticGpusResponse
  ): zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly = new Wrapper(impl)
}
