package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateNetworkInsightsAccessScopeRequest(
    matchPaths: Option[Iterable[zio.aws.ec2.model.AccessScopePathRequest]] =
      None,
    excludePaths: Option[Iterable[zio.aws.ec2.model.AccessScopePathRequest]] =
      None,
    clientToken: String,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest = {
    import CreateNetworkInsightsAccessScopeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
      .builder()
      .optionallyWith(
        matchPaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.matchPaths)
      .optionallyWith(
        excludePaths.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludePaths)
      .clientToken(clientToken: java.lang.String)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly =
    zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest
      .wrap(buildAwsValue())
}
object CreateNetworkInsightsAccessScopeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest =
      zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest(
        matchPaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        excludePaths.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def matchPaths
        : Option[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]]
    def excludePaths
        : Option[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]]
    def clientToken: String
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getMatchPaths: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccessScopePathRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("matchPaths", matchPaths)
    def getExcludePaths: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.AccessScopePathRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("excludePaths", excludePaths)
    def getClientToken: ZIO[Any, Nothing, String] = ZIO.succeed(clientToken)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ) extends zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly {
    override val matchPaths
        : Option[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]] =
      scala
        .Option(impl.matchPaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AccessScopePathRequest.wrap(item)
          }.toList
        )
    override val excludePaths
        : Option[List[zio.aws.ec2.model.AccessScopePathRequest.ReadOnly]] =
      scala
        .Option(impl.excludePaths())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ec2.model.AccessScopePathRequest.wrap(item)
          }.toList
        )
    override val clientToken: String = impl.clientToken(): String
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ): zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest.ReadOnly =
    new Wrapper(impl)
}
