package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.{
  VersionDescription,
  LaunchTemplateName,
  LaunchTemplateId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLaunchTemplateVersionRequest(
    clientToken: Option[String] = None,
    launchTemplateId: Option[LaunchTemplateId] = None,
    launchTemplateName: Option[LaunchTemplateName] = None,
    sourceVersion: Option[String] = None,
    versionDescription: Option[VersionDescription] = None,
    launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest = {
    import CreateLaunchTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(
        launchTemplateId.map(value =>
          LaunchTemplateId.unwrap(value): java.lang.String
        )
      )(_.launchTemplateId)
      .optionallyWith(
        launchTemplateName.map(value =>
          LaunchTemplateName.unwrap(value): java.lang.String
        )
      )(_.launchTemplateName)
      .optionallyWith(sourceVersion.map(value => value: java.lang.String))(
        _.sourceVersion
      )
      .optionallyWith(
        versionDescription.map(value =>
          VersionDescription.unwrap(value): java.lang.String
        )
      )(_.versionDescription)
      .launchTemplateData(launchTemplateData.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly =
    zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.wrap(buildAwsValue())
}
object CreateLaunchTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateLaunchTemplateVersionRequest =
      zio.aws.ec2.model.CreateLaunchTemplateVersionRequest(
        clientToken.map(value => value),
        launchTemplateId.map(value => value),
        launchTemplateName.map(value => value),
        sourceVersion.map(value => value),
        versionDescription.map(value => value),
        launchTemplateData.asEditable
      )
    def clientToken: Option[String]
    def launchTemplateId: Option[LaunchTemplateId]
    def launchTemplateName: Option[LaunchTemplateName]
    def sourceVersion: Option[String]
    def versionDescription: Option[VersionDescription]
    def launchTemplateData: zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLaunchTemplateId: ZIO[Any, AwsError, LaunchTemplateId] =
      AwsError.unwrapOptionField("launchTemplateId", launchTemplateId)
    def getLaunchTemplateName: ZIO[Any, AwsError, LaunchTemplateName] =
      AwsError.unwrapOptionField("launchTemplateName", launchTemplateName)
    def getSourceVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceVersion", sourceVersion)
    def getVersionDescription: ZIO[Any, AwsError, VersionDescription] =
      AwsError.unwrapOptionField("versionDescription", versionDescription)
    def getLaunchTemplateData: ZIO[
      Any,
      Nothing,
      zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly
    ] = ZIO.succeed(launchTemplateData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ) extends zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val launchTemplateId: Option[LaunchTemplateId] = scala
      .Option(impl.launchTemplateId())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateId(value))
    override val launchTemplateName: Option[LaunchTemplateName] = scala
      .Option(impl.launchTemplateName())
      .map(value => zio.aws.ec2.model.primitives.LaunchTemplateName(value))
    override val sourceVersion: Option[String] =
      scala.Option(impl.sourceVersion()).map(value => value: String)
    override val versionDescription: Option[VersionDescription] = scala
      .Option(impl.versionDescription())
      .map(value => zio.aws.ec2.model.primitives.VersionDescription(value))
    override val launchTemplateData
        : zio.aws.ec2.model.RequestLaunchTemplateData.ReadOnly =
      zio.aws.ec2.model.RequestLaunchTemplateData
        .wrap(impl.launchTemplateData())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateLaunchTemplateVersionRequest
  ): zio.aws.ec2.model.CreateLaunchTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
