package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIpamResponse(
    ipam: Option[zio.aws.ec2.model.Ipam] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateIpamResponse = {
    import CreateIpamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateIpamResponse
      .builder()
      .optionallyWith(ipam.map(value => value.buildAwsValue()))(_.ipam)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateIpamResponse.ReadOnly =
    zio.aws.ec2.model.CreateIpamResponse.wrap(buildAwsValue())
}
object CreateIpamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateIpamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateIpamResponse =
      zio.aws.ec2.model.CreateIpamResponse(ipam.map(value => value.asEditable))
    def ipam: Option[zio.aws.ec2.model.Ipam.ReadOnly]
    def getIpam: ZIO[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
      AwsError.unwrapOptionField("ipam", ipam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamResponse
  ) extends zio.aws.ec2.model.CreateIpamResponse.ReadOnly {
    override val ipam: Option[zio.aws.ec2.model.Ipam.ReadOnly] =
      scala.Option(impl.ipam()).map(value => zio.aws.ec2.model.Ipam.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateIpamResponse
  ): zio.aws.ec2.model.CreateIpamResponse.ReadOnly = new Wrapper(impl)
}
