package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateInstanceEventWindowRequest(
    name: Option[String] = None,
    timeRanges: Option[
      Iterable[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest]
    ] = None,
    cronExpression: Option[InstanceEventWindowCronExpression] = None,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest = {
    import CreateInstanceEventWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        timeRanges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.timeRanges)
      .optionallyWith(
        cronExpression.map(value =>
          InstanceEventWindowCronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly =
    zio.aws.ec2.model.CreateInstanceEventWindowRequest.wrap(buildAwsValue())
}
object CreateInstanceEventWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateInstanceEventWindowRequest =
      zio.aws.ec2.model.CreateInstanceEventWindowRequest(
        name.map(value => value),
        timeRanges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        cronExpression.map(value => value),
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[String]
    def timeRanges: Option[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ]
    def cronExpression: Option[InstanceEventWindowCronExpression]
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getTimeRanges: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly
    ]] = AwsError.unwrapOptionField("timeRanges", timeRanges)
    def getCronExpression
        : ZIO[Any, AwsError, InstanceEventWindowCronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ) extends zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly {
    override val name: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override val timeRanges: Option[
      List[zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.ReadOnly]
    ] = scala
      .Option(impl.timeRanges())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.InstanceEventWindowTimeRangeRequest.wrap(item)
        }.toList
      )
    override val cronExpression: Option[InstanceEventWindowCronExpression] =
      scala
        .Option(impl.cronExpression())
        .map(value =>
          zio.aws.ec2.model.primitives.InstanceEventWindowCronExpression(value)
        )
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateInstanceEventWindowRequest
  ): zio.aws.ec2.model.CreateInstanceEventWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
