package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFpgaImageResponse(
    fpgaImageId: Option[String] = None,
    fpgaImageGlobalId: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse = {
    import CreateFpgaImageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse
      .builder()
      .optionallyWith(fpgaImageId.map(value => value: java.lang.String))(
        _.fpgaImageId
      )
      .optionallyWith(fpgaImageGlobalId.map(value => value: java.lang.String))(
        _.fpgaImageGlobalId
      )
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly =
    zio.aws.ec2.model.CreateFpgaImageResponse.wrap(buildAwsValue())
}
object CreateFpgaImageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CreateFpgaImageResponse =
      zio.aws.ec2.model.CreateFpgaImageResponse(
        fpgaImageId.map(value => value),
        fpgaImageGlobalId.map(value => value)
      )
    def fpgaImageId: Option[String]
    def fpgaImageGlobalId: Option[String]
    def getFpgaImageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageId", fpgaImageId)
    def getFpgaImageGlobalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("fpgaImageGlobalId", fpgaImageGlobalId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse
  ) extends zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly {
    override val fpgaImageId: Option[String] =
      scala.Option(impl.fpgaImageId()).map(value => value: String)
    override val fpgaImageGlobalId: Option[String] =
      scala.Option(impl.fpgaImageGlobalId()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CreateFpgaImageResponse
  ): zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly = new Wrapper(impl)
}
