package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ContainerFormat {
  def unwrap: software.amazon.awssdk.services.ec2.model.ContainerFormat
}
object ContainerFormat {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ContainerFormat
  ): zio.aws.ec2.model.ContainerFormat = value match {
    case software.amazon.awssdk.services.ec2.model.ContainerFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ContainerFormat.OVA =>
      val r = ova
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.ContainerFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ContainerFormat =
      software.amazon.awssdk.services.ec2.model.ContainerFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object ova extends zio.aws.ec2.model.ContainerFormat {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ContainerFormat =
      software.amazon.awssdk.services.ec2.model.ContainerFormat.OVA
  }
}
