package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait ClientVpnAuthenticationType {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType
}
object ClientVpnAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType
  ): zio.aws.ec2.model.ClientVpnAuthenticationType = value match {
    case software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.CERTIFICATE_AUTHENTICATION =>
      val r = `certificate-authentication`
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.DIRECTORY_SERVICE_AUTHENTICATION =>
      val r = `directory-service-authentication`
      r
    case software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.FEDERATED_AUTHENTICATION =>
      val r = `federated-authentication`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.ClientVpnAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType =
      software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object `certificate-authentication`
      extends zio.aws.ec2.model.ClientVpnAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType =
      software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.CERTIFICATE_AUTHENTICATION
  }
  case object `directory-service-authentication`
      extends zio.aws.ec2.model.ClientVpnAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType =
      software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.DIRECTORY_SERVICE_AUTHENTICATION
  }
  case object `federated-authentication`
      extends zio.aws.ec2.model.ClientVpnAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType =
      software.amazon.awssdk.services.ec2.model.ClientVpnAuthenticationType.FEDERATED_AUTHENTICATION
  }
}
