package zio.aws.ec2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CancelCapacityReservationFleetsResponse(
    successfulFleetCancellations: Option[
      Iterable[zio.aws.ec2.model.CapacityReservationFleetCancellationState]
    ] = None,
    failedFleetCancellations: Option[Iterable[
      zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse = {
    import CancelCapacityReservationFleetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse
      .builder()
      .optionallyWith(
        successfulFleetCancellations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successfulFleetCancellations)
      .optionallyWith(
        failedFleetCancellations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedFleetCancellations)
      .build()
  }
  def asReadOnly
      : zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly =
    zio.aws.ec2.model.CancelCapacityReservationFleetsResponse
      .wrap(buildAwsValue())
}
object CancelCapacityReservationFleetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.CancelCapacityReservationFleetsResponse =
      zio.aws.ec2.model.CancelCapacityReservationFleetsResponse(
        successfulFleetCancellations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failedFleetCancellations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successfulFleetCancellations: Option[
      List[zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly]
    ]
    def failedFleetCancellations: Option[List[
      zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly
    ]]
    def getSuccessfulFleetCancellations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "successfulFleetCancellations",
      successfulFleetCancellations
    )
    def getFailedFleetCancellations: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "failedFleetCancellations",
      failedFleetCancellations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse
  ) extends zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly {
    override val successfulFleetCancellations: Option[
      List[zio.aws.ec2.model.CapacityReservationFleetCancellationState.ReadOnly]
    ] = scala
      .Option(impl.successfulFleetCancellations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.CapacityReservationFleetCancellationState.wrap(item)
        }.toList
      )
    override val failedFleetCancellations: Option[List[
      zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult.ReadOnly
    ]] = scala
      .Option(impl.failedFleetCancellations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.FailedCapacityReservationFleetCancellationResult
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.CancelCapacityReservationFleetsResponse
  ): zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly =
    new Wrapper(impl)
}
