package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait BatchState {
  def unwrap: software.amazon.awssdk.services.ec2.model.BatchState
}
object BatchState {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.BatchState
  ): zio.aws.ec2.model.BatchState = value match {
    case software.amazon.awssdk.services.ec2.model.BatchState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.SUBMITTED =>
      val r = submitted
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED =>
      val r = cancelled
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.FAILED =>
      val r = failed
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED_RUNNING =>
      val r = cancelled_running
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED_TERMINATING =>
      val r = cancelled_terminating
      r
    case software.amazon.awssdk.services.ec2.model.BatchState.MODIFYING =>
      val r = modifying
      r
  }
  case object unknownToSdkVersion extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.UNKNOWN_TO_SDK_VERSION
  }
  case object submitted extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.SUBMITTED
  }
  case object active extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.ACTIVE
  }
  case object cancelled extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED
  }
  case object failed extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.FAILED
  }
  case object cancelled_running extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED_RUNNING
  }
  case object cancelled_terminating extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.CANCELLED_TERMINATING
  }
  case object modifying extends zio.aws.ec2.model.BatchState {
    override def unwrap: software.amazon.awssdk.services.ec2.model.BatchState =
      software.amazon.awssdk.services.ec2.model.BatchState.MODIFYING
  }
}
