package zio.aws.ec2.model
import scala.jdk.CollectionConverters._
sealed trait AvailabilityZoneOptInStatus {
  def unwrap
      : software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus
}
object AvailabilityZoneOptInStatus {
  def wrap(
      value: software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus
  ): zio.aws.ec2.model.AvailabilityZoneOptInStatus = value match {
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.OPT_IN_NOT_REQUIRED =>
      val r = `opt-in-not-required`
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.OPTED_IN =>
      val r = `opted-in`
      r
    case software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.NOT_OPTED_IN =>
      val r = `not-opted-in`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ec2.model.AvailabilityZoneOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object `opt-in-not-required`
      extends zio.aws.ec2.model.AvailabilityZoneOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.OPT_IN_NOT_REQUIRED
  }
  case object `opted-in` extends zio.aws.ec2.model.AvailabilityZoneOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.OPTED_IN
  }
  case object `not-opted-in`
      extends zio.aws.ec2.model.AvailabilityZoneOptInStatus {
    override def unwrap
        : software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus =
      software.amazon.awssdk.services.ec2.model.AvailabilityZoneOptInStatus.NOT_OPTED_IN
  }
}
