package zio.aws.ec2.model
import zio.aws.ec2.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AllocateHostsRequest(
    autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = None,
    availabilityZone: String,
    clientToken: Option[String] = None,
    instanceType: Option[String] = None,
    instanceFamily: Option[String] = None,
    quantity: Integer,
    tagSpecifications: Option[Iterable[zio.aws.ec2.model.TagSpecification]] =
      None,
    hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ec2.model.AllocateHostsRequest = {
    import AllocateHostsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
      .builder()
      .optionallyWith(autoPlacement.map(value => value.unwrap))(_.autoPlacement)
      .availabilityZone(availabilityZone: java.lang.String)
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .optionallyWith(instanceType.map(value => value: java.lang.String))(
        _.instanceType
      )
      .optionallyWith(instanceFamily.map(value => value: java.lang.String))(
        _.instanceFamily
      )
      .quantity(Integer.unwrap(quantity): java.lang.Integer)
      .optionallyWith(
        tagSpecifications.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagSpecifications)
      .optionallyWith(hostRecovery.map(value => value.unwrap))(_.hostRecovery)
      .build()
  }
  def asReadOnly: zio.aws.ec2.model.AllocateHostsRequest.ReadOnly =
    zio.aws.ec2.model.AllocateHostsRequest.wrap(buildAwsValue())
}
object AllocateHostsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ec2.model.AllocateHostsRequest =
      zio.aws.ec2.model.AllocateHostsRequest(
        autoPlacement.map(value => value),
        availabilityZone,
        clientToken.map(value => value),
        instanceType.map(value => value),
        instanceFamily.map(value => value),
        quantity,
        tagSpecifications.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hostRecovery.map(value => value)
      )
    def autoPlacement: Option[zio.aws.ec2.model.AutoPlacement]
    def availabilityZone: String
    def clientToken: Option[String]
    def instanceType: Option[String]
    def instanceFamily: Option[String]
    def quantity: Integer
    def tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]]
    def hostRecovery: Option[zio.aws.ec2.model.HostRecovery]
    def getAutoPlacement: ZIO[Any, AwsError, zio.aws.ec2.model.AutoPlacement] =
      AwsError.unwrapOptionField("autoPlacement", autoPlacement)
    def getAvailabilityZone: ZIO[Any, Nothing, String] =
      ZIO.succeed(availabilityZone)
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getInstanceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceType", instanceType)
    def getInstanceFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("instanceFamily", instanceFamily)
    def getQuantity: ZIO[Any, Nothing, Integer] = ZIO.succeed(quantity)
    def getTagSpecifications: ZIO[Any, AwsError, List[
      zio.aws.ec2.model.TagSpecification.ReadOnly
    ]] = AwsError.unwrapOptionField("tagSpecifications", tagSpecifications)
    def getHostRecovery: ZIO[Any, AwsError, zio.aws.ec2.model.HostRecovery] =
      AwsError.unwrapOptionField("hostRecovery", hostRecovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ) extends zio.aws.ec2.model.AllocateHostsRequest.ReadOnly {
    override val autoPlacement: Option[zio.aws.ec2.model.AutoPlacement] = scala
      .Option(impl.autoPlacement())
      .map(value => zio.aws.ec2.model.AutoPlacement.wrap(value))
    override val availabilityZone: String = impl.availabilityZone(): String
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val instanceType: Option[String] =
      scala.Option(impl.instanceType()).map(value => value: String)
    override val instanceFamily: Option[String] =
      scala.Option(impl.instanceFamily()).map(value => value: String)
    override val quantity: Integer =
      zio.aws.ec2.model.primitives.Integer(impl.quantity())
    override val tagSpecifications
        : Option[List[zio.aws.ec2.model.TagSpecification.ReadOnly]] = scala
      .Option(impl.tagSpecifications())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ec2.model.TagSpecification.wrap(item)
        }.toList
      )
    override val hostRecovery: Option[zio.aws.ec2.model.HostRecovery] = scala
      .Option(impl.hostRecovery())
      .map(value => zio.aws.ec2.model.HostRecovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ec2.model.AllocateHostsRequest
  ): zio.aws.ec2.model.AllocateHostsRequest.ReadOnly = new Wrapper(impl)
}
