package zio.aws.ec2
import zio.aws.ec2.model.SecurityGroupRule.ReadOnly
import software.amazon.awssdk.services.ec2.model.{
  DeleteNetworkInsightsPathRequest,
  ReleaseAddressResponse,
  RejectTransitGatewayMulticastDomainAssociationsRequest,
  ReleaseAddressRequest,
  CreateNetworkInterfacePermissionRequest,
  ModifyVpnTunnelOptionsResponse,
  ListSnapshotsInRecycleBinRequest,
  DescribeInstanceStatusResponse,
  DescribeReservedInstancesModificationsResponse,
  CreateIpamScopeResponse,
  DeleteTransitGatewayConnectResponse,
  GetGroupsForCapacityReservationResponse,
  IpamScope,
  DescribeIdentityIdFormatResponse,
  DisableVpcClassicLinkResponse,
  VolumeStatusItem,
  AuthorizeClientVpnIngressResponse,
  ModifyVpcTenancyRequest,
  ApplySecurityGroupsToClientVpnTargetNetworkRequest,
  PurchaseHostReservationRequest,
  DisableIpamOrganizationAdminAccountRequest,
  DescribeTransitGatewaysResponse,
  CreateTransitGatewayPeeringAttachmentResponse,
  TransitGatewayMulticastGroup,
  ModifyVolumeAttributeResponse,
  DeleteClientVpnRouteResponse,
  ExportTransitGatewayRoutesResponse,
  ModifyVpcAttributeRequest,
  DescribeNetworkInsightsAnalysesResponse,
  ModifyVpcEndpointServicePermissionsRequest,
  GetAssociatedIpv6PoolCidrsResponse,
  ExportClientVpnClientConfigurationResponse,
  CreatePublicIpv4PoolResponse,
  DeleteNetworkInsightsAccessScopeAnalysisResponse,
  DescribeTrafficMirrorFiltersRequest,
  ImportClientVpnClientCertificateRevocationListRequest,
  CreateSnapshotsResponse,
  DescribeTrafficMirrorSessionsRequest,
  DeleteTransitGatewayPeeringAttachmentResponse,
  DeleteRouteResponse,
  AttachNetworkInterfaceRequest,
  GetInstanceTypesFromInstanceRequirementsResponse,
  DescribeVpcEndpointsRequest,
  CreateTransitGatewayPrefixListReferenceResponse,
  DeleteTransitGatewayPrefixListReferenceRequest,
  DescribeExportTasksRequest,
  AddressAttribute,
  CancelCapacityReservationFleetsRequest,
  ModifyTrafficMirrorSessionResponse,
  AttachNetworkInterfaceResponse,
  DetachVpnGatewayRequest,
  CreateVpcEndpointConnectionNotificationRequest,
  CopyImageResponse,
  DescribeTransitGatewayAttachmentsResponse,
  DescribeLaunchTemplatesRequest,
  DisassociateAddressResponse,
  DeleteNetworkInterfaceResponse,
  GetPasswordDataRequest,
  DescribeSubnetsRequest,
  ReplaceNetworkAclAssociationResponse,
  DeleteTrafficMirrorTargetResponse,
  AcceptReservedInstancesExchangeQuoteResponse,
  GetTransitGatewayAttachmentPropagationsResponse,
  DeregisterImageRequest,
  ResetNetworkInterfaceAttributeRequest,
  CreateVpnGatewayRequest,
  DeleteTrafficMirrorFilterRequest,
  DescribeIpamScopesResponse,
  CreateTransitGatewayConnectRequest,
  DescribeManagedPrefixListsResponse,
  ModifyFleetRequest,
  AssociateSubnetCidrBlockResponse,
  SearchLocalGatewayRoutesRequest,
  EnableImageDeprecationRequest,
  DeleteCarrierGatewayResponse,
  DeleteVpcEndpointConnectionNotificationsResponse,
  CreateNetworkInterfacePermissionResponse,
  ModifyIpamResourceCidrResponse,
  DescribeLocalGatewayRouteTableVpcAssociationsRequest,
  ImportKeyPairResponse,
  RequestSpotFleetResponse,
  DescribeAvailabilityZonesResponse,
  ModifyTrafficMirrorFilterNetworkServicesResponse,
  GetPasswordDataResponse,
  CreateIpamPoolRequest,
  ReleaseHostsRequest,
  DescribeIpamsRequest,
  DescribeKeyPairsRequest,
  GetSpotPlacementScoresResponse,
  DescribeMovingAddressesRequest,
  DeleteRouteRequest,
  CancelSpotInstanceRequestsRequest,
  ReservedInstancesOffering,
  DescribeNetworkInterfaceAttributeResponse,
  ResetInstanceAttributeResponse,
  DescribeHostReservationOfferingsRequest,
  ModifyVpnConnectionOptionsResponse,
  Host,
  DescribeSpotFleetRequestsResponse,
  DeleteSpotDatafeedSubscriptionRequest,
  DescribeCustomerGatewaysResponse,
  CreateTrafficMirrorTargetResponse,
  EnableIpamOrganizationAdminAccountRequest,
  ExportClientVpnClientCertificateRevocationListRequest,
  ModifyFpgaImageAttributeResponse,
  DescribeLocalGatewayRouteTablesResponse,
  DeleteNetworkInsightsAnalysisRequest,
  DeleteTransitGatewayVpcAttachmentRequest,
  DescribeTrunkInterfaceAssociationsRequest,
  ExportClientVpnClientConfigurationRequest,
  AcceptTransitGatewayVpcAttachmentResponse,
  MoveByoipCidrToIpamResponse,
  CreateLaunchTemplateResponse,
  TransitGatewayPrefixListReference,
  IpamPool,
  GetManagedPrefixListEntriesResponse,
  DeleteVpcEndpointsRequest,
  InstanceCreditSpecification,
  DeleteFlowLogsRequest,
  AssociateVpcCidrBlockRequest,
  ModifyTrafficMirrorSessionRequest,
  DescribeIpamPoolsRequest,
  AssociateRouteTableResponse,
  DisableImageDeprecationRequest,
  CancelImportTaskRequest,
  ReportInstanceStatusResponse,
  DescribeIdFormatRequest,
  RevokeClientVpnIngressRequest,
  DeleteNatGatewayRequest,
  AttachClassicLinkVpcRequest,
  DescribeNetworkInsightsPathsRequest,
  ReplaceNetworkAclEntryRequest,
  DisableTransitGatewayRouteTablePropagationResponse,
  DescribeInstancesResponse,
  CreateClientVpnEndpointResponse,
  TrafficMirrorTarget,
  DeleteInternetGatewayRequest,
  StartNetworkInsightsAnalysisResponse,
  WithdrawByoipCidrResponse,
  DescribePrefixListsRequest,
  RunScheduledInstancesRequest,
  AssociateTrunkInterfaceRequest,
  CreateVpcEndpointResponse,
  DescribeAvailabilityZonesRequest,
  StartNetworkInsightsAccessScopeAnalysisResponse,
  AcceptVpcPeeringConnectionRequest,
  AssociateTransitGatewayRouteTableRequest,
  CreateFleetResponse,
  DescribeLocalGatewaysResponse,
  AllocateAddressRequest,
  CopyImageRequest,
  DeleteInstanceEventWindowResponse,
  ModifyTransitGatewayVpcAttachmentResponse,
  DeleteSecurityGroupRequest,
  ResetSnapshotAttributeRequest,
  DisableImageDeprecationResponse,
  CreateDhcpOptionsResponse,
  RestoreAddressToClassicRequest,
  DescribeVpcEndpointConnectionsRequest,
  DescribeNetworkInterfacePermissionsRequest,
  Subnet,
  DescribeReservedInstancesResponse,
  NetworkInterface,
  SearchTransitGatewayMulticastGroupsRequest,
  TrunkInterfaceAssociation,
  DisassociateTransitGatewayRouteTableResponse,
  DescribeExportImageTasksRequest,
  DescribeVolumeAttributeRequest,
  ModifyPrivateDnsNameOptionsRequest,
  GetVpnConnectionDeviceSampleConfigurationResponse,
  ServiceDetail,
  GetDefaultCreditSpecificationResponse,
  DeleteNatGatewayResponse,
  ProvisionPublicIpv4PoolCidrRequest,
  GetIpamAddressHistoryRequest,
  GetIpamPoolCidrsRequest,
  ModifyReservedInstancesResponse,
  ClassicLinkDnsSupport,
  DescribeSnapshotsRequest,
  DeleteDhcpOptionsResponse,
  RestoreSnapshotTierRequest,
  ModifyTransitGatewayPrefixListReferenceResponse,
  RegisterImageResponse,
  RestoreSnapshotFromRecycleBinResponse,
  RejectVpcPeeringConnectionResponse,
  DeleteVolumeRequest,
  DeleteSpotDatafeedSubscriptionResponse,
  GetSubnetCidrReservationsRequest,
  DescribeSnapshotsResponse,
  ResetSnapshotAttributeResponse,
  DeleteTransitGatewayPeeringAttachmentRequest,
  DeleteSnapshotRequest,
  AuthorizeClientVpnIngressRequest,
  TagDescription,
  GetHostReservationPurchasePreviewResponse,
  DescribeAddressesResponse,
  TransitGatewayRouteTable,
  CreateTrafficMirrorFilterRuleResponse,
  DescribeLocalGatewayVirtualInterfaceGroupsRequest,
  GetCoipPoolUsageResponse,
  RevokeClientVpnIngressResponse,
  ModifyTrafficMirrorFilterRuleResponse,
  DeleteSubnetCidrReservationRequest,
  GetGroupsForCapacityReservationRequest,
  DeleteKeyPairRequest,
  DescribeTrunkInterfaceAssociationsResponse,
  CreateCarrierGatewayResponse,
  DeleteSubnetResponse,
  ModifyReservedInstancesRequest,
  NetworkInsightsAccessScope,
  CreateVpnConnectionResponse,
  DescribeReservedInstancesModificationsRequest,
  DescribeTransitGatewayMulticastDomainsRequest,
  DescribeIpamsResponse,
  CapacityReservationGroup,
  DeletePublicIpv4PoolRequest,
  ReplaceRouteRequest,
  DescribeInstanceTypesRequest,
  DisassociateTransitGatewayMulticastDomainResponse,
  RestoreManagedPrefixListVersionResponse,
  DescribeKeyPairsResponse,
  CreateClientVpnRouteRequest,
  ModifyCapacityReservationFleetResponse,
  ReplaceTransitGatewayRouteRequest,
  RestoreSnapshotTierResponse,
  GetSerialConsoleAccessStatusResponse,
  EnableVpcClassicLinkDnsSupportRequest,
  DeleteNetworkAclEntryResponse,
  DescribeNetworkInsightsAnalysesRequest,
  ModifyEbsDefaultKmsKeyIdRequest,
  AssociateClientVpnTargetNetworkResponse,
  DescribeTransitGatewayVpcAttachmentsRequest,
  CreateTransitGatewayResponse,
  LocalGateway,
  DescribePlacementGroupsRequest,
  DescribeNatGatewaysRequest,
  DeleteTagsRequest,
  ReplaceTransitGatewayRouteResponse,
  VpcPeeringConnection,
  SpotPlacementScore,
  DescribeSnapshotTierStatusRequest,
  CreateDhcpOptionsRequest,
  ModifySecurityGroupRulesRequest,
  CreateVpnConnectionRouteResponse,
  CreateLocalGatewayRouteTableVpcAssociationRequest,
  EnableVpcClassicLinkResponse,
  DeleteDhcpOptionsRequest,
  DescribeLocalGatewayVirtualInterfaceGroupsResponse,
  EnableEbsEncryptionByDefaultRequest,
  VpcEndpointConnection,
  DescribeTransitGatewayMulticastDomainsResponse,
  DescribeVpcEndpointServicePermissionsResponse,
  CreateNetworkInsightsPathResponse,
  DescribeSubnetsResponse,
  MonitorInstancesResponse,
  ModifySecurityGroupRulesResponse,
  ModifyInstanceEventStartTimeResponse,
  DetachClassicLinkVpcResponse,
  InstanceTypeInfo,
  DescribeFleetInstancesResponse,
  DeleteSubnetCidrReservationResponse,
  DescribeLocalGatewayRouteTableVpcAssociationsResponse,
  CreateReservedInstancesListingRequest,
  ProvisionIpamPoolCidrResponse,
  DescribeSecurityGroupRulesResponse,
  AllocateIpamPoolCidrRequest,
  ReportInstanceStatusRequest,
  ModifyIpamScopeRequest,
  GetManagedPrefixListAssociationsResponse,
  DescribeImagesResponse,
  GetTransitGatewayPrefixListReferencesRequest,
  DeleteTagsResponse,
  AllocateHostsRequest,
  DeleteNetworkInterfaceRequest,
  DescribeFpgaImageAttributeRequest,
  DescribeFleetsRequest,
  DescribeInstanceAttributeRequest,
  DescribeDhcpOptionsResponse,
  DescribeNetworkInsightsPathsResponse,
  DescribeTransitGatewayConnectPeersRequest,
  AssociateAddressResponse,
  PurchaseScheduledInstancesResponse,
  GetManagedPrefixListEntriesRequest,
  DeprovisionPublicIpv4PoolCidrRequest,
  DescribeClientVpnConnectionsResponse,
  ReplaceIamInstanceProfileAssociationRequest,
  DescribeImportSnapshotTasksRequest,
  ModifyCapacityReservationFleetRequest,
  DescribeEgressOnlyInternetGatewaysResponse,
  ModifySnapshotAttributeResponse,
  HistoryRecordEntry,
  DisassociateIamInstanceProfileResponse,
  DescribeTrafficMirrorTargetsResponse,
  CreateIpamRequest,
  LocalGatewayVirtualInterface,
  ResetImageAttributeRequest,
  DescribeVpcEndpointsResponse,
  AssignPrivateIpAddressesRequest,
  DescribeVpcEndpointConnectionsResponse,
  RunInstancesResponse,
  DeleteLocalGatewayRouteTableVpcAssociationResponse,
  ConfirmProductInstanceRequest,
  DescribeInstanceEventWindowsRequest,
  GetTransitGatewayMulticastDomainAssociationsRequest,
  DeleteCustomerGatewayRequest,
  CancelImportTaskResponse,
  Vpc,
  ByoipCidr,
  DeleteLocalGatewayRouteRequest,
  ModifyInstanceMetadataOptionsResponse,
  DescribeCapacityReservationFleetsRequest,
  DeleteVpnGatewayResponse,
  AssociateVpcCidrBlockResponse,
  RevokeSecurityGroupEgressRequest,
  DeleteSecurityGroupResponse,
  DescribeVpcEndpointConnectionNotificationsRequest,
  ModifyVpcEndpointRequest,
  CreateNatGatewayResponse,
  ReplaceRouteTableAssociationResponse,
  SpotPrice,
  DeleteTransitGatewayRouteTableResponse,
  GetVpnConnectionDeviceTypesResponse,
  DescribeVpcsResponse,
  DescribeCapacityReservationsRequest,
  CreateVpcResponse,
  GetHostReservationPurchasePreviewRequest,
  CreateFpgaImageRequest,
  ModifySpotFleetRequestRequest,
  ModifyIpamPoolResponse,
  UnassignIpv6AddressesResponse,
  DeleteVpcEndpointServiceConfigurationsResponse,
  DeleteTrafficMirrorSessionResponse,
  DescribeExportImageTasksResponse,
  ReplaceIamInstanceProfileAssociationResponse,
  DescribeSpotFleetRequestsRequest,
  CreateFpgaImageResponse,
  RejectVpcEndpointConnectionsResponse,
  ModifyTrafficMirrorFilterNetworkServicesRequest,
  ProvisionByoipCidrResponse,
  DisableFastSnapshotRestoresResponse,
  NetworkInsightsAccessScopeAnalysis,
  DeleteTrafficMirrorFilterResponse,
  DescribeSecurityGroupReferencesRequest,
  DeleteFleetsRequest,
  DescribeMovingAddressesResponse,
  ReservedInstancesModification,
  InstanceTypeOffering,
  DisassociateIamInstanceProfileRequest,
  DescribeLocalGatewayRouteTablesRequest,
  DisableVpcClassicLinkDnsSupportRequest,
  ExportImageTask,
  TerminateInstancesRequest,
  DisableSerialConsoleAccessResponse,
  DescribeTransitGatewayAttachmentsRequest,
  PurchaseScheduledInstancesRequest,
  DisassociateRouteTableRequest,
  AllocateAddressResponse,
  ServiceConfiguration,
  UpdateSecurityGroupRuleDescriptionsIngressResponse,
  CreateDefaultVpcResponse,
  ModifyIdFormatResponse,
  IpamResourceCidr,
  CreateLocalGatewayRouteRequest,
  IpamPoolAllocation,
  DisableVpcClassicLinkRequest,
  AcceptVpcPeeringConnectionResponse,
  DeleteTrafficMirrorFilterRuleResponse,
  DescribeTransitGatewayRouteTablesRequest,
  DeleteTransitGatewayResponse,
  TransitGatewayConnect,
  RegisterInstanceEventNotificationAttributesResponse,
  DescribeInstanceAttributeResponse,
  IpamAddressHistoryRecord,
  CreateRouteResponse,
  DeleteNetworkInsightsAnalysisResponse,
  CreateDefaultSubnetResponse,
  DeleteVpnConnectionRequest,
  DeleteVpcEndpointsResponse,
  ModifyTransitGatewayResponse,
  NetworkInsightsAnalysis,
  DescribeFpgaImagesRequest,
  DetachNetworkInterfaceRequest,
  CreateInstanceExportTaskRequest,
  DeleteIpamPoolRequest,
  DisassociateEnclaveCertificateIamRoleRequest,
  RunInstancesRequest,
  RejectTransitGatewayPeeringAttachmentResponse,
  MovingAddressStatus,
  DeprovisionIpamPoolCidrResponse,
  CreateTransitGatewayRequest,
  DeleteLaunchTemplateVersionsResponse,
  ClientVpnEndpoint,
  AssociateTransitGatewayMulticastDomainResponse,
  ModifyVpcEndpointServiceConfigurationRequest,
  CreateTransitGatewayConnectResponse,
  DeleteRouteTableRequest,
  GetIpamAddressHistoryResponse,
  ModifyClientVpnEndpointResponse,
  ModifyIpamResourceCidrRequest,
  CreateNetworkAclEntryRequest,
  DescribeInstanceEventNotificationAttributesRequest,
  DescribeCapacityReservationsResponse,
  CreateTagsRequest,
  MoveAddressToVpcResponse,
  DescribeVpnConnectionsResponse,
  CancelCapacityReservationRequest,
  CreateSpotDatafeedSubscriptionRequest,
  ResetNetworkInterfaceAttributeResponse,
  CopyFpgaImageResponse,
  DisassociateTransitGatewayRouteTableRequest,
  DescribePlacementGroupsResponse,
  RejectTransitGatewayVpcAttachmentResponse,
  HistoryRecord,
  EgressOnlyInternetGateway,
  DisassociateClientVpnTargetNetworkRequest,
  DescribeReplaceRootVolumeTasksRequest,
  ModifySubnetAttributeRequest,
  CreateTrafficMirrorSessionResponse,
  ModifyManagedPrefixListResponse,
  GetIpamPoolCidrsResponse,
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse,
  DetachVolumeRequest,
  DisableVpcClassicLinkDnsSupportResponse,
  ConnectionNotification,
  TerminateClientVpnConnectionsResponse,
  DescribeIdentityIdFormatRequest,
  ModifyTrafficMirrorFilterRuleRequest,
  DescribeImportImageTasksRequest,
  TransitGatewayPeeringAttachment,
  CreateRouteRequest,
  GetCapacityReservationUsageRequest,
  CopySnapshotRequest,
  CancelCapacityReservationResponse,
  AcceptVpcEndpointConnectionsResponse,
  AccessScopeAnalysisFinding,
  DescribeBundleTasksResponse,
  ModifyInstanceEventWindowRequest,
  SecurityGroup,
  TransitGatewayRouteTableAssociation,
  ModifyVpcEndpointConnectionNotificationRequest,
  DescribeStoreImageTasksRequest,
  ModifySnapshotAttributeRequest,
  MoveByoipCidrToIpamRequest,
  DisassociateAddressRequest,
  HostReservation,
  ModifyVpcEndpointServiceConfigurationResponse,
  CreateStoreImageTaskRequest,
  CreateReservedInstancesListingResponse,
  DescribeEgressOnlyInternetGatewaysRequest,
  DescribeTransitGatewaysRequest,
  ModifyCapacityReservationRequest,
  ImportImageTask,
  DeleteQueuedReservedInstancesResponse,
  GetConsoleScreenshotRequest,
  CreateVpnConnectionRequest,
  CancelExportTaskResponse,
  DescribeVolumeAttributeResponse,
  DeleteTrafficMirrorSessionRequest,
  DescribeLaunchTemplateVersionsResponse,
  GetCoipPoolUsageRequest,
  InstanceUsage,
  ModifyDefaultCreditSpecificationRequest,
  ModifyAvailabilityZoneGroupRequest,
  TransitGatewayAttachment,
  DeleteNetworkInterfacePermissionResponse,
  PrefixListEntry,
  RouteTable,
  DescribeInstanceTypeOfferingsResponse,
  ImportClientVpnClientCertificateRevocationListResponse,
  DescribeInstanceCreditSpecificationsResponse,
  EnableVgwRoutePropagationResponse,
  EnableEbsEncryptionByDefaultResponse,
  ImportVolumeResponse,
  GetIpamResourceCidrsResponse,
  RejectTransitGatewayPeeringAttachmentRequest,
  AssociateTransitGatewayRouteTableResponse,
  DescribeReservedInstancesListingsResponse,
  AssociateIamInstanceProfileResponse,
  ModifyVpnConnectionOptionsRequest,
  DeleteNetworkInsightsAccessScopeAnalysisRequest,
  DescribeReservedInstancesOfferingsRequest,
  CreateRouteTableRequest,
  StartNetworkInsightsAnalysisRequest,
  GetIpamPoolAllocationsResponse,
  CancelSpotInstanceRequestsResponse,
  AcceptTransitGatewayPeeringAttachmentResponse,
  ModifyVpcEndpointResponse,
  ModifyInstanceEventWindowResponse,
  DeleteClientVpnEndpointResponse,
  GetTransitGatewayRouteTablePropagationsResponse,
  CreateDefaultVpcRequest,
  EnableFastSnapshotRestoresRequest,
  CreateCapacityReservationFleetRequest,
  GetTransitGatewayRouteTableAssociationsResponse,
  RebootInstancesResponse,
  CreateTrafficMirrorFilterResponse,
  ExportImageRequest,
  ImportVolumeRequest,
  DescribeCarrierGatewaysRequest,
  DescribeClientVpnEndpointsResponse,
  CreateNetworkInsightsAccessScopeRequest,
  ModifyVpcAttributeResponse,
  DescribeVpcAttributeResponse,
  ResetFpgaImageAttributeResponse,
  SearchTransitGatewayMulticastGroupsResponse,
  DescribeTransitGatewayConnectPeersResponse,
  DescribeLocalGatewayVirtualInterfacesResponse,
  DescribeClientVpnRoutesResponse,
  DescribeTrafficMirrorSessionsResponse,
  ModifyImageAttributeResponse,
  BundleInstanceRequest,
  DescribeVpcEndpointConnectionNotificationsResponse,
  CreateVpcEndpointServiceConfigurationResponse,
  DisassociateTransitGatewayMulticastDomainRequest,
  ModifyLaunchTemplateResponse,
  ModifyVpcTenancyResponse,
  ReplaceRootVolumeTask,
  NetworkInterfacePermission,
  LaunchTemplateVersion,
  CreateLocalGatewayRouteResponse,
  Snapshot,
  AllocateIpamPoolCidrResponse,
  StartVpcEndpointServicePrivateDnsVerificationResponse,
  DescribeAddressesRequest,
  DescribeTrafficMirrorFiltersResponse,
  DeleteVolumeResponse,
  RestoreManagedPrefixListVersionRequest,
  ReleaseIpamPoolAllocationResponse,
  PublicIpv4Pool,
  DeregisterTransitGatewayMulticastGroupSourcesRequest,
  DescribeClientVpnTargetNetworksRequest,
  DescribeSecurityGroupsResponse,
  DescribeFleetHistoryRequest,
  CreateTransitGatewayMulticastDomainRequest,
  DetachVpnGatewayResponse,
  TransitGateway,
  ModifyInstanceAttributeResponse,
  DisassociateInstanceEventWindowResponse,
  ModifyAvailabilityZoneGroupResponse,
  DeleteInternetGatewayResponse,
  RevokeSecurityGroupEgressResponse,
  EnableVpcClassicLinkRequest,
  DescribeTransitGatewayConnectsRequest,
  GetTransitGatewayMulticastDomainAssociationsResponse,
  CreateFlowLogsRequest,
  CreateTrafficMirrorFilterRequest,
  GetTransitGatewayPrefixListReferencesResponse,
  DescribeFleetsResponse,
  DescribeVolumesRequest,
  DescribePrincipalIdFormatRequest,
  TransitGatewayVpcAttachment,
  Reservation,
  AssociateDhcpOptionsRequest,
  CancelBundleTaskRequest,
  DeleteTransitGatewayMulticastDomainRequest,
  DeleteIpamResponse,
  DescribeNatGatewaysResponse,
  RejectTransitGatewayVpcAttachmentRequest,
  CreateTransitGatewayConnectPeerRequest,
  RequestSpotInstancesResponse,
  TransitGatewayMulticastDomain,
  ModifyHostsResponse,
  CreateIpamResponse,
  DescribeRouteTablesResponse,
  CreateManagedPrefixListResponse,
  CreateNetworkAclEntryResponse,
  ModifyEbsDefaultKmsKeyIdResponse,
  DescribeFleetInstancesRequest,
  DeleteFpgaImageRequest,
  ModifyTransitGatewayPrefixListReferenceRequest,
  DeregisterInstanceEventNotificationAttributesResponse,
  CreateNetworkInsightsPathRequest,
  CoipPool,
  AssociateClientVpnTargetNetworkRequest,
  AttachVpnGatewayResponse,
  VpnConnectionDeviceType,
  ModifyImageAttributeRequest,
  DeregisterInstanceEventNotificationAttributesRequest,
  DescribeElasticGpusResponse,
  DeletePlacementGroupRequest,
  DetachClassicLinkVpcRequest,
  DeleteTransitGatewayPrefixListReferenceResponse,
  ModifyFleetResponse,
  DisassociateVpcCidrBlockResponse,
  RegisterTransitGatewayMulticastGroupMembersResponse,
  TrafficMirrorSession,
  UpdateSecurityGroupRuleDescriptionsEgressRequest,
  AuthorizeSecurityGroupEgressRequest,
  ModifyInstanceCapacityReservationAttributesRequest,
  DescribeConversionTasksResponse,
  DescribeLocalGatewaysRequest,
  DescribeHostReservationsResponse,
  AssociateRouteTableRequest,
  DisassociateTrunkInterfaceRequest,
  TerminateInstancesResponse,
  ReplaceNetworkAclEntryResponse,
  DeleteFpgaImageResponse,
  DescribeVpcEndpointServiceConfigurationsRequest,
  DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
  ModifyIpamRequest,
  DescribeSpotInstanceRequestsRequest,
  CreateIpamScopeRequest,
  ReplaceNetworkAclAssociationRequest,
  GetEbsEncryptionByDefaultRequest,
  DescribeDhcpOptionsRequest,
  ManagedPrefixList,
  ClientVpnRoute,
  DeleteNetworkInsightsPathResponse,
  RegisterTransitGatewayMulticastGroupSourcesRequest,
  CreateClientVpnEndpointRequest,
  DescribeNetworkInterfacesResponse,
  CreateTransitGatewayRouteRequest,
  EnableIpamOrganizationAdminAccountResponse,
  ModifyInstanceAttributeRequest,
  RejectVpcPeeringConnectionRequest,
  AllowedPrincipal,
  VpcEndpoint,
  AcceptTransitGatewayVpcAttachmentRequest,
  DescribeSpotInstanceRequestsResponse,
  ModifyAddressAttributeResponse,
  DescribeSnapshotTierStatusResponse,
  ClassicLinkInstance,
  DeleteManagedPrefixListResponse,
  DeregisterTransitGatewayMulticastGroupSourcesResponse,
  ReleaseHostsResponse,
  ExportTransitGatewayRoutesRequest,
  DescribeInstanceTypeOfferingsRequest,
  DescribeFpgaImageAttributeResponse,
  DescribeClientVpnEndpointsRequest,
  UpdateSecurityGroupRuleDescriptionsIngressRequest,
  CancelSpotFleetRequestsRequest,
  ModifyVpnTunnelCertificateRequest,
  DetachNetworkInterfaceResponse,
  CreateSubnetCidrReservationRequest,
  GetFlowLogsIntegrationTemplateRequest,
  ModifyIdentityIdFormatResponse,
  DescribeVpcEndpointServicesRequest,
  GetEbsDefaultKmsKeyIdResponse,
  EnableSerialConsoleAccessResponse,
  DescribeNetworkAclsRequest,
  DescribeVpnGatewaysResponse,
  DescribeSecurityGroupRulesRequest,
  NetworkAcl,
  DescribeSnapshotAttributeResponse,
  DescribeClientVpnConnectionsRequest,
  DescribeCustomerGatewaysRequest,
  ModifyFpgaImageAttributeRequest,
  ModifyCapacityReservationResponse,
  CreateCapacityReservationFleetResponse,
  TargetNetwork,
  DescribeTransitGatewayPeeringAttachmentsRequest,
  GetAssociatedEnclaveCertificateIamRolesRequest,
  DescribeAggregateIdFormatResponse,
  ModifyIpamScopeResponse,
  DisassociateTrunkInterfaceResponse,
  DisableIpamOrganizationAdminAccountResponse,
  DescribeNetworkInsightsAccessScopesRequest,
  GetEbsEncryptionByDefaultResponse,
  DescribeFleetHistoryResponse,
  DeleteIpamRequest,
  CreatePublicIpv4PoolRequest,
  DescribeVpcPeeringConnectionsRequest,
  DeprovisionPublicIpv4PoolCidrResponse,
  DeleteTransitGatewayConnectRequest,
  DescribeFastSnapshotRestoresRequest,
  FleetData,
  LocalGatewayVirtualInterfaceGroup,
  CreateTransitGatewayRouteTableResponse,
  DeleteTransitGatewayConnectPeerResponse,
  CreateCustomerGatewayResponse,
  DeleteTransitGatewayRequest,
  DescribeSpotPriceHistoryResponse,
  DeleteVpcRequest,
  CancelConversionTaskRequest,
  CreateNetworkAclRequest,
  GetCapacityReservationUsageResponse,
  DescribeIamInstanceProfileAssociationsRequest,
  CreateTrafficMirrorSessionRequest,
  CreateVpcPeeringConnectionRequest,
  DescribeInternetGatewaysResponse,
  LocalGatewayRouteTable,
  CreateTrafficMirrorFilterRuleRequest,
  ProvisionPublicIpv4PoolCidrResponse,
  DescribeInternetGatewaysRequest,
  DescribeVolumeStatusResponse,
  DescribePublicIpv4PoolsRequest,
  DeregisterTransitGatewayMulticastGroupMembersRequest,
  DisableVgwRoutePropagationResponse,
  DescribeInstanceTypesResponse,
  CreateKeyPairRequest,
  ModifyVpcEndpointServicePermissionsResponse,
  ModifyHostsRequest,
  SearchTransitGatewayRoutesRequest,
  GetReservedInstancesExchangeQuoteResponse,
  DetachInternetGatewayResponse,
  GetConsoleOutputRequest,
  ProvisionByoipCidrRequest,
  StartInstancesRequest,
  DescribeVpcEndpointServiceConfigurationsResponse,
  ModifyVpnConnectionResponse,
  DescribeNetworkAclsResponse,
  DescribeVpcAttributeRequest,
  ReplaceRouteTableAssociationRequest,
  UnassignPrivateIpAddressesRequest,
  DeleteCarrierGatewayRequest,
  GetConsoleScreenshotResponse,
  DeleteQueuedReservedInstancesRequest,
  DescribeNetworkInsightsAccessScopeAnalysesRequest,
  AuthorizationRule,
  GetFlowLogsIntegrationTemplateResponse,
  DescribeClassicLinkInstancesResponse,
  DescribeAggregateIdFormatRequest,
  AssociateAddressRequest,
  AssociateTransitGatewayMulticastDomainRequest,
  CreateReplaceRootVolumeTaskRequest,
  GetConsoleOutputResponse,
  CreateVpnGatewayResponse,
  AdvertiseByoipCidrRequest,
  DeprovisionByoipCidrRequest,
  RequestSpotFleetRequest,
  DeleteNetworkInsightsAccessScopeRequest,
  CreateCustomerGatewayRequest,
  DescribeVolumeStatusRequest,
  GetAssociatedIpv6PoolCidrsRequest,
  DescribeCarrierGatewaysResponse,
  AuthorizeSecurityGroupIngressRequest,
  DescribeVpcPeeringConnectionsResponse,
  CreateFleetRequest,
  ScheduledInstanceAvailability,
  DisableTransitGatewayRouteTablePropagationRequest,
  TerminateClientVpnConnectionsRequest,
  DeleteVpcEndpointServiceConfigurationsRequest,
  ResetImageAttributeResponse,
  DeleteTransitGatewayRouteResponse,
  DeleteNetworkAclEntryRequest,
  ImportSnapshotTask,
  DescribeExportTasksResponse,
  CreateSecurityGroupResponse,
  DescribeHostReservationOfferingsResponse,
  DisassociateEnclaveCertificateIamRoleResponse,
  CreateEgressOnlyInternetGatewayRequest,
  CopySnapshotResponse,
  ModifyVpnTunnelCertificateResponse,
  ModifyInstanceCapacityReservationAttributesResponse,
  GetTransitGatewayAttachmentPropagationsRequest,
  CreateVpcEndpointRequest,
  DescribeFpgaImagesResponse,
  CreateInstanceEventWindowRequest,
  CreatePlacementGroupResponse,
  DeleteIpamScopeRequest,
  CapacityReservation,
  CreateFlowLogsResponse,
  CreateVpnConnectionRouteRequest,
  DescribeTagsRequest,
  DescribeVpcClassicLinkRequest,
  ModifyVpnTunnelOptionsRequest,
  DeleteVpnConnectionRouteResponse,
  TransitGatewayMulticastDomainAssociation,
  AssociateDhcpOptionsResponse,
  DescribeSpotPriceHistoryRequest,
  PrincipalIdFormat,
  CreateSecurityGroupRequest,
  RevokeSecurityGroupIngressResponse,
  CopyFpgaImageRequest,
  ModifyTransitGatewayVpcAttachmentRequest,
  DescribeHostsResponse,
  CreateNetworkAclResponse,
  Ipam,
  CreateVolumeRequest,
  ReplaceRouteResponse,
  CreateRouteTableResponse,
  CreateManagedPrefixListRequest,
  ModifyInstancePlacementRequest,
  DescribeReservedInstancesRequest,
  PurchaseReservedInstancesOfferingResponse,
  DescribeConversionTasksRequest,
  DescribeNetworkInsightsAccessScopesResponse,
  GetTransitGatewayRouteTableAssociationsRequest,
  VolumeModification,
  CreateClientVpnRouteResponse,
  DeleteLocalGatewayRouteResponse,
  DescribeStaleSecurityGroupsRequest,
  CancelCapacityReservationFleetsResponse,
  DescribeSpotFleetRequestHistoryResponse,
  RegisterTransitGatewayMulticastGroupMembersRequest,
  DescribeVolumesResponse,
  DescribeImageAttributeResponse,
  ReleaseIpamPoolAllocationRequest,
  DetachInternetGatewayRequest,
  DeleteTrafficMirrorFilterRuleRequest,
  CreateVpcRequest,
  StopInstancesRequest,
  DescribeVolumesModificationsResponse,
  GetManagedPrefixListAssociationsRequest,
  GetVpnConnectionDeviceTypesRequest,
  DetachVolumeResponse,
  DescribeTransitGatewayRouteTablesResponse,
  CreateNetworkInterfaceResponse,
  DescribeImageAttributeRequest,
  BundleInstanceResponse,
  FpgaImage,
  ActiveInstance,
  NatGateway,
  ModifyNetworkInterfaceAttributeResponse,
  DescribeClientVpnAuthorizationRulesRequest,
  DeletePublicIpv4PoolResponse,
  Ipv6Pool,
  CreateRestoreImageTaskRequest,
  ImportInstanceRequest,
  CreateVolumeResponse,
  DescribeInstanceEventNotificationAttributesResponse,
  DisassociateInstanceEventWindowRequest,
  DeleteClientVpnEndpointRequest,
  ModifyInstanceEventStartTimeRequest,
  DeleteManagedPrefixListRequest,
  GetSpotPlacementScoresRequest,
  DeletePlacementGroupResponse,
  DeleteVpnConnectionRouteRequest,
  AttachClassicLinkVpcResponse,
  DescribeSecurityGroupReferencesResponse,
  ResetFpgaImageAttributeRequest,
  DescribeSpotDatafeedSubscriptionRequest,
  DescribeIpamPoolsResponse,
  DisableEbsEncryptionByDefaultRequest,
  LaunchTemplate,
  DeleteEgressOnlyInternetGatewayResponse,
  DescribeTrafficMirrorTargetsRequest,
  CreateTrafficMirrorTargetRequest,
  DeleteTransitGatewayMulticastDomainResponse,
  CancelConversionTaskResponse,
  ExportImageResponse,
  ModifyIdentityIdFormatRequest,
  CancelSpotFleetRequestsResponse,
  StaleSecurityGroup,
  CreateSubnetCidrReservationResponse,
  DeprovisionIpamPoolCidrRequest,
  ModifyIpamResponse,
  UnmonitorInstancesResponse,
  ImportInstanceResponse,
  CreateCarrierGatewayRequest,
  AdvertiseByoipCidrResponse,
  NetworkInsightsPath,
  EnableTransitGatewayRouteTablePropagationResponse,
  DescribeVolumesModificationsRequest,
  ModifyPrivateDnsNameOptionsResponse,
  DescribeIpv6PoolsRequest,
  ModifyInstanceCreditSpecificationRequest,
  DescribeReplaceRootVolumeTasksResponse,
  DescribeAccountAttributesRequest,
  CreateInstanceEventWindowResponse,
  RegisterTransitGatewayMulticastGroupSourcesResponse,
  CreateCapacityReservationResponse,
  MoveAddressToVpcRequest,
  LocalGatewayRoute,
  DeleteLaunchTemplateResponse,
  DescribeHostsRequest,
  ImportSnapshotRequest,
  DescribeVpnConnectionsRequest,
  DeleteLocalGatewayRouteTableVpcAssociationRequest,
  DescribeStaleSecurityGroupsResponse,
  ApplySecurityGroupsToClientVpnTargetNetworkResponse,
  DeleteTrafficMirrorTargetRequest,
  DeleteKeyPairResponse,
  GetNetworkInsightsAccessScopeContentRequest,
  DeleteVpnConnectionResponse,
  AssociateInstanceEventWindowRequest,
  DescribeSecurityGroupsRequest,
  AuthorizeSecurityGroupEgressResponse,
  CreateLaunchTemplateVersionRequest,
  DeleteInstanceEventWindowRequest,
  PrefixListAssociation,
  CreateStoreImageTaskResponse,
  DescribeInstancesRequest,
  DescribeCoipPoolsResponse,
  CreateLocalGatewayRouteTableVpcAssociationResponse,
  ModifyVpcPeeringConnectionOptionsRequest,
  RegisterImageRequest,
  DescribeVpcClassicLinkResponse,
  ModifyLaunchTemplateRequest,
  LocalGatewayRouteTableVpcAssociation,
  RequestSpotInstancesRequest,
  AcceptTransitGatewayMulticastDomainAssociationsRequest,
  DescribeReservedInstancesOfferingsResponse,
  DescribeFastSnapshotRestoreSuccessItem,
  StartVpcEndpointServicePrivateDnsVerificationRequest,
  RestoreAddressToClassicResponse,
  DescribeScheduledInstancesResponse,
  CreateTransitGatewayConnectPeerResponse,
  CreateTransitGatewayMulticastDomainResponse,
  CreatePlacementGroupRequest,
  ModifyVpnConnectionRequest,
  CreateLaunchTemplateVersionResponse,
  ResetEbsDefaultKmsKeyIdRequest,
  CreateSnapshotRequest,
  DescribeSpotDatafeedSubscriptionResponse,
  UpdateSecurityGroupRuleDescriptionsEgressResponse,
  UnassignPrivateIpAddressesResponse,
  DeleteVpnGatewayRequest,
  CreateImageRequest,
  CancelExportTaskRequest,
  HostOffering,
  SpotFleetRequestConfig,
  PrefixList,
  DeleteSubnetRequest,
  ModifyManagedPrefixListRequest,
  DescribeImagesRequest,
  ModifyIdFormatRequest,
  AttachVpnGatewayRequest,
  DescribeSpotFleetInstancesRequest,
  ProvisionIpamPoolCidrRequest,
  ModifyTransitGatewayRequest,
  GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
  GetNetworkInsightsAccessScopeContentResponse,
  RestoreSnapshotFromRecycleBinRequest,
  DescribeSnapshotAttributeRequest,
  DescribePublicIpv4PoolsResponse,
  DeleteTransitGatewayConnectPeerRequest,
  DescribeLocalGatewayVirtualInterfacesRequest,
  GetSerialConsoleAccessStatusRequest,
  DescribeByoipCidrsResponse,
  CreateRestoreImageTaskResponse,
  InstanceTypeInfoFromInstanceRequirements,
  CreateCapacityReservationRequest,
  ImportSnapshotResponse,
  UnassignIpv6AddressesRequest,
  ClientVpnConnection,
  DeregisterTransitGatewayMulticastGroupMembersResponse,
  DisableVgwRoutePropagationRequest,
  CreateNatGatewayRequest,
  CancelBundleTaskResponse,
  GetSubnetCidrReservationsResponse,
  CreateSnapshotsRequest,
  ScheduledInstance,
  CreateReplaceRootVolumeTaskResponse,
  CreateDefaultSubnetRequest,
  AssociateInstanceEventWindowResponse,
  ImportImageRequest,
  DeleteNetworkAclRequest,
  InstanceStatus,
  DescribePrefixListsResponse,
  ModifyClientVpnEndpointRequest,
  DescribeScheduledInstanceAvailabilityRequest,
  DescribeVpcEndpointServicePermissionsRequest,
  DescribeLaunchTemplatesResponse,
  SearchTransitGatewayRoutesResponse,
  AssociateEnclaveCertificateIamRoleResponse,
  DescribeSpotFleetRequestHistoryRequest,
  PurchaseHostReservationResponse,
  ModifySnapshotTierRequest,
  DeleteRouteTableResponse,
  LocalGatewayRouteTableVirtualInterfaceGroupAssociation,
  ExportClientVpnClientCertificateRevocationListResponse,
  DeleteFlowLogsResponse,
  DescribeIpv6PoolsResponse,
  StartNetworkInsightsAccessScopeAnalysisRequest,
  DescribeInstanceEventWindowsResponse,
  DescribeClientVpnRoutesRequest,
  AttachInternetGatewayRequest,
  Volume,
  CreateVpcEndpointConnectionNotificationResponse,
  DeleteFleetsResponse,
  DescribeAddressesAttributeRequest,
  ModifyInstanceCreditSpecificationResponse,
  DhcpOptions,
  DescribeTransitGatewayVpcAttachmentsResponse,
  DescribeTransitGatewayPeeringAttachmentsResponse,
  DescribeReservedInstancesListingsRequest,
  DescribeElasticGpusRequest,
  AssignIpv6AddressesResponse,
  Ipv6CidrAssociation,
  StoreImageTaskResult,
  ImportImageResponse,
  CreateTransitGatewayVpcAttachmentResponse,
  ModifyInstancePlacementResponse,
  CreateTransitGatewayPrefixListReferenceRequest,
  DescribeVpcEndpointServicesResponse,
  CreateInternetGatewayRequest,
  DescribeIdFormatResponse,
  DescribeVpcClassicLinkDnsSupportRequest,
  DescribeFlowLogsResponse,
  TransitGatewayConnectPeer,
  GetDefaultCreditSpecificationRequest,
  DescribeCapacityReservationFleetsResponse,
  DeleteClientVpnRouteRequest,
  DescribeRegionsResponse,
  DeleteEgressOnlyInternetGatewayRequest,
  GetEbsDefaultKmsKeyIdRequest,
  InternetGateway,
  InstanceEventWindow,
  ModifyVolumeRequest,
  DeleteTransitGatewayRouteRequest,
  DescribeInstanceStatusRequest,
  AttachVolumeResponse,
  CreateEgressOnlyInternetGatewayResponse,
  DescribeNetworkInterfacesRequest,
  DeleteLaunchTemplateRequest,
  ListSnapshotsInRecycleBinResponse,
  DescribeVpcsRequest,
  RebootInstancesRequest,
  DisassociateSubnetCidrBlockRequest,
  StopInstancesResponse,
  CreateImageResponse,
  CarrierGateway,
  DescribeTagsResponse,
  IpamPoolCidr,
  DescribeAddressesAttributeResponse,
  ModifySnapshotTierResponse,
  ElasticGpus,
  ConfirmProductInstanceResponse,
  DeregisterImageResponse,
  TrafficMirrorFilter,
  DescribeScheduledInstancesRequest,
  DescribeHostReservationsRequest,
  AssignIpv6AddressesRequest,
  DeleteVpcEndpointConnectionNotificationsRequest,
  AcceptTransitGatewayPeeringAttachmentRequest,
  DeleteLaunchTemplateVersionsRequest,
  DescribeSpotFleetInstancesResponse,
  DisassociateRouteTableResponse,
  MonitorInstancesRequest,
  CreateSpotDatafeedSubscriptionResponse,
  CancelReservedInstancesListingRequest,
  CreateVpcPeeringConnectionResponse,
  AssociateTrunkInterfaceResponse,
  DescribeBundleTasksRequest,
  CreateInstanceExportTaskResponse,
  SnapshotTierStatus,
  PurchaseReservedInstancesOfferingRequest,
  DescribeNetworkInterfacePermissionsResponse,
  ModifySpotFleetRequestResponse,
  GetReservedInstancesExchangeQuoteRequest,
  AcceptTransitGatewayMulticastDomainAssociationsResponse,
  CreateVpcEndpointServiceConfigurationRequest,
  RegisterInstanceEventNotificationAttributesRequest,
  RunScheduledInstancesResponse,
  DescribeImportSnapshotTasksResponse,
  DescribePrincipalIdFormatResponse,
  DescribeNetworkInsightsAccessScopeAnalysesResponse,
  ModifyInstanceMetadataOptionsRequest,
  DescribeVpcClassicLinkDnsSupportResponse,
  ResetEbsDefaultKmsKeyIdResponse,
  DeleteVpcPeeringConnectionRequest,
  EnableVolumeIoRequest,
  GetLaunchTemplateDataResponse,
  EnableVgwRoutePropagationRequest,
  DescribeClientVpnAuthorizationRulesResponse,
  CreateTransitGatewayRouteTableRequest,
  DescribeRouteTablesRequest,
  FlowLog,
  DescribeIamInstanceProfileAssociationsResponse,
  ImportKeyPairRequest,
  ModifyVpcPeeringConnectionOptionsResponse,
  CreateSubnetRequest,
  TransitGatewayAttachmentPropagation,
  DisassociateSubnetCidrBlockResponse,
  EnableFastSnapshotRestoresResponse,
  CreateSnapshotResponse,
  SendDiagnosticInterruptRequest,
  ModifyVolumeResponse,
  ModifyDefaultCreditSpecificationResponse,
  DescribeAccountAttributesResponse,
  DescribeManagedPrefixListsRequest,
  RejectTransitGatewayMulticastDomainAssociationsResponse,
  DeleteCustomerGatewayResponse,
  DescribeByoipCidrsRequest,
  DeleteNetworkInsightsAccessScopeResponse,
  EnableTransitGatewayRouteTablePropagationRequest,
  DescribeLaunchTemplateVersionsRequest,
  AcceptReservedInstancesExchangeQuoteRequest,
  EnableVpcClassicLinkDnsSupportResponse,
  DeleteIpamScopeResponse,
  DescribeImportImageTasksResponse,
  DeleteVpcPeeringConnectionResponse,
  ResetInstanceAttributeRequest,
  ModifySubnetAttributeResponse,
  GetLaunchTemplateDataRequest,
  DeleteVpcResponse,
  EnableImageDeprecationResponse,
  DeleteSnapshotResponse,
  SecurityGroupRule,
  SearchLocalGatewayRoutesResponse,
  DescribeIpamScopesRequest,
  AssociateEnclaveCertificateIamRoleRequest,
  GetVpnConnectionDeviceSampleConfigurationRequest,
  ModifyAddressAttributeRequest,
  SendDiagnosticInterruptResponse,
  EnableSerialConsoleAccessRequest,
  AssociateIamInstanceProfileRequest,
  UnmonitorInstancesRequest,
  DisableEbsEncryptionByDefaultResponse,
  CreateKeyPairResponse,
  SnapshotRecycleBinInfo,
  DisassociateClientVpnTargetNetworkResponse,
  StartInstancesResponse,
  DisableSerialConsoleAccessRequest,
  DescribeFastSnapshotRestoresResponse,
  GetNetworkInsightsAccessScopeAnalysisFindingsResponse,
  DisassociateVpcCidrBlockRequest,
  CreateTransitGatewayPeeringAttachmentRequest,
  DescribeClassicLinkInstancesRequest,
  RevokeSecurityGroupIngressRequest,
  AttachInternetGatewayResponse,
  CancelReservedInstancesListingResponse,
  DeleteNetworkInterfacePermissionRequest,
  GetAssociatedEnclaveCertificateIamRolesResponse,
  DescribeFlowLogsRequest,
  DescribeNetworkInterfaceAttributeRequest,
  ModifyVolumeAttributeRequest,
  DeleteTransitGatewayRouteTableRequest,
  CreateNetworkInsightsAccessScopeResponse,
  ModifyIpamPoolRequest,
  RejectVpcEndpointConnectionsRequest,
  CreateLaunchTemplateRequest,
  GetInstanceTypesFromInstanceRequirementsRequest,
  DisableFastSnapshotRestoresRequest,
  CreateNetworkInterfaceRequest,
  DescribeRegionsRequest,
  DeprovisionByoipCidrResponse,
  IamInstanceProfileAssociation,
  DeleteTransitGatewayVpcAttachmentResponse,
  DescribeCoipPoolsRequest,
  DescribeStoreImageTasksResponse,
  AssignPrivateIpAddressesResponse,
  GetIpamPoolAllocationsRequest,
  AllocateHostsResponse,
  DeleteIpamPoolResponse,
  CreateIpamPoolResponse,
  DescribeInstanceCreditSpecificationsRequest,
  CreateInternetGatewayResponse,
  CapacityReservationFleet,
  DescribeClientVpnTargetNetworksResponse,
  AttachVolumeRequest,
  AssociateSubnetCidrBlockRequest,
  CreateTagsResponse,
  CreateTransitGatewayRouteResponse,
  AcceptVpcEndpointConnectionsRequest,
  ModifyVpcEndpointConnectionNotificationResponse,
  GetIpamResourceCidrsRequest,
  DescribeTransitGatewayConnectsResponse,
  DescribeScheduledInstanceAvailabilityResponse,
  EnableVolumeIoResponse,
  WithdrawByoipCidrRequest,
  DeleteNetworkAclResponse,
  GetTransitGatewayRouteTablePropagationsRequest,
  SpotInstanceRequest,
  CreateSubnetResponse,
  AuthorizeSecurityGroupIngressResponse,
  ResetAddressAttributeRequest,
  ModifyNetworkInterfaceAttributeRequest,
  ResetAddressAttributeResponse,
  TransitGatewayRouteTablePropagation,
  DescribeVpnGatewaysRequest,
  CreateTransitGatewayVpcAttachmentRequest
}
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.ec2.{
  Ec2AsyncClientBuilder,
  Ec2AsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Ec2 extends AspectSupport[Ec2] {
  val api: Ec2AsyncClient
  def describeVolumesModifications(
      request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VolumeModification.ReadOnly]
  def describeVolumesModificationsPaginated(
      request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly
  ]
  def deleteSpotDatafeedSubscription(
      request: zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest
  ): IO[AwsError, Unit]
  def deleteVpcEndpointConnectionNotifications(
      request: zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.ReadOnly
  ]
  def createNetworkInterface(
      request: zio.aws.ec2.model.CreateNetworkInterfaceRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly]
  def enableVpcClassicLink(
      request: zio.aws.ec2.model.EnableVpcClassicLinkRequest
  ): IO[AwsError, zio.aws.ec2.model.EnableVpcClassicLinkResponse.ReadOnly]
  def rejectTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly
  ]
  def createVpnConnection(
      request: zio.aws.ec2.model.CreateVpnConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly]
  def describeDhcpOptions(
      request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.DhcpOptions.ReadOnly]
  def describeDhcpOptionsPaginated(
      request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly]
  def modifyVpnTunnelOptions(
      request: zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly]
  def modifyCapacityReservation(
      request: zio.aws.ec2.model.ModifyCapacityReservationRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyCapacityReservationResponse.ReadOnly]
  def describeVpcs(
      request: zio.aws.ec2.model.DescribeVpcsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Vpc.ReadOnly]
  def describeVpcsPaginated(
      request: zio.aws.ec2.model.DescribeVpcsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly]
  def deleteNetworkInsightsAnalysis(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly
  ]
  def describeIdentityIdFormat(
      request: zio.aws.ec2.model.DescribeIdentityIdFormatRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly]
  def describeTags(
      request: zio.aws.ec2.model.DescribeTagsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TagDescription.ReadOnly]
  def describeTagsPaginated(
      request: zio.aws.ec2.model.DescribeTagsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeTagsResponse.ReadOnly]
  def monitorInstances(
      request: zio.aws.ec2.model.MonitorInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly]
  def allocateIpamPoolCidr(
      request: zio.aws.ec2.model.AllocateIpamPoolCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly]
  def getManagedPrefixListEntries(
      request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixListEntry.ReadOnly]
  def getManagedPrefixListEntriesPaginated(
      request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly
  ]
  def deleteTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly
  ]
  def getTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
  ]
  def getTransitGatewayMulticastDomainAssociationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ]
  def modifyIpamResourceCidr(
      request: zio.aws.ec2.model.ModifyIpamResourceCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly]
  def createTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly
  ]
  def replaceNetworkAclEntry(
      request: zio.aws.ec2.model.ReplaceNetworkAclEntryRequest
  ): IO[AwsError, Unit]
  def describeVpcPeeringConnections(
      request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcPeeringConnection.ReadOnly]
  def describeVpcPeeringConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
  ]
  def describeFleetHistory(
      request: zio.aws.ec2.model.DescribeFleetHistoryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly,
    zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
  ]]
  def describeFleetHistoryPaginated(
      request: zio.aws.ec2.model.DescribeFleetHistoryRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly]
  def cancelSpotFleetRequests(
      request: zio.aws.ec2.model.CancelSpotFleetRequestsRequest
  ): IO[AwsError, zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly]
  def bundleInstance(
      request: zio.aws.ec2.model.BundleInstanceRequest
  ): IO[AwsError, zio.aws.ec2.model.BundleInstanceResponse.ReadOnly]
  def revokeClientVpnIngress(
      request: zio.aws.ec2.model.RevokeClientVpnIngressRequest
  ): IO[AwsError, zio.aws.ec2.model.RevokeClientVpnIngressResponse.ReadOnly]
  def deleteSubnetCidrReservation(
      request: zio.aws.ec2.model.DeleteSubnetCidrReservationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly
  ]
  def associateTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly
  ]
  def searchTransitGatewayMulticastGroups(
      request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
  ]
  def searchTransitGatewayMulticastGroupsPaginated(
      request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly
  ]
  def sendDiagnosticInterrupt(
      request: zio.aws.ec2.model.SendDiagnosticInterruptRequest
  ): IO[AwsError, Unit]
  def describeAddresses(
      request: zio.aws.ec2.model.DescribeAddressesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly]
  def enableTransitGatewayRouteTablePropagation(
      request: zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly
  ]
  def deleteIpamScope(
      request: zio.aws.ec2.model.DeleteIpamScopeRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly]
  def createPublicIpv4Pool(
      request: zio.aws.ec2.model.CreatePublicIpv4PoolRequest
  ): IO[AwsError, zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly]
  def createTransitGatewayRouteTable(
      request: zio.aws.ec2.model.CreateTransitGatewayRouteTableRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.ReadOnly
  ]
  def registerTransitGatewayMulticastGroupMembers(
      request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
  ]
  def describeKeyPairs(
      request: zio.aws.ec2.model.DescribeKeyPairsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly]
  def startInstances(
      request: zio.aws.ec2.model.StartInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.StartInstancesResponse.ReadOnly]
  def describeScheduledInstanceAvailability(
      request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
  ]
  def describeScheduledInstanceAvailabilityPaginated(
      request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly
  ]
  def resetInstanceAttribute(
      request: zio.aws.ec2.model.ResetInstanceAttributeRequest
  ): IO[AwsError, Unit]
  def modifyInstanceMetadataOptions(
      request: zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly
  ]
  def createRoute(
      request: zio.aws.ec2.model.CreateRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateRouteResponse.ReadOnly]
  def deleteFlowLogs(
      request: zio.aws.ec2.model.DeleteFlowLogsRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteFlowLogsResponse.ReadOnly]
  def describeFpgaImages(
      request: zio.aws.ec2.model.DescribeFpgaImagesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.FpgaImage.ReadOnly]
  def describeFpgaImagesPaginated(
      request: zio.aws.ec2.model.DescribeFpgaImagesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly]
  def deleteRoute(
      request: zio.aws.ec2.model.DeleteRouteRequest
  ): IO[AwsError, Unit]
  def modifyClientVpnEndpoint(
      request: zio.aws.ec2.model.ModifyClientVpnEndpointRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly]
  def modifyTrafficMirrorFilterNetworkServices(
      request: zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly
  ]
  def disassociateTransitGatewayRouteTable(
      request: zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly
  ]
  def modifyInstanceCapacityReservationAttributes(
      request: zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly
  ]
  def describeRouteTables(
      request: zio.aws.ec2.model.DescribeRouteTablesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.RouteTable.ReadOnly]
  def describeRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeRouteTablesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly]
  def modifySubnetAttribute(
      request: zio.aws.ec2.model.ModifySubnetAttributeRequest
  ): IO[AwsError, Unit]
  def modifyVolumeAttribute(
      request: zio.aws.ec2.model.ModifyVolumeAttributeRequest
  ): IO[AwsError, Unit]
  def acceptVpcEndpointConnections(
      request: zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly
  ]
  def attachNetworkInterface(
      request: zio.aws.ec2.model.AttachNetworkInterfaceRequest
  ): IO[AwsError, zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly]
  def deleteFpgaImage(
      request: zio.aws.ec2.model.DeleteFpgaImageRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly]
  def deleteTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.ReadOnly
  ]
  def deleteSecurityGroup(
      request: zio.aws.ec2.model.DeleteSecurityGroupRequest
  ): IO[AwsError, Unit]
  def describeNatGateways(
      request: zio.aws.ec2.model.DescribeNatGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.NatGateway.ReadOnly]
  def describeNatGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeNatGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly]
  def getCoipPoolUsage(
      request: zio.aws.ec2.model.GetCoipPoolUsageRequest
  ): IO[AwsError, zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly]
  def authorizeSecurityGroupEgress(
      request: zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly
  ]
  def modifyVpcEndpoint(
      request: zio.aws.ec2.model.ModifyVpcEndpointRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpcEndpointResponse.ReadOnly]
  def deprovisionIpamPoolCidr(
      request: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly]
  def deleteTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly
  ]
  def createInternetGateway(
      request: zio.aws.ec2.model.CreateInternetGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly]
  def describeCarrierGateways(
      request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.CarrierGateway.ReadOnly]
  def describeCarrierGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly]
  def disableSerialConsoleAccess(
      request: zio.aws.ec2.model.DisableSerialConsoleAccessRequest
  ): IO[AwsError, zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly]
  def enableEbsEncryptionByDefault(
      request: zio.aws.ec2.model.EnableEbsEncryptionByDefaultRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.ReadOnly
  ]
  def modifyTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.ReadOnly
  ]
  def assignPrivateIpAddresses(
      request: zio.aws.ec2.model.AssignPrivateIpAddressesRequest
  ): IO[AwsError, zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly]
  def modifyLaunchTemplate(
      request: zio.aws.ec2.model.ModifyLaunchTemplateRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly]
  def deleteRouteTable(
      request: zio.aws.ec2.model.DeleteRouteTableRequest
  ): IO[AwsError, Unit]
  def restoreAddressToClassic(
      request: zio.aws.ec2.model.RestoreAddressToClassicRequest
  ): IO[AwsError, zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly]
  def describeMovingAddresses(
      request: zio.aws.ec2.model.DescribeMovingAddressesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.MovingAddressStatus.ReadOnly]
  def describeMovingAddressesPaginated(
      request: zio.aws.ec2.model.DescribeMovingAddressesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly]
  def modifyPrivateDnsNameOptions(
      request: zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.ReadOnly
  ]
  def describeFleetInstances(
      request: zio.aws.ec2.model.DescribeFleetInstancesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly,
    zio.aws.ec2.model.ActiveInstance.ReadOnly
  ]]
  def describeFleetInstancesPaginated(
      request: zio.aws.ec2.model.DescribeFleetInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly]
  def describeSecurityGroupRules(
      request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def describeSecurityGroupRulesPaginated(
      request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly]
  def rejectVpcPeeringConnection(
      request: zio.aws.ec2.model.RejectVpcPeeringConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly]
  def attachInternetGateway(
      request: zio.aws.ec2.model.AttachInternetGatewayRequest
  ): IO[AwsError, Unit]
  def describeAvailabilityZones(
      request: zio.aws.ec2.model.DescribeAvailabilityZonesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly]
  def cancelBundleTask(
      request: zio.aws.ec2.model.CancelBundleTaskRequest
  ): IO[AwsError, zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly]
  def describeLocalGateways(
      request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGateway.ReadOnly]
  def describeLocalGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly]
  def deleteVpc(request: zio.aws.ec2.model.DeleteVpcRequest): IO[AwsError, Unit]
  def deleteVpnConnectionRoute(
      request: zio.aws.ec2.model.DeleteVpnConnectionRouteRequest
  ): IO[AwsError, Unit]
  def deleteTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.ReadOnly
  ]
  def disassociateClientVpnTargetNetwork(
      request: zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly
  ]
  def describeInstances(
      request: zio.aws.ec2.model.DescribeInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Reservation.ReadOnly]
  def describeInstancesPaginated(
      request: zio.aws.ec2.model.DescribeInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly]
  def describeVpnConnections(
      request: zio.aws.ec2.model.DescribeVpnConnectionsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly]
  def attachClassicLinkVpc(
      request: zio.aws.ec2.model.AttachClassicLinkVpcRequest
  ): IO[AwsError, zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly]
  def createLaunchTemplateVersion(
      request: zio.aws.ec2.model.CreateLaunchTemplateVersionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly
  ]
  def deleteNetworkInsightsAccessScope(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly
  ]
  def modifyVpcEndpointConnectionNotification(
      request: zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.ReadOnly
  ]
  def describeInstanceTypes(
      request: zio.aws.ec2.model.DescribeInstanceTypesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceTypeInfo.ReadOnly]
  def describeInstanceTypesPaginated(
      request: zio.aws.ec2.model.DescribeInstanceTypesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly]
  def rebootInstances(
      request: zio.aws.ec2.model.RebootInstancesRequest
  ): IO[AwsError, Unit]
  def describeInstanceCreditSpecifications(
      request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
  ]
  def describeInstanceCreditSpecificationsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly
  ]
  def describeFleets(
      request: zio.aws.ec2.model.DescribeFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.FleetData.ReadOnly]
  def describeFleetsPaginated(
      request: zio.aws.ec2.model.DescribeFleetsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly]
  def getSpotPlacementScores(
      request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotPlacementScore.ReadOnly]
  def getSpotPlacementScoresPaginated(
      request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
  ): IO[AwsError, zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly]
  def createDefaultSubnet(
      request: zio.aws.ec2.model.CreateDefaultSubnetRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateDefaultSubnetResponse.ReadOnly]
  def modifyVolume(
      request: zio.aws.ec2.model.ModifyVolumeRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly]
  def getSerialConsoleAccessStatus(
      request: zio.aws.ec2.model.GetSerialConsoleAccessStatusRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly
  ]
  def getEbsEncryptionByDefault(
      request: zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest
  ): IO[AwsError, zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly]
  def describeSnapshotTierStatus(
      request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SnapshotTierStatus.ReadOnly]
  def describeSnapshotTierStatusPaginated(
      request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly]
  def resetNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest
  ): IO[AwsError, Unit]
  def modifyTransitGateway(
      request: zio.aws.ec2.model.ModifyTransitGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly]
  def enableVolumeIO(
      request: zio.aws.ec2.model.EnableVolumeIoRequest
  ): IO[AwsError, Unit]
  def deleteTransitGatewayRoute(
      request: zio.aws.ec2.model.DeleteTransitGatewayRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly]
  def describeImportSnapshotTasks(
      request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ImportSnapshotTask.ReadOnly]
  def describeImportSnapshotTasksPaginated(
      request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly
  ]
  def describeNetworkInsightsAnalyses(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly]
  def describeNetworkInsightsAnalysesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly
  ]
  def disassociateSubnetCidrBlock(
      request: zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.ReadOnly
  ]
  def cancelExportTask(
      request: zio.aws.ec2.model.CancelExportTaskRequest
  ): IO[AwsError, Unit]
  def deleteVpnGateway(
      request: zio.aws.ec2.model.DeleteVpnGatewayRequest
  ): IO[AwsError, Unit]
  def associateVpcCidrBlock(
      request: zio.aws.ec2.model.AssociateVpcCidrBlockRequest
  ): IO[AwsError, zio.aws.ec2.model.AssociateVpcCidrBlockResponse.ReadOnly]
  def modifyInstanceEventStartTime(
      request: zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly
  ]
  def reportInstanceStatus(
      request: zio.aws.ec2.model.ReportInstanceStatusRequest
  ): IO[AwsError, Unit]
  def createVpcEndpointServiceConfiguration(
      request: zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly
  ]
  def getEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.GetEbsDefaultKmsKeyIdRequest
  ): IO[AwsError, zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly]
  def deleteNetworkInterfacePermission(
      request: zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.ReadOnly
  ]
  def describeTransitGatewayPeeringAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
  ]
  def describeTransitGatewayPeeringAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly
  ]
  def describeReservedInstances(
      request: zio.aws.ec2.model.DescribeReservedInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly]
  def describeLocalGatewayVirtualInterfaces(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
  ]
  def describeLocalGatewayVirtualInterfacesPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly
  ]
  def modifySecurityGroupRules(
      request: zio.aws.ec2.model.ModifySecurityGroupRulesRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifySecurityGroupRulesResponse.ReadOnly]
  def createEgressOnlyInternetGateway(
      request: zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly
  ]
  def getPasswordData(
      request: zio.aws.ec2.model.GetPasswordDataRequest
  ): IO[AwsError, zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly]
  def exportClientVpnClientCertificateRevocationList(
      request: zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly
  ]
  def purchaseScheduledInstances(
      request: zio.aws.ec2.model.PurchaseScheduledInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly]
  def getTransitGatewayAttachmentPropagations(
      request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
  ]
  def getTransitGatewayAttachmentPropagationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly
  ]
  def describeClassicLinkInstances(
      request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ClassicLinkInstance.ReadOnly]
  def describeClassicLinkInstancesPaginated(
      request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly
  ]
  def describeCoipPools(
      request: zio.aws.ec2.model.DescribeCoipPoolsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly]
  def describeCoipPoolsPaginated(
      request: zio.aws.ec2.model.DescribeCoipPoolsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly]
  def createVpcEndpointConnectionNotification(
      request: zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly
  ]
  def modifyVpnConnectionOptions(
      request: zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly]
  def getSubnetCidrReservations(
      request: zio.aws.ec2.model.GetSubnetCidrReservationsRequest
  ): IO[AwsError, zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly]
  def deleteDhcpOptions(
      request: zio.aws.ec2.model.DeleteDhcpOptionsRequest
  ): IO[AwsError, Unit]
  def requestSpotInstances(
      request: zio.aws.ec2.model.RequestSpotInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly]
  def deleteCustomerGateway(
      request: zio.aws.ec2.model.DeleteCustomerGatewayRequest
  ): IO[AwsError, Unit]
  def deleteTransitGateway(
      request: zio.aws.ec2.model.DeleteTransitGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteTransitGatewayResponse.ReadOnly]
  def authorizeSecurityGroupIngress(
      request: zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly
  ]
  def terminateClientVpnConnections(
      request: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly
  ]
  def importVolume(
      request: zio.aws.ec2.model.ImportVolumeRequest
  ): IO[AwsError, zio.aws.ec2.model.ImportVolumeResponse.ReadOnly]
  def deregisterTransitGatewayMulticastGroupSources(
      request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
  ]
  def disassociateTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly
  ]
  def describeVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly]
  def describeVpcClassicLinkDnsSupportPaginated(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly
  ]
  def describeInstanceEventWindows(
      request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceEventWindow.ReadOnly]
  def describeInstanceEventWindowsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly
  ]
  def applySecurityGroupsToClientVpnTargetNetwork(
      request: zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly
  ]
  def createSnapshots(
      request: zio.aws.ec2.model.CreateSnapshotsRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly]
  def rejectVpcEndpointConnections(
      request: zio.aws.ec2.model.RejectVpcEndpointConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.ReadOnly
  ]
  def copySnapshot(
      request: zio.aws.ec2.model.CopySnapshotRequest
  ): IO[AwsError, zio.aws.ec2.model.CopySnapshotResponse.ReadOnly]
  def describeInstanceTypeOfferings(
      request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceTypeOffering.ReadOnly]
  def describeInstanceTypeOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly
  ]
  def deleteManagedPrefixList(
      request: zio.aws.ec2.model.DeleteManagedPrefixListRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly]
  def deleteTransitGatewayRouteTable(
      request: zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly
  ]
  def describeHosts(
      request: zio.aws.ec2.model.DescribeHostsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Host.ReadOnly]
  def describeHostsPaginated(
      request: zio.aws.ec2.model.DescribeHostsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeHostsResponse.ReadOnly]
  def modifyIdFormat(
      request: zio.aws.ec2.model.ModifyIdFormatRequest
  ): IO[AwsError, Unit]
  def getGroupsForCapacityReservation(
      request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.CapacityReservationGroup.ReadOnly]
  def getGroupsForCapacityReservationPaginated(
      request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly
  ]
  def disableEbsEncryptionByDefault(
      request: zio.aws.ec2.model.DisableEbsEncryptionByDefaultRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.ReadOnly
  ]
  def createTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly
  ]
  def describeVpnGateways(
      request: zio.aws.ec2.model.DescribeVpnGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly]
  def deprovisionByoipCidr(
      request: zio.aws.ec2.model.DeprovisionByoipCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.DeprovisionByoipCidrResponse.ReadOnly]
  def describeSubnets(
      request: zio.aws.ec2.model.DescribeSubnetsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Subnet.ReadOnly]
  def describeSubnetsPaginated(
      request: zio.aws.ec2.model.DescribeSubnetsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly]
  def describeSpotFleetRequestHistory(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly,
    zio.aws.ec2.model.HistoryRecord.ReadOnly
  ]]
  def describeSpotFleetRequestHistoryPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly
  ]
  def unmonitorInstances(
      request: zio.aws.ec2.model.UnmonitorInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.UnmonitorInstancesResponse.ReadOnly]
  def createManagedPrefixList(
      request: zio.aws.ec2.model.CreateManagedPrefixListRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateManagedPrefixListResponse.ReadOnly]
  def describeTransitGatewayConnectPeers(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
  ]
  def describeTransitGatewayConnectPeersPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly
  ]
  def describeTransitGatewayConnects(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TransitGatewayConnect.ReadOnly]
  def describeTransitGatewayConnectsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly
  ]
  def createIpamScope(
      request: zio.aws.ec2.model.CreateIpamScopeRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly]
  def describeTrafficMirrorTargets(
      request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly]
  def describeTrafficMirrorTargetsPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly
  ]
  def deleteVpcEndpoints(
      request: zio.aws.ec2.model.DeleteVpcEndpointsRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteVpcEndpointsResponse.ReadOnly]
  def disassociateIamInstanceProfile(
      request: zio.aws.ec2.model.DisassociateIamInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly
  ]
  def modifyFleet(
      request: zio.aws.ec2.model.ModifyFleetRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyFleetResponse.ReadOnly]
  def describeVpcEndpointServiceConfigurations(
      request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ServiceConfiguration.ReadOnly]
  def describeVpcEndpointServiceConfigurationsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly
  ]
  def deleteNetworkAclEntry(
      request: zio.aws.ec2.model.DeleteNetworkAclEntryRequest
  ): IO[AwsError, Unit]
  def updateSecurityGroupRuleDescriptionsIngress(
      request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.ReadOnly
  ]
  def describeCapacityReservations(
      request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.CapacityReservation.ReadOnly]
  def describeCapacityReservationsPaginated(
      request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly
  ]
  def createTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly
  ]
  def startVpcEndpointServicePrivateDnsVerification(
      request: zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly
  ]
  def createLaunchTemplate(
      request: zio.aws.ec2.model.CreateLaunchTemplateRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly]
  def deleteTrafficMirrorFilter(
      request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly]
  def describeLocalGatewayRouteTables(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly]
  def describeLocalGatewayRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly
  ]
  def describeNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly
  ]
  def createCapacityReservationFleet(
      request: zio.aws.ec2.model.CreateCapacityReservationFleetRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly
  ]
  def deleteLaunchTemplate(
      request: zio.aws.ec2.model.DeleteLaunchTemplateRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly]
  def replaceNetworkAclAssociation(
      request: zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly
  ]
  def getManagedPrefixListAssociations(
      request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixListAssociation.ReadOnly]
  def getManagedPrefixListAssociationsPaginated(
      request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly
  ]
  def createNetworkAcl(
      request: zio.aws.ec2.model.CreateNetworkAclRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly]
  def describeVpcEndpointConnections(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcEndpointConnection.ReadOnly]
  def describeVpcEndpointConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly
  ]
  def createLocalGatewayRouteTableVpcAssociation(
      request: zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
  ]
  def describeVpcAttribute(
      request: zio.aws.ec2.model.DescribeVpcAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly]
  def describeStoreImageTasks(
      request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.StoreImageTaskResult.ReadOnly]
  def describeStoreImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeStoreImageTasksResponse.ReadOnly]
  def describeFastSnapshotRestores(
      request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
  ]
  def describeFastSnapshotRestoresPaginated(
      request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly
  ]
  def modifyInstancePlacement(
      request: zio.aws.ec2.model.ModifyInstancePlacementRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyInstancePlacementResponse.ReadOnly]
  def createIpamPool(
      request: zio.aws.ec2.model.CreateIpamPoolRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly]
  def modifySnapshotTier(
      request: zio.aws.ec2.model.ModifySnapshotTierRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly]
  def describeSpotFleetRequests(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly]
  def describeSpotFleetRequestsPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly]
  def getTransitGatewayRouteTableAssociations(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
  ]
  def getTransitGatewayRouteTableAssociationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly
  ]
  def releaseIpamPoolAllocation(
      request: zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest
  ): IO[AwsError, zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly]
  def registerImage(
      request: zio.aws.ec2.model.RegisterImageRequest
  ): IO[AwsError, zio.aws.ec2.model.RegisterImageResponse.ReadOnly]
  def createDhcpOptions(
      request: zio.aws.ec2.model.CreateDhcpOptionsRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly]
  def describeReservedInstancesModifications(
      request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
  ]
  def describeReservedInstancesModificationsPaginated(
      request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly
  ]
  def describeSpotDatafeedSubscription(
      request: zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly
  ]
  def describeNetworkInsightsAccessScopeAnalyses(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
  ]
  def describeNetworkInsightsAccessScopeAnalysesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly
  ]
  def createTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly
  ]
  def searchLocalGatewayRoutes(
      request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGatewayRoute.ReadOnly]
  def searchLocalGatewayRoutesPaginated(
      request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
  ): IO[AwsError, zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly]
  def describeHostReservationOfferings(
      request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.HostOffering.ReadOnly]
  def describeHostReservationOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly
  ]
  def modifyIpam(
      request: zio.aws.ec2.model.ModifyIpamRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyIpamResponse.ReadOnly]
  def disableVpcClassicLink(
      request: zio.aws.ec2.model.DisableVpcClassicLinkRequest
  ): IO[AwsError, zio.aws.ec2.model.DisableVpcClassicLinkResponse.ReadOnly]
  def getNetworkInsightsAccessScopeContent(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.ReadOnly
  ]
  def createCapacityReservation(
      request: zio.aws.ec2.model.CreateCapacityReservationRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly]
  def modifyAddressAttribute(
      request: zio.aws.ec2.model.ModifyAddressAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly]
  def createNetworkInterfacePermission(
      request: zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly
  ]
  def describeLaunchTemplateVersions(
      request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly]
  def describeLaunchTemplateVersionsPaginated(
      request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly
  ]
  def allocateHosts(
      request: zio.aws.ec2.model.AllocateHostsRequest
  ): IO[AwsError, zio.aws.ec2.model.AllocateHostsResponse.ReadOnly]
  def describeExportImageTasks(
      request: zio.aws.ec2.model.DescribeExportImageTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ExportImageTask.ReadOnly]
  def describeExportImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeExportImageTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly]
  def describeSpotFleetInstances(
      request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly,
    zio.aws.ec2.model.ActiveInstance.ReadOnly
  ]]
  def describeSpotFleetInstancesPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly]
  def rejectTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly
  ]
  def describeByoipCidrs(
      request: zio.aws.ec2.model.DescribeByoipCidrsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly]
  def describeByoipCidrsPaginated(
      request: zio.aws.ec2.model.DescribeByoipCidrsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly]
  def moveAddressToVpc(
      request: zio.aws.ec2.model.MoveAddressToVpcRequest
  ): IO[AwsError, zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly]
  def disassociateAddress(
      request: zio.aws.ec2.model.DisassociateAddressRequest
  ): IO[AwsError, Unit]
  def resetFpgaImageAttribute(
      request: zio.aws.ec2.model.ResetFpgaImageAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly]
  def modifyImageAttribute(
      request: zio.aws.ec2.model.ModifyImageAttributeRequest
  ): IO[AwsError, Unit]
  def restoreSnapshotFromRecycleBin(
      request: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly
  ]
  def exportClientVpnClientConfiguration(
      request: zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly
  ]
  def restoreSnapshotTier(
      request: zio.aws.ec2.model.RestoreSnapshotTierRequest
  ): IO[AwsError, zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly]
  def registerTransitGatewayMulticastGroupSources(
      request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
  ]
  def deleteNetworkInterface(
      request: zio.aws.ec2.model.DeleteNetworkInterfaceRequest
  ): IO[AwsError, Unit]
  def provisionPublicIpv4PoolCidr(
      request: zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly
  ]
  def describeVolumes(
      request: zio.aws.ec2.model.DescribeVolumesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Volume.ReadOnly]
  def describeVolumesPaginated(
      request: zio.aws.ec2.model.DescribeVolumesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly]
  def modifyTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly
  ]
  def createFlowLogs(
      request: zio.aws.ec2.model.CreateFlowLogsRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly]
  def modifyIpamScope(
      request: zio.aws.ec2.model.ModifyIpamScopeRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly]
  def purchaseHostReservation(
      request: zio.aws.ec2.model.PurchaseHostReservationRequest
  ): IO[AwsError, zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly]
  def describeStaleSecurityGroups(
      request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.StaleSecurityGroup.ReadOnly]
  def describeStaleSecurityGroupsPaginated(
      request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly
  ]
  def createVolume(
      request: zio.aws.ec2.model.CreateVolumeRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVolumeResponse.ReadOnly]
  def runInstances(
      request: zio.aws.ec2.model.RunInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.RunInstancesResponse.ReadOnly]
  def describeReplaceRootVolumeTasks(
      request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly]
  def describeReplaceRootVolumeTasksPaginated(
      request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly
  ]
  def associateDhcpOptions(
      request: zio.aws.ec2.model.AssociateDhcpOptionsRequest
  ): IO[AwsError, Unit]
  def createRouteTable(
      request: zio.aws.ec2.model.CreateRouteTableRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly]
  def deleteVpcPeeringConnection(
      request: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly]
  def describePublicIpv4Pools(
      request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.PublicIpv4Pool.ReadOnly]
  def describePublicIpv4PoolsPaginated(
      request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly]
  def modifyAvailabilityZoneGroup(
      request: zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly
  ]
  def createClientVpnEndpoint(
      request: zio.aws.ec2.model.CreateClientVpnEndpointRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly]
  def deleteSnapshot(
      request: zio.aws.ec2.model.DeleteSnapshotRequest
  ): IO[AwsError, Unit]
  def createTrafficMirrorFilter(
      request: zio.aws.ec2.model.CreateTrafficMirrorFilterRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly]
  def createReservedInstancesListing(
      request: zio.aws.ec2.model.CreateReservedInstancesListingRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateReservedInstancesListingResponse.ReadOnly
  ]
  def assignIpv6Addresses(
      request: zio.aws.ec2.model.AssignIpv6AddressesRequest
  ): IO[AwsError, zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly]
  def getVpnConnectionDeviceTypes(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly]
  def getVpnConnectionDeviceTypesPaginated(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly
  ]
  def describeSecurityGroupReferences(
      request: zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly
  ]
  def describeImages(
      request: zio.aws.ec2.model.DescribeImagesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeImagesResponse.ReadOnly]
  def requestSpotFleet(
      request: zio.aws.ec2.model.RequestSpotFleetRequest
  ): IO[AwsError, zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly]
  def acceptTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ]
  def deletePublicIpv4Pool(
      request: zio.aws.ec2.model.DeletePublicIpv4PoolRequest
  ): IO[AwsError, zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly]
  def updateSecurityGroupRuleDescriptionsEgress(
      request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly
  ]
  def replaceRoute(
      request: zio.aws.ec2.model.ReplaceRouteRequest
  ): IO[AwsError, Unit]
  def createNetworkInsightsPath(
      request: zio.aws.ec2.model.CreateNetworkInsightsPathRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly]
  def deleteQueuedReservedInstances(
      request: zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly
  ]
  def disassociateInstanceEventWindow(
      request: zio.aws.ec2.model.DisassociateInstanceEventWindowRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly
  ]
  def getConsoleOutput(
      request: zio.aws.ec2.model.GetConsoleOutputRequest
  ): IO[AwsError, zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly]
  def createStoreImageTask(
      request: zio.aws.ec2.model.CreateStoreImageTaskRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly]
  def getReservedInstancesExchangeQuote(
      request: zio.aws.ec2.model.GetReservedInstancesExchangeQuoteRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly
  ]
  def attachVpnGateway(
      request: zio.aws.ec2.model.AttachVpnGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly]
  def modifyVpnConnection(
      request: zio.aws.ec2.model.ModifyVpnConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly]
  def getDefaultCreditSpecification(
      request: zio.aws.ec2.model.GetDefaultCreditSpecificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.ReadOnly
  ]
  def createImage(
      request: zio.aws.ec2.model.CreateImageRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateImageResponse.ReadOnly]
  def disableTransitGatewayRouteTablePropagation(
      request: zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly
  ]
  def createFleet(
      request: zio.aws.ec2.model.CreateFleetRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateFleetResponse.ReadOnly]
  def createSubnet(
      request: zio.aws.ec2.model.CreateSubnetRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateSubnetResponse.ReadOnly]
  def listSnapshotsInRecycleBin(
      request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly]
  def listSnapshotsInRecycleBinPaginated(
      request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
  ): IO[AwsError, zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly]
  def describeAggregateIdFormat(
      request: zio.aws.ec2.model.DescribeAggregateIdFormatRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly]
  def createNetworkInsightsAccessScope(
      request: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly
  ]
  def modifySpotFleetRequest(
      request: zio.aws.ec2.model.ModifySpotFleetRequestRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifySpotFleetRequestResponse.ReadOnly]
  def modifyCapacityReservationFleet(
      request: zio.aws.ec2.model.ModifyCapacityReservationFleetRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.ReadOnly
  ]
  def describeIpv6Pools(
      request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipv6Pool.ReadOnly]
  def describeIpv6PoolsPaginated(
      request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly]
  def stopInstances(
      request: zio.aws.ec2.model.StopInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.StopInstancesResponse.ReadOnly]
  def describeExportTasks(
      request: zio.aws.ec2.model.DescribeExportTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly]
  def restoreManagedPrefixListVersion(
      request: zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly
  ]
  def describeBundleTasks(
      request: zio.aws.ec2.model.DescribeBundleTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly]
  def describeClientVpnRoutes(
      request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnRoute.ReadOnly]
  def describeClientVpnRoutesPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly]
  def describeIamInstanceProfileAssociations(
      request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
  ]
  def describeIamInstanceProfileAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly
  ]
  def deleteIpam(
      request: zio.aws.ec2.model.DeleteIpamRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteIpamResponse.ReadOnly]
  def attachVolume(
      request: zio.aws.ec2.model.AttachVolumeRequest
  ): IO[AwsError, zio.aws.ec2.model.AttachVolumeResponse.ReadOnly]
  def createClientVpnRoute(
      request: zio.aws.ec2.model.CreateClientVpnRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly]
  def acceptTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly
  ]
  def describeNetworkInterfaces(
      request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkInterface.ReadOnly]
  def describeNetworkInterfacesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly]
  def describeLocalGatewayVirtualInterfaceGroups(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
  ]
  def describeLocalGatewayVirtualInterfaceGroupsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly
  ]
  def modifyTrafficMirrorSession(
      request: zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly]
  def disassociateVpcCidrBlock(
      request: zio.aws.ec2.model.DisassociateVpcCidrBlockRequest
  ): IO[AwsError, zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly]
  def disableVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.ReadOnly
  ]
  def deleteClientVpnRoute(
      request: zio.aws.ec2.model.DeleteClientVpnRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly]
  def createTransitGatewayConnect(
      request: zio.aws.ec2.model.CreateTransitGatewayConnectRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayConnectResponse.ReadOnly
  ]
  def createReplaceRootVolumeTask(
      request: zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly
  ]
  def cancelImportTask(
      request: zio.aws.ec2.model.CancelImportTaskRequest
  ): IO[AwsError, zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly]
  def describeVpcClassicLink(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly]
  def modifyHosts(
      request: zio.aws.ec2.model.ModifyHostsRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyHostsResponse.ReadOnly]
  def createRestoreImageTask(
      request: zio.aws.ec2.model.CreateRestoreImageTaskRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly]
  def describeTransitGatewayAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly]
  def describeTransitGatewayAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly
  ]
  def deleteVpcEndpointServiceConfigurations(
      request: zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.ReadOnly
  ]
  def startNetworkInsightsAccessScopeAnalysis(
      request: zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
  ]
  def describeTransitGatewayMulticastDomains(
      request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
  ]
  def describeTransitGatewayMulticastDomainsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly
  ]
  def importKeyPair(
      request: zio.aws.ec2.model.ImportKeyPairRequest
  ): IO[AwsError, zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly]
  def revokeSecurityGroupEgress(
      request: zio.aws.ec2.model.RevokeSecurityGroupEgressRequest
  ): IO[AwsError, zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly]
  def enableVgwRoutePropagation(
      request: zio.aws.ec2.model.EnableVgwRoutePropagationRequest
  ): IO[AwsError, Unit]
  def createTransitGatewayRoute(
      request: zio.aws.ec2.model.CreateTransitGatewayRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly]
  def acceptReservedInstancesExchangeQuote(
      request: zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly
  ]
  def modifyInstanceAttribute(
      request: zio.aws.ec2.model.ModifyInstanceAttributeRequest
  ): IO[AwsError, Unit]
  def deleteTransitGatewayConnectPeer(
      request: zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly
  ]
  def createIpam(
      request: zio.aws.ec2.model.CreateIpamRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateIpamResponse.ReadOnly]
  def getConsoleScreenshot(
      request: zio.aws.ec2.model.GetConsoleScreenshotRequest
  ): IO[AwsError, zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly]
  def deregisterTransitGatewayMulticastGroupMembers(
      request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
  ]
  def describeNetworkInterfacePermissions(
      request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
  ]
  def describeNetworkInterfacePermissionsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly
  ]
  def createTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.ReadOnly
  ]
  def cancelCapacityReservation(
      request: zio.aws.ec2.model.CancelCapacityReservationRequest
  ): IO[AwsError, zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly]
  def getIpamAddressHistory(
      request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly]
  def getIpamAddressHistoryPaginated(
      request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
  ): IO[AwsError, zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly]
  def describePlacementGroups(
      request: zio.aws.ec2.model.DescribePlacementGroupsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly]
  def detachVpnGateway(
      request: zio.aws.ec2.model.DetachVpnGatewayRequest
  ): IO[AwsError, Unit]
  def describeInternetGateways(
      request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.InternetGateway.ReadOnly]
  def describeInternetGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly]
  def disassociateEnclaveCertificateIamRole(
      request: zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly
  ]
  def modifyTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly
  ]
  def modifyVpcEndpointServicePermissions(
      request: zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly
  ]
  def createKeyPair(
      request: zio.aws.ec2.model.CreateKeyPairRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly]
  def releaseAddress(
      request: zio.aws.ec2.model.ReleaseAddressRequest
  ): IO[AwsError, Unit]
  def describeVpcEndpointConnectionNotifications(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ConnectionNotification.ReadOnly]
  def describeVpcEndpointConnectionNotificationsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly
  ]
  def associateAddress(
      request: zio.aws.ec2.model.AssociateAddressRequest
  ): IO[AwsError, zio.aws.ec2.model.AssociateAddressResponse.ReadOnly]
  def describeTransitGateways(
      request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TransitGateway.ReadOnly]
  def describeTransitGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly]
  def createCarrierGateway(
      request: zio.aws.ec2.model.CreateCarrierGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly]
  def modifyVpcEndpointServiceConfiguration(
      request: zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly
  ]
  def describeVolumeStatus(
      request: zio.aws.ec2.model.DescribeVolumeStatusRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VolumeStatusItem.ReadOnly]
  def describeVolumeStatusPaginated(
      request: zio.aws.ec2.model.DescribeVolumeStatusRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly]
  def describeTransitGatewayVpcAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
  ]
  def describeTransitGatewayVpcAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly
  ]
  def createVpcPeeringConnection(
      request: zio.aws.ec2.model.CreateVpcPeeringConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly]
  def createVpcEndpoint(
      request: zio.aws.ec2.model.CreateVpcEndpointRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly]
  def replaceIamInstanceProfileAssociation(
      request: zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly
  ]
  def disableVgwRoutePropagation(
      request: zio.aws.ec2.model.DisableVgwRoutePropagationRequest
  ): IO[AwsError, Unit]
  def describeNetworkInsightsAccessScopes(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
  ]
  def describeNetworkInsightsAccessScopesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly
  ]
  def getNetworkInsightsAccessScopeAnalysisFindings(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly,
    zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
  ]]
  def getNetworkInsightsAccessScopeAnalysisFindingsPaginated(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly
  ]
  def cancelCapacityReservationFleets(
      request: zio.aws.ec2.model.CancelCapacityReservationFleetsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly
  ]
  def deleteLocalGatewayRouteTableVpcAssociation(
      request: zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
  ]
  def associateIamInstanceProfile(
      request: zio.aws.ec2.model.AssociateIamInstanceProfileRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateIamInstanceProfileResponse.ReadOnly
  ]
  def describeTrunkInterfaceAssociations(
      request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
  ]
  def describeTrunkInterfaceAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly
  ]
  def startNetworkInsightsAnalysis(
      request: zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly
  ]
  def purchaseReservedInstancesOffering(
      request: zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly
  ]
  def exportImage(
      request: zio.aws.ec2.model.ExportImageRequest
  ): IO[AwsError, zio.aws.ec2.model.ExportImageResponse.ReadOnly]
  def describeClientVpnConnections(
      request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnConnection.ReadOnly]
  def describeClientVpnConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly
  ]
  def describeInstanceStatus(
      request: zio.aws.ec2.model.DescribeInstanceStatusRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceStatus.ReadOnly]
  def describeInstanceStatusPaginated(
      request: zio.aws.ec2.model.DescribeInstanceStatusRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly]
  def describeAddressesAttribute(
      request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.AddressAttribute.ReadOnly]
  def describeAddressesAttributePaginated(
      request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly]
  def associateRouteTable(
      request: zio.aws.ec2.model.AssociateRouteTableRequest
  ): IO[AwsError, zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly]
  def provisionIpamPoolCidr(
      request: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly]
  def withdrawByoipCidr(
      request: zio.aws.ec2.model.WithdrawByoipCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly]
  def describeIpamPools(
      request: zio.aws.ec2.model.DescribeIpamPoolsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly]
  def describeIpamPoolsPaginated(
      request: zio.aws.ec2.model.DescribeIpamPoolsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly]
  def getAssociatedIpv6PoolCidrs(
      request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly]
  def getAssociatedIpv6PoolCidrsPaginated(
      request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): IO[AwsError, zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly]
  def describeSnapshots(
      request: zio.aws.ec2.model.DescribeSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Snapshot.ReadOnly]
  def describeSnapshotsPaginated(
      request: zio.aws.ec2.model.DescribeSnapshotsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly]
  def enableVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.ReadOnly
  ]
  def createTrafficMirrorSession(
      request: zio.aws.ec2.model.CreateTrafficMirrorSessionRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly]
  def getIpamPoolAllocations(
      request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocation.ReadOnly]
  def getIpamPoolAllocationsPaginated(
      request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
  ): IO[AwsError, zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly]
  def describeCustomerGateways(
      request: zio.aws.ec2.model.DescribeCustomerGatewaysRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly]
  def describeClientVpnAuthorizationRules(
      request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.AuthorizationRule.ReadOnly]
  def describeClientVpnAuthorizationRulesPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly
  ]
  def rejectTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ]
  def deleteSubnet(
      request: zio.aws.ec2.model.DeleteSubnetRequest
  ): IO[AwsError, Unit]
  def deleteEgressOnlyInternetGateway(
      request: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly
  ]
  def deleteTrafficMirrorTarget(
      request: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly]
  def describeInstanceAttribute(
      request: zio.aws.ec2.model.DescribeInstanceAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly]
  def disableImageDeprecation(
      request: zio.aws.ec2.model.DisableImageDeprecationRequest
  ): IO[AwsError, zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly]
  def deleteKeyPair(
      request: zio.aws.ec2.model.DeleteKeyPairRequest
  ): IO[AwsError, Unit]
  def deleteCarrierGateway(
      request: zio.aws.ec2.model.DeleteCarrierGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly]
  def deleteTransitGatewayConnect(
      request: zio.aws.ec2.model.DeleteTransitGatewayConnectRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly
  ]
  def createCustomerGateway(
      request: zio.aws.ec2.model.CreateCustomerGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly]
  def deleteInternetGateway(
      request: zio.aws.ec2.model.DeleteInternetGatewayRequest
  ): IO[AwsError, Unit]
  def createVpnConnectionRoute(
      request: zio.aws.ec2.model.CreateVpnConnectionRouteRequest
  ): IO[AwsError, Unit]
  def getCapacityReservationUsage(
      request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly,
    zio.aws.ec2.model.InstanceUsage.ReadOnly
  ]]
  def getCapacityReservationUsagePaginated(
      request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly
  ]
  def createPlacementGroup(
      request: zio.aws.ec2.model.CreatePlacementGroupRequest
  ): IO[AwsError, zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly]
  def modifyNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ): IO[AwsError, Unit]
  def importSnapshot(
      request: zio.aws.ec2.model.ImportSnapshotRequest
  ): IO[AwsError, zio.aws.ec2.model.ImportSnapshotResponse.ReadOnly]
  def modifyFpgaImageAttribute(
      request: zio.aws.ec2.model.ModifyFpgaImageAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly]
  def describeNetworkInsightsPaths(
      request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkInsightsPath.ReadOnly]
  def describeNetworkInsightsPathsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly
  ]
  def createVpc(
      request: zio.aws.ec2.model.CreateVpcRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVpcResponse.ReadOnly]
  def cancelReservedInstancesListing(
      request: zio.aws.ec2.model.CancelReservedInstancesListingRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly
  ]
  def getIpamPoolCidrs(
      request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPoolCidr.ReadOnly]
  def getIpamPoolCidrsPaginated(
      request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
  ): IO[AwsError, zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly]
  def deleteVolume(
      request: zio.aws.ec2.model.DeleteVolumeRequest
  ): IO[AwsError, Unit]
  def revokeSecurityGroupIngress(
      request: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest
  ): IO[AwsError, zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly]
  def describeNetworkAcls(
      request: zio.aws.ec2.model.DescribeNetworkAclsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkAcl.ReadOnly]
  def describeNetworkAclsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkAclsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly]
  def copyImage(
      request: zio.aws.ec2.model.CopyImageRequest
  ): IO[AwsError, zio.aws.ec2.model.CopyImageResponse.ReadOnly]
  def advertiseByoipCidr(
      request: zio.aws.ec2.model.AdvertiseByoipCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly]
  def createLocalGatewayRoute(
      request: zio.aws.ec2.model.CreateLocalGatewayRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly]
  def disassociateTrunkInterface(
      request: zio.aws.ec2.model.DisassociateTrunkInterfaceRequest
  ): IO[AwsError, zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly]
  def describeClientVpnEndpoints(
      request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly]
  def describeClientVpnEndpointsPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly]
  def disableFastSnapshotRestores(
      request: zio.aws.ec2.model.DisableFastSnapshotRestoresRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly
  ]
  def createSubnetCidrReservation(
      request: zio.aws.ec2.model.CreateSubnetCidrReservationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly
  ]
  def disassociateRouteTable(
      request: zio.aws.ec2.model.DisassociateRouteTableRequest
  ): IO[AwsError, Unit]
  def describeSpotInstanceRequests(
      request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotInstanceRequest.ReadOnly]
  def describeSpotInstanceRequestsPaginated(
      request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly
  ]
  def deleteTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly
  ]
  def describeHostReservations(
      request: zio.aws.ec2.model.DescribeHostReservationsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.HostReservation.ReadOnly]
  def describeHostReservationsPaginated(
      request: zio.aws.ec2.model.DescribeHostReservationsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly]
  def modifyVpnTunnelCertificate(
      request: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly]
  def detachInternetGateway(
      request: zio.aws.ec2.model.DetachInternetGatewayRequest
  ): IO[AwsError, Unit]
  def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
  ]
  def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly
  ]
  def deregisterImage(
      request: zio.aws.ec2.model.DeregisterImageRequest
  ): IO[AwsError, Unit]
  def modifySnapshotAttribute(
      request: zio.aws.ec2.model.ModifySnapshotAttributeRequest
  ): IO[AwsError, Unit]
  def describeVolumeAttribute(
      request: zio.aws.ec2.model.DescribeVolumeAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly]
  def describeVpcEndpoints(
      request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcEndpoint.ReadOnly]
  def describeVpcEndpointsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly]
  def getLaunchTemplateData(
      request: zio.aws.ec2.model.GetLaunchTemplateDataRequest
  ): IO[AwsError, zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly]
  def deleteNetworkAcl(
      request: zio.aws.ec2.model.DeleteNetworkAclRequest
  ): IO[AwsError, Unit]
  def describeSecurityGroups(
      request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SecurityGroup.ReadOnly]
  def describeSecurityGroupsPaginated(
      request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly]
  def deleteFleets(
      request: zio.aws.ec2.model.DeleteFleetsRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly]
  def replaceTransitGatewayRoute(
      request: zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly]
  def getVpnConnectionDeviceSampleConfiguration(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly
  ]
  def detachClassicLinkVpc(
      request: zio.aws.ec2.model.DetachClassicLinkVpcRequest
  ): IO[AwsError, zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly]
  def allocateAddress(
      request: zio.aws.ec2.model.AllocateAddressRequest
  ): IO[AwsError, zio.aws.ec2.model.AllocateAddressResponse.ReadOnly]
  def deleteVpnConnection(
      request: zio.aws.ec2.model.DeleteVpnConnectionRequest
  ): IO[AwsError, Unit]
  def describeReservedInstancesOfferings(
      request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
  ]
  def describeReservedInstancesOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly
  ]
  def describeConversionTasks(
      request: zio.aws.ec2.model.DescribeConversionTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly]
  def describeLocalGatewayRouteTableVpcAssociations(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
  ]
  def describeLocalGatewayRouteTableVpcAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly
  ]
  def associateInstanceEventWindow(
      request: zio.aws.ec2.model.AssociateInstanceEventWindowRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly
  ]
  def describeInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly
  ]
  def deleteNetworkInsightsPath(
      request: zio.aws.ec2.model.DeleteNetworkInsightsPathRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly]
  def describeElasticGpus(
      request: zio.aws.ec2.model.DescribeElasticGpusRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly,
    zio.aws.ec2.model.ElasticGpus.ReadOnly
  ]]
  def describeElasticGpusPaginated(
      request: zio.aws.ec2.model.DescribeElasticGpusRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly]
  def exportTransitGatewayRoutes(
      request: zio.aws.ec2.model.ExportTransitGatewayRoutesRequest
  ): IO[AwsError, zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly]
  def describeTrafficMirrorSessions(
      request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorSession.ReadOnly]
  def describeTrafficMirrorSessionsPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly
  ]
  def describeSpotPriceHistory(
      request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotPrice.ReadOnly]
  def describeSpotPriceHistoryPaginated(
      request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly]
  def enableImageDeprecation(
      request: zio.aws.ec2.model.EnableImageDeprecationRequest
  ): IO[AwsError, zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly]
  def describeRegions(
      request: zio.aws.ec2.model.DescribeRegionsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly]
  def runScheduledInstances(
      request: zio.aws.ec2.model.RunScheduledInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly]
  def modifyInstanceEventWindow(
      request: zio.aws.ec2.model.ModifyInstanceEventWindowRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyInstanceEventWindowResponse.ReadOnly]
  def deleteTrafficMirrorSession(
      request: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly]
  def modifyVpcPeeringConnectionOptions(
      request: zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly
  ]
  def describeFlowLogs(
      request: zio.aws.ec2.model.DescribeFlowLogsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.FlowLog.ReadOnly]
  def describeFlowLogsPaginated(
      request: zio.aws.ec2.model.DescribeFlowLogsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly]
  def describeIpams(
      request: zio.aws.ec2.model.DescribeIpamsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly]
  def describeIpamsPaginated(
      request: zio.aws.ec2.model.DescribeIpamsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly]
  def modifyIpamPool(
      request: zio.aws.ec2.model.ModifyIpamPoolRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly]
  def unassignIpv6Addresses(
      request: zio.aws.ec2.model.UnassignIpv6AddressesRequest
  ): IO[AwsError, zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly]
  def describeImportImageTasks(
      request: zio.aws.ec2.model.DescribeImportImageTasksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ImportImageTask.ReadOnly]
  def describeImportImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeImportImageTasksRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly]
  def deletePlacementGroup(
      request: zio.aws.ec2.model.DeletePlacementGroupRequest
  ): IO[AwsError, Unit]
  def cancelSpotInstanceRequests(
      request: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest
  ): IO[AwsError, zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly]
  def describeSnapshotAttribute(
      request: zio.aws.ec2.model.DescribeSnapshotAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly]
  def describeManagedPrefixLists(
      request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ManagedPrefixList.ReadOnly]
  def describeManagedPrefixListsPaginated(
      request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly]
  def createNetworkAclEntry(
      request: zio.aws.ec2.model.CreateNetworkAclEntryRequest
  ): IO[AwsError, Unit]
  def associateTransitGatewayRouteTable(
      request: zio.aws.ec2.model.AssociateTransitGatewayRouteTableRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly
  ]
  def describeScheduledInstances(
      request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.ScheduledInstance.ReadOnly]
  def describeScheduledInstancesPaginated(
      request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly]
  def authorizeClientVpnIngress(
      request: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest
  ): IO[AwsError, zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly]
  def getTransitGatewayPrefixListReferences(
      request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
  ]
  def getTransitGatewayPrefixListReferencesPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly
  ]
  def detachNetworkInterface(
      request: zio.aws.ec2.model.DetachNetworkInterfaceRequest
  ): IO[AwsError, Unit]
  def importImage(
      request: zio.aws.ec2.model.ImportImageRequest
  ): IO[AwsError, zio.aws.ec2.model.ImportImageResponse.ReadOnly]
  def describeEgressOnlyInternetGateways(
      request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
  ]
  def describeEgressOnlyInternetGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly
  ]
  def confirmProductInstance(
      request: zio.aws.ec2.model.ConfirmProductInstanceRequest
  ): IO[AwsError, zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly]
  def describePrincipalIdFormat(
      request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.PrincipalIdFormat.ReadOnly]
  def describePrincipalIdFormatPaginated(
      request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly]
  def associateSubnetCidrBlock(
      request: zio.aws.ec2.model.AssociateSubnetCidrBlockRequest
  ): IO[AwsError, zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly]
  def describeClientVpnTargetNetworks(
      request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TargetNetwork.ReadOnly]
  def describeClientVpnTargetNetworksPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly
  ]
  def resetEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdRequest
  ): IO[AwsError, zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly]
  def disableIpamOrganizationAdminAccount(
      request: zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly
  ]
  def describeIdFormat(
      request: zio.aws.ec2.model.DescribeIdFormatRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly]
  def describeIpamScopes(
      request: zio.aws.ec2.model.DescribeIpamScopesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly]
  def describeIpamScopesPaginated(
      request: zio.aws.ec2.model.DescribeIpamScopesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly]
  def describeVpcEndpointServicePermissions(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.AllowedPrincipal.ReadOnly]
  def describeVpcEndpointServicePermissionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly
  ]
  def describeFpgaImageAttribute(
      request: zio.aws.ec2.model.DescribeFpgaImageAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly]
  def registerInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly
  ]
  def deleteNetworkInsightsAccessScopeAnalysis(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
  ]
  def modifyVpcAttribute(
      request: zio.aws.ec2.model.ModifyVpcAttributeRequest
  ): IO[AwsError, Unit]
  def describeTrafficMirrorFilters(
      request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly]
  def describeTrafficMirrorFiltersPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly
  ]
  def describeImageAttribute(
      request: zio.aws.ec2.model.DescribeImageAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly]
  def resetImageAttribute(
      request: zio.aws.ec2.model.ResetImageAttributeRequest
  ): IO[AwsError, Unit]
  def describeCapacityReservationFleets(
      request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.CapacityReservationFleet.ReadOnly]
  def describeCapacityReservationFleetsPaginated(
      request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly
  ]
  def deleteNatGateway(
      request: zio.aws.ec2.model.DeleteNatGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly]
  def deleteTags(
      request: zio.aws.ec2.model.DeleteTagsRequest
  ): IO[AwsError, Unit]
  def describeReservedInstancesListings(
      request: zio.aws.ec2.model.DescribeReservedInstancesListingsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly
  ]
  def deleteIpamPool(
      request: zio.aws.ec2.model.DeleteIpamPoolRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly]
  def associateClientVpnTargetNetwork(
      request: zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly
  ]
  def copyFpgaImage(
      request: zio.aws.ec2.model.CopyFpgaImageRequest
  ): IO[AwsError, zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly]
  def getFlowLogsIntegrationTemplate(
      request: zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly
  ]
  def getInstanceTypesFromInstanceRequirements(
      request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
  ]
  def getInstanceTypesFromInstanceRequirementsPaginated(
      request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly
  ]
  def unassignPrivateIpAddresses(
      request: zio.aws.ec2.model.UnassignPrivateIpAddressesRequest
  ): IO[AwsError, Unit]
  def resetSnapshotAttribute(
      request: zio.aws.ec2.model.ResetSnapshotAttributeRequest
  ): IO[AwsError, Unit]
  def describeAccountAttributes(
      request: zio.aws.ec2.model.DescribeAccountAttributesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly]
  def acceptTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly
  ]
  def createInstanceExportTask(
      request: zio.aws.ec2.model.CreateInstanceExportTaskRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly]
  def associateEnclaveCertificateIamRole(
      request: zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly
  ]
  def createDefaultVpc(
      request: zio.aws.ec2.model.CreateDefaultVpcRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly]
  def getTransitGatewayRouteTablePropagations(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
  ]
  def getTransitGatewayRouteTablePropagationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly
  ]
  def enableIpamOrganizationAdminAccount(
      request: zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly
  ]
  def createTransitGateway(
      request: zio.aws.ec2.model.CreateTransitGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly]
  def createTransitGatewayConnectPeer(
      request: zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.ReadOnly
  ]
  def modifyDefaultCreditSpecification(
      request: zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly
  ]
  def modifyManagedPrefixList(
      request: zio.aws.ec2.model.ModifyManagedPrefixListRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly]
  def modifyVpcTenancy(
      request: zio.aws.ec2.model.ModifyVpcTenancyRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyVpcTenancyResponse.ReadOnly]
  def associateTrunkInterface(
      request: zio.aws.ec2.model.AssociateTrunkInterfaceRequest
  ): IO[AwsError, zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly]
  def cancelConversionTask(
      request: zio.aws.ec2.model.CancelConversionTaskRequest
  ): IO[AwsError, Unit]
  def createTrafficMirrorTarget(
      request: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly]
  def searchTransitGatewayRoutes(
      request: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest
  ): IO[AwsError, zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly]
  def describeVpcEndpointServices(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly,
    zio.aws.ec2.model.ServiceDetail.ReadOnly
  ]]
  def describeVpcEndpointServicesPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly
  ]
  def deleteLaunchTemplateVersions(
      request: zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly
  ]
  def createInstanceEventWindow(
      request: zio.aws.ec2.model.CreateInstanceEventWindowRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateInstanceEventWindowResponse.ReadOnly]
  def createNatGateway(
      request: zio.aws.ec2.model.CreateNatGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly]
  def enableSerialConsoleAccess(
      request: zio.aws.ec2.model.EnableSerialConsoleAccessRequest
  ): IO[AwsError, zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly]
  def replaceRouteTableAssociation(
      request: zio.aws.ec2.model.ReplaceRouteTableAssociationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly
  ]
  def modifyEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly]
  def provisionByoipCidr(
      request: zio.aws.ec2.model.ProvisionByoipCidrRequest
  ): IO[AwsError, zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly]
  def deleteLocalGatewayRoute(
      request: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly]
  def releaseHosts(
      request: zio.aws.ec2.model.ReleaseHostsRequest
  ): IO[AwsError, zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly]
  def describeLaunchTemplates(
      request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.LaunchTemplate.ReadOnly]
  def describeLaunchTemplatesPaginated(
      request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly]
  def terminateInstances(
      request: zio.aws.ec2.model.TerminateInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly]
  def getHostReservationPurchasePreview(
      request: zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly
  ]
  def modifyInstanceCreditSpecification(
      request: zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly
  ]
  def detachVolume(
      request: zio.aws.ec2.model.DetachVolumeRequest
  ): IO[AwsError, zio.aws.ec2.model.DetachVolumeResponse.ReadOnly]
  def createSnapshot(
      request: zio.aws.ec2.model.CreateSnapshotRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly]
  def getIpamResourceCidrs(
      request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamResourceCidr.ReadOnly]
  def getIpamResourceCidrsPaginated(
      request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
  ): IO[AwsError, zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly]
  def modifyReservedInstances(
      request: zio.aws.ec2.model.ModifyReservedInstancesRequest
  ): IO[AwsError, zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly]
  def createFpgaImage(
      request: zio.aws.ec2.model.CreateFpgaImageRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly]
  def deprovisionPublicIpv4PoolCidr(
      request: zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly
  ]
  def acceptVpcPeeringConnection(
      request: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest
  ): IO[AwsError, zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.ReadOnly]
  def describeTransitGatewayRouteTables(
      request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly]
  def describeTransitGatewayRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly
  ]
  def deleteClientVpnEndpoint(
      request: zio.aws.ec2.model.DeleteClientVpnEndpointRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly]
  def importInstance(
      request: zio.aws.ec2.model.ImportInstanceRequest
  ): IO[AwsError, zio.aws.ec2.model.ImportInstanceResponse.ReadOnly]
  def enableFastSnapshotRestores(
      request: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest
  ): IO[AwsError, zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly]
  def getAssociatedEnclaveCertificateIamRoles(
      request: zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly
  ]
  def deregisterInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly
  ]
  def resetAddressAttribute(
      request: zio.aws.ec2.model.ResetAddressAttributeRequest
  ): IO[AwsError, zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly]
  def moveByoipCidrToIpam(
      request: zio.aws.ec2.model.MoveByoipCidrToIpamRequest
  ): IO[AwsError, zio.aws.ec2.model.MoveByoipCidrToIpamResponse.ReadOnly]
  def importClientVpnClientCertificateRevocationList(
      request: zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.ReadOnly
  ]
  def createSpotDatafeedSubscription(
      request: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly
  ]
  def modifyIdentityIdFormat(
      request: zio.aws.ec2.model.ModifyIdentityIdFormatRequest
  ): IO[AwsError, Unit]
  def describePrefixLists(
      request: zio.aws.ec2.model.DescribePrefixListsRequest
  ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixList.ReadOnly]
  def describePrefixListsPaginated(
      request: zio.aws.ec2.model.DescribePrefixListsRequest
  ): IO[AwsError, zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly]
  def createVpnGateway(
      request: zio.aws.ec2.model.CreateVpnGatewayRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly]
  def createTags(
      request: zio.aws.ec2.model.CreateTagsRequest
  ): IO[AwsError, Unit]
  def createSecurityGroup(
      request: zio.aws.ec2.model.CreateSecurityGroupRequest
  ): IO[AwsError, zio.aws.ec2.model.CreateSecurityGroupResponse.ReadOnly]
  def deleteInstanceEventWindow(
      request: zio.aws.ec2.model.DeleteInstanceEventWindowRequest
  ): IO[AwsError, zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly]
}
object Ec2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ec2] = customized(identity)
  def customized(
      customization: Ec2AsyncClientBuilder => Ec2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ec2] = managed(
    customization
  ).toLayer
  def managed(
      customization: Ec2AsyncClientBuilder => Ec2AsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Ec2] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = Ec2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[Ec2AsyncClient, Ec2AsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[Ec2AsyncClient, Ec2AsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new Ec2Impl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class Ec2Impl[R](
      override val api: Ec2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ec2
      with AwsServiceBase[R] {
    override val serviceName: String = "Ec2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): Ec2Impl[R1] = new Ec2Impl(api, newAspect, r)
    def describeVolumesModifications(
        request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.VolumeModification.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVolumesModificationsRequest,
        DescribeVolumesModificationsResponse,
        VolumeModification
      ](
        "describeVolumesModifications",
        api.describeVolumesModifications,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.volumesModifications().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.VolumeModification.wrap(item))
        .provideEnvironment(r)
    def describeVolumesModificationsPaginated(
        request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVolumesModificationsRequest,
      DescribeVolumesModificationsResponse
    ]("describeVolumesModifications", api.describeVolumesModifications)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVolumesModificationsResponse.wrap)
      .provideEnvironment(r)
    def deleteSpotDatafeedSubscription(
        request: zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSpotDatafeedSubscriptionRequest,
      DeleteSpotDatafeedSubscriptionResponse
    ]("deleteSpotDatafeedSubscription", api.deleteSpotDatafeedSubscription)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteVpcEndpointConnectionNotifications(
        request: zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpcEndpointConnectionNotificationsRequest,
      DeleteVpcEndpointConnectionNotificationsResponse
    ](
      "deleteVpcEndpointConnectionNotifications",
      api.deleteVpcEndpointConnectionNotifications
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.wrap
      )
      .provideEnvironment(r)
    def createNetworkInterface(
        request: zio.aws.ec2.model.CreateNetworkInterfaceRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly] =
      asyncRequestResponse[
        CreateNetworkInterfaceRequest,
        CreateNetworkInterfaceResponse
      ]("createNetworkInterface", api.createNetworkInterface)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateNetworkInterfaceResponse.wrap)
        .provideEnvironment(r)
    def enableVpcClassicLink(
        request: zio.aws.ec2.model.EnableVpcClassicLinkRequest
    ): IO[AwsError, zio.aws.ec2.model.EnableVpcClassicLinkResponse.ReadOnly] =
      asyncRequestResponse[
        EnableVpcClassicLinkRequest,
        EnableVpcClassicLinkResponse
      ]("enableVpcClassicLink", api.enableVpcClassicLink)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.EnableVpcClassicLinkResponse.wrap)
        .provideEnvironment(r)
    def rejectTransitGatewayPeeringAttachment(
        request: zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectTransitGatewayPeeringAttachmentRequest,
      RejectTransitGatewayPeeringAttachmentResponse
    ](
      "rejectTransitGatewayPeeringAttachment",
      api.rejectTransitGatewayPeeringAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.wrap)
      .provideEnvironment(r)
    def createVpnConnection(
        request: zio.aws.ec2.model.CreateVpnConnectionRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly] =
      asyncRequestResponse[
        CreateVpnConnectionRequest,
        CreateVpnConnectionResponse
      ]("createVpnConnection", api.createVpnConnection)(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateVpnConnectionResponse.wrap)
        .provideEnvironment(r)
    def describeDhcpOptions(
        request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.DhcpOptions.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeDhcpOptionsRequest,
        DescribeDhcpOptionsResponse,
        DhcpOptions
      ](
        "describeDhcpOptions",
        api.describeDhcpOptions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.dhcpOptions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.DhcpOptions.wrap(item))
        .provideEnvironment(r)
    def describeDhcpOptionsPaginated(
        request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeDhcpOptionsRequest,
        DescribeDhcpOptionsResponse
      ]("describeDhcpOptions", api.describeDhcpOptions)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeDhcpOptionsResponse.wrap)
        .provideEnvironment(r)
    def modifyVpnTunnelOptions(
        request: zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyVpnTunnelOptionsRequest,
        ModifyVpnTunnelOptionsResponse
      ]("modifyVpnTunnelOptions", api.modifyVpnTunnelOptions)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.wrap)
        .provideEnvironment(r)
    def modifyCapacityReservation(
        request: zio.aws.ec2.model.ModifyCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyCapacityReservationRequest,
      ModifyCapacityReservationResponse
    ]("modifyCapacityReservation", api.modifyCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def describeVpcs(
        request: zio.aws.ec2.model.DescribeVpcsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Vpc.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVpcsRequest,
        DescribeVpcsResponse,
        Vpc
      ](
        "describeVpcs",
        api.describeVpcs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.vpcs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Vpc.wrap(item))
        .provideEnvironment(r)
    def describeVpcsPaginated(
        request: zio.aws.ec2.model.DescribeVpcsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly] =
      asyncRequestResponse[DescribeVpcsRequest, DescribeVpcsResponse](
        "describeVpcs",
        api.describeVpcs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeVpcsResponse.wrap)
        .provideEnvironment(r)
    def deleteNetworkInsightsAnalysis(
        request: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkInsightsAnalysisRequest,
      DeleteNetworkInsightsAnalysisResponse
    ]("deleteNetworkInsightsAnalysis", api.deleteNetworkInsightsAnalysis)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.wrap)
      .provideEnvironment(r)
    def describeIdentityIdFormat(
        request: zio.aws.ec2.model.DescribeIdentityIdFormatRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeIdentityIdFormatRequest,
      DescribeIdentityIdFormatResponse
    ]("describeIdentityIdFormat", api.describeIdentityIdFormat)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeIdentityIdFormatResponse.wrap)
      .provideEnvironment(r)
    def describeTags(
        request: zio.aws.ec2.model.DescribeTagsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TagDescription.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeTagsRequest,
        DescribeTagsResponse,
        TagDescription
      ](
        "describeTags",
        api.describeTags,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.tags().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TagDescription.wrap(item))
        .provideEnvironment(r)
    def describeTagsPaginated(
        request: zio.aws.ec2.model.DescribeTagsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeTagsResponse.ReadOnly] =
      asyncRequestResponse[DescribeTagsRequest, DescribeTagsResponse](
        "describeTags",
        api.describeTags
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeTagsResponse.wrap)
        .provideEnvironment(r)
    def monitorInstances(
        request: zio.aws.ec2.model.MonitorInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly] =
      asyncRequestResponse[MonitorInstancesRequest, MonitorInstancesResponse](
        "monitorInstances",
        api.monitorInstances
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.MonitorInstancesResponse.wrap)
        .provideEnvironment(r)
    def allocateIpamPoolCidr(
        request: zio.aws.ec2.model.AllocateIpamPoolCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly] =
      asyncRequestResponse[
        AllocateIpamPoolCidrRequest,
        AllocateIpamPoolCidrResponse
      ]("allocateIpamPoolCidr", api.allocateIpamPoolCidr)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.AllocateIpamPoolCidrResponse.wrap)
        .provideEnvironment(r)
    def getManagedPrefixListEntries(
        request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixListEntry.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetManagedPrefixListEntriesRequest,
        GetManagedPrefixListEntriesResponse,
        PrefixListEntry
      ](
        "getManagedPrefixListEntries",
        api.getManagedPrefixListEntries,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.entries().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.PrefixListEntry.wrap(item))
        .provideEnvironment(r)
    def getManagedPrefixListEntriesPaginated(
        request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetManagedPrefixListEntriesRequest,
      GetManagedPrefixListEntriesResponse
    ]("getManagedPrefixListEntries", api.getManagedPrefixListEntries)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.wrap)
      .provideEnvironment(r)
    def deleteTransitGatewayPeeringAttachment(
        request: zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayPeeringAttachmentRequest,
      DeleteTransitGatewayPeeringAttachmentResponse
    ](
      "deleteTransitGatewayPeeringAttachment",
      api.deleteTransitGatewayPeeringAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayMulticastDomainAssociations(
        request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTransitGatewayMulticastDomainAssociationsRequest,
      GetTransitGatewayMulticastDomainAssociationsResponse,
      TransitGatewayMulticastDomainAssociation
    ](
      "getTransitGatewayMulticastDomainAssociations",
      api.getTransitGatewayMulticastDomainAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multicastDomainAssociations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayMulticastDomainAssociationsPaginated(
        request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTransitGatewayMulticastDomainAssociationsRequest,
      GetTransitGatewayMulticastDomainAssociationsResponse
    ](
      "getTransitGatewayMulticastDomainAssociations",
      api.getTransitGatewayMulticastDomainAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def modifyIpamResourceCidr(
        request: zio.aws.ec2.model.ModifyIpamResourceCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyIpamResourceCidrRequest,
        ModifyIpamResourceCidrResponse
      ]("modifyIpamResourceCidr", api.modifyIpamResourceCidr)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifyIpamResourceCidrResponse.wrap)
        .provideEnvironment(r)
    def createTransitGatewayVpcAttachment(
        request: zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayVpcAttachmentRequest,
      CreateTransitGatewayVpcAttachmentResponse
    ](
      "createTransitGatewayVpcAttachment",
      api.createTransitGatewayVpcAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def replaceNetworkAclEntry(
        request: zio.aws.ec2.model.ReplaceNetworkAclEntryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ReplaceNetworkAclEntryRequest,
      ReplaceNetworkAclEntryResponse
    ]("replaceNetworkAclEntry", api.replaceNetworkAclEntry)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeVpcPeeringConnections(
        request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcPeeringConnection.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVpcPeeringConnectionsRequest,
        DescribeVpcPeeringConnectionsResponse,
        VpcPeeringConnection
      ](
        "describeVpcPeeringConnections",
        api.describeVpcPeeringConnections,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.vpcPeeringConnections().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.VpcPeeringConnection.wrap(item))
        .provideEnvironment(r)
    def describeVpcPeeringConnectionsPaginated(
        request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcPeeringConnectionsRequest,
      DescribeVpcPeeringConnectionsResponse
    ]("describeVpcPeeringConnections", api.describeVpcPeeringConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.wrap)
      .provideEnvironment(r)
    def describeFleetHistory(
        request: zio.aws.ec2.model.DescribeFleetHistoryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly,
      zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeFleetHistoryRequest,
      DescribeFleetHistoryResponse,
      HistoryRecordEntry
    ](
      "describeFleetHistory",
      api.describeFleetHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.historyRecords().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.ec2.model.DescribeFleetHistoryResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.ec2.model.HistoryRecordEntry.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeFleetHistoryPaginated(
        request: zio.aws.ec2.model.DescribeFleetHistoryRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeFleetHistoryRequest,
        DescribeFleetHistoryResponse
      ]("describeFleetHistory", api.describeFleetHistory)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeFleetHistoryResponse.wrap)
        .provideEnvironment(r)
    def cancelSpotFleetRequests(
        request: zio.aws.ec2.model.CancelSpotFleetRequestsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelSpotFleetRequestsRequest,
      CancelSpotFleetRequestsResponse
    ]("cancelSpotFleetRequests", api.cancelSpotFleetRequests)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CancelSpotFleetRequestsResponse.wrap)
      .provideEnvironment(r)
    def bundleInstance(
        request: zio.aws.ec2.model.BundleInstanceRequest
    ): IO[AwsError, zio.aws.ec2.model.BundleInstanceResponse.ReadOnly] =
      asyncRequestResponse[BundleInstanceRequest, BundleInstanceResponse](
        "bundleInstance",
        api.bundleInstance
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.BundleInstanceResponse.wrap)
        .provideEnvironment(r)
    def revokeClientVpnIngress(
        request: zio.aws.ec2.model.RevokeClientVpnIngressRequest
    ): IO[AwsError, zio.aws.ec2.model.RevokeClientVpnIngressResponse.ReadOnly] =
      asyncRequestResponse[
        RevokeClientVpnIngressRequest,
        RevokeClientVpnIngressResponse
      ]("revokeClientVpnIngress", api.revokeClientVpnIngress)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.RevokeClientVpnIngressResponse.wrap)
        .provideEnvironment(r)
    def deleteSubnetCidrReservation(
        request: zio.aws.ec2.model.DeleteSubnetCidrReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteSubnetCidrReservationRequest,
      DeleteSubnetCidrReservationResponse
    ]("deleteSubnetCidrReservation", api.deleteSubnetCidrReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.wrap)
      .provideEnvironment(r)
    def associateTransitGatewayMulticastDomain(
        request: zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateTransitGatewayMulticastDomainRequest,
      AssociateTransitGatewayMulticastDomainResponse
    ](
      "associateTransitGatewayMulticastDomain",
      api.associateTransitGatewayMulticastDomain
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.wrap
      )
      .provideEnvironment(r)
    def searchTransitGatewayMulticastGroups(
        request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      SearchTransitGatewayMulticastGroupsRequest,
      SearchTransitGatewayMulticastGroupsResponse,
      TransitGatewayMulticastGroup
    ](
      "searchTransitGatewayMulticastGroups",
      api.searchTransitGatewayMulticastGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.multicastGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayMulticastGroup.wrap(item))
      .provideEnvironment(r)
    def searchTransitGatewayMulticastGroupsPaginated(
        request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchTransitGatewayMulticastGroupsRequest,
      SearchTransitGatewayMulticastGroupsResponse
    ](
      "searchTransitGatewayMulticastGroups",
      api.searchTransitGatewayMulticastGroups
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.wrap)
      .provideEnvironment(r)
    def sendDiagnosticInterrupt(
        request: zio.aws.ec2.model.SendDiagnosticInterruptRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      SendDiagnosticInterruptRequest,
      SendDiagnosticInterruptResponse
    ]("sendDiagnosticInterrupt", api.sendDiagnosticInterrupt)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeAddresses(
        request: zio.aws.ec2.model.DescribeAddressesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly] =
      asyncRequestResponse[DescribeAddressesRequest, DescribeAddressesResponse](
        "describeAddresses",
        api.describeAddresses
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeAddressesResponse.wrap)
        .provideEnvironment(r)
    def enableTransitGatewayRouteTablePropagation(
        request: zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableTransitGatewayRouteTablePropagationRequest,
      EnableTransitGatewayRouteTablePropagationResponse
    ](
      "enableTransitGatewayRouteTablePropagation",
      api.enableTransitGatewayRouteTablePropagation
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.wrap
      )
      .provideEnvironment(r)
    def deleteIpamScope(
        request: zio.aws.ec2.model.DeleteIpamScopeRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly] =
      asyncRequestResponse[DeleteIpamScopeRequest, DeleteIpamScopeResponse](
        "deleteIpamScope",
        api.deleteIpamScope
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteIpamScopeResponse.wrap)
        .provideEnvironment(r)
    def createPublicIpv4Pool(
        request: zio.aws.ec2.model.CreatePublicIpv4PoolRequest
    ): IO[AwsError, zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly] =
      asyncRequestResponse[
        CreatePublicIpv4PoolRequest,
        CreatePublicIpv4PoolResponse
      ]("createPublicIpv4Pool", api.createPublicIpv4Pool)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreatePublicIpv4PoolResponse.wrap)
        .provideEnvironment(r)
    def createTransitGatewayRouteTable(
        request: zio.aws.ec2.model.CreateTransitGatewayRouteTableRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayRouteTableRequest,
      CreateTransitGatewayRouteTableResponse
    ]("createTransitGatewayRouteTable", api.createTransitGatewayRouteTable)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.wrap)
      .provideEnvironment(r)
    def registerTransitGatewayMulticastGroupMembers(
        request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterTransitGatewayMulticastGroupMembersRequest,
      RegisterTransitGatewayMulticastGroupMembersResponse
    ](
      "registerTransitGatewayMulticastGroupMembers",
      api.registerTransitGatewayMulticastGroupMembers
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.wrap
      )
      .provideEnvironment(r)
    def describeKeyPairs(
        request: zio.aws.ec2.model.DescribeKeyPairsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly] =
      asyncRequestResponse[DescribeKeyPairsRequest, DescribeKeyPairsResponse](
        "describeKeyPairs",
        api.describeKeyPairs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeKeyPairsResponse.wrap)
        .provideEnvironment(r)
    def startInstances(
        request: zio.aws.ec2.model.StartInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.StartInstancesResponse.ReadOnly] =
      asyncRequestResponse[StartInstancesRequest, StartInstancesResponse](
        "startInstances",
        api.startInstances
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.StartInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeScheduledInstanceAvailability(
        request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeScheduledInstanceAvailabilityRequest,
      DescribeScheduledInstanceAvailabilityResponse,
      ScheduledInstanceAvailability
    ](
      "describeScheduledInstanceAvailability",
      api.describeScheduledInstanceAvailability,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scheduledInstanceAvailabilitySet().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ScheduledInstanceAvailability.wrap(item))
      .provideEnvironment(r)
    def describeScheduledInstanceAvailabilityPaginated(
        request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScheduledInstanceAvailabilityRequest,
      DescribeScheduledInstanceAvailabilityResponse
    ](
      "describeScheduledInstanceAvailability",
      api.describeScheduledInstanceAvailability
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.wrap)
      .provideEnvironment(r)
    def resetInstanceAttribute(
        request: zio.aws.ec2.model.ResetInstanceAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResetInstanceAttributeRequest,
      ResetInstanceAttributeResponse
    ]("resetInstanceAttribute", api.resetInstanceAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyInstanceMetadataOptions(
        request: zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceMetadataOptionsRequest,
      ModifyInstanceMetadataOptionsResponse
    ]("modifyInstanceMetadataOptions", api.modifyInstanceMetadataOptions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.wrap)
      .provideEnvironment(r)
    def createRoute(
        request: zio.aws.ec2.model.CreateRouteRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateRouteResponse.ReadOnly] =
      asyncRequestResponse[CreateRouteRequest, CreateRouteResponse](
        "createRoute",
        api.createRoute
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateRouteResponse.wrap)
        .provideEnvironment(r)
    def deleteFlowLogs(
        request: zio.aws.ec2.model.DeleteFlowLogsRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteFlowLogsResponse.ReadOnly] =
      asyncRequestResponse[DeleteFlowLogsRequest, DeleteFlowLogsResponse](
        "deleteFlowLogs",
        api.deleteFlowLogs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteFlowLogsResponse.wrap)
        .provideEnvironment(r)
    def describeFpgaImages(
        request: zio.aws.ec2.model.DescribeFpgaImagesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.FpgaImage.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFpgaImagesRequest,
        DescribeFpgaImagesResponse,
        FpgaImage
      ](
        "describeFpgaImages",
        api.describeFpgaImages,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fpgaImages().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.FpgaImage.wrap(item))
        .provideEnvironment(r)
    def describeFpgaImagesPaginated(
        request: zio.aws.ec2.model.DescribeFpgaImagesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeFpgaImagesRequest,
        DescribeFpgaImagesResponse
      ]("describeFpgaImages", api.describeFpgaImages)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeFpgaImagesResponse.wrap)
        .provideEnvironment(r)
    def deleteRoute(
        request: zio.aws.ec2.model.DeleteRouteRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRouteRequest, DeleteRouteResponse](
        "deleteRoute",
        api.deleteRoute
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def modifyClientVpnEndpoint(
        request: zio.aws.ec2.model.ModifyClientVpnEndpointRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyClientVpnEndpointRequest,
      ModifyClientVpnEndpointResponse
    ]("modifyClientVpnEndpoint", api.modifyClientVpnEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyClientVpnEndpointResponse.wrap)
      .provideEnvironment(r)
    def modifyTrafficMirrorFilterNetworkServices(
        request: zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyTrafficMirrorFilterNetworkServicesRequest,
      ModifyTrafficMirrorFilterNetworkServicesResponse
    ](
      "modifyTrafficMirrorFilterNetworkServices",
      api.modifyTrafficMirrorFilterNetworkServices
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateTransitGatewayRouteTable(
        request: zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateTransitGatewayRouteTableRequest,
      DisassociateTransitGatewayRouteTableResponse
    ](
      "disassociateTransitGatewayRouteTable",
      api.disassociateTransitGatewayRouteTable
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.wrap)
      .provideEnvironment(r)
    def modifyInstanceCapacityReservationAttributes(
        request: zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceCapacityReservationAttributesRequest,
      ModifyInstanceCapacityReservationAttributesResponse
    ](
      "modifyInstanceCapacityReservationAttributes",
      api.modifyInstanceCapacityReservationAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def describeRouteTables(
        request: zio.aws.ec2.model.DescribeRouteTablesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.RouteTable.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeRouteTablesRequest,
        DescribeRouteTablesResponse,
        RouteTable
      ](
        "describeRouteTables",
        api.describeRouteTables,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.routeTables().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.RouteTable.wrap(item))
        .provideEnvironment(r)
    def describeRouteTablesPaginated(
        request: zio.aws.ec2.model.DescribeRouteTablesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeRouteTablesRequest,
        DescribeRouteTablesResponse
      ]("describeRouteTables", api.describeRouteTables)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeRouteTablesResponse.wrap)
        .provideEnvironment(r)
    def modifySubnetAttribute(
        request: zio.aws.ec2.model.ModifySubnetAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifySubnetAttributeRequest,
      ModifySubnetAttributeResponse
    ]("modifySubnetAttribute", api.modifySubnetAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyVolumeAttribute(
        request: zio.aws.ec2.model.ModifyVolumeAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyVolumeAttributeRequest,
      ModifyVolumeAttributeResponse
    ]("modifyVolumeAttribute", api.modifyVolumeAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def acceptVpcEndpointConnections(
        request: zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptVpcEndpointConnectionsRequest,
      AcceptVpcEndpointConnectionsResponse
    ]("acceptVpcEndpointConnections", api.acceptVpcEndpointConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.wrap)
      .provideEnvironment(r)
    def attachNetworkInterface(
        request: zio.aws.ec2.model.AttachNetworkInterfaceRequest
    ): IO[AwsError, zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly] =
      asyncRequestResponse[
        AttachNetworkInterfaceRequest,
        AttachNetworkInterfaceResponse
      ]("attachNetworkInterface", api.attachNetworkInterface)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.AttachNetworkInterfaceResponse.wrap)
        .provideEnvironment(r)
    def deleteFpgaImage(
        request: zio.aws.ec2.model.DeleteFpgaImageRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly] =
      asyncRequestResponse[DeleteFpgaImageRequest, DeleteFpgaImageResponse](
        "deleteFpgaImage",
        api.deleteFpgaImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteFpgaImageResponse.wrap)
        .provideEnvironment(r)
    def deleteTransitGatewayVpcAttachment(
        request: zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayVpcAttachmentRequest,
      DeleteTransitGatewayVpcAttachmentResponse
    ](
      "deleteTransitGatewayVpcAttachment",
      api.deleteTransitGatewayVpcAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def deleteSecurityGroup(
        request: zio.aws.ec2.model.DeleteSecurityGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteSecurityGroupRequest,
      DeleteSecurityGroupResponse
    ]("deleteSecurityGroup", api.deleteSecurityGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeNatGateways(
        request: zio.aws.ec2.model.DescribeNatGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.NatGateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeNatGatewaysRequest,
        DescribeNatGatewaysResponse,
        NatGateway
      ](
        "describeNatGateways",
        api.describeNatGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.natGateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.NatGateway.wrap(item))
        .provideEnvironment(r)
    def describeNatGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeNatGatewaysRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeNatGatewaysRequest,
        DescribeNatGatewaysResponse
      ]("describeNatGateways", api.describeNatGateways)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeNatGatewaysResponse.wrap)
        .provideEnvironment(r)
    def getCoipPoolUsage(
        request: zio.aws.ec2.model.GetCoipPoolUsageRequest
    ): IO[AwsError, zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly] =
      asyncRequestResponse[GetCoipPoolUsageRequest, GetCoipPoolUsageResponse](
        "getCoipPoolUsage",
        api.getCoipPoolUsage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.GetCoipPoolUsageResponse.wrap)
        .provideEnvironment(r)
    def authorizeSecurityGroupEgress(
        request: zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly
    ] = asyncRequestResponse[
      AuthorizeSecurityGroupEgressRequest,
      AuthorizeSecurityGroupEgressResponse
    ]("authorizeSecurityGroupEgress", api.authorizeSecurityGroupEgress)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.wrap)
      .provideEnvironment(r)
    def modifyVpcEndpoint(
        request: zio.aws.ec2.model.ModifyVpcEndpointRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyVpcEndpointResponse.ReadOnly] =
      asyncRequestResponse[ModifyVpcEndpointRequest, ModifyVpcEndpointResponse](
        "modifyVpcEndpoint",
        api.modifyVpcEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyVpcEndpointResponse.wrap)
        .provideEnvironment(r)
    def deprovisionIpamPoolCidr(
        request: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      DeprovisionIpamPoolCidrRequest,
      DeprovisionIpamPoolCidrResponse
    ]("deprovisionIpamPoolCidr", api.deprovisionIpamPoolCidr)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.wrap)
      .provideEnvironment(r)
    def deleteTransitGatewayPrefixListReference(
        request: zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayPrefixListReferenceRequest,
      DeleteTransitGatewayPrefixListReferenceResponse
    ](
      "deleteTransitGatewayPrefixListReference",
      api.deleteTransitGatewayPrefixListReference
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.wrap
      )
      .provideEnvironment(r)
    def createInternetGateway(
        request: zio.aws.ec2.model.CreateInternetGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        CreateInternetGatewayRequest,
        CreateInternetGatewayResponse
      ]("createInternetGateway", api.createInternetGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateInternetGatewayResponse.wrap)
        .provideEnvironment(r)
    def describeCarrierGateways(
        request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.CarrierGateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeCarrierGatewaysRequest,
        DescribeCarrierGatewaysResponse,
        CarrierGateway
      ](
        "describeCarrierGateways",
        api.describeCarrierGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.carrierGateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.CarrierGateway.wrap(item))
        .provideEnvironment(r)
    def describeCarrierGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCarrierGatewaysRequest,
      DescribeCarrierGatewaysResponse
    ]("describeCarrierGateways", api.describeCarrierGateways)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeCarrierGatewaysResponse.wrap)
      .provideEnvironment(r)
    def disableSerialConsoleAccess(
        request: zio.aws.ec2.model.DisableSerialConsoleAccessRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableSerialConsoleAccessRequest,
      DisableSerialConsoleAccessResponse
    ]("disableSerialConsoleAccess", api.disableSerialConsoleAccess)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisableSerialConsoleAccessResponse.wrap)
      .provideEnvironment(r)
    def enableEbsEncryptionByDefault(
        request: zio.aws.ec2.model.EnableEbsEncryptionByDefaultRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableEbsEncryptionByDefaultRequest,
      EnableEbsEncryptionByDefaultResponse
    ]("enableEbsEncryptionByDefault", api.enableEbsEncryptionByDefault)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.wrap)
      .provideEnvironment(r)
    def modifyTransitGatewayVpcAttachment(
        request: zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyTransitGatewayVpcAttachmentRequest,
      ModifyTransitGatewayVpcAttachmentResponse
    ](
      "modifyTransitGatewayVpcAttachment",
      api.modifyTransitGatewayVpcAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def assignPrivateIpAddresses(
        request: zio.aws.ec2.model.AssignPrivateIpAddressesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly
    ] = asyncRequestResponse[
      AssignPrivateIpAddressesRequest,
      AssignPrivateIpAddressesResponse
    ]("assignPrivateIpAddresses", api.assignPrivateIpAddresses)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssignPrivateIpAddressesResponse.wrap)
      .provideEnvironment(r)
    def modifyLaunchTemplate(
        request: zio.aws.ec2.model.ModifyLaunchTemplateRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyLaunchTemplateRequest,
        ModifyLaunchTemplateResponse
      ]("modifyLaunchTemplate", api.modifyLaunchTemplate)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifyLaunchTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteRouteTable(
        request: zio.aws.ec2.model.DeleteRouteTableRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRouteTableRequest, DeleteRouteTableResponse](
        "deleteRouteTable",
        api.deleteRouteTable
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def restoreAddressToClassic(
        request: zio.aws.ec2.model.RestoreAddressToClassicRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreAddressToClassicRequest,
      RestoreAddressToClassicResponse
    ]("restoreAddressToClassic", api.restoreAddressToClassic)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RestoreAddressToClassicResponse.wrap)
      .provideEnvironment(r)
    def describeMovingAddresses(
        request: zio.aws.ec2.model.DescribeMovingAddressesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.MovingAddressStatus.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeMovingAddressesRequest,
        DescribeMovingAddressesResponse,
        MovingAddressStatus
      ](
        "describeMovingAddresses",
        api.describeMovingAddresses,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.movingAddressStatuses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.MovingAddressStatus.wrap(item))
        .provideEnvironment(r)
    def describeMovingAddressesPaginated(
        request: zio.aws.ec2.model.DescribeMovingAddressesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeMovingAddressesRequest,
      DescribeMovingAddressesResponse
    ]("describeMovingAddresses", api.describeMovingAddresses)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeMovingAddressesResponse.wrap)
      .provideEnvironment(r)
    def modifyPrivateDnsNameOptions(
        request: zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyPrivateDnsNameOptionsRequest,
      ModifyPrivateDnsNameOptionsResponse
    ]("modifyPrivateDnsNameOptions", api.modifyPrivateDnsNameOptions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.wrap)
      .provideEnvironment(r)
    def describeFleetInstances(
        request: zio.aws.ec2.model.DescribeFleetInstancesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly,
      zio.aws.ec2.model.ActiveInstance.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeFleetInstancesRequest,
      DescribeFleetInstancesResponse,
      ActiveInstance
    ](
      "describeFleetInstances",
      api.describeFleetInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.activeInstances().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.ec2.model.DescribeFleetInstancesResponse.wrap)
          .mapOutput(_.map(item => zio.aws.ec2.model.ActiveInstance.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeFleetInstancesPaginated(
        request: zio.aws.ec2.model.DescribeFleetInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeFleetInstancesRequest,
        DescribeFleetInstancesResponse
      ]("describeFleetInstances", api.describeFleetInstances)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeFleetInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeSecurityGroupRules(
        request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      DescribeSecurityGroupRulesRequest,
      DescribeSecurityGroupRulesResponse,
      SecurityGroupRule
    ](
      "describeSecurityGroupRules",
      api.describeSecurityGroupRules,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.securityGroupRules().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.SecurityGroupRule.wrap(item))
      .provideEnvironment(r)
    def describeSecurityGroupRulesPaginated(
        request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSecurityGroupRulesRequest,
      DescribeSecurityGroupRulesResponse
    ]("describeSecurityGroupRules", api.describeSecurityGroupRules)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.wrap)
      .provideEnvironment(r)
    def rejectVpcPeeringConnection(
        request: zio.aws.ec2.model.RejectVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectVpcPeeringConnectionRequest,
      RejectVpcPeeringConnectionResponse
    ]("rejectVpcPeeringConnection", api.rejectVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def attachInternetGateway(
        request: zio.aws.ec2.model.AttachInternetGatewayRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AttachInternetGatewayRequest,
      AttachInternetGatewayResponse
    ]("attachInternetGateway", api.attachInternetGateway)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeAvailabilityZones(
        request: zio.aws.ec2.model.DescribeAvailabilityZonesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAvailabilityZonesRequest,
      DescribeAvailabilityZonesResponse
    ]("describeAvailabilityZones", api.describeAvailabilityZones)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeAvailabilityZonesResponse.wrap)
      .provideEnvironment(r)
    def cancelBundleTask(
        request: zio.aws.ec2.model.CancelBundleTaskRequest
    ): IO[AwsError, zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly] =
      asyncRequestResponse[CancelBundleTaskRequest, CancelBundleTaskResponse](
        "cancelBundleTask",
        api.cancelBundleTask
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CancelBundleTaskResponse.wrap)
        .provideEnvironment(r)
    def describeLocalGateways(
        request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeLocalGatewaysRequest,
        DescribeLocalGatewaysResponse,
        LocalGateway
      ](
        "describeLocalGateways",
        api.describeLocalGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.localGateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.LocalGateway.wrap(item))
        .provideEnvironment(r)
    def describeLocalGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeLocalGatewaysRequest,
        DescribeLocalGatewaysResponse
      ]("describeLocalGateways", api.describeLocalGateways)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeLocalGatewaysResponse.wrap)
        .provideEnvironment(r)
    def deleteVpc(
        request: zio.aws.ec2.model.DeleteVpcRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteVpcRequest, DeleteVpcResponse](
        "deleteVpc",
        api.deleteVpc
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteVpnConnectionRoute(
        request: zio.aws.ec2.model.DeleteVpnConnectionRouteRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteVpnConnectionRouteRequest,
      DeleteVpnConnectionRouteResponse
    ]("deleteVpnConnectionRoute", api.deleteVpnConnectionRoute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteTransitGatewayMulticastDomain(
        request: zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayMulticastDomainRequest,
      DeleteTransitGatewayMulticastDomainResponse
    ](
      "deleteTransitGatewayMulticastDomain",
      api.deleteTransitGatewayMulticastDomain
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.wrap)
      .provideEnvironment(r)
    def disassociateClientVpnTargetNetwork(
        request: zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateClientVpnTargetNetworkRequest,
      DisassociateClientVpnTargetNetworkResponse
    ](
      "disassociateClientVpnTargetNetwork",
      api.disassociateClientVpnTargetNetwork
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.wrap)
      .provideEnvironment(r)
    def describeInstances(
        request: zio.aws.ec2.model.DescribeInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Reservation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstancesRequest,
        DescribeInstancesResponse,
        Reservation
      ](
        "describeInstances",
        api.describeInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.reservations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Reservation.wrap(item))
        .provideEnvironment(r)
    def describeInstancesPaginated(
        request: zio.aws.ec2.model.DescribeInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly] =
      asyncRequestResponse[DescribeInstancesRequest, DescribeInstancesResponse](
        "describeInstances",
        api.describeInstances
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeVpnConnections(
        request: zio.aws.ec2.model.DescribeVpnConnectionsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVpnConnectionsRequest,
        DescribeVpnConnectionsResponse
      ]("describeVpnConnections", api.describeVpnConnections)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeVpnConnectionsResponse.wrap)
        .provideEnvironment(r)
    def attachClassicLinkVpc(
        request: zio.aws.ec2.model.AttachClassicLinkVpcRequest
    ): IO[AwsError, zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly] =
      asyncRequestResponse[
        AttachClassicLinkVpcRequest,
        AttachClassicLinkVpcResponse
      ]("attachClassicLinkVpc", api.attachClassicLinkVpc)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.AttachClassicLinkVpcResponse.wrap)
        .provideEnvironment(r)
    def createLaunchTemplateVersion(
        request: zio.aws.ec2.model.CreateLaunchTemplateVersionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLaunchTemplateVersionRequest,
      CreateLaunchTemplateVersionResponse
    ]("createLaunchTemplateVersion", api.createLaunchTemplateVersion)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.wrap)
      .provideEnvironment(r)
    def deleteNetworkInsightsAccessScope(
        request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkInsightsAccessScopeRequest,
      DeleteNetworkInsightsAccessScopeResponse
    ]("deleteNetworkInsightsAccessScope", api.deleteNetworkInsightsAccessScope)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.wrap)
      .provideEnvironment(r)
    def modifyVpcEndpointConnectionNotification(
        request: zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpcEndpointConnectionNotificationRequest,
      ModifyVpcEndpointConnectionNotificationResponse
    ](
      "modifyVpcEndpointConnectionNotification",
      api.modifyVpcEndpointConnectionNotification
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.wrap
      )
      .provideEnvironment(r)
    def describeInstanceTypes(
        request: zio.aws.ec2.model.DescribeInstanceTypesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceTypeInfo.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstanceTypesRequest,
        DescribeInstanceTypesResponse,
        InstanceTypeInfo
      ](
        "describeInstanceTypes",
        api.describeInstanceTypes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceTypes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.InstanceTypeInfo.wrap(item))
        .provideEnvironment(r)
    def describeInstanceTypesPaginated(
        request: zio.aws.ec2.model.DescribeInstanceTypesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeInstanceTypesRequest,
        DescribeInstanceTypesResponse
      ]("describeInstanceTypes", api.describeInstanceTypes)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeInstanceTypesResponse.wrap)
        .provideEnvironment(r)
    def rebootInstances(
        request: zio.aws.ec2.model.RebootInstancesRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[RebootInstancesRequest, RebootInstancesResponse](
        "rebootInstances",
        api.rebootInstances
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeInstanceCreditSpecifications(
        request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeInstanceCreditSpecificationsRequest,
      DescribeInstanceCreditSpecificationsResponse,
      InstanceCreditSpecification
    ](
      "describeInstanceCreditSpecifications",
      api.describeInstanceCreditSpecifications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceCreditSpecifications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.InstanceCreditSpecification.wrap(item))
      .provideEnvironment(r)
    def describeInstanceCreditSpecificationsPaginated(
        request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceCreditSpecificationsRequest,
      DescribeInstanceCreditSpecificationsResponse
    ](
      "describeInstanceCreditSpecifications",
      api.describeInstanceCreditSpecifications
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.wrap)
      .provideEnvironment(r)
    def describeFleets(
        request: zio.aws.ec2.model.DescribeFleetsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.FleetData.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFleetsRequest,
        DescribeFleetsResponse,
        FleetData
      ](
        "describeFleets",
        api.describeFleets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.fleets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.FleetData.wrap(item))
        .provideEnvironment(r)
    def describeFleetsPaginated(
        request: zio.aws.ec2.model.DescribeFleetsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly] =
      asyncRequestResponse[DescribeFleetsRequest, DescribeFleetsResponse](
        "describeFleets",
        api.describeFleets
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeFleetsResponse.wrap)
        .provideEnvironment(r)
    def getSpotPlacementScores(
        request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotPlacementScore.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetSpotPlacementScoresRequest,
        GetSpotPlacementScoresResponse,
        SpotPlacementScore
      ](
        "getSpotPlacementScores",
        api.getSpotPlacementScores,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.spotPlacementScores().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.SpotPlacementScore.wrap(item))
        .provideEnvironment(r)
    def getSpotPlacementScoresPaginated(
        request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
    ): IO[AwsError, zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly] =
      asyncRequestResponse[
        GetSpotPlacementScoresRequest,
        GetSpotPlacementScoresResponse
      ]("getSpotPlacementScores", api.getSpotPlacementScores)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetSpotPlacementScoresResponse.wrap)
        .provideEnvironment(r)
    def createDefaultSubnet(
        request: zio.aws.ec2.model.CreateDefaultSubnetRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateDefaultSubnetResponse.ReadOnly] =
      asyncRequestResponse[
        CreateDefaultSubnetRequest,
        CreateDefaultSubnetResponse
      ]("createDefaultSubnet", api.createDefaultSubnet)(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateDefaultSubnetResponse.wrap)
        .provideEnvironment(r)
    def modifyVolume(
        request: zio.aws.ec2.model.ModifyVolumeRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly] =
      asyncRequestResponse[ModifyVolumeRequest, ModifyVolumeResponse](
        "modifyVolume",
        api.modifyVolume
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyVolumeResponse.wrap)
        .provideEnvironment(r)
    def getSerialConsoleAccessStatus(
        request: zio.aws.ec2.model.GetSerialConsoleAccessStatusRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSerialConsoleAccessStatusRequest,
      GetSerialConsoleAccessStatusResponse
    ]("getSerialConsoleAccessStatus", api.getSerialConsoleAccessStatus)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.wrap)
      .provideEnvironment(r)
    def getEbsEncryptionByDefault(
        request: zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly
    ] = asyncRequestResponse[
      GetEbsEncryptionByDefaultRequest,
      GetEbsEncryptionByDefaultResponse
    ]("getEbsEncryptionByDefault", api.getEbsEncryptionByDefault)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshotTierStatus(
        request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.SnapshotTierStatus.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSnapshotTierStatusRequest,
        DescribeSnapshotTierStatusResponse,
        SnapshotTierStatus
      ](
        "describeSnapshotTierStatus",
        api.describeSnapshotTierStatus,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.snapshotTierStatuses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.SnapshotTierStatus.wrap(item))
        .provideEnvironment(r)
    def describeSnapshotTierStatusPaginated(
        request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSnapshotTierStatusRequest,
      DescribeSnapshotTierStatusResponse
    ]("describeSnapshotTierStatus", api.describeSnapshotTierStatus)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.wrap)
      .provideEnvironment(r)
    def resetNetworkInterfaceAttribute(
        request: zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResetNetworkInterfaceAttributeRequest,
      ResetNetworkInterfaceAttributeResponse
    ]("resetNetworkInterfaceAttribute", api.resetNetworkInterfaceAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def modifyTransitGateway(
        request: zio.aws.ec2.model.ModifyTransitGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyTransitGatewayRequest,
        ModifyTransitGatewayResponse
      ]("modifyTransitGateway", api.modifyTransitGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifyTransitGatewayResponse.wrap)
        .provideEnvironment(r)
    def enableVolumeIO(
        request: zio.aws.ec2.model.EnableVolumeIoRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[EnableVolumeIoRequest, EnableVolumeIoResponse](
        "enableVolumeIO",
        api.enableVolumeIO
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteTransitGatewayRoute(
        request: zio.aws.ec2.model.DeleteTransitGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayRouteRequest,
      DeleteTransitGatewayRouteResponse
    ]("deleteTransitGatewayRoute", api.deleteTransitGatewayRoute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def describeImportSnapshotTasks(
        request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ImportSnapshotTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeImportSnapshotTasksRequest,
        DescribeImportSnapshotTasksResponse,
        ImportSnapshotTask
      ](
        "describeImportSnapshotTasks",
        api.describeImportSnapshotTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.importSnapshotTasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ImportSnapshotTask.wrap(item))
        .provideEnvironment(r)
    def describeImportSnapshotTasksPaginated(
        request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeImportSnapshotTasksRequest,
      DescribeImportSnapshotTasksResponse
    ]("describeImportSnapshotTasks", api.describeImportSnapshotTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkInsightsAnalyses(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeNetworkInsightsAnalysesRequest,
      DescribeNetworkInsightsAnalysesResponse,
      NetworkInsightsAnalysis
    ](
      "describeNetworkInsightsAnalyses",
      api.describeNetworkInsightsAnalyses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkInsightsAnalyses().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.NetworkInsightsAnalysis.wrap(item))
      .provideEnvironment(r)
    def describeNetworkInsightsAnalysesPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInsightsAnalysesRequest,
      DescribeNetworkInsightsAnalysesResponse
    ]("describeNetworkInsightsAnalyses", api.describeNetworkInsightsAnalyses)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.wrap)
      .provideEnvironment(r)
    def disassociateSubnetCidrBlock(
        request: zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateSubnetCidrBlockRequest,
      DisassociateSubnetCidrBlockResponse
    ]("disassociateSubnetCidrBlock", api.disassociateSubnetCidrBlock)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.wrap)
      .provideEnvironment(r)
    def cancelExportTask(
        request: zio.aws.ec2.model.CancelExportTaskRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CancelExportTaskRequest, CancelExportTaskResponse](
        "cancelExportTask",
        api.cancelExportTask
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteVpnGateway(
        request: zio.aws.ec2.model.DeleteVpnGatewayRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteVpnGatewayRequest, DeleteVpnGatewayResponse](
        "deleteVpnGateway",
        api.deleteVpnGateway
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def associateVpcCidrBlock(
        request: zio.aws.ec2.model.AssociateVpcCidrBlockRequest
    ): IO[AwsError, zio.aws.ec2.model.AssociateVpcCidrBlockResponse.ReadOnly] =
      asyncRequestResponse[
        AssociateVpcCidrBlockRequest,
        AssociateVpcCidrBlockResponse
      ]("associateVpcCidrBlock", api.associateVpcCidrBlock)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.AssociateVpcCidrBlockResponse.wrap)
        .provideEnvironment(r)
    def modifyInstanceEventStartTime(
        request: zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceEventStartTimeRequest,
      ModifyInstanceEventStartTimeResponse
    ]("modifyInstanceEventStartTime", api.modifyInstanceEventStartTime)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.wrap)
      .provideEnvironment(r)
    def reportInstanceStatus(
        request: zio.aws.ec2.model.ReportInstanceStatusRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ReportInstanceStatusRequest,
      ReportInstanceStatusResponse
    ]("reportInstanceStatus", api.reportInstanceStatus)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createVpcEndpointServiceConfiguration(
        request: zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpcEndpointServiceConfigurationRequest,
      CreateVpcEndpointServiceConfigurationResponse
    ](
      "createVpcEndpointServiceConfiguration",
      api.createVpcEndpointServiceConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getEbsDefaultKmsKeyId(
        request: zio.aws.ec2.model.GetEbsDefaultKmsKeyIdRequest
    ): IO[AwsError, zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly] =
      asyncRequestResponse[
        GetEbsDefaultKmsKeyIdRequest,
        GetEbsDefaultKmsKeyIdResponse
      ]("getEbsDefaultKmsKeyId", api.getEbsDefaultKmsKeyId)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.wrap)
        .provideEnvironment(r)
    def deleteNetworkInterfacePermission(
        request: zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkInterfacePermissionRequest,
      DeleteNetworkInterfacePermissionResponse
    ]("deleteNetworkInterfacePermission", api.deleteNetworkInterfacePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.wrap)
      .provideEnvironment(r)
    def describeTransitGatewayPeeringAttachments(
        request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayPeeringAttachmentsRequest,
      DescribeTransitGatewayPeeringAttachmentsResponse,
      TransitGatewayPeeringAttachment
    ](
      "describeTransitGatewayPeeringAttachments",
      api.describeTransitGatewayPeeringAttachments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayPeeringAttachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayPeeringAttachment.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayPeeringAttachmentsPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayPeeringAttachmentsRequest,
      DescribeTransitGatewayPeeringAttachmentsResponse
    ](
      "describeTransitGatewayPeeringAttachments",
      api.describeTransitGatewayPeeringAttachments
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.wrap
      )
      .provideEnvironment(r)
    def describeReservedInstances(
        request: zio.aws.ec2.model.DescribeReservedInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstancesRequest,
      DescribeReservedInstancesResponse
    ]("describeReservedInstances", api.describeReservedInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeReservedInstancesResponse.wrap)
      .provideEnvironment(r)
    def describeLocalGatewayVirtualInterfaces(
        request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLocalGatewayVirtualInterfacesRequest,
      DescribeLocalGatewayVirtualInterfacesResponse,
      LocalGatewayVirtualInterface
    ](
      "describeLocalGatewayVirtualInterfaces",
      api.describeLocalGatewayVirtualInterfaces,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.localGatewayVirtualInterfaces().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.LocalGatewayVirtualInterface.wrap(item))
      .provideEnvironment(r)
    def describeLocalGatewayVirtualInterfacesPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLocalGatewayVirtualInterfacesRequest,
      DescribeLocalGatewayVirtualInterfacesResponse
    ](
      "describeLocalGatewayVirtualInterfaces",
      api.describeLocalGatewayVirtualInterfaces
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.wrap)
      .provideEnvironment(r)
    def modifySecurityGroupRules(
        request: zio.aws.ec2.model.ModifySecurityGroupRulesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifySecurityGroupRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifySecurityGroupRulesRequest,
      ModifySecurityGroupRulesResponse
    ]("modifySecurityGroupRules", api.modifySecurityGroupRules)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifySecurityGroupRulesResponse.wrap)
      .provideEnvironment(r)
    def createEgressOnlyInternetGateway(
        request: zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEgressOnlyInternetGatewayRequest,
      CreateEgressOnlyInternetGatewayResponse
    ]("createEgressOnlyInternetGateway", api.createEgressOnlyInternetGateway)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.wrap)
      .provideEnvironment(r)
    def getPasswordData(
        request: zio.aws.ec2.model.GetPasswordDataRequest
    ): IO[AwsError, zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly] =
      asyncRequestResponse[GetPasswordDataRequest, GetPasswordDataResponse](
        "getPasswordData",
        api.getPasswordData
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.GetPasswordDataResponse.wrap)
        .provideEnvironment(r)
    def exportClientVpnClientCertificateRevocationList(
        request: zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly
    ] = asyncRequestResponse[
      ExportClientVpnClientCertificateRevocationListRequest,
      ExportClientVpnClientCertificateRevocationListResponse
    ](
      "exportClientVpnClientCertificateRevocationList",
      api.exportClientVpnClientCertificateRevocationList
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.wrap
      )
      .provideEnvironment(r)
    def purchaseScheduledInstances(
        request: zio.aws.ec2.model.PurchaseScheduledInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      PurchaseScheduledInstancesRequest,
      PurchaseScheduledInstancesResponse
    ]("purchaseScheduledInstances", api.purchaseScheduledInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.PurchaseScheduledInstancesResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayAttachmentPropagations(
        request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTransitGatewayAttachmentPropagationsRequest,
      GetTransitGatewayAttachmentPropagationsResponse,
      TransitGatewayAttachmentPropagation
    ](
      "getTransitGatewayAttachmentPropagations",
      api.getTransitGatewayAttachmentPropagations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.transitGatewayAttachmentPropagations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.TransitGatewayAttachmentPropagation.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayAttachmentPropagationsPaginated(
        request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTransitGatewayAttachmentPropagationsRequest,
      GetTransitGatewayAttachmentPropagationsResponse
    ](
      "getTransitGatewayAttachmentPropagations",
      api.getTransitGatewayAttachmentPropagations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.wrap
      )
      .provideEnvironment(r)
    def describeClassicLinkInstances(
        request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ClassicLinkInstance.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClassicLinkInstancesRequest,
        DescribeClassicLinkInstancesResponse,
        ClassicLinkInstance
      ](
        "describeClassicLinkInstances",
        api.describeClassicLinkInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instances().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ClassicLinkInstance.wrap(item))
        .provideEnvironment(r)
    def describeClassicLinkInstancesPaginated(
        request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClassicLinkInstancesRequest,
      DescribeClassicLinkInstancesResponse
    ]("describeClassicLinkInstances", api.describeClassicLinkInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.wrap)
      .provideEnvironment(r)
    def describeCoipPools(
        request: zio.aws.ec2.model.DescribeCoipPoolsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeCoipPoolsRequest,
        DescribeCoipPoolsResponse,
        CoipPool
      ](
        "describeCoipPools",
        api.describeCoipPools,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.coipPools().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.CoipPool.wrap(item))
        .provideEnvironment(r)
    def describeCoipPoolsPaginated(
        request: zio.aws.ec2.model.DescribeCoipPoolsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly] =
      asyncRequestResponse[DescribeCoipPoolsRequest, DescribeCoipPoolsResponse](
        "describeCoipPools",
        api.describeCoipPools
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeCoipPoolsResponse.wrap)
        .provideEnvironment(r)
    def createVpcEndpointConnectionNotification(
        request: zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpcEndpointConnectionNotificationRequest,
      CreateVpcEndpointConnectionNotificationResponse
    ](
      "createVpcEndpointConnectionNotification",
      api.createVpcEndpointConnectionNotification
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.wrap
      )
      .provideEnvironment(r)
    def modifyVpnConnectionOptions(
        request: zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpnConnectionOptionsRequest,
      ModifyVpnConnectionOptionsResponse
    ]("modifyVpnConnectionOptions", api.modifyVpnConnectionOptions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.wrap)
      .provideEnvironment(r)
    def getSubnetCidrReservations(
        request: zio.aws.ec2.model.GetSubnetCidrReservationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetSubnetCidrReservationsRequest,
      GetSubnetCidrReservationsResponse
    ]("getSubnetCidrReservations", api.getSubnetCidrReservations)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetSubnetCidrReservationsResponse.wrap)
      .provideEnvironment(r)
    def deleteDhcpOptions(
        request: zio.aws.ec2.model.DeleteDhcpOptionsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteDhcpOptionsRequest, DeleteDhcpOptionsResponse](
        "deleteDhcpOptions",
        api.deleteDhcpOptions
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def requestSpotInstances(
        request: zio.aws.ec2.model.RequestSpotInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        RequestSpotInstancesRequest,
        RequestSpotInstancesResponse
      ]("requestSpotInstances", api.requestSpotInstances)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.RequestSpotInstancesResponse.wrap)
        .provideEnvironment(r)
    def deleteCustomerGateway(
        request: zio.aws.ec2.model.DeleteCustomerGatewayRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteCustomerGatewayRequest,
      DeleteCustomerGatewayResponse
    ]("deleteCustomerGateway", api.deleteCustomerGateway)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteTransitGateway(
        request: zio.aws.ec2.model.DeleteTransitGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteTransitGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteTransitGatewayRequest,
        DeleteTransitGatewayResponse
      ]("deleteTransitGateway", api.deleteTransitGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeleteTransitGatewayResponse.wrap)
        .provideEnvironment(r)
    def authorizeSecurityGroupIngress(
        request: zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      AuthorizeSecurityGroupIngressRequest,
      AuthorizeSecurityGroupIngressResponse
    ]("authorizeSecurityGroupIngress", api.authorizeSecurityGroupIngress)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.wrap)
      .provideEnvironment(r)
    def terminateClientVpnConnections(
        request: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      TerminateClientVpnConnectionsRequest,
      TerminateClientVpnConnectionsResponse
    ]("terminateClientVpnConnections", api.terminateClientVpnConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.wrap)
      .provideEnvironment(r)
    def importVolume(
        request: zio.aws.ec2.model.ImportVolumeRequest
    ): IO[AwsError, zio.aws.ec2.model.ImportVolumeResponse.ReadOnly] =
      asyncRequestResponse[ImportVolumeRequest, ImportVolumeResponse](
        "importVolume",
        api.importVolume
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ImportVolumeResponse.wrap)
        .provideEnvironment(r)
    def deregisterTransitGatewayMulticastGroupSources(
        request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterTransitGatewayMulticastGroupSourcesRequest,
      DeregisterTransitGatewayMulticastGroupSourcesResponse
    ](
      "deregisterTransitGatewayMulticastGroupSources",
      api.deregisterTransitGatewayMulticastGroupSources
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.wrap
      )
      .provideEnvironment(r)
    def disassociateTransitGatewayMulticastDomain(
        request: zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateTransitGatewayMulticastDomainRequest,
      DisassociateTransitGatewayMulticastDomainResponse
    ](
      "disassociateTransitGatewayMulticastDomain",
      api.disassociateTransitGatewayMulticastDomain
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.wrap
      )
      .provideEnvironment(r)
    def describeVpcClassicLinkDnsSupport(
        request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeVpcClassicLinkDnsSupportRequest,
      DescribeVpcClassicLinkDnsSupportResponse,
      ClassicLinkDnsSupport
    ](
      "describeVpcClassicLinkDnsSupport",
      api.describeVpcClassicLinkDnsSupport,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpcs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ClassicLinkDnsSupport.wrap(item))
      .provideEnvironment(r)
    def describeVpcClassicLinkDnsSupportPaginated(
        request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcClassicLinkDnsSupportRequest,
      DescribeVpcClassicLinkDnsSupportResponse
    ]("describeVpcClassicLinkDnsSupport", api.describeVpcClassicLinkDnsSupport)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceEventWindows(
        request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceEventWindow.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstanceEventWindowsRequest,
        DescribeInstanceEventWindowsResponse,
        InstanceEventWindow
      ](
        "describeInstanceEventWindows",
        api.describeInstanceEventWindows,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceEventWindows().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.InstanceEventWindow.wrap(item))
        .provideEnvironment(r)
    def describeInstanceEventWindowsPaginated(
        request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceEventWindowsRequest,
      DescribeInstanceEventWindowsResponse
    ]("describeInstanceEventWindows", api.describeInstanceEventWindows)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.wrap)
      .provideEnvironment(r)
    def applySecurityGroupsToClientVpnTargetNetwork(
        request: zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      ApplySecurityGroupsToClientVpnTargetNetworkRequest,
      ApplySecurityGroupsToClientVpnTargetNetworkResponse
    ](
      "applySecurityGroupsToClientVpnTargetNetwork",
      api.applySecurityGroupsToClientVpnTargetNetwork
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.wrap
      )
      .provideEnvironment(r)
    def createSnapshots(
        request: zio.aws.ec2.model.CreateSnapshotsRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[CreateSnapshotsRequest, CreateSnapshotsResponse](
        "createSnapshots",
        api.createSnapshots
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def rejectVpcEndpointConnections(
        request: zio.aws.ec2.model.RejectVpcEndpointConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectVpcEndpointConnectionsRequest,
      RejectVpcEndpointConnectionsResponse
    ]("rejectVpcEndpointConnections", api.rejectVpcEndpointConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.wrap)
      .provideEnvironment(r)
    def copySnapshot(
        request: zio.aws.ec2.model.CopySnapshotRequest
    ): IO[AwsError, zio.aws.ec2.model.CopySnapshotResponse.ReadOnly] =
      asyncRequestResponse[CopySnapshotRequest, CopySnapshotResponse](
        "copySnapshot",
        api.copySnapshot
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CopySnapshotResponse.wrap)
        .provideEnvironment(r)
    def describeInstanceTypeOfferings(
        request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceTypeOffering.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstanceTypeOfferingsRequest,
        DescribeInstanceTypeOfferingsResponse,
        InstanceTypeOffering
      ](
        "describeInstanceTypeOfferings",
        api.describeInstanceTypeOfferings,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceTypeOfferings().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.InstanceTypeOffering.wrap(item))
        .provideEnvironment(r)
    def describeInstanceTypeOfferingsPaginated(
        request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceTypeOfferingsRequest,
      DescribeInstanceTypeOfferingsResponse
    ]("describeInstanceTypeOfferings", api.describeInstanceTypeOfferings)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.wrap)
      .provideEnvironment(r)
    def deleteManagedPrefixList(
        request: zio.aws.ec2.model.DeleteManagedPrefixListRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteManagedPrefixListRequest,
      DeleteManagedPrefixListResponse
    ]("deleteManagedPrefixList", api.deleteManagedPrefixList)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteManagedPrefixListResponse.wrap)
      .provideEnvironment(r)
    def deleteTransitGatewayRouteTable(
        request: zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayRouteTableRequest,
      DeleteTransitGatewayRouteTableResponse
    ]("deleteTransitGatewayRouteTable", api.deleteTransitGatewayRouteTable)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.wrap)
      .provideEnvironment(r)
    def describeHosts(
        request: zio.aws.ec2.model.DescribeHostsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Host.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeHostsRequest,
        DescribeHostsResponse,
        Host
      ](
        "describeHosts",
        api.describeHosts,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.hosts().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Host.wrap(item))
        .provideEnvironment(r)
    def describeHostsPaginated(
        request: zio.aws.ec2.model.DescribeHostsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeHostsResponse.ReadOnly] =
      asyncRequestResponse[DescribeHostsRequest, DescribeHostsResponse](
        "describeHosts",
        api.describeHosts
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeHostsResponse.wrap)
        .provideEnvironment(r)
    def modifyIdFormat(
        request: zio.aws.ec2.model.ModifyIdFormatRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[ModifyIdFormatRequest, ModifyIdFormatResponse](
        "modifyIdFormat",
        api.modifyIdFormat
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getGroupsForCapacityReservation(
        request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetGroupsForCapacityReservationRequest,
      GetGroupsForCapacityReservationResponse,
      CapacityReservationGroup
    ](
      "getGroupsForCapacityReservation",
      api.getGroupsForCapacityReservation,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.capacityReservationGroups().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.CapacityReservationGroup.wrap(item))
      .provideEnvironment(r)
    def getGroupsForCapacityReservationPaginated(
        request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetGroupsForCapacityReservationRequest,
      GetGroupsForCapacityReservationResponse
    ]("getGroupsForCapacityReservation", api.getGroupsForCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def disableEbsEncryptionByDefault(
        request: zio.aws.ec2.model.DisableEbsEncryptionByDefaultRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableEbsEncryptionByDefaultRequest,
      DisableEbsEncryptionByDefaultResponse
    ]("disableEbsEncryptionByDefault", api.disableEbsEncryptionByDefault)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.wrap)
      .provideEnvironment(r)
    def createTransitGatewayPeeringAttachment(
        request: zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayPeeringAttachmentRequest,
      CreateTransitGatewayPeeringAttachmentResponse
    ](
      "createTransitGatewayPeeringAttachment",
      api.createTransitGatewayPeeringAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.wrap)
      .provideEnvironment(r)
    def describeVpnGateways(
        request: zio.aws.ec2.model.DescribeVpnGatewaysRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVpnGatewaysRequest,
        DescribeVpnGatewaysResponse
      ]("describeVpnGateways", api.describeVpnGateways)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeVpnGatewaysResponse.wrap)
        .provideEnvironment(r)
    def deprovisionByoipCidr(
        request: zio.aws.ec2.model.DeprovisionByoipCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.DeprovisionByoipCidrResponse.ReadOnly] =
      asyncRequestResponse[
        DeprovisionByoipCidrRequest,
        DeprovisionByoipCidrResponse
      ]("deprovisionByoipCidr", api.deprovisionByoipCidr)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeprovisionByoipCidrResponse.wrap)
        .provideEnvironment(r)
    def describeSubnets(
        request: zio.aws.ec2.model.DescribeSubnetsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Subnet.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSubnetsRequest,
        DescribeSubnetsResponse,
        Subnet
      ](
        "describeSubnets",
        api.describeSubnets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.subnets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Subnet.wrap(item))
        .provideEnvironment(r)
    def describeSubnetsPaginated(
        request: zio.aws.ec2.model.DescribeSubnetsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly] =
      asyncRequestResponse[DescribeSubnetsRequest, DescribeSubnetsResponse](
        "describeSubnets",
        api.describeSubnets
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeSubnetsResponse.wrap)
        .provideEnvironment(r)
    def describeSpotFleetRequestHistory(
        request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly,
      zio.aws.ec2.model.HistoryRecord.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeSpotFleetRequestHistoryRequest,
      DescribeSpotFleetRequestHistoryResponse,
      HistoryRecord
    ](
      "describeSpotFleetRequestHistory",
      api.describeSpotFleetRequestHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.historyRecords().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.ec2.model.HistoryRecord.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeSpotFleetRequestHistoryPaginated(
        request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotFleetRequestHistoryRequest,
      DescribeSpotFleetRequestHistoryResponse
    ]("describeSpotFleetRequestHistory", api.describeSpotFleetRequestHistory)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.wrap)
      .provideEnvironment(r)
    def unmonitorInstances(
        request: zio.aws.ec2.model.UnmonitorInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.UnmonitorInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        UnmonitorInstancesRequest,
        UnmonitorInstancesResponse
      ]("unmonitorInstances", api.unmonitorInstances)(request.buildAwsValue())
        .map(zio.aws.ec2.model.UnmonitorInstancesResponse.wrap)
        .provideEnvironment(r)
    def createManagedPrefixList(
        request: zio.aws.ec2.model.CreateManagedPrefixListRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateManagedPrefixListResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateManagedPrefixListRequest,
      CreateManagedPrefixListResponse
    ]("createManagedPrefixList", api.createManagedPrefixList)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateManagedPrefixListResponse.wrap)
      .provideEnvironment(r)
    def describeTransitGatewayConnectPeers(
        request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayConnectPeersRequest,
      DescribeTransitGatewayConnectPeersResponse,
      TransitGatewayConnectPeer
    ](
      "describeTransitGatewayConnectPeers",
      api.describeTransitGatewayConnectPeers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayConnectPeers().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayConnectPeer.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayConnectPeersPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayConnectPeersRequest,
      DescribeTransitGatewayConnectPeersResponse
    ](
      "describeTransitGatewayConnectPeers",
      api.describeTransitGatewayConnectPeers
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.wrap)
      .provideEnvironment(r)
    def describeTransitGatewayConnects(
        request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayConnect.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayConnectsRequest,
      DescribeTransitGatewayConnectsResponse,
      TransitGatewayConnect
    ](
      "describeTransitGatewayConnects",
      api.describeTransitGatewayConnects,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayConnects().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayConnect.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayConnectsPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayConnectsRequest,
      DescribeTransitGatewayConnectsResponse
    ]("describeTransitGatewayConnects", api.describeTransitGatewayConnects)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.wrap)
      .provideEnvironment(r)
    def createIpamScope(
        request: zio.aws.ec2.model.CreateIpamScopeRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly] =
      asyncRequestResponse[CreateIpamScopeRequest, CreateIpamScopeResponse](
        "createIpamScope",
        api.createIpamScope
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateIpamScopeResponse.wrap)
        .provideEnvironment(r)
    def describeTrafficMirrorTargets(
        request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeTrafficMirrorTargetsRequest,
        DescribeTrafficMirrorTargetsResponse,
        TrafficMirrorTarget
      ](
        "describeTrafficMirrorTargets",
        api.describeTrafficMirrorTargets,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.trafficMirrorTargets().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TrafficMirrorTarget.wrap(item))
        .provideEnvironment(r)
    def describeTrafficMirrorTargetsPaginated(
        request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTrafficMirrorTargetsRequest,
      DescribeTrafficMirrorTargetsResponse
    ]("describeTrafficMirrorTargets", api.describeTrafficMirrorTargets)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcEndpoints(
        request: zio.aws.ec2.model.DeleteVpcEndpointsRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteVpcEndpointsResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteVpcEndpointsRequest,
        DeleteVpcEndpointsResponse
      ]("deleteVpcEndpoints", api.deleteVpcEndpoints)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteVpcEndpointsResponse.wrap)
        .provideEnvironment(r)
    def disassociateIamInstanceProfile(
        request: zio.aws.ec2.model.DisassociateIamInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateIamInstanceProfileRequest,
      DisassociateIamInstanceProfileResponse
    ]("disassociateIamInstanceProfile", api.disassociateIamInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def modifyFleet(
        request: zio.aws.ec2.model.ModifyFleetRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyFleetResponse.ReadOnly] =
      asyncRequestResponse[ModifyFleetRequest, ModifyFleetResponse](
        "modifyFleet",
        api.modifyFleet
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyFleetResponse.wrap)
        .provideEnvironment(r)
    def describeVpcEndpointServiceConfigurations(
        request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ServiceConfiguration.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVpcEndpointServiceConfigurationsRequest,
        DescribeVpcEndpointServiceConfigurationsResponse,
        ServiceConfiguration
      ](
        "describeVpcEndpointServiceConfigurations",
        api.describeVpcEndpointServiceConfigurations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.serviceConfigurations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ServiceConfiguration.wrap(item))
        .provideEnvironment(r)
    def describeVpcEndpointServiceConfigurationsPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointServiceConfigurationsRequest,
      DescribeVpcEndpointServiceConfigurationsResponse
    ](
      "describeVpcEndpointServiceConfigurations",
      api.describeVpcEndpointServiceConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteNetworkAclEntry(
        request: zio.aws.ec2.model.DeleteNetworkAclEntryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteNetworkAclEntryRequest,
      DeleteNetworkAclEntryResponse
    ]("deleteNetworkAclEntry", api.deleteNetworkAclEntry)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def updateSecurityGroupRuleDescriptionsIngress(
        request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSecurityGroupRuleDescriptionsIngressRequest,
      UpdateSecurityGroupRuleDescriptionsIngressResponse
    ](
      "updateSecurityGroupRuleDescriptionsIngress",
      api.updateSecurityGroupRuleDescriptionsIngress
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.wrap
      )
      .provideEnvironment(r)
    def describeCapacityReservations(
        request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.CapacityReservation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeCapacityReservationsRequest,
        DescribeCapacityReservationsResponse,
        CapacityReservation
      ](
        "describeCapacityReservations",
        api.describeCapacityReservations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.capacityReservations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.CapacityReservation.wrap(item))
        .provideEnvironment(r)
    def describeCapacityReservationsPaginated(
        request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCapacityReservationsRequest,
      DescribeCapacityReservationsResponse
    ]("describeCapacityReservations", api.describeCapacityReservations)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeCapacityReservationsResponse.wrap)
      .provideEnvironment(r)
    def createTransitGatewayMulticastDomain(
        request: zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayMulticastDomainRequest,
      CreateTransitGatewayMulticastDomainResponse
    ](
      "createTransitGatewayMulticastDomain",
      api.createTransitGatewayMulticastDomain
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.wrap)
      .provideEnvironment(r)
    def startVpcEndpointServicePrivateDnsVerification(
        request: zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartVpcEndpointServicePrivateDnsVerificationRequest,
      StartVpcEndpointServicePrivateDnsVerificationResponse
    ](
      "startVpcEndpointServicePrivateDnsVerification",
      api.startVpcEndpointServicePrivateDnsVerification
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.wrap
      )
      .provideEnvironment(r)
    def createLaunchTemplate(
        request: zio.aws.ec2.model.CreateLaunchTemplateRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        CreateLaunchTemplateRequest,
        CreateLaunchTemplateResponse
      ]("createLaunchTemplate", api.createLaunchTemplate)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateLaunchTemplateResponse.wrap)
        .provideEnvironment(r)
    def deleteTrafficMirrorFilter(
        request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTrafficMirrorFilterRequest,
      DeleteTrafficMirrorFilterResponse
    ]("deleteTrafficMirrorFilter", api.deleteTrafficMirrorFilter)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.wrap)
      .provideEnvironment(r)
    def describeLocalGatewayRouteTables(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLocalGatewayRouteTablesRequest,
      DescribeLocalGatewayRouteTablesResponse,
      LocalGatewayRouteTable
    ](
      "describeLocalGatewayRouteTables",
      api.describeLocalGatewayRouteTables,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.localGatewayRouteTables().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.LocalGatewayRouteTable.wrap(item))
      .provideEnvironment(r)
    def describeLocalGatewayRouteTablesPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLocalGatewayRouteTablesRequest,
      DescribeLocalGatewayRouteTablesResponse
    ]("describeLocalGatewayRouteTables", api.describeLocalGatewayRouteTables)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkInterfaceAttribute(
        request: zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInterfaceAttributeRequest,
      DescribeNetworkInterfaceAttributeResponse
    ](
      "describeNetworkInterfaceAttribute",
      api.describeNetworkInterfaceAttribute
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.wrap)
      .provideEnvironment(r)
    def createCapacityReservationFleet(
        request: zio.aws.ec2.model.CreateCapacityReservationFleetRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCapacityReservationFleetRequest,
      CreateCapacityReservationFleetResponse
    ]("createCapacityReservationFleet", api.createCapacityReservationFleet)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateCapacityReservationFleetResponse.wrap)
      .provideEnvironment(r)
    def deleteLaunchTemplate(
        request: zio.aws.ec2.model.DeleteLaunchTemplateRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteLaunchTemplateRequest,
        DeleteLaunchTemplateResponse
      ]("deleteLaunchTemplate", api.deleteLaunchTemplate)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeleteLaunchTemplateResponse.wrap)
        .provideEnvironment(r)
    def replaceNetworkAclAssociation(
        request: zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      ReplaceNetworkAclAssociationRequest,
      ReplaceNetworkAclAssociationResponse
    ]("replaceNetworkAclAssociation", api.replaceNetworkAclAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.wrap)
      .provideEnvironment(r)
    def getManagedPrefixListAssociations(
        request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.PrefixListAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetManagedPrefixListAssociationsRequest,
      GetManagedPrefixListAssociationsResponse,
      PrefixListAssociation
    ](
      "getManagedPrefixListAssociations",
      api.getManagedPrefixListAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.prefixListAssociations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.PrefixListAssociation.wrap(item))
      .provideEnvironment(r)
    def getManagedPrefixListAssociationsPaginated(
        request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetManagedPrefixListAssociationsRequest,
      GetManagedPrefixListAssociationsResponse
    ]("getManagedPrefixListAssociations", api.getManagedPrefixListAssociations)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.wrap)
      .provideEnvironment(r)
    def createNetworkAcl(
        request: zio.aws.ec2.model.CreateNetworkAclRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly] =
      asyncRequestResponse[CreateNetworkAclRequest, CreateNetworkAclResponse](
        "createNetworkAcl",
        api.createNetworkAcl
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateNetworkAclResponse.wrap)
        .provideEnvironment(r)
    def describeVpcEndpointConnections(
        request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.VpcEndpointConnection.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeVpcEndpointConnectionsRequest,
      DescribeVpcEndpointConnectionsResponse,
      VpcEndpointConnection
    ](
      "describeVpcEndpointConnections",
      api.describeVpcEndpointConnections,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpcEndpointConnections().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.VpcEndpointConnection.wrap(item))
      .provideEnvironment(r)
    def describeVpcEndpointConnectionsPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointConnectionsRequest,
      DescribeVpcEndpointConnectionsResponse
    ]("describeVpcEndpointConnections", api.describeVpcEndpointConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.wrap)
      .provideEnvironment(r)
    def createLocalGatewayRouteTableVpcAssociation(
        request: zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLocalGatewayRouteTableVpcAssociationRequest,
      CreateLocalGatewayRouteTableVpcAssociationResponse
    ](
      "createLocalGatewayRouteTableVpcAssociation",
      api.createLocalGatewayRouteTableVpcAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def describeVpcAttribute(
        request: zio.aws.ec2.model.DescribeVpcAttributeRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVpcAttributeRequest,
        DescribeVpcAttributeResponse
      ]("describeVpcAttribute", api.describeVpcAttribute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeVpcAttributeResponse.wrap)
        .provideEnvironment(r)
    def describeStoreImageTasks(
        request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.StoreImageTaskResult.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeStoreImageTasksRequest,
        DescribeStoreImageTasksResponse,
        StoreImageTaskResult
      ](
        "describeStoreImageTasks",
        api.describeStoreImageTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.storeImageTaskResults().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.StoreImageTaskResult.wrap(item))
        .provideEnvironment(r)
    def describeStoreImageTasksPaginated(
        request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeStoreImageTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStoreImageTasksRequest,
      DescribeStoreImageTasksResponse
    ]("describeStoreImageTasks", api.describeStoreImageTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeStoreImageTasksResponse.wrap)
      .provideEnvironment(r)
    def describeFastSnapshotRestores(
        request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeFastSnapshotRestoresRequest,
      DescribeFastSnapshotRestoresResponse,
      DescribeFastSnapshotRestoreSuccessItem
    ](
      "describeFastSnapshotRestores",
      api.describeFastSnapshotRestores,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.fastSnapshotRestores().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.wrap(item)
      )
      .provideEnvironment(r)
    def describeFastSnapshotRestoresPaginated(
        request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFastSnapshotRestoresRequest,
      DescribeFastSnapshotRestoresResponse
    ]("describeFastSnapshotRestores", api.describeFastSnapshotRestores)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.wrap)
      .provideEnvironment(r)
    def modifyInstancePlacement(
        request: zio.aws.ec2.model.ModifyInstancePlacementRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstancePlacementResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstancePlacementRequest,
      ModifyInstancePlacementResponse
    ]("modifyInstancePlacement", api.modifyInstancePlacement)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyInstancePlacementResponse.wrap)
      .provideEnvironment(r)
    def createIpamPool(
        request: zio.aws.ec2.model.CreateIpamPoolRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly] =
      asyncRequestResponse[CreateIpamPoolRequest, CreateIpamPoolResponse](
        "createIpamPool",
        api.createIpamPool
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateIpamPoolResponse.wrap)
        .provideEnvironment(r)
    def modifySnapshotTier(
        request: zio.aws.ec2.model.ModifySnapshotTierRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly] =
      asyncRequestResponse[
        ModifySnapshotTierRequest,
        ModifySnapshotTierResponse
      ]("modifySnapshotTier", api.modifySnapshotTier)(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifySnapshotTierResponse.wrap)
        .provideEnvironment(r)
    def describeSpotFleetRequests(
        request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeSpotFleetRequestsRequest,
      DescribeSpotFleetRequestsResponse,
      SpotFleetRequestConfig
    ](
      "describeSpotFleetRequests",
      api.describeSpotFleetRequests,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.spotFleetRequestConfigs().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.SpotFleetRequestConfig.wrap(item))
      .provideEnvironment(r)
    def describeSpotFleetRequestsPaginated(
        request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotFleetRequestsRequest,
      DescribeSpotFleetRequestsResponse
    ]("describeSpotFleetRequests", api.describeSpotFleetRequests)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayRouteTableAssociations(
        request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTransitGatewayRouteTableAssociationsRequest,
      GetTransitGatewayRouteTableAssociationsResponse,
      TransitGatewayRouteTableAssociation
    ](
      "getTransitGatewayRouteTableAssociations",
      api.getTransitGatewayRouteTableAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.associations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.TransitGatewayRouteTableAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayRouteTableAssociationsPaginated(
        request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTransitGatewayRouteTableAssociationsRequest,
      GetTransitGatewayRouteTableAssociationsResponse
    ](
      "getTransitGatewayRouteTableAssociations",
      api.getTransitGatewayRouteTableAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def releaseIpamPoolAllocation(
        request: zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly
    ] = asyncRequestResponse[
      ReleaseIpamPoolAllocationRequest,
      ReleaseIpamPoolAllocationResponse
    ]("releaseIpamPoolAllocation", api.releaseIpamPoolAllocation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.wrap)
      .provideEnvironment(r)
    def registerImage(
        request: zio.aws.ec2.model.RegisterImageRequest
    ): IO[AwsError, zio.aws.ec2.model.RegisterImageResponse.ReadOnly] =
      asyncRequestResponse[RegisterImageRequest, RegisterImageResponse](
        "registerImage",
        api.registerImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.RegisterImageResponse.wrap)
        .provideEnvironment(r)
    def createDhcpOptions(
        request: zio.aws.ec2.model.CreateDhcpOptionsRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly] =
      asyncRequestResponse[CreateDhcpOptionsRequest, CreateDhcpOptionsResponse](
        "createDhcpOptions",
        api.createDhcpOptions
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateDhcpOptionsResponse.wrap)
        .provideEnvironment(r)
    def describeReservedInstancesModifications(
        request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReservedInstancesModificationsRequest,
      DescribeReservedInstancesModificationsResponse,
      ReservedInstancesModification
    ](
      "describeReservedInstancesModifications",
      api.describeReservedInstancesModifications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reservedInstancesModifications().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ReservedInstancesModification.wrap(item))
      .provideEnvironment(r)
    def describeReservedInstancesModificationsPaginated(
        request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstancesModificationsRequest,
      DescribeReservedInstancesModificationsResponse
    ](
      "describeReservedInstancesModifications",
      api.describeReservedInstancesModifications
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.wrap
      )
      .provideEnvironment(r)
    def describeSpotDatafeedSubscription(
        request: zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotDatafeedSubscriptionRequest,
      DescribeSpotDatafeedSubscriptionResponse
    ]("describeSpotDatafeedSubscription", api.describeSpotDatafeedSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkInsightsAccessScopeAnalyses(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeNetworkInsightsAccessScopeAnalysesRequest,
      DescribeNetworkInsightsAccessScopeAnalysesResponse,
      NetworkInsightsAccessScopeAnalysis
    ](
      "describeNetworkInsightsAccessScopeAnalyses",
      api.describeNetworkInsightsAccessScopeAnalyses,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.networkInsightsAccessScopeAnalyses().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.wrap(item)
      )
      .provideEnvironment(r)
    def describeNetworkInsightsAccessScopeAnalysesPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInsightsAccessScopeAnalysesRequest,
      DescribeNetworkInsightsAccessScopeAnalysesResponse
    ](
      "describeNetworkInsightsAccessScopeAnalyses",
      api.describeNetworkInsightsAccessScopeAnalyses
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.wrap
      )
      .provideEnvironment(r)
    def createTrafficMirrorFilterRule(
        request: zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTrafficMirrorFilterRuleRequest,
      CreateTrafficMirrorFilterRuleResponse
    ]("createTrafficMirrorFilterRule", api.createTrafficMirrorFilterRule)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.wrap)
      .provideEnvironment(r)
    def searchLocalGatewayRoutes(
        request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.LocalGatewayRoute.ReadOnly] =
      asyncSimplePaginatedRequest[
        SearchLocalGatewayRoutesRequest,
        SearchLocalGatewayRoutesResponse,
        LocalGatewayRoute
      ](
        "searchLocalGatewayRoutes",
        api.searchLocalGatewayRoutes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.routes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.LocalGatewayRoute.wrap(item))
        .provideEnvironment(r)
    def searchLocalGatewayRoutesPaginated(
        request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchLocalGatewayRoutesRequest,
      SearchLocalGatewayRoutesResponse
    ]("searchLocalGatewayRoutes", api.searchLocalGatewayRoutes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.wrap)
      .provideEnvironment(r)
    def describeHostReservationOfferings(
        request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.HostOffering.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeHostReservationOfferingsRequest,
        DescribeHostReservationOfferingsResponse,
        HostOffering
      ](
        "describeHostReservationOfferings",
        api.describeHostReservationOfferings,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.offeringSet().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.HostOffering.wrap(item))
        .provideEnvironment(r)
    def describeHostReservationOfferingsPaginated(
        request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeHostReservationOfferingsRequest,
      DescribeHostReservationOfferingsResponse
    ]("describeHostReservationOfferings", api.describeHostReservationOfferings)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.wrap)
      .provideEnvironment(r)
    def modifyIpam(
        request: zio.aws.ec2.model.ModifyIpamRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyIpamResponse.ReadOnly] =
      asyncRequestResponse[ModifyIpamRequest, ModifyIpamResponse](
        "modifyIpam",
        api.modifyIpam
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyIpamResponse.wrap)
        .provideEnvironment(r)
    def disableVpcClassicLink(
        request: zio.aws.ec2.model.DisableVpcClassicLinkRequest
    ): IO[AwsError, zio.aws.ec2.model.DisableVpcClassicLinkResponse.ReadOnly] =
      asyncRequestResponse[
        DisableVpcClassicLinkRequest,
        DisableVpcClassicLinkResponse
      ]("disableVpcClassicLink", api.disableVpcClassicLink)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DisableVpcClassicLinkResponse.wrap)
        .provideEnvironment(r)
    def getNetworkInsightsAccessScopeContent(
        request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.ReadOnly
    ] = asyncRequestResponse[
      GetNetworkInsightsAccessScopeContentRequest,
      GetNetworkInsightsAccessScopeContentResponse
    ](
      "getNetworkInsightsAccessScopeContent",
      api.getNetworkInsightsAccessScopeContent
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.wrap)
      .provideEnvironment(r)
    def createCapacityReservation(
        request: zio.aws.ec2.model.CreateCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateCapacityReservationRequest,
      CreateCapacityReservationResponse
    ]("createCapacityReservation", api.createCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def modifyAddressAttribute(
        request: zio.aws.ec2.model.ModifyAddressAttributeRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyAddressAttributeRequest,
        ModifyAddressAttributeResponse
      ]("modifyAddressAttribute", api.modifyAddressAttribute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifyAddressAttributeResponse.wrap)
        .provideEnvironment(r)
    def createNetworkInterfacePermission(
        request: zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNetworkInterfacePermissionRequest,
      CreateNetworkInterfacePermissionResponse
    ]("createNetworkInterfacePermission", api.createNetworkInterfacePermission)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.wrap)
      .provideEnvironment(r)
    def describeLaunchTemplateVersions(
        request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLaunchTemplateVersionsRequest,
      DescribeLaunchTemplateVersionsResponse,
      LaunchTemplateVersion
    ](
      "describeLaunchTemplateVersions",
      api.describeLaunchTemplateVersions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.launchTemplateVersions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.LaunchTemplateVersion.wrap(item))
      .provideEnvironment(r)
    def describeLaunchTemplateVersionsPaginated(
        request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLaunchTemplateVersionsRequest,
      DescribeLaunchTemplateVersionsResponse
    ]("describeLaunchTemplateVersions", api.describeLaunchTemplateVersions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def allocateHosts(
        request: zio.aws.ec2.model.AllocateHostsRequest
    ): IO[AwsError, zio.aws.ec2.model.AllocateHostsResponse.ReadOnly] =
      asyncRequestResponse[AllocateHostsRequest, AllocateHostsResponse](
        "allocateHosts",
        api.allocateHosts
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.AllocateHostsResponse.wrap)
        .provideEnvironment(r)
    def describeExportImageTasks(
        request: zio.aws.ec2.model.DescribeExportImageTasksRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ExportImageTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeExportImageTasksRequest,
        DescribeExportImageTasksResponse,
        ExportImageTask
      ](
        "describeExportImageTasks",
        api.describeExportImageTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.exportImageTasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ExportImageTask.wrap(item))
        .provideEnvironment(r)
    def describeExportImageTasksPaginated(
        request: zio.aws.ec2.model.DescribeExportImageTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeExportImageTasksRequest,
      DescribeExportImageTasksResponse
    ]("describeExportImageTasks", api.describeExportImageTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeExportImageTasksResponse.wrap)
      .provideEnvironment(r)
    def describeSpotFleetInstances(
        request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly,
      zio.aws.ec2.model.ActiveInstance.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeSpotFleetInstancesRequest,
      DescribeSpotFleetInstancesResponse,
      ActiveInstance
    ](
      "describeSpotFleetInstances",
      api.describeSpotFleetInstances,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.activeInstances().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.ec2.model.ActiveInstance.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeSpotFleetInstancesPaginated(
        request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotFleetInstancesRequest,
      DescribeSpotFleetInstancesResponse
    ]("describeSpotFleetInstances", api.describeSpotFleetInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.wrap)
      .provideEnvironment(r)
    def rejectTransitGatewayVpcAttachment(
        request: zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectTransitGatewayVpcAttachmentRequest,
      RejectTransitGatewayVpcAttachmentResponse
    ](
      "rejectTransitGatewayVpcAttachment",
      api.rejectTransitGatewayVpcAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def describeByoipCidrs(
        request: zio.aws.ec2.model.DescribeByoipCidrsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeByoipCidrsRequest,
        DescribeByoipCidrsResponse,
        ByoipCidr
      ](
        "describeByoipCidrs",
        api.describeByoipCidrs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.byoipCidrs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ByoipCidr.wrap(item))
        .provideEnvironment(r)
    def describeByoipCidrsPaginated(
        request: zio.aws.ec2.model.DescribeByoipCidrsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeByoipCidrsRequest,
        DescribeByoipCidrsResponse
      ]("describeByoipCidrs", api.describeByoipCidrs)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeByoipCidrsResponse.wrap)
        .provideEnvironment(r)
    def moveAddressToVpc(
        request: zio.aws.ec2.model.MoveAddressToVpcRequest
    ): IO[AwsError, zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly] =
      asyncRequestResponse[MoveAddressToVpcRequest, MoveAddressToVpcResponse](
        "moveAddressToVpc",
        api.moveAddressToVpc
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.MoveAddressToVpcResponse.wrap)
        .provideEnvironment(r)
    def disassociateAddress(
        request: zio.aws.ec2.model.DisassociateAddressRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateAddressRequest,
      DisassociateAddressResponse
    ]("disassociateAddress", api.disassociateAddress)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resetFpgaImageAttribute(
        request: zio.aws.ec2.model.ResetFpgaImageAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetFpgaImageAttributeRequest,
      ResetFpgaImageAttributeResponse
    ]("resetFpgaImageAttribute", api.resetFpgaImageAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ResetFpgaImageAttributeResponse.wrap)
      .provideEnvironment(r)
    def modifyImageAttribute(
        request: zio.aws.ec2.model.ModifyImageAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyImageAttributeRequest,
      ModifyImageAttributeResponse
    ]("modifyImageAttribute", api.modifyImageAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def restoreSnapshotFromRecycleBin(
        request: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreSnapshotFromRecycleBinRequest,
      RestoreSnapshotFromRecycleBinResponse
    ]("restoreSnapshotFromRecycleBin", api.restoreSnapshotFromRecycleBin)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.wrap)
      .provideEnvironment(r)
    def exportClientVpnClientConfiguration(
        request: zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      ExportClientVpnClientConfigurationRequest,
      ExportClientVpnClientConfigurationResponse
    ](
      "exportClientVpnClientConfiguration",
      api.exportClientVpnClientConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.wrap)
      .provideEnvironment(r)
    def restoreSnapshotTier(
        request: zio.aws.ec2.model.RestoreSnapshotTierRequest
    ): IO[AwsError, zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly] =
      asyncRequestResponse[
        RestoreSnapshotTierRequest,
        RestoreSnapshotTierResponse
      ]("restoreSnapshotTier", api.restoreSnapshotTier)(request.buildAwsValue())
        .map(zio.aws.ec2.model.RestoreSnapshotTierResponse.wrap)
        .provideEnvironment(r)
    def registerTransitGatewayMulticastGroupSources(
        request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterTransitGatewayMulticastGroupSourcesRequest,
      RegisterTransitGatewayMulticastGroupSourcesResponse
    ](
      "registerTransitGatewayMulticastGroupSources",
      api.registerTransitGatewayMulticastGroupSources
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteNetworkInterface(
        request: zio.aws.ec2.model.DeleteNetworkInterfaceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteNetworkInterfaceRequest,
      DeleteNetworkInterfaceResponse
    ]("deleteNetworkInterface", api.deleteNetworkInterface)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def provisionPublicIpv4PoolCidr(
        request: zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      ProvisionPublicIpv4PoolCidrRequest,
      ProvisionPublicIpv4PoolCidrResponse
    ]("provisionPublicIpv4PoolCidr", api.provisionPublicIpv4PoolCidr)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.wrap)
      .provideEnvironment(r)
    def describeVolumes(
        request: zio.aws.ec2.model.DescribeVolumesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Volume.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVolumesRequest,
        DescribeVolumesResponse,
        Volume
      ](
        "describeVolumes",
        api.describeVolumes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.volumes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Volume.wrap(item))
        .provideEnvironment(r)
    def describeVolumesPaginated(
        request: zio.aws.ec2.model.DescribeVolumesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly] =
      asyncRequestResponse[DescribeVolumesRequest, DescribeVolumesResponse](
        "describeVolumes",
        api.describeVolumes
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeVolumesResponse.wrap)
        .provideEnvironment(r)
    def modifyTransitGatewayPrefixListReference(
        request: zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyTransitGatewayPrefixListReferenceRequest,
      ModifyTransitGatewayPrefixListReferenceResponse
    ](
      "modifyTransitGatewayPrefixListReference",
      api.modifyTransitGatewayPrefixListReference
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.wrap
      )
      .provideEnvironment(r)
    def createFlowLogs(
        request: zio.aws.ec2.model.CreateFlowLogsRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly] =
      asyncRequestResponse[CreateFlowLogsRequest, CreateFlowLogsResponse](
        "createFlowLogs",
        api.createFlowLogs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateFlowLogsResponse.wrap)
        .provideEnvironment(r)
    def modifyIpamScope(
        request: zio.aws.ec2.model.ModifyIpamScopeRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly] =
      asyncRequestResponse[ModifyIpamScopeRequest, ModifyIpamScopeResponse](
        "modifyIpamScope",
        api.modifyIpamScope
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyIpamScopeResponse.wrap)
        .provideEnvironment(r)
    def purchaseHostReservation(
        request: zio.aws.ec2.model.PurchaseHostReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      PurchaseHostReservationRequest,
      PurchaseHostReservationResponse
    ]("purchaseHostReservation", api.purchaseHostReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.PurchaseHostReservationResponse.wrap)
      .provideEnvironment(r)
    def describeStaleSecurityGroups(
        request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.StaleSecurityGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeStaleSecurityGroupsRequest,
        DescribeStaleSecurityGroupsResponse,
        StaleSecurityGroup
      ](
        "describeStaleSecurityGroups",
        api.describeStaleSecurityGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.staleSecurityGroupSet().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.StaleSecurityGroup.wrap(item))
        .provideEnvironment(r)
    def describeStaleSecurityGroupsPaginated(
        request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeStaleSecurityGroupsRequest,
      DescribeStaleSecurityGroupsResponse
    ]("describeStaleSecurityGroups", api.describeStaleSecurityGroups)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.wrap)
      .provideEnvironment(r)
    def createVolume(
        request: zio.aws.ec2.model.CreateVolumeRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateVolumeResponse.ReadOnly] =
      asyncRequestResponse[CreateVolumeRequest, CreateVolumeResponse](
        "createVolume",
        api.createVolume
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateVolumeResponse.wrap)
        .provideEnvironment(r)
    def runInstances(
        request: zio.aws.ec2.model.RunInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.RunInstancesResponse.ReadOnly] =
      asyncRequestResponse[RunInstancesRequest, RunInstancesResponse](
        "runInstances",
        api.runInstances
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.RunInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeReplaceRootVolumeTasks(
        request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReplaceRootVolumeTasksRequest,
      DescribeReplaceRootVolumeTasksResponse,
      ReplaceRootVolumeTask
    ](
      "describeReplaceRootVolumeTasks",
      api.describeReplaceRootVolumeTasks,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.replaceRootVolumeTasks().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ReplaceRootVolumeTask.wrap(item))
      .provideEnvironment(r)
    def describeReplaceRootVolumeTasksPaginated(
        request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReplaceRootVolumeTasksRequest,
      DescribeReplaceRootVolumeTasksResponse
    ]("describeReplaceRootVolumeTasks", api.describeReplaceRootVolumeTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.wrap)
      .provideEnvironment(r)
    def associateDhcpOptions(
        request: zio.aws.ec2.model.AssociateDhcpOptionsRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      AssociateDhcpOptionsRequest,
      AssociateDhcpOptionsResponse
    ]("associateDhcpOptions", api.associateDhcpOptions)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createRouteTable(
        request: zio.aws.ec2.model.CreateRouteTableRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly] =
      asyncRequestResponse[CreateRouteTableRequest, CreateRouteTableResponse](
        "createRouteTable",
        api.createRouteTable
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateRouteTableResponse.wrap)
        .provideEnvironment(r)
    def deleteVpcPeeringConnection(
        request: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpcPeeringConnectionRequest,
      DeleteVpcPeeringConnectionResponse
    ]("deleteVpcPeeringConnection", api.deleteVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def describePublicIpv4Pools(
        request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.PublicIpv4Pool.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribePublicIpv4PoolsRequest,
        DescribePublicIpv4PoolsResponse,
        PublicIpv4Pool
      ](
        "describePublicIpv4Pools",
        api.describePublicIpv4Pools,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.publicIpv4Pools().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.PublicIpv4Pool.wrap(item))
        .provideEnvironment(r)
    def describePublicIpv4PoolsPaginated(
        request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePublicIpv4PoolsRequest,
      DescribePublicIpv4PoolsResponse
    ]("describePublicIpv4Pools", api.describePublicIpv4Pools)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.wrap)
      .provideEnvironment(r)
    def modifyAvailabilityZoneGroup(
        request: zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyAvailabilityZoneGroupRequest,
      ModifyAvailabilityZoneGroupResponse
    ]("modifyAvailabilityZoneGroup", api.modifyAvailabilityZoneGroup)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.wrap)
      .provideEnvironment(r)
    def createClientVpnEndpoint(
        request: zio.aws.ec2.model.CreateClientVpnEndpointRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateClientVpnEndpointRequest,
      CreateClientVpnEndpointResponse
    ]("createClientVpnEndpoint", api.createClientVpnEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateClientVpnEndpointResponse.wrap)
      .provideEnvironment(r)
    def deleteSnapshot(
        request: zio.aws.ec2.model.DeleteSnapshotRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteSnapshotRequest, DeleteSnapshotResponse](
        "deleteSnapshot",
        api.deleteSnapshot
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createTrafficMirrorFilter(
        request: zio.aws.ec2.model.CreateTrafficMirrorFilterRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTrafficMirrorFilterRequest,
      CreateTrafficMirrorFilterResponse
    ]("createTrafficMirrorFilter", api.createTrafficMirrorFilter)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.wrap)
      .provideEnvironment(r)
    def createReservedInstancesListing(
        request: zio.aws.ec2.model.CreateReservedInstancesListingRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateReservedInstancesListingResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReservedInstancesListingRequest,
      CreateReservedInstancesListingResponse
    ]("createReservedInstancesListing", api.createReservedInstancesListing)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateReservedInstancesListingResponse.wrap)
      .provideEnvironment(r)
    def assignIpv6Addresses(
        request: zio.aws.ec2.model.AssignIpv6AddressesRequest
    ): IO[AwsError, zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly] =
      asyncRequestResponse[
        AssignIpv6AddressesRequest,
        AssignIpv6AddressesResponse
      ]("assignIpv6Addresses", api.assignIpv6Addresses)(request.buildAwsValue())
        .map(zio.aws.ec2.model.AssignIpv6AddressesResponse.wrap)
        .provideEnvironment(r)
    def getVpnConnectionDeviceTypes(
        request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetVpnConnectionDeviceTypesRequest,
      GetVpnConnectionDeviceTypesResponse,
      VpnConnectionDeviceType
    ](
      "getVpnConnectionDeviceTypes",
      api.getVpnConnectionDeviceTypes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.vpnConnectionDeviceTypes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.VpnConnectionDeviceType.wrap(item))
      .provideEnvironment(r)
    def getVpnConnectionDeviceTypesPaginated(
        request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetVpnConnectionDeviceTypesRequest,
      GetVpnConnectionDeviceTypesResponse
    ]("getVpnConnectionDeviceTypes", api.getVpnConnectionDeviceTypes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.wrap)
      .provideEnvironment(r)
    def describeSecurityGroupReferences(
        request: zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSecurityGroupReferencesRequest,
      DescribeSecurityGroupReferencesResponse
    ]("describeSecurityGroupReferences", api.describeSecurityGroupReferences)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.wrap)
      .provideEnvironment(r)
    def describeImages(
        request: zio.aws.ec2.model.DescribeImagesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeImagesResponse.ReadOnly] =
      asyncRequestResponse[DescribeImagesRequest, DescribeImagesResponse](
        "describeImages",
        api.describeImages
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeImagesResponse.wrap)
        .provideEnvironment(r)
    def requestSpotFleet(
        request: zio.aws.ec2.model.RequestSpotFleetRequest
    ): IO[AwsError, zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly] =
      asyncRequestResponse[RequestSpotFleetRequest, RequestSpotFleetResponse](
        "requestSpotFleet",
        api.requestSpotFleet
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.RequestSpotFleetResponse.wrap)
        .provideEnvironment(r)
    def acceptTransitGatewayMulticastDomainAssociations(
        request: zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptTransitGatewayMulticastDomainAssociationsRequest,
      AcceptTransitGatewayMulticastDomainAssociationsResponse
    ](
      "acceptTransitGatewayMulticastDomainAssociations",
      api.acceptTransitGatewayMulticastDomainAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def deletePublicIpv4Pool(
        request: zio.aws.ec2.model.DeletePublicIpv4PoolRequest
    ): IO[AwsError, zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly] =
      asyncRequestResponse[
        DeletePublicIpv4PoolRequest,
        DeletePublicIpv4PoolResponse
      ]("deletePublicIpv4Pool", api.deletePublicIpv4Pool)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeletePublicIpv4PoolResponse.wrap)
        .provideEnvironment(r)
    def updateSecurityGroupRuleDescriptionsEgress(
        request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateSecurityGroupRuleDescriptionsEgressRequest,
      UpdateSecurityGroupRuleDescriptionsEgressResponse
    ](
      "updateSecurityGroupRuleDescriptionsEgress",
      api.updateSecurityGroupRuleDescriptionsEgress
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.wrap
      )
      .provideEnvironment(r)
    def replaceRoute(
        request: zio.aws.ec2.model.ReplaceRouteRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[ReplaceRouteRequest, ReplaceRouteResponse](
        "replaceRoute",
        api.replaceRoute
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createNetworkInsightsPath(
        request: zio.aws.ec2.model.CreateNetworkInsightsPathRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNetworkInsightsPathRequest,
      CreateNetworkInsightsPathResponse
    ]("createNetworkInsightsPath", api.createNetworkInsightsPath)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateNetworkInsightsPathResponse.wrap)
      .provideEnvironment(r)
    def deleteQueuedReservedInstances(
        request: zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteQueuedReservedInstancesRequest,
      DeleteQueuedReservedInstancesResponse
    ]("deleteQueuedReservedInstances", api.deleteQueuedReservedInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.wrap)
      .provideEnvironment(r)
    def disassociateInstanceEventWindow(
        request: zio.aws.ec2.model.DisassociateInstanceEventWindowRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateInstanceEventWindowRequest,
      DisassociateInstanceEventWindowResponse
    ]("disassociateInstanceEventWindow", api.disassociateInstanceEventWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.wrap)
      .provideEnvironment(r)
    def getConsoleOutput(
        request: zio.aws.ec2.model.GetConsoleOutputRequest
    ): IO[AwsError, zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly] =
      asyncRequestResponse[GetConsoleOutputRequest, GetConsoleOutputResponse](
        "getConsoleOutput",
        api.getConsoleOutput
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.GetConsoleOutputResponse.wrap)
        .provideEnvironment(r)
    def createStoreImageTask(
        request: zio.aws.ec2.model.CreateStoreImageTaskRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly] =
      asyncRequestResponse[
        CreateStoreImageTaskRequest,
        CreateStoreImageTaskResponse
      ]("createStoreImageTask", api.createStoreImageTask)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateStoreImageTaskResponse.wrap)
        .provideEnvironment(r)
    def getReservedInstancesExchangeQuote(
        request: zio.aws.ec2.model.GetReservedInstancesExchangeQuoteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly
    ] = asyncRequestResponse[
      GetReservedInstancesExchangeQuoteRequest,
      GetReservedInstancesExchangeQuoteResponse
    ](
      "getReservedInstancesExchangeQuote",
      api.getReservedInstancesExchangeQuote
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.wrap)
      .provideEnvironment(r)
    def attachVpnGateway(
        request: zio.aws.ec2.model.AttachVpnGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly] =
      asyncRequestResponse[AttachVpnGatewayRequest, AttachVpnGatewayResponse](
        "attachVpnGateway",
        api.attachVpnGateway
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.AttachVpnGatewayResponse.wrap)
        .provideEnvironment(r)
    def modifyVpnConnection(
        request: zio.aws.ec2.model.ModifyVpnConnectionRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly] =
      asyncRequestResponse[
        ModifyVpnConnectionRequest,
        ModifyVpnConnectionResponse
      ]("modifyVpnConnection", api.modifyVpnConnection)(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyVpnConnectionResponse.wrap)
        .provideEnvironment(r)
    def getDefaultCreditSpecification(
        request: zio.aws.ec2.model.GetDefaultCreditSpecificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDefaultCreditSpecificationRequest,
      GetDefaultCreditSpecificationResponse
    ]("getDefaultCreditSpecification", api.getDefaultCreditSpecification)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.wrap)
      .provideEnvironment(r)
    def createImage(
        request: zio.aws.ec2.model.CreateImageRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateImageResponse.ReadOnly] =
      asyncRequestResponse[CreateImageRequest, CreateImageResponse](
        "createImage",
        api.createImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateImageResponse.wrap)
        .provideEnvironment(r)
    def disableTransitGatewayRouteTablePropagation(
        request: zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableTransitGatewayRouteTablePropagationRequest,
      DisableTransitGatewayRouteTablePropagationResponse
    ](
      "disableTransitGatewayRouteTablePropagation",
      api.disableTransitGatewayRouteTablePropagation
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.wrap
      )
      .provideEnvironment(r)
    def createFleet(
        request: zio.aws.ec2.model.CreateFleetRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateFleetResponse.ReadOnly] =
      asyncRequestResponse[CreateFleetRequest, CreateFleetResponse](
        "createFleet",
        api.createFleet
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateFleetResponse.wrap)
        .provideEnvironment(r)
    def createSubnet(
        request: zio.aws.ec2.model.CreateSubnetRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateSubnetResponse.ReadOnly] =
      asyncRequestResponse[CreateSubnetRequest, CreateSubnetResponse](
        "createSubnet",
        api.createSubnet
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateSubnetResponse.wrap)
        .provideEnvironment(r)
    def listSnapshotsInRecycleBin(
        request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly
    ] = asyncSimplePaginatedRequest[
      ListSnapshotsInRecycleBinRequest,
      ListSnapshotsInRecycleBinResponse,
      SnapshotRecycleBinInfo
    ](
      "listSnapshotsInRecycleBin",
      api.listSnapshotsInRecycleBin,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.snapshots().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.SnapshotRecycleBinInfo.wrap(item))
      .provideEnvironment(r)
    def listSnapshotsInRecycleBinPaginated(
        request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly
    ] = asyncRequestResponse[
      ListSnapshotsInRecycleBinRequest,
      ListSnapshotsInRecycleBinResponse
    ]("listSnapshotsInRecycleBin", api.listSnapshotsInRecycleBin)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.wrap)
      .provideEnvironment(r)
    def describeAggregateIdFormat(
        request: zio.aws.ec2.model.DescribeAggregateIdFormatRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAggregateIdFormatRequest,
      DescribeAggregateIdFormatResponse
    ]("describeAggregateIdFormat", api.describeAggregateIdFormat)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeAggregateIdFormatResponse.wrap)
      .provideEnvironment(r)
    def createNetworkInsightsAccessScope(
        request: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateNetworkInsightsAccessScopeRequest,
      CreateNetworkInsightsAccessScopeResponse
    ]("createNetworkInsightsAccessScope", api.createNetworkInsightsAccessScope)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.wrap)
      .provideEnvironment(r)
    def modifySpotFleetRequest(
        request: zio.aws.ec2.model.ModifySpotFleetRequestRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifySpotFleetRequestResponse.ReadOnly] =
      asyncRequestResponse[
        ModifySpotFleetRequestRequest,
        ModifySpotFleetRequestResponse
      ]("modifySpotFleetRequest", api.modifySpotFleetRequest)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ModifySpotFleetRequestResponse.wrap)
        .provideEnvironment(r)
    def modifyCapacityReservationFleet(
        request: zio.aws.ec2.model.ModifyCapacityReservationFleetRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyCapacityReservationFleetRequest,
      ModifyCapacityReservationFleetResponse
    ]("modifyCapacityReservationFleet", api.modifyCapacityReservationFleet)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.wrap)
      .provideEnvironment(r)
    def describeIpv6Pools(
        request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipv6Pool.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeIpv6PoolsRequest,
        DescribeIpv6PoolsResponse,
        Ipv6Pool
      ](
        "describeIpv6Pools",
        api.describeIpv6Pools,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipv6Pools().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Ipv6Pool.wrap(item))
        .provideEnvironment(r)
    def describeIpv6PoolsPaginated(
        request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly] =
      asyncRequestResponse[DescribeIpv6PoolsRequest, DescribeIpv6PoolsResponse](
        "describeIpv6Pools",
        api.describeIpv6Pools
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeIpv6PoolsResponse.wrap)
        .provideEnvironment(r)
    def stopInstances(
        request: zio.aws.ec2.model.StopInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.StopInstancesResponse.ReadOnly] =
      asyncRequestResponse[StopInstancesRequest, StopInstancesResponse](
        "stopInstances",
        api.stopInstances
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.StopInstancesResponse.wrap)
        .provideEnvironment(r)
    def describeExportTasks(
        request: zio.aws.ec2.model.DescribeExportTasksRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeExportTasksRequest,
        DescribeExportTasksResponse
      ]("describeExportTasks", api.describeExportTasks)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeExportTasksResponse.wrap)
        .provideEnvironment(r)
    def restoreManagedPrefixListVersion(
        request: zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly
    ] = asyncRequestResponse[
      RestoreManagedPrefixListVersionRequest,
      RestoreManagedPrefixListVersionResponse
    ]("restoreManagedPrefixListVersion", api.restoreManagedPrefixListVersion)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.wrap)
      .provideEnvironment(r)
    def describeBundleTasks(
        request: zio.aws.ec2.model.DescribeBundleTasksRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeBundleTasksRequest,
        DescribeBundleTasksResponse
      ]("describeBundleTasks", api.describeBundleTasks)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeBundleTasksResponse.wrap)
        .provideEnvironment(r)
    def describeClientVpnRoutes(
        request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnRoute.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClientVpnRoutesRequest,
        DescribeClientVpnRoutesResponse,
        ClientVpnRoute
      ](
        "describeClientVpnRoutes",
        api.describeClientVpnRoutes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.routes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ClientVpnRoute.wrap(item))
        .provideEnvironment(r)
    def describeClientVpnRoutesPaginated(
        request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClientVpnRoutesRequest,
      DescribeClientVpnRoutesResponse
    ]("describeClientVpnRoutes", api.describeClientVpnRoutes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeClientVpnRoutesResponse.wrap)
      .provideEnvironment(r)
    def describeIamInstanceProfileAssociations(
        request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeIamInstanceProfileAssociationsRequest,
      DescribeIamInstanceProfileAssociationsResponse,
      IamInstanceProfileAssociation
    ](
      "describeIamInstanceProfileAssociations",
      api.describeIamInstanceProfileAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.iamInstanceProfileAssociations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.IamInstanceProfileAssociation.wrap(item))
      .provideEnvironment(r)
    def describeIamInstanceProfileAssociationsPaginated(
        request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeIamInstanceProfileAssociationsRequest,
      DescribeIamInstanceProfileAssociationsResponse
    ](
      "describeIamInstanceProfileAssociations",
      api.describeIamInstanceProfileAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteIpam(
        request: zio.aws.ec2.model.DeleteIpamRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteIpamResponse.ReadOnly] =
      asyncRequestResponse[DeleteIpamRequest, DeleteIpamResponse](
        "deleteIpam",
        api.deleteIpam
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteIpamResponse.wrap)
        .provideEnvironment(r)
    def attachVolume(
        request: zio.aws.ec2.model.AttachVolumeRequest
    ): IO[AwsError, zio.aws.ec2.model.AttachVolumeResponse.ReadOnly] =
      asyncRequestResponse[AttachVolumeRequest, AttachVolumeResponse](
        "attachVolume",
        api.attachVolume
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.AttachVolumeResponse.wrap)
        .provideEnvironment(r)
    def createClientVpnRoute(
        request: zio.aws.ec2.model.CreateClientVpnRouteRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly] =
      asyncRequestResponse[
        CreateClientVpnRouteRequest,
        CreateClientVpnRouteResponse
      ]("createClientVpnRoute", api.createClientVpnRoute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateClientVpnRouteResponse.wrap)
        .provideEnvironment(r)
    def acceptTransitGatewayPeeringAttachment(
        request: zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptTransitGatewayPeeringAttachmentRequest,
      AcceptTransitGatewayPeeringAttachmentResponse
    ](
      "acceptTransitGatewayPeeringAttachment",
      api.acceptTransitGatewayPeeringAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkInterfaces(
        request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkInterface.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeNetworkInterfacesRequest,
        DescribeNetworkInterfacesResponse,
        NetworkInterface
      ](
        "describeNetworkInterfaces",
        api.describeNetworkInterfaces,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.networkInterfaces().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.NetworkInterface.wrap(item))
        .provideEnvironment(r)
    def describeNetworkInterfacesPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInterfacesRequest,
      DescribeNetworkInterfacesResponse
    ]("describeNetworkInterfaces", api.describeNetworkInterfaces)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeNetworkInterfacesResponse.wrap)
      .provideEnvironment(r)
    def describeLocalGatewayVirtualInterfaceGroups(
        request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLocalGatewayVirtualInterfaceGroupsRequest,
      DescribeLocalGatewayVirtualInterfaceGroupsResponse,
      LocalGatewayVirtualInterfaceGroup
    ](
      "describeLocalGatewayVirtualInterfaceGroups",
      api.describeLocalGatewayVirtualInterfaceGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.localGatewayVirtualInterfaceGroups().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.wrap(item)
      )
      .provideEnvironment(r)
    def describeLocalGatewayVirtualInterfaceGroupsPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLocalGatewayVirtualInterfaceGroupsRequest,
      DescribeLocalGatewayVirtualInterfaceGroupsResponse
    ](
      "describeLocalGatewayVirtualInterfaceGroups",
      api.describeLocalGatewayVirtualInterfaceGroups
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.wrap
      )
      .provideEnvironment(r)
    def modifyTrafficMirrorSession(
        request: zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyTrafficMirrorSessionRequest,
      ModifyTrafficMirrorSessionResponse
    ]("modifyTrafficMirrorSession", api.modifyTrafficMirrorSession)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.wrap)
      .provideEnvironment(r)
    def disassociateVpcCidrBlock(
        request: zio.aws.ec2.model.DisassociateVpcCidrBlockRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateVpcCidrBlockRequest,
      DisassociateVpcCidrBlockResponse
    ]("disassociateVpcCidrBlock", api.disassociateVpcCidrBlock)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.wrap)
      .provideEnvironment(r)
    def disableVpcClassicLinkDnsSupport(
        request: zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableVpcClassicLinkDnsSupportRequest,
      DisableVpcClassicLinkDnsSupportResponse
    ]("disableVpcClassicLinkDnsSupport", api.disableVpcClassicLinkDnsSupport)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.wrap)
      .provideEnvironment(r)
    def deleteClientVpnRoute(
        request: zio.aws.ec2.model.DeleteClientVpnRouteRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteClientVpnRouteRequest,
        DeleteClientVpnRouteResponse
      ]("deleteClientVpnRoute", api.deleteClientVpnRoute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeleteClientVpnRouteResponse.wrap)
        .provideEnvironment(r)
    def createTransitGatewayConnect(
        request: zio.aws.ec2.model.CreateTransitGatewayConnectRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayConnectResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayConnectRequest,
      CreateTransitGatewayConnectResponse
    ]("createTransitGatewayConnect", api.createTransitGatewayConnect)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTransitGatewayConnectResponse.wrap)
      .provideEnvironment(r)
    def createReplaceRootVolumeTask(
        request: zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateReplaceRootVolumeTaskRequest,
      CreateReplaceRootVolumeTaskResponse
    ]("createReplaceRootVolumeTask", api.createReplaceRootVolumeTask)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.wrap)
      .provideEnvironment(r)
    def cancelImportTask(
        request: zio.aws.ec2.model.CancelImportTaskRequest
    ): IO[AwsError, zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly] =
      asyncRequestResponse[CancelImportTaskRequest, CancelImportTaskResponse](
        "cancelImportTask",
        api.cancelImportTask
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CancelImportTaskResponse.wrap)
        .provideEnvironment(r)
    def describeVpcClassicLink(
        request: zio.aws.ec2.model.DescribeVpcClassicLinkRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVpcClassicLinkRequest,
        DescribeVpcClassicLinkResponse
      ]("describeVpcClassicLink", api.describeVpcClassicLink)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeVpcClassicLinkResponse.wrap)
        .provideEnvironment(r)
    def modifyHosts(
        request: zio.aws.ec2.model.ModifyHostsRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyHostsResponse.ReadOnly] =
      asyncRequestResponse[ModifyHostsRequest, ModifyHostsResponse](
        "modifyHosts",
        api.modifyHosts
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyHostsResponse.wrap)
        .provideEnvironment(r)
    def createRestoreImageTask(
        request: zio.aws.ec2.model.CreateRestoreImageTaskRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly] =
      asyncRequestResponse[
        CreateRestoreImageTaskRequest,
        CreateRestoreImageTaskResponse
      ]("createRestoreImageTask", api.createRestoreImageTask)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateRestoreImageTaskResponse.wrap)
        .provideEnvironment(r)
    def describeTransitGatewayAttachments(
        request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayAttachmentsRequest,
      DescribeTransitGatewayAttachmentsResponse,
      TransitGatewayAttachment
    ](
      "describeTransitGatewayAttachments",
      api.describeTransitGatewayAttachments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayAttachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayAttachment.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayAttachmentsPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayAttachmentsRequest,
      DescribeTransitGatewayAttachmentsResponse
    ](
      "describeTransitGatewayAttachments",
      api.describeTransitGatewayAttachments
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.wrap)
      .provideEnvironment(r)
    def deleteVpcEndpointServiceConfigurations(
        request: zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVpcEndpointServiceConfigurationsRequest,
      DeleteVpcEndpointServiceConfigurationsResponse
    ](
      "deleteVpcEndpointServiceConfigurations",
      api.deleteVpcEndpointServiceConfigurations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.wrap
      )
      .provideEnvironment(r)
    def startNetworkInsightsAccessScopeAnalysis(
        request: zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartNetworkInsightsAccessScopeAnalysisRequest,
      StartNetworkInsightsAccessScopeAnalysisResponse
    ](
      "startNetworkInsightsAccessScopeAnalysis",
      api.startNetworkInsightsAccessScopeAnalysis
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.wrap
      )
      .provideEnvironment(r)
    def describeTransitGatewayMulticastDomains(
        request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayMulticastDomainsRequest,
      DescribeTransitGatewayMulticastDomainsResponse,
      TransitGatewayMulticastDomain
    ](
      "describeTransitGatewayMulticastDomains",
      api.describeTransitGatewayMulticastDomains,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayMulticastDomains().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayMulticastDomain.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayMulticastDomainsPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayMulticastDomainsRequest,
      DescribeTransitGatewayMulticastDomainsResponse
    ](
      "describeTransitGatewayMulticastDomains",
      api.describeTransitGatewayMulticastDomains
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.wrap
      )
      .provideEnvironment(r)
    def importKeyPair(
        request: zio.aws.ec2.model.ImportKeyPairRequest
    ): IO[AwsError, zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly] =
      asyncRequestResponse[ImportKeyPairRequest, ImportKeyPairResponse](
        "importKeyPair",
        api.importKeyPair
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ImportKeyPairResponse.wrap)
        .provideEnvironment(r)
    def revokeSecurityGroupEgress(
        request: zio.aws.ec2.model.RevokeSecurityGroupEgressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly
    ] = asyncRequestResponse[
      RevokeSecurityGroupEgressRequest,
      RevokeSecurityGroupEgressResponse
    ]("revokeSecurityGroupEgress", api.revokeSecurityGroupEgress)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.wrap)
      .provideEnvironment(r)
    def enableVgwRoutePropagation(
        request: zio.aws.ec2.model.EnableVgwRoutePropagationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      EnableVgwRoutePropagationRequest,
      EnableVgwRoutePropagationResponse
    ]("enableVgwRoutePropagation", api.enableVgwRoutePropagation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createTransitGatewayRoute(
        request: zio.aws.ec2.model.CreateTransitGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayRouteRequest,
      CreateTransitGatewayRouteResponse
    ]("createTransitGatewayRoute", api.createTransitGatewayRoute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTransitGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def acceptReservedInstancesExchangeQuote(
        request: zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptReservedInstancesExchangeQuoteRequest,
      AcceptReservedInstancesExchangeQuoteResponse
    ](
      "acceptReservedInstancesExchangeQuote",
      api.acceptReservedInstancesExchangeQuote
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.wrap)
      .provideEnvironment(r)
    def modifyInstanceAttribute(
        request: zio.aws.ec2.model.ModifyInstanceAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyInstanceAttributeRequest,
      ModifyInstanceAttributeResponse
    ]("modifyInstanceAttribute", api.modifyInstanceAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def deleteTransitGatewayConnectPeer(
        request: zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayConnectPeerRequest,
      DeleteTransitGatewayConnectPeerResponse
    ]("deleteTransitGatewayConnectPeer", api.deleteTransitGatewayConnectPeer)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def createIpam(
        request: zio.aws.ec2.model.CreateIpamRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateIpamResponse.ReadOnly] =
      asyncRequestResponse[CreateIpamRequest, CreateIpamResponse](
        "createIpam",
        api.createIpam
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateIpamResponse.wrap)
        .provideEnvironment(r)
    def getConsoleScreenshot(
        request: zio.aws.ec2.model.GetConsoleScreenshotRequest
    ): IO[AwsError, zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly] =
      asyncRequestResponse[
        GetConsoleScreenshotRequest,
        GetConsoleScreenshotResponse
      ]("getConsoleScreenshot", api.getConsoleScreenshot)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetConsoleScreenshotResponse.wrap)
        .provideEnvironment(r)
    def deregisterTransitGatewayMulticastGroupMembers(
        request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterTransitGatewayMulticastGroupMembersRequest,
      DeregisterTransitGatewayMulticastGroupMembersResponse
    ](
      "deregisterTransitGatewayMulticastGroupMembers",
      api.deregisterTransitGatewayMulticastGroupMembers
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.wrap
      )
      .provideEnvironment(r)
    def describeNetworkInterfacePermissions(
        request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeNetworkInterfacePermissionsRequest,
      DescribeNetworkInterfacePermissionsResponse,
      NetworkInterfacePermission
    ](
      "describeNetworkInterfacePermissions",
      api.describeNetworkInterfacePermissions,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkInterfacePermissions().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.NetworkInterfacePermission.wrap(item))
      .provideEnvironment(r)
    def describeNetworkInterfacePermissionsPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInterfacePermissionsRequest,
      DescribeNetworkInterfacePermissionsResponse
    ](
      "describeNetworkInterfacePermissions",
      api.describeNetworkInterfacePermissions
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.wrap)
      .provideEnvironment(r)
    def createTransitGatewayPrefixListReference(
        request: zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayPrefixListReferenceRequest,
      CreateTransitGatewayPrefixListReferenceResponse
    ](
      "createTransitGatewayPrefixListReference",
      api.createTransitGatewayPrefixListReference
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.wrap
      )
      .provideEnvironment(r)
    def cancelCapacityReservation(
        request: zio.aws.ec2.model.CancelCapacityReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelCapacityReservationRequest,
      CancelCapacityReservationResponse
    ]("cancelCapacityReservation", api.cancelCapacityReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CancelCapacityReservationResponse.wrap)
      .provideEnvironment(r)
    def getIpamAddressHistory(
        request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetIpamAddressHistoryRequest,
      GetIpamAddressHistoryResponse,
      IpamAddressHistoryRecord
    ](
      "getIpamAddressHistory",
      api.getIpamAddressHistory,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.historyRecords().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.IpamAddressHistoryRecord.wrap(item))
      .provideEnvironment(r)
    def getIpamAddressHistoryPaginated(
        request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
    ): IO[AwsError, zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly] =
      asyncRequestResponse[
        GetIpamAddressHistoryRequest,
        GetIpamAddressHistoryResponse
      ]("getIpamAddressHistory", api.getIpamAddressHistory)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetIpamAddressHistoryResponse.wrap)
        .provideEnvironment(r)
    def describePlacementGroups(
        request: zio.aws.ec2.model.DescribePlacementGroupsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePlacementGroupsRequest,
      DescribePlacementGroupsResponse
    ]("describePlacementGroups", api.describePlacementGroups)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribePlacementGroupsResponse.wrap)
      .provideEnvironment(r)
    def detachVpnGateway(
        request: zio.aws.ec2.model.DetachVpnGatewayRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DetachVpnGatewayRequest, DetachVpnGatewayResponse](
        "detachVpnGateway",
        api.detachVpnGateway
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeInternetGateways(
        request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.InternetGateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInternetGatewaysRequest,
        DescribeInternetGatewaysResponse,
        InternetGateway
      ](
        "describeInternetGateways",
        api.describeInternetGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.internetGateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.InternetGateway.wrap(item))
        .provideEnvironment(r)
    def describeInternetGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInternetGatewaysRequest,
      DescribeInternetGatewaysResponse
    ]("describeInternetGateways", api.describeInternetGateways)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeInternetGatewaysResponse.wrap)
      .provideEnvironment(r)
    def disassociateEnclaveCertificateIamRole(
        request: zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateEnclaveCertificateIamRoleRequest,
      DisassociateEnclaveCertificateIamRoleResponse
    ](
      "disassociateEnclaveCertificateIamRole",
      api.disassociateEnclaveCertificateIamRole
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.wrap)
      .provideEnvironment(r)
    def modifyTrafficMirrorFilterRule(
        request: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyTrafficMirrorFilterRuleRequest,
      ModifyTrafficMirrorFilterRuleResponse
    ]("modifyTrafficMirrorFilterRule", api.modifyTrafficMirrorFilterRule)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.wrap)
      .provideEnvironment(r)
    def modifyVpcEndpointServicePermissions(
        request: zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpcEndpointServicePermissionsRequest,
      ModifyVpcEndpointServicePermissionsResponse
    ](
      "modifyVpcEndpointServicePermissions",
      api.modifyVpcEndpointServicePermissions
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.wrap)
      .provideEnvironment(r)
    def createKeyPair(
        request: zio.aws.ec2.model.CreateKeyPairRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly] =
      asyncRequestResponse[CreateKeyPairRequest, CreateKeyPairResponse](
        "createKeyPair",
        api.createKeyPair
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateKeyPairResponse.wrap)
        .provideEnvironment(r)
    def releaseAddress(
        request: zio.aws.ec2.model.ReleaseAddressRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[ReleaseAddressRequest, ReleaseAddressResponse](
        "releaseAddress",
        api.releaseAddress
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeVpcEndpointConnectionNotifications(
        request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ConnectionNotification.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeVpcEndpointConnectionNotificationsRequest,
      DescribeVpcEndpointConnectionNotificationsResponse,
      ConnectionNotification
    ](
      "describeVpcEndpointConnectionNotifications",
      api.describeVpcEndpointConnectionNotifications,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.connectionNotificationSet().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ConnectionNotification.wrap(item))
      .provideEnvironment(r)
    def describeVpcEndpointConnectionNotificationsPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointConnectionNotificationsRequest,
      DescribeVpcEndpointConnectionNotificationsResponse
    ](
      "describeVpcEndpointConnectionNotifications",
      api.describeVpcEndpointConnectionNotifications
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.wrap
      )
      .provideEnvironment(r)
    def associateAddress(
        request: zio.aws.ec2.model.AssociateAddressRequest
    ): IO[AwsError, zio.aws.ec2.model.AssociateAddressResponse.ReadOnly] =
      asyncRequestResponse[AssociateAddressRequest, AssociateAddressResponse](
        "associateAddress",
        api.associateAddress
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.AssociateAddressResponse.wrap)
        .provideEnvironment(r)
    def describeTransitGateways(
        request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TransitGateway.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeTransitGatewaysRequest,
        DescribeTransitGatewaysResponse,
        TransitGateway
      ](
        "describeTransitGateways",
        api.describeTransitGateways,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.transitGateways().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TransitGateway.wrap(item))
        .provideEnvironment(r)
    def describeTransitGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewaysRequest,
      DescribeTransitGatewaysResponse
    ]("describeTransitGateways", api.describeTransitGateways)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeTransitGatewaysResponse.wrap)
      .provideEnvironment(r)
    def createCarrierGateway(
        request: zio.aws.ec2.model.CreateCarrierGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        CreateCarrierGatewayRequest,
        CreateCarrierGatewayResponse
      ]("createCarrierGateway", api.createCarrierGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateCarrierGatewayResponse.wrap)
        .provideEnvironment(r)
    def modifyVpcEndpointServiceConfiguration(
        request: zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpcEndpointServiceConfigurationRequest,
      ModifyVpcEndpointServiceConfigurationResponse
    ](
      "modifyVpcEndpointServiceConfiguration",
      api.modifyVpcEndpointServiceConfiguration
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.wrap)
      .provideEnvironment(r)
    def describeVolumeStatus(
        request: zio.aws.ec2.model.DescribeVolumeStatusRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.VolumeStatusItem.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVolumeStatusRequest,
        DescribeVolumeStatusResponse,
        VolumeStatusItem
      ](
        "describeVolumeStatus",
        api.describeVolumeStatus,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.volumeStatuses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.VolumeStatusItem.wrap(item))
        .provideEnvironment(r)
    def describeVolumeStatusPaginated(
        request: zio.aws.ec2.model.DescribeVolumeStatusRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVolumeStatusRequest,
        DescribeVolumeStatusResponse
      ]("describeVolumeStatus", api.describeVolumeStatus)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeVolumeStatusResponse.wrap)
        .provideEnvironment(r)
    def describeTransitGatewayVpcAttachments(
        request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayVpcAttachmentsRequest,
      DescribeTransitGatewayVpcAttachmentsResponse,
      TransitGatewayVpcAttachment
    ](
      "describeTransitGatewayVpcAttachments",
      api.describeTransitGatewayVpcAttachments,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayVpcAttachments().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayVpcAttachment.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayVpcAttachmentsPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayVpcAttachmentsRequest,
      DescribeTransitGatewayVpcAttachmentsResponse
    ](
      "describeTransitGatewayVpcAttachments",
      api.describeTransitGatewayVpcAttachments
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.wrap)
      .provideEnvironment(r)
    def createVpcPeeringConnection(
        request: zio.aws.ec2.model.CreateVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVpcPeeringConnectionRequest,
      CreateVpcPeeringConnectionResponse
    ]("createVpcPeeringConnection", api.createVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def createVpcEndpoint(
        request: zio.aws.ec2.model.CreateVpcEndpointRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly] =
      asyncRequestResponse[CreateVpcEndpointRequest, CreateVpcEndpointResponse](
        "createVpcEndpoint",
        api.createVpcEndpoint
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateVpcEndpointResponse.wrap)
        .provideEnvironment(r)
    def replaceIamInstanceProfileAssociation(
        request: zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      ReplaceIamInstanceProfileAssociationRequest,
      ReplaceIamInstanceProfileAssociationResponse
    ](
      "replaceIamInstanceProfileAssociation",
      api.replaceIamInstanceProfileAssociation
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.wrap)
      .provideEnvironment(r)
    def disableVgwRoutePropagation(
        request: zio.aws.ec2.model.DisableVgwRoutePropagationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisableVgwRoutePropagationRequest,
      DisableVgwRoutePropagationResponse
    ]("disableVgwRoutePropagation", api.disableVgwRoutePropagation)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeNetworkInsightsAccessScopes(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeNetworkInsightsAccessScopesRequest,
      DescribeNetworkInsightsAccessScopesResponse,
      NetworkInsightsAccessScope
    ](
      "describeNetworkInsightsAccessScopes",
      api.describeNetworkInsightsAccessScopes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.networkInsightsAccessScopes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.NetworkInsightsAccessScope.wrap(item))
      .provideEnvironment(r)
    def describeNetworkInsightsAccessScopesPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInsightsAccessScopesRequest,
      DescribeNetworkInsightsAccessScopesResponse
    ](
      "describeNetworkInsightsAccessScopes",
      api.describeNetworkInsightsAccessScopes
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.wrap)
      .provideEnvironment(r)
    def getNetworkInsightsAccessScopeAnalysisFindings(
        request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly,
      zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
    ]] = asyncPaginatedRequest[
      GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
      GetNetworkInsightsAccessScopeAnalysisFindingsResponse,
      AccessScopeAnalysisFinding
    ](
      "getNetworkInsightsAccessScopeAnalysisFindings",
      api.getNetworkInsightsAccessScopeAnalysisFindings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.analysisFindings().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.ec2.model.AccessScopeAnalysisFinding.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getNetworkInsightsAccessScopeAnalysisFindingsPaginated(
        request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetNetworkInsightsAccessScopeAnalysisFindingsRequest,
      GetNetworkInsightsAccessScopeAnalysisFindingsResponse
    ](
      "getNetworkInsightsAccessScopeAnalysisFindings",
      api.getNetworkInsightsAccessScopeAnalysisFindings
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.wrap
      )
      .provideEnvironment(r)
    def cancelCapacityReservationFleets(
        request: zio.aws.ec2.model.CancelCapacityReservationFleetsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelCapacityReservationFleetsRequest,
      CancelCapacityReservationFleetsResponse
    ]("cancelCapacityReservationFleets", api.cancelCapacityReservationFleets)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.wrap)
      .provideEnvironment(r)
    def deleteLocalGatewayRouteTableVpcAssociation(
        request: zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLocalGatewayRouteTableVpcAssociationRequest,
      DeleteLocalGatewayRouteTableVpcAssociationResponse
    ](
      "deleteLocalGatewayRouteTableVpcAssociation",
      api.deleteLocalGatewayRouteTableVpcAssociation
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.wrap
      )
      .provideEnvironment(r)
    def associateIamInstanceProfile(
        request: zio.aws.ec2.model.AssociateIamInstanceProfileRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateIamInstanceProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateIamInstanceProfileRequest,
      AssociateIamInstanceProfileResponse
    ]("associateIamInstanceProfile", api.associateIamInstanceProfile)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssociateIamInstanceProfileResponse.wrap)
      .provideEnvironment(r)
    def describeTrunkInterfaceAssociations(
        request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTrunkInterfaceAssociationsRequest,
      DescribeTrunkInterfaceAssociationsResponse,
      TrunkInterfaceAssociation
    ](
      "describeTrunkInterfaceAssociations",
      api.describeTrunkInterfaceAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.interfaceAssociations().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TrunkInterfaceAssociation.wrap(item))
      .provideEnvironment(r)
    def describeTrunkInterfaceAssociationsPaginated(
        request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTrunkInterfaceAssociationsRequest,
      DescribeTrunkInterfaceAssociationsResponse
    ](
      "describeTrunkInterfaceAssociations",
      api.describeTrunkInterfaceAssociations
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.wrap)
      .provideEnvironment(r)
    def startNetworkInsightsAnalysis(
        request: zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartNetworkInsightsAnalysisRequest,
      StartNetworkInsightsAnalysisResponse
    ]("startNetworkInsightsAnalysis", api.startNetworkInsightsAnalysis)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.wrap)
      .provideEnvironment(r)
    def purchaseReservedInstancesOffering(
        request: zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly
    ] = asyncRequestResponse[
      PurchaseReservedInstancesOfferingRequest,
      PurchaseReservedInstancesOfferingResponse
    ](
      "purchaseReservedInstancesOffering",
      api.purchaseReservedInstancesOffering
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.wrap)
      .provideEnvironment(r)
    def exportImage(
        request: zio.aws.ec2.model.ExportImageRequest
    ): IO[AwsError, zio.aws.ec2.model.ExportImageResponse.ReadOnly] =
      asyncRequestResponse[ExportImageRequest, ExportImageResponse](
        "exportImage",
        api.exportImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ExportImageResponse.wrap)
        .provideEnvironment(r)
    def describeClientVpnConnections(
        request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnConnection.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClientVpnConnectionsRequest,
        DescribeClientVpnConnectionsResponse,
        ClientVpnConnection
      ](
        "describeClientVpnConnections",
        api.describeClientVpnConnections,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.connections().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ClientVpnConnection.wrap(item))
        .provideEnvironment(r)
    def describeClientVpnConnectionsPaginated(
        request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClientVpnConnectionsRequest,
      DescribeClientVpnConnectionsResponse
    ]("describeClientVpnConnections", api.describeClientVpnConnections)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceStatus(
        request: zio.aws.ec2.model.DescribeInstanceStatusRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.InstanceStatus.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeInstanceStatusRequest,
        DescribeInstanceStatusResponse,
        InstanceStatus
      ](
        "describeInstanceStatus",
        api.describeInstanceStatus,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.instanceStatuses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.InstanceStatus.wrap(item))
        .provideEnvironment(r)
    def describeInstanceStatusPaginated(
        request: zio.aws.ec2.model.DescribeInstanceStatusRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeInstanceStatusRequest,
        DescribeInstanceStatusResponse
      ]("describeInstanceStatus", api.describeInstanceStatus)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeInstanceStatusResponse.wrap)
        .provideEnvironment(r)
    def describeAddressesAttribute(
        request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.AddressAttribute.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeAddressesAttributeRequest,
        DescribeAddressesAttributeResponse,
        AddressAttribute
      ](
        "describeAddressesAttribute",
        api.describeAddressesAttribute,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.addresses().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.AddressAttribute.wrap(item))
        .provideEnvironment(r)
    def describeAddressesAttributePaginated(
        request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAddressesAttributeRequest,
      DescribeAddressesAttributeResponse
    ]("describeAddressesAttribute", api.describeAddressesAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeAddressesAttributeResponse.wrap)
      .provideEnvironment(r)
    def associateRouteTable(
        request: zio.aws.ec2.model.AssociateRouteTableRequest
    ): IO[AwsError, zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly] =
      asyncRequestResponse[
        AssociateRouteTableRequest,
        AssociateRouteTableResponse
      ]("associateRouteTable", api.associateRouteTable)(request.buildAwsValue())
        .map(zio.aws.ec2.model.AssociateRouteTableResponse.wrap)
        .provideEnvironment(r)
    def provisionIpamPoolCidr(
        request: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly] =
      asyncRequestResponse[
        ProvisionIpamPoolCidrRequest,
        ProvisionIpamPoolCidrResponse
      ]("provisionIpamPoolCidr", api.provisionIpamPoolCidr)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.wrap)
        .provideEnvironment(r)
    def withdrawByoipCidr(
        request: zio.aws.ec2.model.WithdrawByoipCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly] =
      asyncRequestResponse[WithdrawByoipCidrRequest, WithdrawByoipCidrResponse](
        "withdrawByoipCidr",
        api.withdrawByoipCidr
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.WithdrawByoipCidrResponse.wrap)
        .provideEnvironment(r)
    def describeIpamPools(
        request: zio.aws.ec2.model.DescribeIpamPoolsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeIpamPoolsRequest,
        DescribeIpamPoolsResponse,
        IpamPool
      ](
        "describeIpamPools",
        api.describeIpamPools,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipamPools().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.IpamPool.wrap(item))
        .provideEnvironment(r)
    def describeIpamPoolsPaginated(
        request: zio.aws.ec2.model.DescribeIpamPoolsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly] =
      asyncRequestResponse[DescribeIpamPoolsRequest, DescribeIpamPoolsResponse](
        "describeIpamPools",
        api.describeIpamPools
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeIpamPoolsResponse.wrap)
        .provideEnvironment(r)
    def getAssociatedIpv6PoolCidrs(
        request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetAssociatedIpv6PoolCidrsRequest,
        GetAssociatedIpv6PoolCidrsResponse,
        Ipv6CidrAssociation
      ](
        "getAssociatedIpv6PoolCidrs",
        api.getAssociatedIpv6PoolCidrs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipv6CidrAssociations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Ipv6CidrAssociation.wrap(item))
        .provideEnvironment(r)
    def getAssociatedIpv6PoolCidrsPaginated(
        request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssociatedIpv6PoolCidrsRequest,
      GetAssociatedIpv6PoolCidrsResponse
    ]("getAssociatedIpv6PoolCidrs", api.getAssociatedIpv6PoolCidrs)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshots(
        request: zio.aws.ec2.model.DescribeSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Snapshot.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSnapshotsRequest,
        DescribeSnapshotsResponse,
        Snapshot
      ](
        "describeSnapshots",
        api.describeSnapshots,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.snapshots().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Snapshot.wrap(item))
        .provideEnvironment(r)
    def describeSnapshotsPaginated(
        request: zio.aws.ec2.model.DescribeSnapshotsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly] =
      asyncRequestResponse[DescribeSnapshotsRequest, DescribeSnapshotsResponse](
        "describeSnapshots",
        api.describeSnapshots
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeSnapshotsResponse.wrap)
        .provideEnvironment(r)
    def enableVpcClassicLinkDnsSupport(
        request: zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableVpcClassicLinkDnsSupportRequest,
      EnableVpcClassicLinkDnsSupportResponse
    ]("enableVpcClassicLinkDnsSupport", api.enableVpcClassicLinkDnsSupport)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.wrap)
      .provideEnvironment(r)
    def createTrafficMirrorSession(
        request: zio.aws.ec2.model.CreateTrafficMirrorSessionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTrafficMirrorSessionRequest,
      CreateTrafficMirrorSessionResponse
    ]("createTrafficMirrorSession", api.createTrafficMirrorSession)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.wrap)
      .provideEnvironment(r)
    def getIpamPoolAllocations(
        request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPoolAllocation.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetIpamPoolAllocationsRequest,
        GetIpamPoolAllocationsResponse,
        IpamPoolAllocation
      ](
        "getIpamPoolAllocations",
        api.getIpamPoolAllocations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipamPoolAllocations().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.IpamPoolAllocation.wrap(item))
        .provideEnvironment(r)
    def getIpamPoolAllocationsPaginated(
        request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
    ): IO[AwsError, zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly] =
      asyncRequestResponse[
        GetIpamPoolAllocationsRequest,
        GetIpamPoolAllocationsResponse
      ]("getIpamPoolAllocations", api.getIpamPoolAllocations)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetIpamPoolAllocationsResponse.wrap)
        .provideEnvironment(r)
    def describeCustomerGateways(
        request: zio.aws.ec2.model.DescribeCustomerGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCustomerGatewaysRequest,
      DescribeCustomerGatewaysResponse
    ]("describeCustomerGateways", api.describeCustomerGateways)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeCustomerGatewaysResponse.wrap)
      .provideEnvironment(r)
    def describeClientVpnAuthorizationRules(
        request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.AuthorizationRule.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClientVpnAuthorizationRulesRequest,
        DescribeClientVpnAuthorizationRulesResponse,
        AuthorizationRule
      ](
        "describeClientVpnAuthorizationRules",
        api.describeClientVpnAuthorizationRules,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.authorizationRules().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.AuthorizationRule.wrap(item))
        .provideEnvironment(r)
    def describeClientVpnAuthorizationRulesPaginated(
        request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClientVpnAuthorizationRulesRequest,
      DescribeClientVpnAuthorizationRulesResponse
    ](
      "describeClientVpnAuthorizationRules",
      api.describeClientVpnAuthorizationRules
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.wrap)
      .provideEnvironment(r)
    def rejectTransitGatewayMulticastDomainAssociations(
        request: zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      RejectTransitGatewayMulticastDomainAssociationsRequest,
      RejectTransitGatewayMulticastDomainAssociationsResponse
    ](
      "rejectTransitGatewayMulticastDomainAssociations",
      api.rejectTransitGatewayMulticastDomainAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def deleteSubnet(
        request: zio.aws.ec2.model.DeleteSubnetRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteSubnetRequest, DeleteSubnetResponse](
        "deleteSubnet",
        api.deleteSubnet
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteEgressOnlyInternetGateway(
        request: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEgressOnlyInternetGatewayRequest,
      DeleteEgressOnlyInternetGatewayResponse
    ]("deleteEgressOnlyInternetGateway", api.deleteEgressOnlyInternetGateway)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.wrap)
      .provideEnvironment(r)
    def deleteTrafficMirrorTarget(
        request: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTrafficMirrorTargetRequest,
      DeleteTrafficMirrorTargetResponse
    ]("deleteTrafficMirrorTarget", api.deleteTrafficMirrorTarget)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceAttribute(
        request: zio.aws.ec2.model.DescribeInstanceAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceAttributeRequest,
      DescribeInstanceAttributeResponse
    ]("describeInstanceAttribute", api.describeInstanceAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeInstanceAttributeResponse.wrap)
      .provideEnvironment(r)
    def disableImageDeprecation(
        request: zio.aws.ec2.model.DisableImageDeprecationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableImageDeprecationRequest,
      DisableImageDeprecationResponse
    ]("disableImageDeprecation", api.disableImageDeprecation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisableImageDeprecationResponse.wrap)
      .provideEnvironment(r)
    def deleteKeyPair(
        request: zio.aws.ec2.model.DeleteKeyPairRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteKeyPairRequest, DeleteKeyPairResponse](
        "deleteKeyPair",
        api.deleteKeyPair
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def deleteCarrierGateway(
        request: zio.aws.ec2.model.DeleteCarrierGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteCarrierGatewayRequest,
        DeleteCarrierGatewayResponse
      ]("deleteCarrierGateway", api.deleteCarrierGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DeleteCarrierGatewayResponse.wrap)
        .provideEnvironment(r)
    def deleteTransitGatewayConnect(
        request: zio.aws.ec2.model.DeleteTransitGatewayConnectRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTransitGatewayConnectRequest,
      DeleteTransitGatewayConnectResponse
    ]("deleteTransitGatewayConnect", api.deleteTransitGatewayConnect)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.wrap)
      .provideEnvironment(r)
    def createCustomerGateway(
        request: zio.aws.ec2.model.CreateCustomerGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        CreateCustomerGatewayRequest,
        CreateCustomerGatewayResponse
      ]("createCustomerGateway", api.createCustomerGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateCustomerGatewayResponse.wrap)
        .provideEnvironment(r)
    def deleteInternetGateway(
        request: zio.aws.ec2.model.DeleteInternetGatewayRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteInternetGatewayRequest,
      DeleteInternetGatewayResponse
    ]("deleteInternetGateway", api.deleteInternetGateway)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createVpnConnectionRoute(
        request: zio.aws.ec2.model.CreateVpnConnectionRouteRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      CreateVpnConnectionRouteRequest,
      CreateVpnConnectionRouteResponse
    ]("createVpnConnectionRoute", api.createVpnConnectionRoute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def getCapacityReservationUsage(
        request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly,
      zio.aws.ec2.model.InstanceUsage.ReadOnly
    ]] = asyncPaginatedRequest[
      GetCapacityReservationUsageRequest,
      GetCapacityReservationUsageResponse,
      InstanceUsage
    ](
      "getCapacityReservationUsage",
      api.getCapacityReservationUsage,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceUsages().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.ec2.model.GetCapacityReservationUsageResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.ec2.model.InstanceUsage.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getCapacityReservationUsagePaginated(
        request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly
    ] = asyncRequestResponse[
      GetCapacityReservationUsageRequest,
      GetCapacityReservationUsageResponse
    ]("getCapacityReservationUsage", api.getCapacityReservationUsage)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetCapacityReservationUsageResponse.wrap)
      .provideEnvironment(r)
    def createPlacementGroup(
        request: zio.aws.ec2.model.CreatePlacementGroupRequest
    ): IO[AwsError, zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreatePlacementGroupRequest,
        CreatePlacementGroupResponse
      ]("createPlacementGroup", api.createPlacementGroup)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreatePlacementGroupResponse.wrap)
        .provideEnvironment(r)
    def modifyNetworkInterfaceAttribute(
        request: zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyNetworkInterfaceAttributeRequest,
      ModifyNetworkInterfaceAttributeResponse
    ]("modifyNetworkInterfaceAttribute", api.modifyNetworkInterfaceAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def importSnapshot(
        request: zio.aws.ec2.model.ImportSnapshotRequest
    ): IO[AwsError, zio.aws.ec2.model.ImportSnapshotResponse.ReadOnly] =
      asyncRequestResponse[ImportSnapshotRequest, ImportSnapshotResponse](
        "importSnapshot",
        api.importSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ImportSnapshotResponse.wrap)
        .provideEnvironment(r)
    def modifyFpgaImageAttribute(
        request: zio.aws.ec2.model.ModifyFpgaImageAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyFpgaImageAttributeRequest,
      ModifyFpgaImageAttributeResponse
    ]("modifyFpgaImageAttribute", api.modifyFpgaImageAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkInsightsPaths(
        request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkInsightsPath.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeNetworkInsightsPathsRequest,
        DescribeNetworkInsightsPathsResponse,
        NetworkInsightsPath
      ](
        "describeNetworkInsightsPaths",
        api.describeNetworkInsightsPaths,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.networkInsightsPaths().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.NetworkInsightsPath.wrap(item))
        .provideEnvironment(r)
    def describeNetworkInsightsPathsPaginated(
        request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeNetworkInsightsPathsRequest,
      DescribeNetworkInsightsPathsResponse
    ]("describeNetworkInsightsPaths", api.describeNetworkInsightsPaths)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.wrap)
      .provideEnvironment(r)
    def createVpc(
        request: zio.aws.ec2.model.CreateVpcRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateVpcResponse.ReadOnly] =
      asyncRequestResponse[CreateVpcRequest, CreateVpcResponse](
        "createVpc",
        api.createVpc
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateVpcResponse.wrap)
        .provideEnvironment(r)
    def cancelReservedInstancesListing(
        request: zio.aws.ec2.model.CancelReservedInstancesListingRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelReservedInstancesListingRequest,
      CancelReservedInstancesListingResponse
    ]("cancelReservedInstancesListing", api.cancelReservedInstancesListing)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CancelReservedInstancesListingResponse.wrap)
      .provideEnvironment(r)
    def getIpamPoolCidrs(
        request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamPoolCidr.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetIpamPoolCidrsRequest,
        GetIpamPoolCidrsResponse,
        IpamPoolCidr
      ](
        "getIpamPoolCidrs",
        api.getIpamPoolCidrs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipamPoolCidrs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.IpamPoolCidr.wrap(item))
        .provideEnvironment(r)
    def getIpamPoolCidrsPaginated(
        request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
    ): IO[AwsError, zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly] =
      asyncRequestResponse[GetIpamPoolCidrsRequest, GetIpamPoolCidrsResponse](
        "getIpamPoolCidrs",
        api.getIpamPoolCidrs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.GetIpamPoolCidrsResponse.wrap)
        .provideEnvironment(r)
    def deleteVolume(
        request: zio.aws.ec2.model.DeleteVolumeRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteVolumeRequest, DeleteVolumeResponse](
        "deleteVolume",
        api.deleteVolume
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def revokeSecurityGroupIngress(
        request: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      RevokeSecurityGroupIngressRequest,
      RevokeSecurityGroupIngressResponse
    ]("revokeSecurityGroupIngress", api.revokeSecurityGroupIngress)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.wrap)
      .provideEnvironment(r)
    def describeNetworkAcls(
        request: zio.aws.ec2.model.DescribeNetworkAclsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.NetworkAcl.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeNetworkAclsRequest,
        DescribeNetworkAclsResponse,
        NetworkAcl
      ](
        "describeNetworkAcls",
        api.describeNetworkAcls,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.networkAcls().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.NetworkAcl.wrap(item))
        .provideEnvironment(r)
    def describeNetworkAclsPaginated(
        request: zio.aws.ec2.model.DescribeNetworkAclsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeNetworkAclsRequest,
        DescribeNetworkAclsResponse
      ]("describeNetworkAcls", api.describeNetworkAcls)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeNetworkAclsResponse.wrap)
        .provideEnvironment(r)
    def copyImage(
        request: zio.aws.ec2.model.CopyImageRequest
    ): IO[AwsError, zio.aws.ec2.model.CopyImageResponse.ReadOnly] =
      asyncRequestResponse[CopyImageRequest, CopyImageResponse](
        "copyImage",
        api.copyImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CopyImageResponse.wrap)
        .provideEnvironment(r)
    def advertiseByoipCidr(
        request: zio.aws.ec2.model.AdvertiseByoipCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly] =
      asyncRequestResponse[
        AdvertiseByoipCidrRequest,
        AdvertiseByoipCidrResponse
      ]("advertiseByoipCidr", api.advertiseByoipCidr)(request.buildAwsValue())
        .map(zio.aws.ec2.model.AdvertiseByoipCidrResponse.wrap)
        .provideEnvironment(r)
    def createLocalGatewayRoute(
        request: zio.aws.ec2.model.CreateLocalGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLocalGatewayRouteRequest,
      CreateLocalGatewayRouteResponse
    ]("createLocalGatewayRoute", api.createLocalGatewayRoute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateLocalGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def disassociateTrunkInterface(
        request: zio.aws.ec2.model.DisassociateTrunkInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateTrunkInterfaceRequest,
      DisassociateTrunkInterfaceResponse
    ]("disassociateTrunkInterface", api.disassociateTrunkInterface)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.wrap)
      .provideEnvironment(r)
    def describeClientVpnEndpoints(
        request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClientVpnEndpointsRequest,
        DescribeClientVpnEndpointsResponse,
        ClientVpnEndpoint
      ](
        "describeClientVpnEndpoints",
        api.describeClientVpnEndpoints,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clientVpnEndpoints().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ClientVpnEndpoint.wrap(item))
        .provideEnvironment(r)
    def describeClientVpnEndpointsPaginated(
        request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClientVpnEndpointsRequest,
      DescribeClientVpnEndpointsResponse
    ]("describeClientVpnEndpoints", api.describeClientVpnEndpoints)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.wrap)
      .provideEnvironment(r)
    def disableFastSnapshotRestores(
        request: zio.aws.ec2.model.DisableFastSnapshotRestoresRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableFastSnapshotRestoresRequest,
      DisableFastSnapshotRestoresResponse
    ]("disableFastSnapshotRestores", api.disableFastSnapshotRestores)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.wrap)
      .provideEnvironment(r)
    def createSubnetCidrReservation(
        request: zio.aws.ec2.model.CreateSubnetCidrReservationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSubnetCidrReservationRequest,
      CreateSubnetCidrReservationResponse
    ]("createSubnetCidrReservation", api.createSubnetCidrReservation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateSubnetCidrReservationResponse.wrap)
      .provideEnvironment(r)
    def disassociateRouteTable(
        request: zio.aws.ec2.model.DisassociateRouteTableRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DisassociateRouteTableRequest,
      DisassociateRouteTableResponse
    ]("disassociateRouteTable", api.disassociateRouteTable)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeSpotInstanceRequests(
        request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotInstanceRequest.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSpotInstanceRequestsRequest,
        DescribeSpotInstanceRequestsResponse,
        SpotInstanceRequest
      ](
        "describeSpotInstanceRequests",
        api.describeSpotInstanceRequests,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.spotInstanceRequests().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.SpotInstanceRequest.wrap(item))
        .provideEnvironment(r)
    def describeSpotInstanceRequestsPaginated(
        request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotInstanceRequestsRequest,
      DescribeSpotInstanceRequestsResponse
    ]("describeSpotInstanceRequests", api.describeSpotInstanceRequests)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.wrap)
      .provideEnvironment(r)
    def deleteTrafficMirrorFilterRule(
        request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTrafficMirrorFilterRuleRequest,
      DeleteTrafficMirrorFilterRuleResponse
    ]("deleteTrafficMirrorFilterRule", api.deleteTrafficMirrorFilterRule)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.wrap)
      .provideEnvironment(r)
    def describeHostReservations(
        request: zio.aws.ec2.model.DescribeHostReservationsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.HostReservation.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeHostReservationsRequest,
        DescribeHostReservationsResponse,
        HostReservation
      ](
        "describeHostReservations",
        api.describeHostReservations,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.hostReservationSet().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.HostReservation.wrap(item))
        .provideEnvironment(r)
    def describeHostReservationsPaginated(
        request: zio.aws.ec2.model.DescribeHostReservationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeHostReservationsRequest,
      DescribeHostReservationsResponse
    ]("describeHostReservations", api.describeHostReservations)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeHostReservationsResponse.wrap)
      .provideEnvironment(r)
    def modifyVpnTunnelCertificate(
        request: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpnTunnelCertificateRequest,
      ModifyVpnTunnelCertificateResponse
    ]("modifyVpnTunnelCertificate", api.modifyVpnTunnelCertificate)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.wrap)
      .provideEnvironment(r)
    def detachInternetGateway(
        request: zio.aws.ec2.model.DetachInternetGatewayRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DetachInternetGatewayRequest,
      DetachInternetGatewayResponse
    ]("detachInternetGateway", api.detachInternetGateway)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
      DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse,
      LocalGatewayRouteTableVirtualInterfaceGroupAssociation
    ](
      "describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
      api.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.localGatewayRouteTableVirtualInterfaceGroupAssociations().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation
          .wrap(item)
      )
      .provideEnvironment(r)
    def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest,
      DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse
    ](
      "describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
      api.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterImage(
        request: zio.aws.ec2.model.DeregisterImageRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeregisterImageRequest, DeregisterImageResponse](
        "deregisterImage",
        api.deregisterImage
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def modifySnapshotAttribute(
        request: zio.aws.ec2.model.ModifySnapshotAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifySnapshotAttributeRequest,
      ModifySnapshotAttributeResponse
    ]("modifySnapshotAttribute", api.modifySnapshotAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeVolumeAttribute(
        request: zio.aws.ec2.model.DescribeVolumeAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVolumeAttributeRequest,
      DescribeVolumeAttributeResponse
    ]("describeVolumeAttribute", api.describeVolumeAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVolumeAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeVpcEndpoints(
        request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.VpcEndpoint.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVpcEndpointsRequest,
        DescribeVpcEndpointsResponse,
        VpcEndpoint
      ](
        "describeVpcEndpoints",
        api.describeVpcEndpoints,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.vpcEndpoints().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.VpcEndpoint.wrap(item))
        .provideEnvironment(r)
    def describeVpcEndpointsPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeVpcEndpointsRequest,
        DescribeVpcEndpointsResponse
      ]("describeVpcEndpoints", api.describeVpcEndpoints)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeVpcEndpointsResponse.wrap)
        .provideEnvironment(r)
    def getLaunchTemplateData(
        request: zio.aws.ec2.model.GetLaunchTemplateDataRequest
    ): IO[AwsError, zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly] =
      asyncRequestResponse[
        GetLaunchTemplateDataRequest,
        GetLaunchTemplateDataResponse
      ]("getLaunchTemplateData", api.getLaunchTemplateData)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetLaunchTemplateDataResponse.wrap)
        .provideEnvironment(r)
    def deleteNetworkAcl(
        request: zio.aws.ec2.model.DeleteNetworkAclRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteNetworkAclRequest, DeleteNetworkAclResponse](
        "deleteNetworkAcl",
        api.deleteNetworkAcl
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeSecurityGroups(
        request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.SecurityGroup.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSecurityGroupsRequest,
        DescribeSecurityGroupsResponse,
        SecurityGroup
      ](
        "describeSecurityGroups",
        api.describeSecurityGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.securityGroups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.SecurityGroup.wrap(item))
        .provideEnvironment(r)
    def describeSecurityGroupsPaginated(
        request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeSecurityGroupsRequest,
        DescribeSecurityGroupsResponse
      ]("describeSecurityGroups", api.describeSecurityGroups)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeSecurityGroupsResponse.wrap)
        .provideEnvironment(r)
    def deleteFleets(
        request: zio.aws.ec2.model.DeleteFleetsRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly] =
      asyncRequestResponse[DeleteFleetsRequest, DeleteFleetsResponse](
        "deleteFleets",
        api.deleteFleets
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteFleetsResponse.wrap)
        .provideEnvironment(r)
    def replaceTransitGatewayRoute(
        request: zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      ReplaceTransitGatewayRouteRequest,
      ReplaceTransitGatewayRouteResponse
    ]("replaceTransitGatewayRoute", api.replaceTransitGatewayRoute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def getVpnConnectionDeviceSampleConfiguration(
        request: zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetVpnConnectionDeviceSampleConfigurationRequest,
      GetVpnConnectionDeviceSampleConfigurationResponse
    ](
      "getVpnConnectionDeviceSampleConfiguration",
      api.getVpnConnectionDeviceSampleConfiguration
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.wrap
      )
      .provideEnvironment(r)
    def detachClassicLinkVpc(
        request: zio.aws.ec2.model.DetachClassicLinkVpcRequest
    ): IO[AwsError, zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly] =
      asyncRequestResponse[
        DetachClassicLinkVpcRequest,
        DetachClassicLinkVpcResponse
      ]("detachClassicLinkVpc", api.detachClassicLinkVpc)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DetachClassicLinkVpcResponse.wrap)
        .provideEnvironment(r)
    def allocateAddress(
        request: zio.aws.ec2.model.AllocateAddressRequest
    ): IO[AwsError, zio.aws.ec2.model.AllocateAddressResponse.ReadOnly] =
      asyncRequestResponse[AllocateAddressRequest, AllocateAddressResponse](
        "allocateAddress",
        api.allocateAddress
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.AllocateAddressResponse.wrap)
        .provideEnvironment(r)
    def deleteVpnConnection(
        request: zio.aws.ec2.model.DeleteVpnConnectionRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteVpnConnectionRequest,
      DeleteVpnConnectionResponse
    ]("deleteVpnConnection", api.deleteVpnConnection)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeReservedInstancesOfferings(
        request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeReservedInstancesOfferingsRequest,
      DescribeReservedInstancesOfferingsResponse,
      ReservedInstancesOffering
    ](
      "describeReservedInstancesOfferings",
      api.describeReservedInstancesOfferings,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.reservedInstancesOfferings().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.ReservedInstancesOffering.wrap(item))
      .provideEnvironment(r)
    def describeReservedInstancesOfferingsPaginated(
        request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstancesOfferingsRequest,
      DescribeReservedInstancesOfferingsResponse
    ](
      "describeReservedInstancesOfferings",
      api.describeReservedInstancesOfferings
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.wrap)
      .provideEnvironment(r)
    def describeConversionTasks(
        request: zio.aws.ec2.model.DescribeConversionTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConversionTasksRequest,
      DescribeConversionTasksResponse
    ]("describeConversionTasks", api.describeConversionTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeConversionTasksResponse.wrap)
      .provideEnvironment(r)
    def describeLocalGatewayRouteTableVpcAssociations(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeLocalGatewayRouteTableVpcAssociationsRequest,
      DescribeLocalGatewayRouteTableVpcAssociationsResponse,
      LocalGatewayRouteTableVpcAssociation
    ](
      "describeLocalGatewayRouteTableVpcAssociations",
      api.describeLocalGatewayRouteTableVpcAssociations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(
          r.localGatewayRouteTableVpcAssociations().asScala
        )
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.wrap(item)
      )
      .provideEnvironment(r)
    def describeLocalGatewayRouteTableVpcAssociationsPaginated(
        request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLocalGatewayRouteTableVpcAssociationsRequest,
      DescribeLocalGatewayRouteTableVpcAssociationsResponse
    ](
      "describeLocalGatewayRouteTableVpcAssociations",
      api.describeLocalGatewayRouteTableVpcAssociations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.wrap
      )
      .provideEnvironment(r)
    def associateInstanceEventWindow(
        request: zio.aws.ec2.model.AssociateInstanceEventWindowRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateInstanceEventWindowRequest,
      AssociateInstanceEventWindowResponse
    ]("associateInstanceEventWindow", api.associateInstanceEventWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssociateInstanceEventWindowResponse.wrap)
      .provideEnvironment(r)
    def describeInstanceEventNotificationAttributes(
        request: zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeInstanceEventNotificationAttributesRequest,
      DescribeInstanceEventNotificationAttributesResponse
    ](
      "describeInstanceEventNotificationAttributes",
      api.describeInstanceEventNotificationAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteNetworkInsightsPath(
        request: zio.aws.ec2.model.DeleteNetworkInsightsPathRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkInsightsPathRequest,
      DeleteNetworkInsightsPathResponse
    ]("deleteNetworkInsightsPath", api.deleteNetworkInsightsPath)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.wrap)
      .provideEnvironment(r)
    def describeElasticGpus(
        request: zio.aws.ec2.model.DescribeElasticGpusRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly,
      zio.aws.ec2.model.ElasticGpus.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeElasticGpusRequest,
      DescribeElasticGpusResponse,
      ElasticGpus
    ](
      "describeElasticGpus",
      api.describeElasticGpus,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.elasticGpuSet().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.ec2.model.DescribeElasticGpusResponse.wrap)
          .mapOutput(_.map(item => zio.aws.ec2.model.ElasticGpus.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeElasticGpusPaginated(
        request: zio.aws.ec2.model.DescribeElasticGpusRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeElasticGpusRequest,
        DescribeElasticGpusResponse
      ]("describeElasticGpus", api.describeElasticGpus)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeElasticGpusResponse.wrap)
        .provideEnvironment(r)
    def exportTransitGatewayRoutes(
        request: zio.aws.ec2.model.ExportTransitGatewayRoutesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly
    ] = asyncRequestResponse[
      ExportTransitGatewayRoutesRequest,
      ExportTransitGatewayRoutesResponse
    ]("exportTransitGatewayRoutes", api.exportTransitGatewayRoutes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.wrap)
      .provideEnvironment(r)
    def describeTrafficMirrorSessions(
        request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorSession.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeTrafficMirrorSessionsRequest,
        DescribeTrafficMirrorSessionsResponse,
        TrafficMirrorSession
      ](
        "describeTrafficMirrorSessions",
        api.describeTrafficMirrorSessions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.trafficMirrorSessions().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TrafficMirrorSession.wrap(item))
        .provideEnvironment(r)
    def describeTrafficMirrorSessionsPaginated(
        request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTrafficMirrorSessionsRequest,
      DescribeTrafficMirrorSessionsResponse
    ]("describeTrafficMirrorSessions", api.describeTrafficMirrorSessions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.wrap)
      .provideEnvironment(r)
    def describeSpotPriceHistory(
        request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.SpotPrice.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeSpotPriceHistoryRequest,
        DescribeSpotPriceHistoryResponse,
        SpotPrice
      ](
        "describeSpotPriceHistory",
        api.describeSpotPriceHistory,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.spotPriceHistory().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.SpotPrice.wrap(item))
        .provideEnvironment(r)
    def describeSpotPriceHistoryPaginated(
        request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpotPriceHistoryRequest,
      DescribeSpotPriceHistoryResponse
    ]("describeSpotPriceHistory", api.describeSpotPriceHistory)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.wrap)
      .provideEnvironment(r)
    def enableImageDeprecation(
        request: zio.aws.ec2.model.EnableImageDeprecationRequest
    ): IO[AwsError, zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly] =
      asyncRequestResponse[
        EnableImageDeprecationRequest,
        EnableImageDeprecationResponse
      ]("enableImageDeprecation", api.enableImageDeprecation)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.EnableImageDeprecationResponse.wrap)
        .provideEnvironment(r)
    def describeRegions(
        request: zio.aws.ec2.model.DescribeRegionsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly] =
      asyncRequestResponse[DescribeRegionsRequest, DescribeRegionsResponse](
        "describeRegions",
        api.describeRegions
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeRegionsResponse.wrap)
        .provideEnvironment(r)
    def runScheduledInstances(
        request: zio.aws.ec2.model.RunScheduledInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        RunScheduledInstancesRequest,
        RunScheduledInstancesResponse
      ]("runScheduledInstances", api.runScheduledInstances)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.RunScheduledInstancesResponse.wrap)
        .provideEnvironment(r)
    def modifyInstanceEventWindow(
        request: zio.aws.ec2.model.ModifyInstanceEventWindowRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstanceEventWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceEventWindowRequest,
      ModifyInstanceEventWindowResponse
    ]("modifyInstanceEventWindow", api.modifyInstanceEventWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyInstanceEventWindowResponse.wrap)
      .provideEnvironment(r)
    def deleteTrafficMirrorSession(
        request: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTrafficMirrorSessionRequest,
      DeleteTrafficMirrorSessionResponse
    ]("deleteTrafficMirrorSession", api.deleteTrafficMirrorSession)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.wrap)
      .provideEnvironment(r)
    def modifyVpcPeeringConnectionOptions(
        request: zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyVpcPeeringConnectionOptionsRequest,
      ModifyVpcPeeringConnectionOptionsResponse
    ](
      "modifyVpcPeeringConnectionOptions",
      api.modifyVpcPeeringConnectionOptions
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.wrap)
      .provideEnvironment(r)
    def describeFlowLogs(
        request: zio.aws.ec2.model.DescribeFlowLogsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.FlowLog.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeFlowLogsRequest,
        DescribeFlowLogsResponse,
        FlowLog
      ](
        "describeFlowLogs",
        api.describeFlowLogs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.flowLogs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.FlowLog.wrap(item))
        .provideEnvironment(r)
    def describeFlowLogsPaginated(
        request: zio.aws.ec2.model.DescribeFlowLogsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly] =
      asyncRequestResponse[DescribeFlowLogsRequest, DescribeFlowLogsResponse](
        "describeFlowLogs",
        api.describeFlowLogs
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeFlowLogsResponse.wrap)
        .provideEnvironment(r)
    def describeIpams(
        request: zio.aws.ec2.model.DescribeIpamsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeIpamsRequest,
        DescribeIpamsResponse,
        Ipam
      ](
        "describeIpams",
        api.describeIpams,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipams().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.Ipam.wrap(item))
        .provideEnvironment(r)
    def describeIpamsPaginated(
        request: zio.aws.ec2.model.DescribeIpamsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly] =
      asyncRequestResponse[DescribeIpamsRequest, DescribeIpamsResponse](
        "describeIpams",
        api.describeIpams
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeIpamsResponse.wrap)
        .provideEnvironment(r)
    def modifyIpamPool(
        request: zio.aws.ec2.model.ModifyIpamPoolRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly] =
      asyncRequestResponse[ModifyIpamPoolRequest, ModifyIpamPoolResponse](
        "modifyIpamPool",
        api.modifyIpamPool
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyIpamPoolResponse.wrap)
        .provideEnvironment(r)
    def unassignIpv6Addresses(
        request: zio.aws.ec2.model.UnassignIpv6AddressesRequest
    ): IO[AwsError, zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly] =
      asyncRequestResponse[
        UnassignIpv6AddressesRequest,
        UnassignIpv6AddressesResponse
      ]("unassignIpv6Addresses", api.unassignIpv6Addresses)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.UnassignIpv6AddressesResponse.wrap)
        .provideEnvironment(r)
    def describeImportImageTasks(
        request: zio.aws.ec2.model.DescribeImportImageTasksRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ImportImageTask.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeImportImageTasksRequest,
        DescribeImportImageTasksResponse,
        ImportImageTask
      ](
        "describeImportImageTasks",
        api.describeImportImageTasks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.importImageTasks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ImportImageTask.wrap(item))
        .provideEnvironment(r)
    def describeImportImageTasksPaginated(
        request: zio.aws.ec2.model.DescribeImportImageTasksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeImportImageTasksRequest,
      DescribeImportImageTasksResponse
    ]("describeImportImageTasks", api.describeImportImageTasks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeImportImageTasksResponse.wrap)
      .provideEnvironment(r)
    def deletePlacementGroup(
        request: zio.aws.ec2.model.DeletePlacementGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeletePlacementGroupRequest,
      DeletePlacementGroupResponse
    ]("deletePlacementGroup", api.deletePlacementGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def cancelSpotInstanceRequests(
        request: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly
    ] = asyncRequestResponse[
      CancelSpotInstanceRequestsRequest,
      CancelSpotInstanceRequestsResponse
    ]("cancelSpotInstanceRequests", api.cancelSpotInstanceRequests)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.wrap)
      .provideEnvironment(r)
    def describeSnapshotAttribute(
        request: zio.aws.ec2.model.DescribeSnapshotAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSnapshotAttributeRequest,
      DescribeSnapshotAttributeResponse
    ]("describeSnapshotAttribute", api.describeSnapshotAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeSnapshotAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeManagedPrefixLists(
        request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ManagedPrefixList.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeManagedPrefixListsRequest,
        DescribeManagedPrefixListsResponse,
        ManagedPrefixList
      ](
        "describeManagedPrefixLists",
        api.describeManagedPrefixLists,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.prefixLists().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ManagedPrefixList.wrap(item))
        .provideEnvironment(r)
    def describeManagedPrefixListsPaginated(
        request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeManagedPrefixListsRequest,
      DescribeManagedPrefixListsResponse
    ]("describeManagedPrefixLists", api.describeManagedPrefixLists)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeManagedPrefixListsResponse.wrap)
      .provideEnvironment(r)
    def createNetworkAclEntry(
        request: zio.aws.ec2.model.CreateNetworkAclEntryRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      CreateNetworkAclEntryRequest,
      CreateNetworkAclEntryResponse
    ]("createNetworkAclEntry", api.createNetworkAclEntry)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def associateTransitGatewayRouteTable(
        request: zio.aws.ec2.model.AssociateTransitGatewayRouteTableRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateTransitGatewayRouteTableRequest,
      AssociateTransitGatewayRouteTableResponse
    ](
      "associateTransitGatewayRouteTable",
      api.associateTransitGatewayRouteTable
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.wrap)
      .provideEnvironment(r)
    def describeScheduledInstances(
        request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.ScheduledInstance.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeScheduledInstancesRequest,
        DescribeScheduledInstancesResponse,
        ScheduledInstance
      ](
        "describeScheduledInstances",
        api.describeScheduledInstances,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.scheduledInstanceSet().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.ScheduledInstance.wrap(item))
        .provideEnvironment(r)
    def describeScheduledInstancesPaginated(
        request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeScheduledInstancesRequest,
      DescribeScheduledInstancesResponse
    ]("describeScheduledInstances", api.describeScheduledInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeScheduledInstancesResponse.wrap)
      .provideEnvironment(r)
    def authorizeClientVpnIngress(
        request: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly
    ] = asyncRequestResponse[
      AuthorizeClientVpnIngressRequest,
      AuthorizeClientVpnIngressResponse
    ]("authorizeClientVpnIngress", api.authorizeClientVpnIngress)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.wrap)
      .provideEnvironment(r)
    def getTransitGatewayPrefixListReferences(
        request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTransitGatewayPrefixListReferencesRequest,
      GetTransitGatewayPrefixListReferencesResponse,
      TransitGatewayPrefixListReference
    ](
      "getTransitGatewayPrefixListReferences",
      api.getTransitGatewayPrefixListReferences,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.transitGatewayPrefixListReferences().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.TransitGatewayPrefixListReference.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayPrefixListReferencesPaginated(
        request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTransitGatewayPrefixListReferencesRequest,
      GetTransitGatewayPrefixListReferencesResponse
    ](
      "getTransitGatewayPrefixListReferences",
      api.getTransitGatewayPrefixListReferences
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.wrap)
      .provideEnvironment(r)
    def detachNetworkInterface(
        request: zio.aws.ec2.model.DetachNetworkInterfaceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DetachNetworkInterfaceRequest,
      DetachNetworkInterfaceResponse
    ]("detachNetworkInterface", api.detachNetworkInterface)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def importImage(
        request: zio.aws.ec2.model.ImportImageRequest
    ): IO[AwsError, zio.aws.ec2.model.ImportImageResponse.ReadOnly] =
      asyncRequestResponse[ImportImageRequest, ImportImageResponse](
        "importImage",
        api.importImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ImportImageResponse.wrap)
        .provideEnvironment(r)
    def describeEgressOnlyInternetGateways(
        request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeEgressOnlyInternetGatewaysRequest,
      DescribeEgressOnlyInternetGatewaysResponse,
      EgressOnlyInternetGateway
    ](
      "describeEgressOnlyInternetGateways",
      api.describeEgressOnlyInternetGateways,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.egressOnlyInternetGateways().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.EgressOnlyInternetGateway.wrap(item))
      .provideEnvironment(r)
    def describeEgressOnlyInternetGatewaysPaginated(
        request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeEgressOnlyInternetGatewaysRequest,
      DescribeEgressOnlyInternetGatewaysResponse
    ](
      "describeEgressOnlyInternetGateways",
      api.describeEgressOnlyInternetGateways
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.wrap)
      .provideEnvironment(r)
    def confirmProductInstance(
        request: zio.aws.ec2.model.ConfirmProductInstanceRequest
    ): IO[AwsError, zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        ConfirmProductInstanceRequest,
        ConfirmProductInstanceResponse
      ]("confirmProductInstance", api.confirmProductInstance)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ConfirmProductInstanceResponse.wrap)
        .provideEnvironment(r)
    def describePrincipalIdFormat(
        request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.PrincipalIdFormat.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribePrincipalIdFormatRequest,
        DescribePrincipalIdFormatResponse,
        PrincipalIdFormat
      ](
        "describePrincipalIdFormat",
        api.describePrincipalIdFormat,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.principals().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.PrincipalIdFormat.wrap(item))
        .provideEnvironment(r)
    def describePrincipalIdFormatPaginated(
        request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePrincipalIdFormatRequest,
      DescribePrincipalIdFormatResponse
    ]("describePrincipalIdFormat", api.describePrincipalIdFormat)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribePrincipalIdFormatResponse.wrap)
      .provideEnvironment(r)
    def associateSubnetCidrBlock(
        request: zio.aws.ec2.model.AssociateSubnetCidrBlockRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateSubnetCidrBlockRequest,
      AssociateSubnetCidrBlockResponse
    ]("associateSubnetCidrBlock", api.associateSubnetCidrBlock)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.wrap)
      .provideEnvironment(r)
    def describeClientVpnTargetNetworks(
        request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TargetNetwork.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeClientVpnTargetNetworksRequest,
        DescribeClientVpnTargetNetworksResponse,
        TargetNetwork
      ](
        "describeClientVpnTargetNetworks",
        api.describeClientVpnTargetNetworks,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.clientVpnTargetNetworks().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TargetNetwork.wrap(item))
        .provideEnvironment(r)
    def describeClientVpnTargetNetworksPaginated(
        request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeClientVpnTargetNetworksRequest,
      DescribeClientVpnTargetNetworksResponse
    ]("describeClientVpnTargetNetworks", api.describeClientVpnTargetNetworks)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.wrap)
      .provideEnvironment(r)
    def resetEbsDefaultKmsKeyId(
        request: zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly
    ] = asyncRequestResponse[
      ResetEbsDefaultKmsKeyIdRequest,
      ResetEbsDefaultKmsKeyIdResponse
    ]("resetEbsDefaultKmsKeyId", api.resetEbsDefaultKmsKeyId)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.wrap)
      .provideEnvironment(r)
    def disableIpamOrganizationAdminAccount(
        request: zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      DisableIpamOrganizationAdminAccountRequest,
      DisableIpamOrganizationAdminAccountResponse
    ](
      "disableIpamOrganizationAdminAccount",
      api.disableIpamOrganizationAdminAccount
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def describeIdFormat(
        request: zio.aws.ec2.model.DescribeIdFormatRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly] =
      asyncRequestResponse[DescribeIdFormatRequest, DescribeIdFormatResponse](
        "describeIdFormat",
        api.describeIdFormat
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeIdFormatResponse.wrap)
        .provideEnvironment(r)
    def describeIpamScopes(
        request: zio.aws.ec2.model.DescribeIpamScopesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeIpamScopesRequest,
        DescribeIpamScopesResponse,
        IpamScope
      ](
        "describeIpamScopes",
        api.describeIpamScopes,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipamScopes().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.IpamScope.wrap(item))
        .provideEnvironment(r)
    def describeIpamScopesPaginated(
        request: zio.aws.ec2.model.DescribeIpamScopesRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeIpamScopesRequest,
        DescribeIpamScopesResponse
      ]("describeIpamScopes", api.describeIpamScopes)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribeIpamScopesResponse.wrap)
        .provideEnvironment(r)
    def describeVpcEndpointServicePermissions(
        request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.AllowedPrincipal.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeVpcEndpointServicePermissionsRequest,
        DescribeVpcEndpointServicePermissionsResponse,
        AllowedPrincipal
      ](
        "describeVpcEndpointServicePermissions",
        api.describeVpcEndpointServicePermissions,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.allowedPrincipals().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.AllowedPrincipal.wrap(item))
        .provideEnvironment(r)
    def describeVpcEndpointServicePermissionsPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointServicePermissionsRequest,
      DescribeVpcEndpointServicePermissionsResponse
    ](
      "describeVpcEndpointServicePermissions",
      api.describeVpcEndpointServicePermissions
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.wrap)
      .provideEnvironment(r)
    def describeFpgaImageAttribute(
        request: zio.aws.ec2.model.DescribeFpgaImageAttributeRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeFpgaImageAttributeRequest,
      DescribeFpgaImageAttributeResponse
    ]("describeFpgaImageAttribute", api.describeFpgaImageAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.wrap)
      .provideEnvironment(r)
    def registerInstanceEventNotificationAttributes(
        request: zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      RegisterInstanceEventNotificationAttributesRequest,
      RegisterInstanceEventNotificationAttributesResponse
    ](
      "registerInstanceEventNotificationAttributes",
      api.registerInstanceEventNotificationAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def deleteNetworkInsightsAccessScopeAnalysis(
        request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteNetworkInsightsAccessScopeAnalysisRequest,
      DeleteNetworkInsightsAccessScopeAnalysisResponse
    ](
      "deleteNetworkInsightsAccessScopeAnalysis",
      api.deleteNetworkInsightsAccessScopeAnalysis
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.wrap
      )
      .provideEnvironment(r)
    def modifyVpcAttribute(
        request: zio.aws.ec2.model.ModifyVpcAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyVpcAttributeRequest,
      ModifyVpcAttributeResponse
    ]("modifyVpcAttribute", api.modifyVpcAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeTrafficMirrorFilters(
        request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeTrafficMirrorFiltersRequest,
        DescribeTrafficMirrorFiltersResponse,
        TrafficMirrorFilter
      ](
        "describeTrafficMirrorFilters",
        api.describeTrafficMirrorFilters,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.trafficMirrorFilters().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.TrafficMirrorFilter.wrap(item))
        .provideEnvironment(r)
    def describeTrafficMirrorFiltersPaginated(
        request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTrafficMirrorFiltersRequest,
      DescribeTrafficMirrorFiltersResponse
    ]("describeTrafficMirrorFilters", api.describeTrafficMirrorFilters)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.wrap)
      .provideEnvironment(r)
    def describeImageAttribute(
        request: zio.aws.ec2.model.DescribeImageAttributeRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly] =
      asyncRequestResponse[
        DescribeImageAttributeRequest,
        DescribeImageAttributeResponse
      ]("describeImageAttribute", api.describeImageAttribute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.DescribeImageAttributeResponse.wrap)
        .provideEnvironment(r)
    def resetImageAttribute(
        request: zio.aws.ec2.model.ResetImageAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResetImageAttributeRequest,
      ResetImageAttributeResponse
    ]("resetImageAttribute", api.resetImageAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeCapacityReservationFleets(
        request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.CapacityReservationFleet.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeCapacityReservationFleetsRequest,
      DescribeCapacityReservationFleetsResponse,
      CapacityReservationFleet
    ](
      "describeCapacityReservationFleets",
      api.describeCapacityReservationFleets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.capacityReservationFleets().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.CapacityReservationFleet.wrap(item))
      .provideEnvironment(r)
    def describeCapacityReservationFleetsPaginated(
        request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeCapacityReservationFleetsRequest,
      DescribeCapacityReservationFleetsResponse
    ](
      "describeCapacityReservationFleets",
      api.describeCapacityReservationFleets
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.wrap)
      .provideEnvironment(r)
    def deleteNatGateway(
        request: zio.aws.ec2.model.DeleteNatGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly] =
      asyncRequestResponse[DeleteNatGatewayRequest, DeleteNatGatewayResponse](
        "deleteNatGateway",
        api.deleteNatGateway
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteNatGatewayResponse.wrap)
        .provideEnvironment(r)
    def deleteTags(
        request: zio.aws.ec2.model.DeleteTagsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteTagsRequest, DeleteTagsResponse](
        "deleteTags",
        api.deleteTags
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def describeReservedInstancesListings(
        request: zio.aws.ec2.model.DescribeReservedInstancesListingsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeReservedInstancesListingsRequest,
      DescribeReservedInstancesListingsResponse
    ](
      "describeReservedInstancesListings",
      api.describeReservedInstancesListings
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.wrap)
      .provideEnvironment(r)
    def deleteIpamPool(
        request: zio.aws.ec2.model.DeleteIpamPoolRequest
    ): IO[AwsError, zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly] =
      asyncRequestResponse[DeleteIpamPoolRequest, DeleteIpamPoolResponse](
        "deleteIpamPool",
        api.deleteIpamPool
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DeleteIpamPoolResponse.wrap)
        .provideEnvironment(r)
    def associateClientVpnTargetNetwork(
        request: zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateClientVpnTargetNetworkRequest,
      AssociateClientVpnTargetNetworkResponse
    ]("associateClientVpnTargetNetwork", api.associateClientVpnTargetNetwork)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.wrap)
      .provideEnvironment(r)
    def copyFpgaImage(
        request: zio.aws.ec2.model.CopyFpgaImageRequest
    ): IO[AwsError, zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly] =
      asyncRequestResponse[CopyFpgaImageRequest, CopyFpgaImageResponse](
        "copyFpgaImage",
        api.copyFpgaImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CopyFpgaImageResponse.wrap)
        .provideEnvironment(r)
    def getFlowLogsIntegrationTemplate(
        request: zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly
    ] = asyncRequestResponse[
      GetFlowLogsIntegrationTemplateRequest,
      GetFlowLogsIntegrationTemplateResponse
    ]("getFlowLogsIntegrationTemplate", api.getFlowLogsIntegrationTemplate)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.wrap)
      .provideEnvironment(r)
    def getInstanceTypesFromInstanceRequirements(
        request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetInstanceTypesFromInstanceRequirementsRequest,
      GetInstanceTypesFromInstanceRequirementsResponse,
      InstanceTypeInfoFromInstanceRequirements
    ](
      "getInstanceTypesFromInstanceRequirements",
      api.getInstanceTypesFromInstanceRequirements,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.instanceTypes().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.wrap(item)
      )
      .provideEnvironment(r)
    def getInstanceTypesFromInstanceRequirementsPaginated(
        request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetInstanceTypesFromInstanceRequirementsRequest,
      GetInstanceTypesFromInstanceRequirementsResponse
    ](
      "getInstanceTypesFromInstanceRequirements",
      api.getInstanceTypesFromInstanceRequirements
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.wrap
      )
      .provideEnvironment(r)
    def unassignPrivateIpAddresses(
        request: zio.aws.ec2.model.UnassignPrivateIpAddressesRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      UnassignPrivateIpAddressesRequest,
      UnassignPrivateIpAddressesResponse
    ]("unassignPrivateIpAddresses", api.unassignPrivateIpAddresses)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def resetSnapshotAttribute(
        request: zio.aws.ec2.model.ResetSnapshotAttributeRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ResetSnapshotAttributeRequest,
      ResetSnapshotAttributeResponse
    ]("resetSnapshotAttribute", api.resetSnapshotAttribute)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describeAccountAttributes(
        request: zio.aws.ec2.model.DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeAccountAttributesResponse.wrap)
      .provideEnvironment(r)
    def acceptTransitGatewayVpcAttachment(
        request: zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptTransitGatewayVpcAttachmentRequest,
      AcceptTransitGatewayVpcAttachmentResponse
    ](
      "acceptTransitGatewayVpcAttachment",
      api.acceptTransitGatewayVpcAttachment
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.wrap)
      .provideEnvironment(r)
    def createInstanceExportTask(
        request: zio.aws.ec2.model.CreateInstanceExportTaskRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInstanceExportTaskRequest,
      CreateInstanceExportTaskResponse
    ]("createInstanceExportTask", api.createInstanceExportTask)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateInstanceExportTaskResponse.wrap)
      .provideEnvironment(r)
    def associateEnclaveCertificateIamRole(
        request: zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateEnclaveCertificateIamRoleRequest,
      AssociateEnclaveCertificateIamRoleResponse
    ](
      "associateEnclaveCertificateIamRole",
      api.associateEnclaveCertificateIamRole
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.wrap)
      .provideEnvironment(r)
    def createDefaultVpc(
        request: zio.aws.ec2.model.CreateDefaultVpcRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly] =
      asyncRequestResponse[CreateDefaultVpcRequest, CreateDefaultVpcResponse](
        "createDefaultVpc",
        api.createDefaultVpc
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateDefaultVpcResponse.wrap)
        .provideEnvironment(r)
    def getTransitGatewayRouteTablePropagations(
        request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      GetTransitGatewayRouteTablePropagationsRequest,
      GetTransitGatewayRouteTablePropagationsResponse,
      TransitGatewayRouteTablePropagation
    ](
      "getTransitGatewayRouteTablePropagations",
      api.getTransitGatewayRouteTablePropagations,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r =>
        zio.Chunk.fromIterable(r.transitGatewayRouteTablePropagations().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.ec2.model.TransitGatewayRouteTablePropagation.wrap(item)
      )
      .provideEnvironment(r)
    def getTransitGatewayRouteTablePropagationsPaginated(
        request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly
    ] = asyncRequestResponse[
      GetTransitGatewayRouteTablePropagationsRequest,
      GetTransitGatewayRouteTablePropagationsResponse
    ](
      "getTransitGatewayRouteTablePropagations",
      api.getTransitGatewayRouteTablePropagations
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.wrap
      )
      .provideEnvironment(r)
    def enableIpamOrganizationAdminAccount(
        request: zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableIpamOrganizationAdminAccountRequest,
      EnableIpamOrganizationAdminAccountResponse
    ](
      "enableIpamOrganizationAdminAccount",
      api.enableIpamOrganizationAdminAccount
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.wrap)
      .provideEnvironment(r)
    def createTransitGateway(
        request: zio.aws.ec2.model.CreateTransitGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly] =
      asyncRequestResponse[
        CreateTransitGatewayRequest,
        CreateTransitGatewayResponse
      ]("createTransitGateway", api.createTransitGateway)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.CreateTransitGatewayResponse.wrap)
        .provideEnvironment(r)
    def createTransitGatewayConnectPeer(
        request: zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTransitGatewayConnectPeerRequest,
      CreateTransitGatewayConnectPeerResponse
    ]("createTransitGatewayConnectPeer", api.createTransitGatewayConnectPeer)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.wrap)
      .provideEnvironment(r)
    def modifyDefaultCreditSpecification(
        request: zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyDefaultCreditSpecificationRequest,
      ModifyDefaultCreditSpecificationResponse
    ]("modifyDefaultCreditSpecification", api.modifyDefaultCreditSpecification)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.wrap)
      .provideEnvironment(r)
    def modifyManagedPrefixList(
        request: zio.aws.ec2.model.ModifyManagedPrefixListRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyManagedPrefixListRequest,
      ModifyManagedPrefixListResponse
    ]("modifyManagedPrefixList", api.modifyManagedPrefixList)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyManagedPrefixListResponse.wrap)
      .provideEnvironment(r)
    def modifyVpcTenancy(
        request: zio.aws.ec2.model.ModifyVpcTenancyRequest
    ): IO[AwsError, zio.aws.ec2.model.ModifyVpcTenancyResponse.ReadOnly] =
      asyncRequestResponse[ModifyVpcTenancyRequest, ModifyVpcTenancyResponse](
        "modifyVpcTenancy",
        api.modifyVpcTenancy
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ModifyVpcTenancyResponse.wrap)
        .provideEnvironment(r)
    def associateTrunkInterface(
        request: zio.aws.ec2.model.AssociateTrunkInterfaceRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateTrunkInterfaceRequest,
      AssociateTrunkInterfaceResponse
    ]("associateTrunkInterface", api.associateTrunkInterface)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AssociateTrunkInterfaceResponse.wrap)
      .provideEnvironment(r)
    def cancelConversionTask(
        request: zio.aws.ec2.model.CancelConversionTaskRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      CancelConversionTaskRequest,
      CancelConversionTaskResponse
    ]("cancelConversionTask", api.cancelConversionTask)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def createTrafficMirrorTarget(
        request: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateTrafficMirrorTargetRequest,
      CreateTrafficMirrorTargetResponse
    ]("createTrafficMirrorTarget", api.createTrafficMirrorTarget)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.wrap)
      .provideEnvironment(r)
    def searchTransitGatewayRoutes(
        request: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly
    ] = asyncRequestResponse[
      SearchTransitGatewayRoutesRequest,
      SearchTransitGatewayRoutesResponse
    ]("searchTransitGatewayRoutes", api.searchTransitGatewayRoutes)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.wrap)
      .provideEnvironment(r)
    def describeVpcEndpointServices(
        request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly,
      zio.aws.ec2.model.ServiceDetail.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeVpcEndpointServicesRequest,
      DescribeVpcEndpointServicesResponse,
      ServiceDetail
    ](
      "describeVpcEndpointServices",
      api.describeVpcEndpointServices,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.serviceDetails().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.ec2.model.ServiceDetail.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeVpcEndpointServicesPaginated(
        request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVpcEndpointServicesRequest,
      DescribeVpcEndpointServicesResponse
    ]("describeVpcEndpointServices", api.describeVpcEndpointServices)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.wrap)
      .provideEnvironment(r)
    def deleteLaunchTemplateVersions(
        request: zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLaunchTemplateVersionsRequest,
      DeleteLaunchTemplateVersionsResponse
    ]("deleteLaunchTemplateVersions", api.deleteLaunchTemplateVersions)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.wrap)
      .provideEnvironment(r)
    def createInstanceEventWindow(
        request: zio.aws.ec2.model.CreateInstanceEventWindowRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateInstanceEventWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateInstanceEventWindowRequest,
      CreateInstanceEventWindowResponse
    ]("createInstanceEventWindow", api.createInstanceEventWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateInstanceEventWindowResponse.wrap)
      .provideEnvironment(r)
    def createNatGateway(
        request: zio.aws.ec2.model.CreateNatGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly] =
      asyncRequestResponse[CreateNatGatewayRequest, CreateNatGatewayResponse](
        "createNatGateway",
        api.createNatGateway
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateNatGatewayResponse.wrap)
        .provideEnvironment(r)
    def enableSerialConsoleAccess(
        request: zio.aws.ec2.model.EnableSerialConsoleAccessRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableSerialConsoleAccessRequest,
      EnableSerialConsoleAccessResponse
    ]("enableSerialConsoleAccess", api.enableSerialConsoleAccess)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.EnableSerialConsoleAccessResponse.wrap)
      .provideEnvironment(r)
    def replaceRouteTableAssociation(
        request: zio.aws.ec2.model.ReplaceRouteTableAssociationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly
    ] = asyncRequestResponse[
      ReplaceRouteTableAssociationRequest,
      ReplaceRouteTableAssociationResponse
    ]("replaceRouteTableAssociation", api.replaceRouteTableAssociation)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.wrap)
      .provideEnvironment(r)
    def modifyEbsDefaultKmsKeyId(
        request: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyEbsDefaultKmsKeyIdRequest,
      ModifyEbsDefaultKmsKeyIdResponse
    ]("modifyEbsDefaultKmsKeyId", api.modifyEbsDefaultKmsKeyId)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.wrap)
      .provideEnvironment(r)
    def provisionByoipCidr(
        request: zio.aws.ec2.model.ProvisionByoipCidrRequest
    ): IO[AwsError, zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly] =
      asyncRequestResponse[
        ProvisionByoipCidrRequest,
        ProvisionByoipCidrResponse
      ]("provisionByoipCidr", api.provisionByoipCidr)(request.buildAwsValue())
        .map(zio.aws.ec2.model.ProvisionByoipCidrResponse.wrap)
        .provideEnvironment(r)
    def deleteLocalGatewayRoute(
        request: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteLocalGatewayRouteRequest,
      DeleteLocalGatewayRouteResponse
    ]("deleteLocalGatewayRoute", api.deleteLocalGatewayRoute)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def releaseHosts(
        request: zio.aws.ec2.model.ReleaseHostsRequest
    ): IO[AwsError, zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly] =
      asyncRequestResponse[ReleaseHostsRequest, ReleaseHostsResponse](
        "releaseHosts",
        api.releaseHosts
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ReleaseHostsResponse.wrap)
        .provideEnvironment(r)
    def describeLaunchTemplates(
        request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.LaunchTemplate.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribeLaunchTemplatesRequest,
        DescribeLaunchTemplatesResponse,
        LaunchTemplate
      ](
        "describeLaunchTemplates",
        api.describeLaunchTemplates,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.launchTemplates().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.LaunchTemplate.wrap(item))
        .provideEnvironment(r)
    def describeLaunchTemplatesPaginated(
        request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeLaunchTemplatesRequest,
      DescribeLaunchTemplatesResponse
    ]("describeLaunchTemplates", api.describeLaunchTemplates)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DescribeLaunchTemplatesResponse.wrap)
      .provideEnvironment(r)
    def terminateInstances(
        request: zio.aws.ec2.model.TerminateInstancesRequest
    ): IO[AwsError, zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        TerminateInstancesRequest,
        TerminateInstancesResponse
      ]("terminateInstances", api.terminateInstances)(request.buildAwsValue())
        .map(zio.aws.ec2.model.TerminateInstancesResponse.wrap)
        .provideEnvironment(r)
    def getHostReservationPurchasePreview(
        request: zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly
    ] = asyncRequestResponse[
      GetHostReservationPurchasePreviewRequest,
      GetHostReservationPurchasePreviewResponse
    ](
      "getHostReservationPurchasePreview",
      api.getHostReservationPurchasePreview
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.wrap)
      .provideEnvironment(r)
    def modifyInstanceCreditSpecification(
        request: zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyInstanceCreditSpecificationRequest,
      ModifyInstanceCreditSpecificationResponse
    ](
      "modifyInstanceCreditSpecification",
      api.modifyInstanceCreditSpecification
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.wrap)
      .provideEnvironment(r)
    def detachVolume(
        request: zio.aws.ec2.model.DetachVolumeRequest
    ): IO[AwsError, zio.aws.ec2.model.DetachVolumeResponse.ReadOnly] =
      asyncRequestResponse[DetachVolumeRequest, DetachVolumeResponse](
        "detachVolume",
        api.detachVolume
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.DetachVolumeResponse.wrap)
        .provideEnvironment(r)
    def createSnapshot(
        request: zio.aws.ec2.model.CreateSnapshotRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly] =
      asyncRequestResponse[CreateSnapshotRequest, CreateSnapshotResponse](
        "createSnapshot",
        api.createSnapshot
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateSnapshotResponse.wrap)
        .provideEnvironment(r)
    def getIpamResourceCidrs(
        request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.IpamResourceCidr.ReadOnly] =
      asyncSimplePaginatedRequest[
        GetIpamResourceCidrsRequest,
        GetIpamResourceCidrsResponse,
        IpamResourceCidr
      ](
        "getIpamResourceCidrs",
        api.getIpamResourceCidrs,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.ipamResourceCidrs().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.IpamResourceCidr.wrap(item))
        .provideEnvironment(r)
    def getIpamResourceCidrsPaginated(
        request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
    ): IO[AwsError, zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly] =
      asyncRequestResponse[
        GetIpamResourceCidrsRequest,
        GetIpamResourceCidrsResponse
      ]("getIpamResourceCidrs", api.getIpamResourceCidrs)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.GetIpamResourceCidrsResponse.wrap)
        .provideEnvironment(r)
    def modifyReservedInstances(
        request: zio.aws.ec2.model.ModifyReservedInstancesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly
    ] = asyncRequestResponse[
      ModifyReservedInstancesRequest,
      ModifyReservedInstancesResponse
    ]("modifyReservedInstances", api.modifyReservedInstances)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.ModifyReservedInstancesResponse.wrap)
      .provideEnvironment(r)
    def createFpgaImage(
        request: zio.aws.ec2.model.CreateFpgaImageRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly] =
      asyncRequestResponse[CreateFpgaImageRequest, CreateFpgaImageResponse](
        "createFpgaImage",
        api.createFpgaImage
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateFpgaImageResponse.wrap)
        .provideEnvironment(r)
    def deprovisionPublicIpv4PoolCidr(
        request: zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly
    ] = asyncRequestResponse[
      DeprovisionPublicIpv4PoolCidrRequest,
      DeprovisionPublicIpv4PoolCidrResponse
    ]("deprovisionPublicIpv4PoolCidr", api.deprovisionPublicIpv4PoolCidr)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.wrap)
      .provideEnvironment(r)
    def acceptVpcPeeringConnection(
        request: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.ReadOnly
    ] = asyncRequestResponse[
      AcceptVpcPeeringConnectionRequest,
      AcceptVpcPeeringConnectionResponse
    ]("acceptVpcPeeringConnection", api.acceptVpcPeeringConnection)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.wrap)
      .provideEnvironment(r)
    def describeTransitGatewayRouteTables(
        request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeTransitGatewayRouteTablesRequest,
      DescribeTransitGatewayRouteTablesResponse,
      TransitGatewayRouteTable
    ](
      "describeTransitGatewayRouteTables",
      api.describeTransitGatewayRouteTables,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.transitGatewayRouteTables().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.ec2.model.TransitGatewayRouteTable.wrap(item))
      .provideEnvironment(r)
    def describeTransitGatewayRouteTablesPaginated(
        request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeTransitGatewayRouteTablesRequest,
      DescribeTransitGatewayRouteTablesResponse
    ](
      "describeTransitGatewayRouteTables",
      api.describeTransitGatewayRouteTables
    )(request.buildAwsValue())
      .map(zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.wrap)
      .provideEnvironment(r)
    def deleteClientVpnEndpoint(
        request: zio.aws.ec2.model.DeleteClientVpnEndpointRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteClientVpnEndpointRequest,
      DeleteClientVpnEndpointResponse
    ]("deleteClientVpnEndpoint", api.deleteClientVpnEndpoint)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteClientVpnEndpointResponse.wrap)
      .provideEnvironment(r)
    def importInstance(
        request: zio.aws.ec2.model.ImportInstanceRequest
    ): IO[AwsError, zio.aws.ec2.model.ImportInstanceResponse.ReadOnly] =
      asyncRequestResponse[ImportInstanceRequest, ImportInstanceResponse](
        "importInstance",
        api.importInstance
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.ImportInstanceResponse.wrap)
        .provideEnvironment(r)
    def enableFastSnapshotRestores(
        request: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly
    ] = asyncRequestResponse[
      EnableFastSnapshotRestoresRequest,
      EnableFastSnapshotRestoresResponse
    ]("enableFastSnapshotRestores", api.enableFastSnapshotRestores)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.wrap)
      .provideEnvironment(r)
    def getAssociatedEnclaveCertificateIamRoles(
        request: zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly
    ] = asyncRequestResponse[
      GetAssociatedEnclaveCertificateIamRolesRequest,
      GetAssociatedEnclaveCertificateIamRolesResponse
    ](
      "getAssociatedEnclaveCertificateIamRoles",
      api.getAssociatedEnclaveCertificateIamRoles
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterInstanceEventNotificationAttributes(
        request: zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DeregisterInstanceEventNotificationAttributesRequest,
      DeregisterInstanceEventNotificationAttributesResponse
    ](
      "deregisterInstanceEventNotificationAttributes",
      api.deregisterInstanceEventNotificationAttributes
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.wrap
      )
      .provideEnvironment(r)
    def resetAddressAttribute(
        request: zio.aws.ec2.model.ResetAddressAttributeRequest
    ): IO[AwsError, zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly] =
      asyncRequestResponse[
        ResetAddressAttributeRequest,
        ResetAddressAttributeResponse
      ]("resetAddressAttribute", api.resetAddressAttribute)(
        request.buildAwsValue()
      ).map(zio.aws.ec2.model.ResetAddressAttributeResponse.wrap)
        .provideEnvironment(r)
    def moveByoipCidrToIpam(
        request: zio.aws.ec2.model.MoveByoipCidrToIpamRequest
    ): IO[AwsError, zio.aws.ec2.model.MoveByoipCidrToIpamResponse.ReadOnly] =
      asyncRequestResponse[
        MoveByoipCidrToIpamRequest,
        MoveByoipCidrToIpamResponse
      ]("moveByoipCidrToIpam", api.moveByoipCidrToIpam)(request.buildAwsValue())
        .map(zio.aws.ec2.model.MoveByoipCidrToIpamResponse.wrap)
        .provideEnvironment(r)
    def importClientVpnClientCertificateRevocationList(
        request: zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.ReadOnly
    ] = asyncRequestResponse[
      ImportClientVpnClientCertificateRevocationListRequest,
      ImportClientVpnClientCertificateRevocationListResponse
    ](
      "importClientVpnClientCertificateRevocationList",
      api.importClientVpnClientCertificateRevocationList
    )(request.buildAwsValue())
      .map(
        zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.wrap
      )
      .provideEnvironment(r)
    def createSpotDatafeedSubscription(
        request: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateSpotDatafeedSubscriptionRequest,
      CreateSpotDatafeedSubscriptionResponse
    ]("createSpotDatafeedSubscription", api.createSpotDatafeedSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def modifyIdentityIdFormat(
        request: zio.aws.ec2.model.ModifyIdentityIdFormatRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      ModifyIdentityIdFormatRequest,
      ModifyIdentityIdFormatResponse
    ]("modifyIdentityIdFormat", api.modifyIdentityIdFormat)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def describePrefixLists(
        request: zio.aws.ec2.model.DescribePrefixListsRequest
    ): ZStream[Any, AwsError, zio.aws.ec2.model.PrefixList.ReadOnly] =
      asyncSimplePaginatedRequest[
        DescribePrefixListsRequest,
        DescribePrefixListsResponse,
        PrefixList
      ](
        "describePrefixLists",
        api.describePrefixLists,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.prefixLists().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.ec2.model.PrefixList.wrap(item))
        .provideEnvironment(r)
    def describePrefixListsPaginated(
        request: zio.aws.ec2.model.DescribePrefixListsRequest
    ): IO[AwsError, zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly] =
      asyncRequestResponse[
        DescribePrefixListsRequest,
        DescribePrefixListsResponse
      ]("describePrefixLists", api.describePrefixLists)(request.buildAwsValue())
        .map(zio.aws.ec2.model.DescribePrefixListsResponse.wrap)
        .provideEnvironment(r)
    def createVpnGateway(
        request: zio.aws.ec2.model.CreateVpnGatewayRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly] =
      asyncRequestResponse[CreateVpnGatewayRequest, CreateVpnGatewayResponse](
        "createVpnGateway",
        api.createVpnGateway
      )(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateVpnGatewayResponse.wrap)
        .provideEnvironment(r)
    def createTags(
        request: zio.aws.ec2.model.CreateTagsRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[CreateTagsRequest, CreateTagsResponse](
        "createTags",
        api.createTags
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createSecurityGroup(
        request: zio.aws.ec2.model.CreateSecurityGroupRequest
    ): IO[AwsError, zio.aws.ec2.model.CreateSecurityGroupResponse.ReadOnly] =
      asyncRequestResponse[
        CreateSecurityGroupRequest,
        CreateSecurityGroupResponse
      ]("createSecurityGroup", api.createSecurityGroup)(request.buildAwsValue())
        .map(zio.aws.ec2.model.CreateSecurityGroupResponse.wrap)
        .provideEnvironment(r)
    def deleteInstanceEventWindow(
        request: zio.aws.ec2.model.DeleteInstanceEventWindowRequest
    ): IO[
      AwsError,
      zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteInstanceEventWindowRequest,
      DeleteInstanceEventWindowResponse
    ]("deleteInstanceEventWindow", api.deleteInstanceEventWindow)(
      request.buildAwsValue()
    ).map(zio.aws.ec2.model.DeleteInstanceEventWindowResponse.wrap)
      .provideEnvironment(r)
  }
  def describeVolumesModifications(
      request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VolumeModification.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVolumesModifications(request))
  def describeVolumesModificationsPaginated(
      request: zio.aws.ec2.model.DescribeVolumesModificationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVolumesModificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVolumesModificationsPaginated(request))
  def deleteSpotDatafeedSubscription(
      request: zio.aws.ec2.model.DeleteSpotDatafeedSubscriptionRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSpotDatafeedSubscription(request))
  def deleteVpcEndpointConnectionNotifications(
      request: zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteVpcEndpointConnectionNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcEndpointConnectionNotifications(request))
  def createNetworkInterface(
      request: zio.aws.ec2.model.CreateNetworkInterfaceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNetworkInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkInterface(request))
  def enableVpcClassicLink(
      request: zio.aws.ec2.model.EnableVpcClassicLinkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableVpcClassicLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableVpcClassicLink(request))
  def rejectTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayPeeringAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectTransitGatewayPeeringAttachment(request))
  def createVpnConnection(
      request: zio.aws.ec2.model.CreateVpnConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpnConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpnConnection(request))
  def describeDhcpOptions(
      request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DhcpOptions.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDhcpOptions(request))
  def describeDhcpOptionsPaginated(
      request: zio.aws.ec2.model.DescribeDhcpOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeDhcpOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDhcpOptionsPaginated(request))
  def modifyVpnTunnelOptions(
      request: zio.aws.ec2.model.ModifyVpnTunnelOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpnTunnelOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpnTunnelOptions(request))
  def modifyCapacityReservation(
      request: zio.aws.ec2.model.ModifyCapacityReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCapacityReservation(request))
  def describeVpcs(
      request: zio.aws.ec2.model.DescribeVpcsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Vpc.ReadOnly] =
    ZStream.serviceWithStream(_.describeVpcs(request))
  def describeVpcsPaginated(
      request: zio.aws.ec2.model.DescribeVpcsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcsPaginated(request))
  def deleteNetworkInsightsAnalysis(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAnalysisRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkInsightsAnalysis(request))
  def describeIdentityIdFormat(
      request: zio.aws.ec2.model.DescribeIdentityIdFormatRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIdentityIdFormatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdentityIdFormat(request))
  def describeTags(request: zio.aws.ec2.model.DescribeTagsRequest): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TagDescription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTags(request))
  def describeTagsPaginated(
      request: zio.aws.ec2.model.DescribeTagsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTagsPaginated(request))
  def monitorInstances(request: zio.aws.ec2.model.MonitorInstancesRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.MonitorInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.monitorInstances(request))
  def allocateIpamPoolCidr(
      request: zio.aws.ec2.model.AllocateIpamPoolCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AllocateIpamPoolCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateIpamPoolCidr(request))
  def getManagedPrefixListEntries(
      request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PrefixListEntry.ReadOnly
  ] = ZStream.serviceWithStream(_.getManagedPrefixListEntries(request))
  def getManagedPrefixListEntriesPaginated(
      request: zio.aws.ec2.model.GetManagedPrefixListEntriesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetManagedPrefixListEntriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getManagedPrefixListEntriesPaginated(request))
  def deleteTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayPeeringAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayPeeringAttachment(request))
  def getTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastDomainAssociation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getTransitGatewayMulticastDomainAssociations(request)
  )
  def getTransitGatewayMulticastDomainAssociationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayMulticastDomainAssociationsPaginated(request)
  )
  def modifyIpamResourceCidr(
      request: zio.aws.ec2.model.ModifyIpamResourceCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyIpamResourceCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyIpamResourceCidr(request))
  def createTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayVpcAttachment(request))
  def replaceNetworkAclEntry(
      request: zio.aws.ec2.model.ReplaceNetworkAclEntryRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.replaceNetworkAclEntry(request))
  def describeVpcPeeringConnections(
      request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VpcPeeringConnection.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVpcPeeringConnections(request))
  def describeVpcPeeringConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcPeeringConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcPeeringConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcPeeringConnectionsPaginated(request))
  def describeFleetHistory(
      request: zio.aws.ec2.model.DescribeFleetHistoryRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly,
    zio.aws.ec2.model.HistoryRecordEntry.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeFleetHistory(request))
  def describeFleetHistoryPaginated(
      request: zio.aws.ec2.model.DescribeFleetHistoryRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFleetHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetHistoryPaginated(request))
  def cancelSpotFleetRequests(
      request: zio.aws.ec2.model.CancelSpotFleetRequestsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelSpotFleetRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSpotFleetRequests(request))
  def bundleInstance(request: zio.aws.ec2.model.BundleInstanceRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.BundleInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.bundleInstance(request))
  def revokeClientVpnIngress(
      request: zio.aws.ec2.model.RevokeClientVpnIngressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RevokeClientVpnIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeClientVpnIngress(request))
  def deleteSubnetCidrReservation(
      request: zio.aws.ec2.model.DeleteSubnetCidrReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteSubnetCidrReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteSubnetCidrReservation(request))
  def associateTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateTransitGatewayMulticastDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTransitGatewayMulticastDomain(request))
  def searchTransitGatewayMulticastGroups(
      request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.searchTransitGatewayMulticastGroups(request))
  def searchTransitGatewayMulticastGroupsPaginated(
      request: zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SearchTransitGatewayMulticastGroupsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.searchTransitGatewayMulticastGroupsPaginated(request))
  def sendDiagnosticInterrupt(
      request: zio.aws.ec2.model.SendDiagnosticInterruptRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.sendDiagnosticInterrupt(request))
  def describeAddresses(
      request: zio.aws.ec2.model.DescribeAddressesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddresses(request))
  def enableTransitGatewayRouteTablePropagation(
      request: zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableTransitGatewayRouteTablePropagationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableTransitGatewayRouteTablePropagation(request))
  def deleteIpamScope(request: zio.aws.ec2.model.DeleteIpamScopeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteIpamScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIpamScope(request))
  def createPublicIpv4Pool(
      request: zio.aws.ec2.model.CreatePublicIpv4PoolRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreatePublicIpv4PoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPublicIpv4Pool(request))
  def createTransitGatewayRouteTable(
      request: zio.aws.ec2.model.CreateTransitGatewayRouteTableRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayRouteTable(request))
  def registerTransitGatewayMulticastGroupMembers(
      request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTransitGatewayMulticastGroupMembers(request))
  def describeKeyPairs(request: zio.aws.ec2.model.DescribeKeyPairsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeKeyPairsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKeyPairs(request))
  def startInstances(request: zio.aws.ec2.model.StartInstancesRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StartInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startInstances(request))
  def describeScheduledInstanceAvailability(
      request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ScheduledInstanceAvailability.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeScheduledInstanceAvailability(request))
  def describeScheduledInstanceAvailabilityPaginated(
      request: zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeScheduledInstanceAvailabilityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeScheduledInstanceAvailabilityPaginated(request)
  )
  def resetInstanceAttribute(
      request: zio.aws.ec2.model.ResetInstanceAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resetInstanceAttribute(request))
  def modifyInstanceMetadataOptions(
      request: zio.aws.ec2.model.ModifyInstanceMetadataOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstanceMetadataOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceMetadataOptions(request))
  def createRoute(request: zio.aws.ec2.model.CreateRouteRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoute(request))
  def deleteFlowLogs(request: zio.aws.ec2.model.DeleteFlowLogsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteFlowLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFlowLogs(request))
  def describeFpgaImages(
      request: zio.aws.ec2.model.DescribeFpgaImagesRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.FpgaImage.ReadOnly] =
    ZStream.serviceWithStream(_.describeFpgaImages(request))
  def describeFpgaImagesPaginated(
      request: zio.aws.ec2.model.DescribeFpgaImagesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFpgaImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFpgaImagesPaginated(request))
  def deleteRoute(
      request: zio.aws.ec2.model.DeleteRouteRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRoute(request))
  def modifyClientVpnEndpoint(
      request: zio.aws.ec2.model.ModifyClientVpnEndpointRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyClientVpnEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyClientVpnEndpoint(request))
  def modifyTrafficMirrorFilterNetworkServices(
      request: zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTrafficMirrorFilterNetworkServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTrafficMirrorFilterNetworkServices(request))
  def disassociateTransitGatewayRouteTable(
      request: zio.aws.ec2.model.DisassociateTransitGatewayRouteTableRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateTransitGatewayRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTransitGatewayRouteTable(request))
  def modifyInstanceCapacityReservationAttributes(
      request: zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstanceCapacityReservationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceCapacityReservationAttributes(request))
  def describeRouteTables(
      request: zio.aws.ec2.model.DescribeRouteTablesRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.RouteTable.ReadOnly] =
    ZStream.serviceWithStream(_.describeRouteTables(request))
  def describeRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeRouteTablesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeRouteTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRouteTablesPaginated(request))
  def modifySubnetAttribute(
      request: zio.aws.ec2.model.ModifySubnetAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifySubnetAttribute(request))
  def modifyVolumeAttribute(
      request: zio.aws.ec2.model.ModifyVolumeAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyVolumeAttribute(request))
  def acceptVpcEndpointConnections(
      request: zio.aws.ec2.model.AcceptVpcEndpointConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptVpcEndpointConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptVpcEndpointConnections(request))
  def attachNetworkInterface(
      request: zio.aws.ec2.model.AttachNetworkInterfaceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AttachNetworkInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachNetworkInterface(request))
  def deleteFpgaImage(request: zio.aws.ec2.model.DeleteFpgaImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteFpgaImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFpgaImage(request))
  def deleteTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayVpcAttachment(request))
  def deleteSecurityGroup(
      request: zio.aws.ec2.model.DeleteSecurityGroupRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSecurityGroup(request))
  def describeNatGateways(
      request: zio.aws.ec2.model.DescribeNatGatewaysRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.NatGateway.ReadOnly] =
    ZStream.serviceWithStream(_.describeNatGateways(request))
  def describeNatGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeNatGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNatGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNatGatewaysPaginated(request))
  def getCoipPoolUsage(request: zio.aws.ec2.model.GetCoipPoolUsageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetCoipPoolUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCoipPoolUsage(request))
  def authorizeSecurityGroupEgress(
      request: zio.aws.ec2.model.AuthorizeSecurityGroupEgressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AuthorizeSecurityGroupEgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeSecurityGroupEgress(request))
  def modifyVpcEndpoint(
      request: zio.aws.ec2.model.ModifyVpcEndpointRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcEndpoint(request))
  def deprovisionIpamPoolCidr(
      request: zio.aws.ec2.model.DeprovisionIpamPoolCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeprovisionIpamPoolCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprovisionIpamPoolCidr(request))
  def deleteTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayPrefixListReferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayPrefixListReference(request))
  def createInternetGateway(
      request: zio.aws.ec2.model.CreateInternetGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateInternetGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInternetGateway(request))
  def describeCarrierGateways(
      request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CarrierGateway.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCarrierGateways(request))
  def describeCarrierGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeCarrierGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeCarrierGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCarrierGatewaysPaginated(request))
  def disableSerialConsoleAccess(
      request: zio.aws.ec2.model.DisableSerialConsoleAccessRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableSerialConsoleAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableSerialConsoleAccess(request))
  def enableEbsEncryptionByDefault(
      request: zio.aws.ec2.model.EnableEbsEncryptionByDefaultRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableEbsEncryptionByDefaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableEbsEncryptionByDefault(request))
  def modifyTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTransitGatewayVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTransitGatewayVpcAttachment(request))
  def assignPrivateIpAddresses(
      request: zio.aws.ec2.model.AssignPrivateIpAddressesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssignPrivateIpAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assignPrivateIpAddresses(request))
  def modifyLaunchTemplate(
      request: zio.aws.ec2.model.ModifyLaunchTemplateRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyLaunchTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyLaunchTemplate(request))
  def deleteRouteTable(
      request: zio.aws.ec2.model.DeleteRouteTableRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRouteTable(request))
  def restoreAddressToClassic(
      request: zio.aws.ec2.model.RestoreAddressToClassicRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RestoreAddressToClassicResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreAddressToClassic(request))
  def describeMovingAddresses(
      request: zio.aws.ec2.model.DescribeMovingAddressesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.MovingAddressStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeMovingAddresses(request))
  def describeMovingAddressesPaginated(
      request: zio.aws.ec2.model.DescribeMovingAddressesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeMovingAddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMovingAddressesPaginated(request))
  def modifyPrivateDnsNameOptions(
      request: zio.aws.ec2.model.ModifyPrivateDnsNameOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyPrivateDnsNameOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyPrivateDnsNameOptions(request))
  def describeFleetInstances(
      request: zio.aws.ec2.model.DescribeFleetInstancesRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly,
    zio.aws.ec2.model.ActiveInstance.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeFleetInstances(request))
  def describeFleetInstancesPaginated(
      request: zio.aws.ec2.model.DescribeFleetInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFleetInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetInstancesPaginated(request))
  def describeSecurityGroupRules(
      request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.describeSecurityGroupRules(request))
  def describeSecurityGroupRulesPaginated(
      request: zio.aws.ec2.model.DescribeSecurityGroupRulesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSecurityGroupRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityGroupRulesPaginated(request))
  def rejectVpcPeeringConnection(
      request: zio.aws.ec2.model.RejectVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RejectVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectVpcPeeringConnection(request))
  def attachInternetGateway(
      request: zio.aws.ec2.model.AttachInternetGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.attachInternetGateway(request))
  def describeAvailabilityZones(
      request: zio.aws.ec2.model.DescribeAvailabilityZonesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeAvailabilityZonesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAvailabilityZones(request))
  def cancelBundleTask(request: zio.aws.ec2.model.CancelBundleTaskRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelBundleTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelBundleTask(request))
  def describeLocalGateways(
      request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGateway.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLocalGateways(request))
  def describeLocalGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocalGatewaysPaginated(request))
  def deleteVpc(
      request: zio.aws.ec2.model.DeleteVpcRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVpc(request))
  def deleteVpnConnectionRoute(
      request: zio.aws.ec2.model.DeleteVpnConnectionRouteRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVpnConnectionRoute(request))
  def deleteTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayMulticastDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayMulticastDomain(request))
  def disassociateClientVpnTargetNetwork(
      request: zio.aws.ec2.model.DisassociateClientVpnTargetNetworkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateClientVpnTargetNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateClientVpnTargetNetwork(request))
  def describeInstances(
      request: zio.aws.ec2.model.DescribeInstancesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.Reservation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstances(request))
  def describeInstancesPaginated(
      request: zio.aws.ec2.model.DescribeInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstancesPaginated(request))
  def describeVpnConnections(
      request: zio.aws.ec2.model.DescribeVpnConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpnConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpnConnections(request))
  def attachClassicLinkVpc(
      request: zio.aws.ec2.model.AttachClassicLinkVpcRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AttachClassicLinkVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachClassicLinkVpc(request))
  def createLaunchTemplateVersion(
      request: zio.aws.ec2.model.CreateLaunchTemplateVersionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateLaunchTemplateVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLaunchTemplateVersion(request))
  def deleteNetworkInsightsAccessScope(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkInsightsAccessScope(request))
  def modifyVpcEndpointConnectionNotification(
      request: zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointConnectionNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcEndpointConnectionNotification(request))
  def describeInstanceTypes(
      request: zio.aws.ec2.model.DescribeInstanceTypesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceTypeInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceTypes(request))
  def describeInstanceTypesPaginated(
      request: zio.aws.ec2.model.DescribeInstanceTypesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceTypesPaginated(request))
  def rebootInstances(
      request: zio.aws.ec2.model.RebootInstancesRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.rebootInstances(request))
  def describeInstanceCreditSpecifications(
      request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceCreditSpecification.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceCreditSpecifications(request))
  def describeInstanceCreditSpecificationsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceCreditSpecificationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceCreditSpecificationsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeInstanceCreditSpecificationsPaginated(request))
  def describeFleets(
      request: zio.aws.ec2.model.DescribeFleetsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.FleetData.ReadOnly] =
    ZStream.serviceWithStream(_.describeFleets(request))
  def describeFleetsPaginated(
      request: zio.aws.ec2.model.DescribeFleetsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFleetsPaginated(request))
  def getSpotPlacementScores(
      request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SpotPlacementScore.ReadOnly
  ] = ZStream.serviceWithStream(_.getSpotPlacementScores(request))
  def getSpotPlacementScoresPaginated(
      request: zio.aws.ec2.model.GetSpotPlacementScoresRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetSpotPlacementScoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSpotPlacementScoresPaginated(request))
  def createDefaultSubnet(
      request: zio.aws.ec2.model.CreateDefaultSubnetRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateDefaultSubnetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDefaultSubnet(request))
  def modifyVolume(request: zio.aws.ec2.model.ModifyVolumeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVolume(request))
  def getSerialConsoleAccessStatus(
      request: zio.aws.ec2.model.GetSerialConsoleAccessStatusRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetSerialConsoleAccessStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSerialConsoleAccessStatus(request))
  def getEbsEncryptionByDefault(
      request: zio.aws.ec2.model.GetEbsEncryptionByDefaultRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetEbsEncryptionByDefaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEbsEncryptionByDefault(request))
  def describeSnapshotTierStatus(
      request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SnapshotTierStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSnapshotTierStatus(request))
  def describeSnapshotTierStatusPaginated(
      request: zio.aws.ec2.model.DescribeSnapshotTierStatusRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSnapshotTierStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotTierStatusPaginated(request))
  def resetNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.ResetNetworkInterfaceAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resetNetworkInterfaceAttribute(request))
  def modifyTransitGateway(
      request: zio.aws.ec2.model.ModifyTransitGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTransitGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTransitGateway(request))
  def enableVolumeIO(
      request: zio.aws.ec2.model.EnableVolumeIoRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableVolumeIO(request))
  def deleteTransitGatewayRoute(
      request: zio.aws.ec2.model.DeleteTransitGatewayRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayRoute(request))
  def describeImportSnapshotTasks(
      request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportSnapshotTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeImportSnapshotTasks(request))
  def describeImportSnapshotTasksPaginated(
      request: zio.aws.ec2.model.DescribeImportSnapshotTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeImportSnapshotTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImportSnapshotTasksPaginated(request))
  def describeNetworkInsightsAnalyses(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsAnalysis.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNetworkInsightsAnalyses(request))
  def describeNetworkInsightsAnalysesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAnalysesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAnalysesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNetworkInsightsAnalysesPaginated(request))
  def disassociateSubnetCidrBlock(
      request: zio.aws.ec2.model.DisassociateSubnetCidrBlockRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateSubnetCidrBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateSubnetCidrBlock(request))
  def cancelExportTask(
      request: zio.aws.ec2.model.CancelExportTaskRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelExportTask(request))
  def deleteVpnGateway(
      request: zio.aws.ec2.model.DeleteVpnGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVpnGateway(request))
  def associateVpcCidrBlock(
      request: zio.aws.ec2.model.AssociateVpcCidrBlockRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateVpcCidrBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateVpcCidrBlock(request))
  def modifyInstanceEventStartTime(
      request: zio.aws.ec2.model.ModifyInstanceEventStartTimeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstanceEventStartTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceEventStartTime(request))
  def reportInstanceStatus(
      request: zio.aws.ec2.model.ReportInstanceStatusRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.reportInstanceStatus(request))
  def createVpcEndpointServiceConfiguration(
      request: zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpcEndpointServiceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcEndpointServiceConfiguration(request))
  def getEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.GetEbsDefaultKmsKeyIdRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetEbsDefaultKmsKeyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getEbsDefaultKmsKeyId(request))
  def deleteNetworkInterfacePermission(
      request: zio.aws.ec2.model.DeleteNetworkInterfacePermissionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInterfacePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkInterfacePermission(request))
  def describeTransitGatewayPeeringAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayPeeringAttachment.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeTransitGatewayPeeringAttachments(request)
  )
  def describeTransitGatewayPeeringAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayPeeringAttachmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeTransitGatewayPeeringAttachmentsPaginated(request)
  )
  def describeReservedInstances(
      request: zio.aws.ec2.model.DescribeReservedInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedInstances(request))
  def describeLocalGatewayVirtualInterfaces(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayVirtualInterface.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeLocalGatewayVirtualInterfaces(request))
  def describeLocalGatewayVirtualInterfacesPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeLocalGatewayVirtualInterfacesPaginated(request)
  )
  def modifySecurityGroupRules(
      request: zio.aws.ec2.model.ModifySecurityGroupRulesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifySecurityGroupRulesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySecurityGroupRules(request))
  def createEgressOnlyInternetGateway(
      request: zio.aws.ec2.model.CreateEgressOnlyInternetGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateEgressOnlyInternetGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEgressOnlyInternetGateway(request))
  def getPasswordData(request: zio.aws.ec2.model.GetPasswordDataRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetPasswordDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPasswordData(request))
  def exportClientVpnClientCertificateRevocationList(
      request: zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ExportClientVpnClientCertificateRevocationListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.exportClientVpnClientCertificateRevocationList(request)
  )
  def purchaseScheduledInstances(
      request: zio.aws.ec2.model.PurchaseScheduledInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PurchaseScheduledInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseScheduledInstances(request))
  def getTransitGatewayAttachmentPropagations(
      request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayAttachmentPropagation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getTransitGatewayAttachmentPropagations(request)
  )
  def getTransitGatewayAttachmentPropagationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayAttachmentPropagationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayAttachmentPropagationsPaginated(request)
  )
  def describeClassicLinkInstances(
      request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ClassicLinkInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClassicLinkInstances(request))
  def describeClassicLinkInstancesPaginated(
      request: zio.aws.ec2.model.DescribeClassicLinkInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClassicLinkInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClassicLinkInstancesPaginated(request))
  def describeCoipPools(
      request: zio.aws.ec2.model.DescribeCoipPoolsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.CoipPool.ReadOnly] =
    ZStream.serviceWithStream(_.describeCoipPools(request))
  def describeCoipPoolsPaginated(
      request: zio.aws.ec2.model.DescribeCoipPoolsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeCoipPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCoipPoolsPaginated(request))
  def createVpcEndpointConnectionNotification(
      request: zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpcEndpointConnectionNotificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcEndpointConnectionNotification(request))
  def modifyVpnConnectionOptions(
      request: zio.aws.ec2.model.ModifyVpnConnectionOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpnConnectionOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpnConnectionOptions(request))
  def getSubnetCidrReservations(
      request: zio.aws.ec2.model.GetSubnetCidrReservationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetSubnetCidrReservationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getSubnetCidrReservations(request))
  def deleteDhcpOptions(
      request: zio.aws.ec2.model.DeleteDhcpOptionsRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDhcpOptions(request))
  def requestSpotInstances(
      request: zio.aws.ec2.model.RequestSpotInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RequestSpotInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.requestSpotInstances(request))
  def deleteCustomerGateway(
      request: zio.aws.ec2.model.DeleteCustomerGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteCustomerGateway(request))
  def deleteTransitGateway(
      request: zio.aws.ec2.model.DeleteTransitGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGateway(request))
  def authorizeSecurityGroupIngress(
      request: zio.aws.ec2.model.AuthorizeSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AuthorizeSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeSecurityGroupIngress(request))
  def terminateClientVpnConnections(
      request: zio.aws.ec2.model.TerminateClientVpnConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TerminateClientVpnConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateClientVpnConnections(request))
  def importVolume(request: zio.aws.ec2.model.ImportVolumeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importVolume(request))
  def deregisterTransitGatewayMulticastGroupSources(
      request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deregisterTransitGatewayMulticastGroupSources(request))
  def disassociateTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateTransitGatewayMulticastDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTransitGatewayMulticastDomain(request))
  def describeVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ClassicLinkDnsSupport.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVpcClassicLinkDnsSupport(request))
  def describeVpcClassicLinkDnsSupportPaginated(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcClassicLinkDnsSupportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcClassicLinkDnsSupportPaginated(request))
  def describeInstanceEventWindows(
      request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceEventWindow.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceEventWindows(request))
  def describeInstanceEventWindowsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceEventWindowsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceEventWindowsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceEventWindowsPaginated(request))
  def applySecurityGroupsToClientVpnTargetNetwork(
      request: zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ApplySecurityGroupsToClientVpnTargetNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applySecurityGroupsToClientVpnTargetNetwork(request))
  def createSnapshots(request: zio.aws.ec2.model.CreateSnapshotsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshots(request))
  def rejectVpcEndpointConnections(
      request: zio.aws.ec2.model.RejectVpcEndpointConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RejectVpcEndpointConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectVpcEndpointConnections(request))
  def copySnapshot(request: zio.aws.ec2.model.CopySnapshotRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CopySnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copySnapshot(request))
  def describeInstanceTypeOfferings(
      request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceTypeOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceTypeOfferings(request))
  def describeInstanceTypeOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeInstanceTypeOfferingsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceTypeOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceTypeOfferingsPaginated(request))
  def deleteManagedPrefixList(
      request: zio.aws.ec2.model.DeleteManagedPrefixListRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteManagedPrefixListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteManagedPrefixList(request))
  def deleteTransitGatewayRouteTable(
      request: zio.aws.ec2.model.DeleteTransitGatewayRouteTableRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayRouteTable(request))
  def describeHosts(
      request: zio.aws.ec2.model.DescribeHostsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Host.ReadOnly] =
    ZStream.serviceWithStream(_.describeHosts(request))
  def describeHostsPaginated(
      request: zio.aws.ec2.model.DescribeHostsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeHostsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHostsPaginated(request))
  def modifyIdFormat(
      request: zio.aws.ec2.model.ModifyIdFormatRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyIdFormat(request))
  def getGroupsForCapacityReservation(
      request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CapacityReservationGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.getGroupsForCapacityReservation(request))
  def getGroupsForCapacityReservationPaginated(
      request: zio.aws.ec2.model.GetGroupsForCapacityReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetGroupsForCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupsForCapacityReservationPaginated(request))
  def disableEbsEncryptionByDefault(
      request: zio.aws.ec2.model.DisableEbsEncryptionByDefaultRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableEbsEncryptionByDefaultResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableEbsEncryptionByDefault(request))
  def createTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayPeeringAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayPeeringAttachment(request))
  def describeVpnGateways(
      request: zio.aws.ec2.model.DescribeVpnGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpnGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpnGateways(request))
  def deprovisionByoipCidr(
      request: zio.aws.ec2.model.DeprovisionByoipCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeprovisionByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprovisionByoipCidr(request))
  def describeSubnets(
      request: zio.aws.ec2.model.DescribeSubnetsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Subnet.ReadOnly] =
    ZStream.serviceWithStream(_.describeSubnets(request))
  def describeSubnetsPaginated(
      request: zio.aws.ec2.model.DescribeSubnetsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSubnetsPaginated(request))
  def describeSpotFleetRequestHistory(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly,
    zio.aws.ec2.model.HistoryRecord.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeSpotFleetRequestHistory(request))
  def describeSpotFleetRequestHistoryPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestHistoryRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotFleetRequestHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotFleetRequestHistoryPaginated(request))
  def unmonitorInstances(
      request: zio.aws.ec2.model.UnmonitorInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.UnmonitorInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unmonitorInstances(request))
  def createManagedPrefixList(
      request: zio.aws.ec2.model.CreateManagedPrefixListRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateManagedPrefixListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createManagedPrefixList(request))
  def describeTransitGatewayConnectPeers(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayConnectPeer.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGatewayConnectPeers(request))
  def describeTransitGatewayConnectPeersPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectPeersRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayConnectPeersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransitGatewayConnectPeersPaginated(request))
  def describeTransitGatewayConnects(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayConnect.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGatewayConnects(request))
  def describeTransitGatewayConnectsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayConnectsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayConnectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransitGatewayConnectsPaginated(request))
  def createIpamScope(request: zio.aws.ec2.model.CreateIpamScopeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateIpamScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIpamScope(request))
  def describeTrafficMirrorTargets(
      request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TrafficMirrorTarget.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTrafficMirrorTargets(request))
  def describeTrafficMirrorTargetsPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorTargetsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorTargetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrafficMirrorTargetsPaginated(request))
  def deleteVpcEndpoints(
      request: zio.aws.ec2.model.DeleteVpcEndpointsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteVpcEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcEndpoints(request))
  def disassociateIamInstanceProfile(
      request: zio.aws.ec2.model.DisassociateIamInstanceProfileRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateIamInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateIamInstanceProfile(request))
  def modifyFleet(request: zio.aws.ec2.model.ModifyFleetRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyFleet(request))
  def describeVpcEndpointServiceConfigurations(
      request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ServiceConfiguration.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeVpcEndpointServiceConfigurations(request)
  )
  def describeVpcEndpointServiceConfigurationsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServiceConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeVpcEndpointServiceConfigurationsPaginated(request)
  )
  def deleteNetworkAclEntry(
      request: zio.aws.ec2.model.DeleteNetworkAclEntryRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNetworkAclEntry(request))
  def updateSecurityGroupRuleDescriptionsIngress(
      request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityGroupRuleDescriptionsIngress(request))
  def describeCapacityReservations(
      request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CapacityReservation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCapacityReservations(request))
  def describeCapacityReservationsPaginated(
      request: zio.aws.ec2.model.DescribeCapacityReservationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeCapacityReservationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCapacityReservationsPaginated(request))
  def createTransitGatewayMulticastDomain(
      request: zio.aws.ec2.model.CreateTransitGatewayMulticastDomainRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayMulticastDomainResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayMulticastDomain(request))
  def startVpcEndpointServicePrivateDnsVerification(
      request: zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StartVpcEndpointServicePrivateDnsVerificationResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.startVpcEndpointServicePrivateDnsVerification(request))
  def createLaunchTemplate(
      request: zio.aws.ec2.model.CreateLaunchTemplateRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateLaunchTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLaunchTemplate(request))
  def deleteTrafficMirrorFilter(
      request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTrafficMirrorFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficMirrorFilter(request))
  def describeLocalGatewayRouteTables(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRouteTable.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLocalGatewayRouteTables(request))
  def describeLocalGatewayRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTablesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLocalGatewayRouteTablesPaginated(request))
  def describeNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.DescribeNetworkInterfaceAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInterfaceAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNetworkInterfaceAttribute(request))
  def createCapacityReservationFleet(
      request: zio.aws.ec2.model.CreateCapacityReservationFleetRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateCapacityReservationFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCapacityReservationFleet(request))
  def deleteLaunchTemplate(
      request: zio.aws.ec2.model.DeleteLaunchTemplateRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteLaunchTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunchTemplate(request))
  def replaceNetworkAclAssociation(
      request: zio.aws.ec2.model.ReplaceNetworkAclAssociationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReplaceNetworkAclAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replaceNetworkAclAssociation(request))
  def getManagedPrefixListAssociations(
      request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PrefixListAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.getManagedPrefixListAssociations(request))
  def getManagedPrefixListAssociationsPaginated(
      request: zio.aws.ec2.model.GetManagedPrefixListAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetManagedPrefixListAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getManagedPrefixListAssociationsPaginated(request))
  def createNetworkAcl(request: zio.aws.ec2.model.CreateNetworkAclRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNetworkAclResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkAcl(request))
  def describeVpcEndpointConnections(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VpcEndpointConnection.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVpcEndpointConnections(request))
  def describeVpcEndpointConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcEndpointConnectionsPaginated(request))
  def createLocalGatewayRouteTableVpcAssociation(
      request: zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocalGatewayRouteTableVpcAssociation(request))
  def describeVpcAttribute(
      request: zio.aws.ec2.model.DescribeVpcAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcAttribute(request))
  def describeStoreImageTasks(
      request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StoreImageTaskResult.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStoreImageTasks(request))
  def describeStoreImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeStoreImageTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeStoreImageTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStoreImageTasksPaginated(request))
  def describeFastSnapshotRestores(
      request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFastSnapshotRestoreSuccessItem.ReadOnly
  ] = ZStream.serviceWithStream(_.describeFastSnapshotRestores(request))
  def describeFastSnapshotRestoresPaginated(
      request: zio.aws.ec2.model.DescribeFastSnapshotRestoresRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFastSnapshotRestoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFastSnapshotRestoresPaginated(request))
  def modifyInstancePlacement(
      request: zio.aws.ec2.model.ModifyInstancePlacementRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstancePlacementResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstancePlacement(request))
  def createIpamPool(request: zio.aws.ec2.model.CreateIpamPoolRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateIpamPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIpamPool(request))
  def modifySnapshotTier(
      request: zio.aws.ec2.model.ModifySnapshotTierRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifySnapshotTierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySnapshotTier(request))
  def describeSpotFleetRequests(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SpotFleetRequestConfig.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSpotFleetRequests(request))
  def describeSpotFleetRequestsPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetRequestsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotFleetRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotFleetRequestsPaginated(request))
  def getTransitGatewayRouteTableAssociations(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayRouteTableAssociation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getTransitGatewayRouteTableAssociations(request)
  )
  def getTransitGatewayRouteTableAssociationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayRouteTableAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayRouteTableAssociationsPaginated(request)
  )
  def releaseIpamPoolAllocation(
      request: zio.aws.ec2.model.ReleaseIpamPoolAllocationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReleaseIpamPoolAllocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.releaseIpamPoolAllocation(request))
  def registerImage(request: zio.aws.ec2.model.RegisterImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RegisterImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerImage(request))
  def createDhcpOptions(
      request: zio.aws.ec2.model.CreateDhcpOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateDhcpOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDhcpOptions(request))
  def describeReservedInstancesModifications(
      request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReservedInstancesModification.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeReservedInstancesModifications(request))
  def describeReservedInstancesModificationsPaginated(
      request: zio.aws.ec2.model.DescribeReservedInstancesModificationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesModificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeReservedInstancesModificationsPaginated(request)
  )
  def describeSpotDatafeedSubscription(
      request: zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotDatafeedSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotDatafeedSubscription(request))
  def describeNetworkInsightsAccessScopeAnalyses(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsAccessScopeAnalysis.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeNetworkInsightsAccessScopeAnalyses(request)
  )
  def describeNetworkInsightsAccessScopeAnalysesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopeAnalysesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeNetworkInsightsAccessScopeAnalysesPaginated(request)
  )
  def createTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.CreateTrafficMirrorFilterRuleRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTrafficMirrorFilterRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficMirrorFilterRule(request))
  def searchLocalGatewayRoutes(
      request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRoute.ReadOnly
  ] = ZStream.serviceWithStream(_.searchLocalGatewayRoutes(request))
  def searchLocalGatewayRoutesPaginated(
      request: zio.aws.ec2.model.SearchLocalGatewayRoutesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SearchLocalGatewayRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchLocalGatewayRoutesPaginated(request))
  def describeHostReservationOfferings(
      request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.HostOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeHostReservationOfferings(request))
  def describeHostReservationOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeHostReservationOfferingsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeHostReservationOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHostReservationOfferingsPaginated(request))
  def modifyIpam(request: zio.aws.ec2.model.ModifyIpamRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyIpamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyIpam(request))
  def disableVpcClassicLink(
      request: zio.aws.ec2.model.DisableVpcClassicLinkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableVpcClassicLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableVpcClassicLink(request))
  def getNetworkInsightsAccessScopeContent(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeContentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getNetworkInsightsAccessScopeContent(request))
  def createCapacityReservation(
      request: zio.aws.ec2.model.CreateCapacityReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCapacityReservation(request))
  def modifyAddressAttribute(
      request: zio.aws.ec2.model.ModifyAddressAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyAddressAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyAddressAttribute(request))
  def createNetworkInterfacePermission(
      request: zio.aws.ec2.model.CreateNetworkInterfacePermissionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNetworkInterfacePermissionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkInterfacePermission(request))
  def describeLaunchTemplateVersions(
      request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LaunchTemplateVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLaunchTemplateVersions(request))
  def describeLaunchTemplateVersionsPaginated(
      request: zio.aws.ec2.model.DescribeLaunchTemplateVersionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLaunchTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLaunchTemplateVersionsPaginated(request))
  def allocateHosts(request: zio.aws.ec2.model.AllocateHostsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AllocateHostsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateHosts(request))
  def describeExportImageTasks(
      request: zio.aws.ec2.model.DescribeExportImageTasksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ExportImageTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeExportImageTasks(request))
  def describeExportImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeExportImageTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeExportImageTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExportImageTasksPaginated(request))
  def describeSpotFleetInstances(
      request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly,
    zio.aws.ec2.model.ActiveInstance.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeSpotFleetInstances(request))
  def describeSpotFleetInstancesPaginated(
      request: zio.aws.ec2.model.DescribeSpotFleetInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotFleetInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotFleetInstancesPaginated(request))
  def rejectTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rejectTransitGatewayVpcAttachment(request))
  def describeByoipCidrs(
      request: zio.aws.ec2.model.DescribeByoipCidrsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.ByoipCidr.ReadOnly] =
    ZStream.serviceWithStream(_.describeByoipCidrs(request))
  def describeByoipCidrsPaginated(
      request: zio.aws.ec2.model.DescribeByoipCidrsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeByoipCidrsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeByoipCidrsPaginated(request))
  def moveAddressToVpc(request: zio.aws.ec2.model.MoveAddressToVpcRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.MoveAddressToVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.moveAddressToVpc(request))
  def disassociateAddress(
      request: zio.aws.ec2.model.DisassociateAddressRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateAddress(request))
  def resetFpgaImageAttribute(
      request: zio.aws.ec2.model.ResetFpgaImageAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ResetFpgaImageAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetFpgaImageAttribute(request))
  def modifyImageAttribute(
      request: zio.aws.ec2.model.ModifyImageAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyImageAttribute(request))
  def restoreSnapshotFromRecycleBin(
      request: zio.aws.ec2.model.RestoreSnapshotFromRecycleBinRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RestoreSnapshotFromRecycleBinResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreSnapshotFromRecycleBin(request))
  def exportClientVpnClientConfiguration(
      request: zio.aws.ec2.model.ExportClientVpnClientConfigurationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ExportClientVpnClientConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportClientVpnClientConfiguration(request))
  def restoreSnapshotTier(
      request: zio.aws.ec2.model.RestoreSnapshotTierRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RestoreSnapshotTierResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreSnapshotTier(request))
  def registerTransitGatewayMulticastGroupSources(
      request: zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RegisterTransitGatewayMulticastGroupSourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerTransitGatewayMulticastGroupSources(request))
  def deleteNetworkInterface(
      request: zio.aws.ec2.model.DeleteNetworkInterfaceRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNetworkInterface(request))
  def provisionPublicIpv4PoolCidr(
      request: zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ProvisionPublicIpv4PoolCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionPublicIpv4PoolCidr(request))
  def describeVolumes(
      request: zio.aws.ec2.model.DescribeVolumesRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Volume.ReadOnly] =
    ZStream.serviceWithStream(_.describeVolumes(request))
  def describeVolumesPaginated(
      request: zio.aws.ec2.model.DescribeVolumesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVolumesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVolumesPaginated(request))
  def modifyTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTransitGatewayPrefixListReferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTransitGatewayPrefixListReference(request))
  def createFlowLogs(request: zio.aws.ec2.model.CreateFlowLogsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateFlowLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFlowLogs(request))
  def modifyIpamScope(request: zio.aws.ec2.model.ModifyIpamScopeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyIpamScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyIpamScope(request))
  def purchaseHostReservation(
      request: zio.aws.ec2.model.PurchaseHostReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PurchaseHostReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseHostReservation(request))
  def describeStaleSecurityGroups(
      request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StaleSecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeStaleSecurityGroups(request))
  def describeStaleSecurityGroupsPaginated(
      request: zio.aws.ec2.model.DescribeStaleSecurityGroupsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeStaleSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStaleSecurityGroupsPaginated(request))
  def createVolume(request: zio.aws.ec2.model.CreateVolumeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVolume(request))
  def runInstances(request: zio.aws.ec2.model.RunInstancesRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RunInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runInstances(request))
  def describeReplaceRootVolumeTasks(
      request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReplaceRootVolumeTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReplaceRootVolumeTasks(request))
  def describeReplaceRootVolumeTasksPaginated(
      request: zio.aws.ec2.model.DescribeReplaceRootVolumeTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeReplaceRootVolumeTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReplaceRootVolumeTasksPaginated(request))
  def associateDhcpOptions(
      request: zio.aws.ec2.model.AssociateDhcpOptionsRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.associateDhcpOptions(request))
  def createRouteTable(request: zio.aws.ec2.model.CreateRouteTableRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRouteTable(request))
  def deleteVpcPeeringConnection(
      request: zio.aws.ec2.model.DeleteVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcPeeringConnection(request))
  def describePublicIpv4Pools(
      request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PublicIpv4Pool.ReadOnly
  ] = ZStream.serviceWithStream(_.describePublicIpv4Pools(request))
  def describePublicIpv4PoolsPaginated(
      request: zio.aws.ec2.model.DescribePublicIpv4PoolsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribePublicIpv4PoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePublicIpv4PoolsPaginated(request))
  def modifyAvailabilityZoneGroup(
      request: zio.aws.ec2.model.ModifyAvailabilityZoneGroupRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyAvailabilityZoneGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyAvailabilityZoneGroup(request))
  def createClientVpnEndpoint(
      request: zio.aws.ec2.model.CreateClientVpnEndpointRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateClientVpnEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClientVpnEndpoint(request))
  def deleteSnapshot(
      request: zio.aws.ec2.model.DeleteSnapshotRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSnapshot(request))
  def createTrafficMirrorFilter(
      request: zio.aws.ec2.model.CreateTrafficMirrorFilterRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTrafficMirrorFilterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficMirrorFilter(request))
  def createReservedInstancesListing(
      request: zio.aws.ec2.model.CreateReservedInstancesListingRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateReservedInstancesListingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReservedInstancesListing(request))
  def assignIpv6Addresses(
      request: zio.aws.ec2.model.AssignIpv6AddressesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssignIpv6AddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.assignIpv6Addresses(request))
  def getVpnConnectionDeviceTypes(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VpnConnectionDeviceType.ReadOnly
  ] = ZStream.serviceWithStream(_.getVpnConnectionDeviceTypes(request))
  def getVpnConnectionDeviceTypesPaginated(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceTypesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetVpnConnectionDeviceTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpnConnectionDeviceTypesPaginated(request))
  def describeSecurityGroupReferences(
      request: zio.aws.ec2.model.DescribeSecurityGroupReferencesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSecurityGroupReferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityGroupReferences(request))
  def describeImages(request: zio.aws.ec2.model.DescribeImagesRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeImagesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImages(request))
  def requestSpotFleet(request: zio.aws.ec2.model.RequestSpotFleetRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RequestSpotFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.requestSpotFleet(request))
  def acceptTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.acceptTransitGatewayMulticastDomainAssociations(request)
  )
  def deletePublicIpv4Pool(
      request: zio.aws.ec2.model.DeletePublicIpv4PoolRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeletePublicIpv4PoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePublicIpv4Pool(request))
  def updateSecurityGroupRuleDescriptionsEgress(
      request: zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.UpdateSecurityGroupRuleDescriptionsEgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateSecurityGroupRuleDescriptionsEgress(request))
  def replaceRoute(
      request: zio.aws.ec2.model.ReplaceRouteRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.replaceRoute(request))
  def createNetworkInsightsPath(
      request: zio.aws.ec2.model.CreateNetworkInsightsPathRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNetworkInsightsPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkInsightsPath(request))
  def deleteQueuedReservedInstances(
      request: zio.aws.ec2.model.DeleteQueuedReservedInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteQueuedReservedInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteQueuedReservedInstances(request))
  def disassociateInstanceEventWindow(
      request: zio.aws.ec2.model.DisassociateInstanceEventWindowRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateInstanceEventWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateInstanceEventWindow(request))
  def getConsoleOutput(request: zio.aws.ec2.model.GetConsoleOutputRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetConsoleOutputResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConsoleOutput(request))
  def createStoreImageTask(
      request: zio.aws.ec2.model.CreateStoreImageTaskRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateStoreImageTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStoreImageTask(request))
  def getReservedInstancesExchangeQuote(
      request: zio.aws.ec2.model.GetReservedInstancesExchangeQuoteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetReservedInstancesExchangeQuoteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getReservedInstancesExchangeQuote(request))
  def attachVpnGateway(request: zio.aws.ec2.model.AttachVpnGatewayRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AttachVpnGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachVpnGateway(request))
  def modifyVpnConnection(
      request: zio.aws.ec2.model.ModifyVpnConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpnConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpnConnection(request))
  def getDefaultCreditSpecification(
      request: zio.aws.ec2.model.GetDefaultCreditSpecificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetDefaultCreditSpecificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDefaultCreditSpecification(request))
  def createImage(request: zio.aws.ec2.model.CreateImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createImage(request))
  def disableTransitGatewayRouteTablePropagation(
      request: zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableTransitGatewayRouteTablePropagationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableTransitGatewayRouteTablePropagation(request))
  def createFleet(request: zio.aws.ec2.model.CreateFleetRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFleet(request))
  def createSubnet(request: zio.aws.ec2.model.CreateSubnetRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSubnetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubnet(request))
  def listSnapshotsInRecycleBin(
      request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SnapshotRecycleBinInfo.ReadOnly
  ] = ZStream.serviceWithStream(_.listSnapshotsInRecycleBin(request))
  def listSnapshotsInRecycleBinPaginated(
      request: zio.aws.ec2.model.ListSnapshotsInRecycleBinRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ListSnapshotsInRecycleBinResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listSnapshotsInRecycleBinPaginated(request))
  def describeAggregateIdFormat(
      request: zio.aws.ec2.model.DescribeAggregateIdFormatRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeAggregateIdFormatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAggregateIdFormat(request))
  def createNetworkInsightsAccessScope(
      request: zio.aws.ec2.model.CreateNetworkInsightsAccessScopeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNetworkInsightsAccessScopeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNetworkInsightsAccessScope(request))
  def modifySpotFleetRequest(
      request: zio.aws.ec2.model.ModifySpotFleetRequestRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifySpotFleetRequestResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifySpotFleetRequest(request))
  def modifyCapacityReservationFleet(
      request: zio.aws.ec2.model.ModifyCapacityReservationFleetRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyCapacityReservationFleetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyCapacityReservationFleet(request))
  def describeIpv6Pools(
      request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Ipv6Pool.ReadOnly] =
    ZStream.serviceWithStream(_.describeIpv6Pools(request))
  def describeIpv6PoolsPaginated(
      request: zio.aws.ec2.model.DescribeIpv6PoolsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIpv6PoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIpv6PoolsPaginated(request))
  def stopInstances(request: zio.aws.ec2.model.StopInstancesRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StopInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopInstances(request))
  def describeExportTasks(
      request: zio.aws.ec2.model.DescribeExportTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeExportTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeExportTasks(request))
  def restoreManagedPrefixListVersion(
      request: zio.aws.ec2.model.RestoreManagedPrefixListVersionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RestoreManagedPrefixListVersionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreManagedPrefixListVersion(request))
  def describeBundleTasks(
      request: zio.aws.ec2.model.DescribeBundleTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeBundleTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeBundleTasks(request))
  def describeClientVpnRoutes(
      request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ClientVpnRoute.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClientVpnRoutes(request))
  def describeClientVpnRoutesPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnRoutesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientVpnRoutesPaginated(request))
  def describeIamInstanceProfileAssociations(
      request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.IamInstanceProfileAssociation.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeIamInstanceProfileAssociations(request))
  def describeIamInstanceProfileAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIamInstanceProfileAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeIamInstanceProfileAssociationsPaginated(request)
  )
  def deleteIpam(request: zio.aws.ec2.model.DeleteIpamRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteIpamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIpam(request))
  def attachVolume(request: zio.aws.ec2.model.AttachVolumeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AttachVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachVolume(request))
  def createClientVpnRoute(
      request: zio.aws.ec2.model.CreateClientVpnRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateClientVpnRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createClientVpnRoute(request))
  def acceptTransitGatewayPeeringAttachment(
      request: zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayPeeringAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptTransitGatewayPeeringAttachment(request))
  def describeNetworkInterfaces(
      request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInterface.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNetworkInterfaces(request))
  def describeNetworkInterfacesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInterfacesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInterfacesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNetworkInterfacesPaginated(request))
  def describeLocalGatewayVirtualInterfaceGroups(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayVirtualInterfaceGroup.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeLocalGatewayVirtualInterfaceGroups(request)
  )
  def describeLocalGatewayVirtualInterfaceGroupsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayVirtualInterfaceGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeLocalGatewayVirtualInterfaceGroupsPaginated(request)
  )
  def modifyTrafficMirrorSession(
      request: zio.aws.ec2.model.ModifyTrafficMirrorSessionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTrafficMirrorSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTrafficMirrorSession(request))
  def disassociateVpcCidrBlock(
      request: zio.aws.ec2.model.DisassociateVpcCidrBlockRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateVpcCidrBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateVpcCidrBlock(request))
  def disableVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableVpcClassicLinkDnsSupportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableVpcClassicLinkDnsSupport(request))
  def deleteClientVpnRoute(
      request: zio.aws.ec2.model.DeleteClientVpnRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteClientVpnRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteClientVpnRoute(request))
  def createTransitGatewayConnect(
      request: zio.aws.ec2.model.CreateTransitGatewayConnectRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayConnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayConnect(request))
  def createReplaceRootVolumeTask(
      request: zio.aws.ec2.model.CreateReplaceRootVolumeTaskRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateReplaceRootVolumeTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createReplaceRootVolumeTask(request))
  def cancelImportTask(request: zio.aws.ec2.model.CancelImportTaskRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelImportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelImportTask(request))
  def describeVpcClassicLink(
      request: zio.aws.ec2.model.DescribeVpcClassicLinkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcClassicLinkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcClassicLink(request))
  def modifyHosts(request: zio.aws.ec2.model.ModifyHostsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyHostsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyHosts(request))
  def createRestoreImageTask(
      request: zio.aws.ec2.model.CreateRestoreImageTaskRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateRestoreImageTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRestoreImageTask(request))
  def describeTransitGatewayAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayAttachment.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGatewayAttachments(request))
  def describeTransitGatewayAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayAttachmentsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayAttachmentsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransitGatewayAttachmentsPaginated(request))
  def deleteVpcEndpointServiceConfigurations(
      request: zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteVpcEndpointServiceConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVpcEndpointServiceConfigurations(request))
  def startNetworkInsightsAccessScopeAnalysis(
      request: zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StartNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startNetworkInsightsAccessScopeAnalysis(request))
  def describeTransitGatewayMulticastDomains(
      request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayMulticastDomain.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeTransitGatewayMulticastDomains(request))
  def describeTransitGatewayMulticastDomainsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayMulticastDomainsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeTransitGatewayMulticastDomainsPaginated(request)
  )
  def importKeyPair(request: zio.aws.ec2.model.ImportKeyPairRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importKeyPair(request))
  def revokeSecurityGroupEgress(
      request: zio.aws.ec2.model.RevokeSecurityGroupEgressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RevokeSecurityGroupEgressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeSecurityGroupEgress(request))
  def enableVgwRoutePropagation(
      request: zio.aws.ec2.model.EnableVgwRoutePropagationRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.enableVgwRoutePropagation(request))
  def createTransitGatewayRoute(
      request: zio.aws.ec2.model.CreateTransitGatewayRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayRoute(request))
  def acceptReservedInstancesExchangeQuote(
      request: zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptReservedInstancesExchangeQuoteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptReservedInstancesExchangeQuote(request))
  def modifyInstanceAttribute(
      request: zio.aws.ec2.model.ModifyInstanceAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyInstanceAttribute(request))
  def deleteTransitGatewayConnectPeer(
      request: zio.aws.ec2.model.DeleteTransitGatewayConnectPeerRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayConnectPeer(request))
  def createIpam(request: zio.aws.ec2.model.CreateIpamRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateIpamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createIpam(request))
  def getConsoleScreenshot(
      request: zio.aws.ec2.model.GetConsoleScreenshotRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetConsoleScreenshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getConsoleScreenshot(request))
  def deregisterTransitGatewayMulticastGroupMembers(
      request: zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeregisterTransitGatewayMulticastGroupMembersResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deregisterTransitGatewayMulticastGroupMembers(request))
  def describeNetworkInterfacePermissions(
      request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInterfacePermission.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNetworkInterfacePermissions(request))
  def describeNetworkInterfacePermissionsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInterfacePermissionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInterfacePermissionsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeNetworkInterfacePermissionsPaginated(request))
  def createTransitGatewayPrefixListReference(
      request: zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayPrefixListReferenceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayPrefixListReference(request))
  def cancelCapacityReservation(
      request: zio.aws.ec2.model.CancelCapacityReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelCapacityReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelCapacityReservation(request))
  def getIpamAddressHistory(
      request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.IpamAddressHistoryRecord.ReadOnly
  ] = ZStream.serviceWithStream(_.getIpamAddressHistory(request))
  def getIpamAddressHistoryPaginated(
      request: zio.aws.ec2.model.GetIpamAddressHistoryRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetIpamAddressHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIpamAddressHistoryPaginated(request))
  def describePlacementGroups(
      request: zio.aws.ec2.model.DescribePlacementGroupsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribePlacementGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePlacementGroups(request))
  def detachVpnGateway(
      request: zio.aws.ec2.model.DetachVpnGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachVpnGateway(request))
  def describeInternetGateways(
      request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InternetGateway.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInternetGateways(request))
  def describeInternetGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeInternetGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInternetGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInternetGatewaysPaginated(request))
  def disassociateEnclaveCertificateIamRole(
      request: zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateEnclaveCertificateIamRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateEnclaveCertificateIamRole(request))
  def modifyTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyTrafficMirrorFilterRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyTrafficMirrorFilterRule(request))
  def modifyVpcEndpointServicePermissions(
      request: zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointServicePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcEndpointServicePermissions(request))
  def createKeyPair(request: zio.aws.ec2.model.CreateKeyPairRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createKeyPair(request))
  def releaseAddress(
      request: zio.aws.ec2.model.ReleaseAddressRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.releaseAddress(request))
  def describeVpcEndpointConnectionNotifications(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ConnectionNotification.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeVpcEndpointConnectionNotifications(request)
  )
  def describeVpcEndpointConnectionNotificationsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointConnectionNotificationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeVpcEndpointConnectionNotificationsPaginated(request)
  )
  def associateAddress(request: zio.aws.ec2.model.AssociateAddressRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateAddress(request))
  def describeTransitGateways(
      request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGateway.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGateways(request))
  def describeTransitGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransitGatewaysPaginated(request))
  def createCarrierGateway(
      request: zio.aws.ec2.model.CreateCarrierGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateCarrierGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCarrierGateway(request))
  def modifyVpcEndpointServiceConfiguration(
      request: zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcEndpointServiceConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcEndpointServiceConfiguration(request))
  def describeVolumeStatus(
      request: zio.aws.ec2.model.DescribeVolumeStatusRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VolumeStatusItem.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVolumeStatus(request))
  def describeVolumeStatusPaginated(
      request: zio.aws.ec2.model.DescribeVolumeStatusRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVolumeStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVolumeStatusPaginated(request))
  def describeTransitGatewayVpcAttachments(
      request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayVpcAttachment.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGatewayVpcAttachments(request))
  def describeTransitGatewayVpcAttachmentsPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayVpcAttachmentsResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeTransitGatewayVpcAttachmentsPaginated(request))
  def createVpcPeeringConnection(
      request: zio.aws.ec2.model.CreateVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcPeeringConnection(request))
  def createVpcEndpoint(
      request: zio.aws.ec2.model.CreateVpcEndpointRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpcEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpcEndpoint(request))
  def replaceIamInstanceProfileAssociation(
      request: zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReplaceIamInstanceProfileAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replaceIamInstanceProfileAssociation(request))
  def disableVgwRoutePropagation(
      request: zio.aws.ec2.model.DisableVgwRoutePropagationRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disableVgwRoutePropagation(request))
  def describeNetworkInsightsAccessScopes(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsAccessScope.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNetworkInsightsAccessScopes(request))
  def describeNetworkInsightsAccessScopesPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsAccessScopesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeNetworkInsightsAccessScopesPaginated(request))
  def getNetworkInsightsAccessScopeAnalysisFindings(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly,
    zio.aws.ec2.model.AccessScopeAnalysisFinding.ReadOnly
  ]] =
    ZIO.serviceWithZIO(_.getNetworkInsightsAccessScopeAnalysisFindings(request))
  def getNetworkInsightsAccessScopeAnalysisFindingsPaginated(
      request: zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetNetworkInsightsAccessScopeAnalysisFindingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getNetworkInsightsAccessScopeAnalysisFindingsPaginated(request)
  )
  def cancelCapacityReservationFleets(
      request: zio.aws.ec2.model.CancelCapacityReservationFleetsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelCapacityReservationFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelCapacityReservationFleets(request))
  def deleteLocalGatewayRouteTableVpcAssociation(
      request: zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteLocalGatewayRouteTableVpcAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLocalGatewayRouteTableVpcAssociation(request))
  def associateIamInstanceProfile(
      request: zio.aws.ec2.model.AssociateIamInstanceProfileRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateIamInstanceProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateIamInstanceProfile(request))
  def describeTrunkInterfaceAssociations(
      request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TrunkInterfaceAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTrunkInterfaceAssociations(request))
  def describeTrunkInterfaceAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTrunkInterfaceAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrunkInterfaceAssociationsPaginated(request))
  def startNetworkInsightsAnalysis(
      request: zio.aws.ec2.model.StartNetworkInsightsAnalysisRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.StartNetworkInsightsAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startNetworkInsightsAnalysis(request))
  def purchaseReservedInstancesOffering(
      request: zio.aws.ec2.model.PurchaseReservedInstancesOfferingRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PurchaseReservedInstancesOfferingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.purchaseReservedInstancesOffering(request))
  def exportImage(request: zio.aws.ec2.model.ExportImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ExportImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportImage(request))
  def describeClientVpnConnections(
      request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ClientVpnConnection.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClientVpnConnections(request))
  def describeClientVpnConnectionsPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnConnectionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnConnectionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientVpnConnectionsPaginated(request))
  def describeInstanceStatus(
      request: zio.aws.ec2.model.DescribeInstanceStatusRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceStatus.ReadOnly
  ] = ZStream.serviceWithStream(_.describeInstanceStatus(request))
  def describeInstanceStatusPaginated(
      request: zio.aws.ec2.model.DescribeInstanceStatusRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceStatusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceStatusPaginated(request))
  def describeAddressesAttribute(
      request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AddressAttribute.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAddressesAttribute(request))
  def describeAddressesAttributePaginated(
      request: zio.aws.ec2.model.DescribeAddressesAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeAddressesAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAddressesAttributePaginated(request))
  def associateRouteTable(
      request: zio.aws.ec2.model.AssociateRouteTableRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateRouteTable(request))
  def provisionIpamPoolCidr(
      request: zio.aws.ec2.model.ProvisionIpamPoolCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ProvisionIpamPoolCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionIpamPoolCidr(request))
  def withdrawByoipCidr(
      request: zio.aws.ec2.model.WithdrawByoipCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.WithdrawByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.withdrawByoipCidr(request))
  def describeIpamPools(
      request: zio.aws.ec2.model.DescribeIpamPoolsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.IpamPool.ReadOnly] =
    ZStream.serviceWithStream(_.describeIpamPools(request))
  def describeIpamPoolsPaginated(
      request: zio.aws.ec2.model.DescribeIpamPoolsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIpamPoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIpamPoolsPaginated(request))
  def getAssociatedIpv6PoolCidrs(
      request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.Ipv6CidrAssociation.ReadOnly
  ] = ZStream.serviceWithStream(_.getAssociatedIpv6PoolCidrs(request))
  def getAssociatedIpv6PoolCidrsPaginated(
      request: zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetAssociatedIpv6PoolCidrsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssociatedIpv6PoolCidrsPaginated(request))
  def describeSnapshots(
      request: zio.aws.ec2.model.DescribeSnapshotsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Snapshot.ReadOnly] =
    ZStream.serviceWithStream(_.describeSnapshots(request))
  def describeSnapshotsPaginated(
      request: zio.aws.ec2.model.DescribeSnapshotsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotsPaginated(request))
  def enableVpcClassicLinkDnsSupport(
      request: zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableVpcClassicLinkDnsSupportResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableVpcClassicLinkDnsSupport(request))
  def createTrafficMirrorSession(
      request: zio.aws.ec2.model.CreateTrafficMirrorSessionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTrafficMirrorSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficMirrorSession(request))
  def getIpamPoolAllocations(
      request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.IpamPoolAllocation.ReadOnly
  ] = ZStream.serviceWithStream(_.getIpamPoolAllocations(request))
  def getIpamPoolAllocationsPaginated(
      request: zio.aws.ec2.model.GetIpamPoolAllocationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetIpamPoolAllocationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIpamPoolAllocationsPaginated(request))
  def describeCustomerGateways(
      request: zio.aws.ec2.model.DescribeCustomerGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeCustomerGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCustomerGateways(request))
  def describeClientVpnAuthorizationRules(
      request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AuthorizationRule.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClientVpnAuthorizationRules(request))
  def describeClientVpnAuthorizationRulesPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnAuthorizationRulesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.describeClientVpnAuthorizationRulesPaginated(request))
  def rejectTransitGatewayMulticastDomainAssociations(
      request: zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RejectTransitGatewayMulticastDomainAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.rejectTransitGatewayMulticastDomainAssociations(request)
  )
  def deleteSubnet(
      request: zio.aws.ec2.model.DeleteSubnetRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteSubnet(request))
  def deleteEgressOnlyInternetGateway(
      request: zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteEgressOnlyInternetGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEgressOnlyInternetGateway(request))
  def deleteTrafficMirrorTarget(
      request: zio.aws.ec2.model.DeleteTrafficMirrorTargetRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTrafficMirrorTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficMirrorTarget(request))
  def describeInstanceAttribute(
      request: zio.aws.ec2.model.DescribeInstanceAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceAttribute(request))
  def disableImageDeprecation(
      request: zio.aws.ec2.model.DisableImageDeprecationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableImageDeprecationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableImageDeprecation(request))
  def deleteKeyPair(
      request: zio.aws.ec2.model.DeleteKeyPairRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteKeyPair(request))
  def deleteCarrierGateway(
      request: zio.aws.ec2.model.DeleteCarrierGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteCarrierGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteCarrierGateway(request))
  def deleteTransitGatewayConnect(
      request: zio.aws.ec2.model.DeleteTransitGatewayConnectRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTransitGatewayConnectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTransitGatewayConnect(request))
  def createCustomerGateway(
      request: zio.aws.ec2.model.CreateCustomerGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateCustomerGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createCustomerGateway(request))
  def deleteInternetGateway(
      request: zio.aws.ec2.model.DeleteInternetGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteInternetGateway(request))
  def createVpnConnectionRoute(
      request: zio.aws.ec2.model.CreateVpnConnectionRouteRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createVpnConnectionRoute(request))
  def getCapacityReservationUsage(
      request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly,
    zio.aws.ec2.model.InstanceUsage.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getCapacityReservationUsage(request))
  def getCapacityReservationUsagePaginated(
      request: zio.aws.ec2.model.GetCapacityReservationUsageRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetCapacityReservationUsageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getCapacityReservationUsagePaginated(request))
  def createPlacementGroup(
      request: zio.aws.ec2.model.CreatePlacementGroupRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreatePlacementGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPlacementGroup(request))
  def modifyNetworkInterfaceAttribute(
      request: zio.aws.ec2.model.ModifyNetworkInterfaceAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyNetworkInterfaceAttribute(request))
  def importSnapshot(request: zio.aws.ec2.model.ImportSnapshotRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importSnapshot(request))
  def modifyFpgaImageAttribute(
      request: zio.aws.ec2.model.ModifyFpgaImageAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyFpgaImageAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyFpgaImageAttribute(request))
  def describeNetworkInsightsPaths(
      request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.NetworkInsightsPath.ReadOnly
  ] = ZStream.serviceWithStream(_.describeNetworkInsightsPaths(request))
  def describeNetworkInsightsPathsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkInsightsPathsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkInsightsPathsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNetworkInsightsPathsPaginated(request))
  def createVpc(request: zio.aws.ec2.model.CreateVpcRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpc(request))
  def cancelReservedInstancesListing(
      request: zio.aws.ec2.model.CancelReservedInstancesListingRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelReservedInstancesListingResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelReservedInstancesListing(request))
  def getIpamPoolCidrs(
      request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.IpamPoolCidr.ReadOnly
  ] = ZStream.serviceWithStream(_.getIpamPoolCidrs(request))
  def getIpamPoolCidrsPaginated(
      request: zio.aws.ec2.model.GetIpamPoolCidrsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetIpamPoolCidrsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIpamPoolCidrsPaginated(request))
  def deleteVolume(
      request: zio.aws.ec2.model.DeleteVolumeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVolume(request))
  def revokeSecurityGroupIngress(
      request: zio.aws.ec2.model.RevokeSecurityGroupIngressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RevokeSecurityGroupIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.revokeSecurityGroupIngress(request))
  def describeNetworkAcls(
      request: zio.aws.ec2.model.DescribeNetworkAclsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.NetworkAcl.ReadOnly] =
    ZStream.serviceWithStream(_.describeNetworkAcls(request))
  def describeNetworkAclsPaginated(
      request: zio.aws.ec2.model.DescribeNetworkAclsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeNetworkAclsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeNetworkAclsPaginated(request))
  def copyImage(request: zio.aws.ec2.model.CopyImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CopyImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyImage(request))
  def advertiseByoipCidr(
      request: zio.aws.ec2.model.AdvertiseByoipCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AdvertiseByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.advertiseByoipCidr(request))
  def createLocalGatewayRoute(
      request: zio.aws.ec2.model.CreateLocalGatewayRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateLocalGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLocalGatewayRoute(request))
  def disassociateTrunkInterface(
      request: zio.aws.ec2.model.DisassociateTrunkInterfaceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisassociateTrunkInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTrunkInterface(request))
  def describeClientVpnEndpoints(
      request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ClientVpnEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClientVpnEndpoints(request))
  def describeClientVpnEndpointsPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnEndpointsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientVpnEndpointsPaginated(request))
  def disableFastSnapshotRestores(
      request: zio.aws.ec2.model.DisableFastSnapshotRestoresRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableFastSnapshotRestoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableFastSnapshotRestores(request))
  def createSubnetCidrReservation(
      request: zio.aws.ec2.model.CreateSubnetCidrReservationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSubnetCidrReservationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSubnetCidrReservation(request))
  def disassociateRouteTable(
      request: zio.aws.ec2.model.DisassociateRouteTableRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.disassociateRouteTable(request))
  def describeSpotInstanceRequests(
      request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SpotInstanceRequest.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSpotInstanceRequests(request))
  def describeSpotInstanceRequestsPaginated(
      request: zio.aws.ec2.model.DescribeSpotInstanceRequestsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotInstanceRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotInstanceRequestsPaginated(request))
  def deleteTrafficMirrorFilterRule(
      request: zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTrafficMirrorFilterRuleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficMirrorFilterRule(request))
  def describeHostReservations(
      request: zio.aws.ec2.model.DescribeHostReservationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.HostReservation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeHostReservations(request))
  def describeHostReservationsPaginated(
      request: zio.aws.ec2.model.DescribeHostReservationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeHostReservationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeHostReservationsPaginated(request))
  def modifyVpnTunnelCertificate(
      request: zio.aws.ec2.model.ModifyVpnTunnelCertificateRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpnTunnelCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpnTunnelCertificate(request))
  def detachInternetGateway(
      request: zio.aws.ec2.model.DetachInternetGatewayRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachInternetGateway(request))
  def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRouteTableVirtualInterfaceGroupAssociation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociations(request)
  )
  def describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginated(
      request
    )
  )
  def deregisterImage(
      request: zio.aws.ec2.model.DeregisterImageRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deregisterImage(request))
  def modifySnapshotAttribute(
      request: zio.aws.ec2.model.ModifySnapshotAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifySnapshotAttribute(request))
  def describeVolumeAttribute(
      request: zio.aws.ec2.model.DescribeVolumeAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVolumeAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVolumeAttribute(request))
  def describeVpcEndpoints(
      request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.VpcEndpoint.ReadOnly
  ] = ZStream.serviceWithStream(_.describeVpcEndpoints(request))
  def describeVpcEndpointsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcEndpointsPaginated(request))
  def getLaunchTemplateData(
      request: zio.aws.ec2.model.GetLaunchTemplateDataRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetLaunchTemplateDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLaunchTemplateData(request))
  def deleteNetworkAcl(
      request: zio.aws.ec2.model.DeleteNetworkAclRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteNetworkAcl(request))
  def describeSecurityGroups(
      request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SecurityGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSecurityGroups(request))
  def describeSecurityGroupsPaginated(
      request: zio.aws.ec2.model.DescribeSecurityGroupsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSecurityGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSecurityGroupsPaginated(request))
  def deleteFleets(request: zio.aws.ec2.model.DeleteFleetsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteFleets(request))
  def replaceTransitGatewayRoute(
      request: zio.aws.ec2.model.ReplaceTransitGatewayRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReplaceTransitGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replaceTransitGatewayRoute(request))
  def getVpnConnectionDeviceSampleConfiguration(
      request: zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetVpnConnectionDeviceSampleConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getVpnConnectionDeviceSampleConfiguration(request))
  def detachClassicLinkVpc(
      request: zio.aws.ec2.model.DetachClassicLinkVpcRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DetachClassicLinkVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachClassicLinkVpc(request))
  def allocateAddress(request: zio.aws.ec2.model.AllocateAddressRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AllocateAddressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.allocateAddress(request))
  def deleteVpnConnection(
      request: zio.aws.ec2.model.DeleteVpnConnectionRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteVpnConnection(request))
  def describeReservedInstancesOfferings(
      request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReservedInstancesOffering.ReadOnly
  ] = ZStream.serviceWithStream(_.describeReservedInstancesOfferings(request))
  def describeReservedInstancesOfferingsPaginated(
      request: zio.aws.ec2.model.DescribeReservedInstancesOfferingsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedInstancesOfferingsPaginated(request))
  def describeConversionTasks(
      request: zio.aws.ec2.model.DescribeConversionTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeConversionTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConversionTasks(request))
  def describeLocalGatewayRouteTableVpcAssociations(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LocalGatewayRouteTableVpcAssociation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.describeLocalGatewayRouteTableVpcAssociations(request)
  )
  def describeLocalGatewayRouteTableVpcAssociationsPaginated(
      request: zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLocalGatewayRouteTableVpcAssociationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeLocalGatewayRouteTableVpcAssociationsPaginated(request)
  )
  def associateInstanceEventWindow(
      request: zio.aws.ec2.model.AssociateInstanceEventWindowRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateInstanceEventWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateInstanceEventWindow(request))
  def describeInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeInstanceEventNotificationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceEventNotificationAttributes(request))
  def deleteNetworkInsightsPath(
      request: zio.aws.ec2.model.DeleteNetworkInsightsPathRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsPathResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkInsightsPath(request))
  def describeElasticGpus(
      request: zio.aws.ec2.model.DescribeElasticGpusRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly,
    zio.aws.ec2.model.ElasticGpus.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeElasticGpus(request))
  def describeElasticGpusPaginated(
      request: zio.aws.ec2.model.DescribeElasticGpusRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeElasticGpusResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeElasticGpusPaginated(request))
  def exportTransitGatewayRoutes(
      request: zio.aws.ec2.model.ExportTransitGatewayRoutesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ExportTransitGatewayRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.exportTransitGatewayRoutes(request))
  def describeTrafficMirrorSessions(
      request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TrafficMirrorSession.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTrafficMirrorSessions(request))
  def describeTrafficMirrorSessionsPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorSessionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrafficMirrorSessionsPaginated(request))
  def describeSpotPriceHistory(
      request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.SpotPrice.ReadOnly] =
    ZStream.serviceWithStream(_.describeSpotPriceHistory(request))
  def describeSpotPriceHistoryPaginated(
      request: zio.aws.ec2.model.DescribeSpotPriceHistoryRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSpotPriceHistoryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpotPriceHistoryPaginated(request))
  def enableImageDeprecation(
      request: zio.aws.ec2.model.EnableImageDeprecationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableImageDeprecationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableImageDeprecation(request))
  def describeRegions(request: zio.aws.ec2.model.DescribeRegionsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeRegionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRegions(request))
  def runScheduledInstances(
      request: zio.aws.ec2.model.RunScheduledInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RunScheduledInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.runScheduledInstances(request))
  def modifyInstanceEventWindow(
      request: zio.aws.ec2.model.ModifyInstanceEventWindowRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstanceEventWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceEventWindow(request))
  def deleteTrafficMirrorSession(
      request: zio.aws.ec2.model.DeleteTrafficMirrorSessionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteTrafficMirrorSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTrafficMirrorSession(request))
  def modifyVpcPeeringConnectionOptions(
      request: zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcPeeringConnectionOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcPeeringConnectionOptions(request))
  def describeFlowLogs(
      request: zio.aws.ec2.model.DescribeFlowLogsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.FlowLog.ReadOnly] =
    ZStream.serviceWithStream(_.describeFlowLogs(request))
  def describeFlowLogsPaginated(
      request: zio.aws.ec2.model.DescribeFlowLogsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFlowLogsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFlowLogsPaginated(request))
  def describeIpams(
      request: zio.aws.ec2.model.DescribeIpamsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.Ipam.ReadOnly] =
    ZStream.serviceWithStream(_.describeIpams(request))
  def describeIpamsPaginated(
      request: zio.aws.ec2.model.DescribeIpamsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIpamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIpamsPaginated(request))
  def modifyIpamPool(request: zio.aws.ec2.model.ModifyIpamPoolRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyIpamPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyIpamPool(request))
  def unassignIpv6Addresses(
      request: zio.aws.ec2.model.UnassignIpv6AddressesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.UnassignIpv6AddressesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.unassignIpv6Addresses(request))
  def describeImportImageTasks(
      request: zio.aws.ec2.model.DescribeImportImageTasksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportImageTask.ReadOnly
  ] = ZStream.serviceWithStream(_.describeImportImageTasks(request))
  def describeImportImageTasksPaginated(
      request: zio.aws.ec2.model.DescribeImportImageTasksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeImportImageTasksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImportImageTasksPaginated(request))
  def deletePlacementGroup(
      request: zio.aws.ec2.model.DeletePlacementGroupRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deletePlacementGroup(request))
  def cancelSpotInstanceRequests(
      request: zio.aws.ec2.model.CancelSpotInstanceRequestsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CancelSpotInstanceRequestsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.cancelSpotInstanceRequests(request))
  def describeSnapshotAttribute(
      request: zio.aws.ec2.model.DescribeSnapshotAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeSnapshotAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSnapshotAttribute(request))
  def describeManagedPrefixLists(
      request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ManagedPrefixList.ReadOnly
  ] = ZStream.serviceWithStream(_.describeManagedPrefixLists(request))
  def describeManagedPrefixListsPaginated(
      request: zio.aws.ec2.model.DescribeManagedPrefixListsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeManagedPrefixListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeManagedPrefixListsPaginated(request))
  def createNetworkAclEntry(
      request: zio.aws.ec2.model.CreateNetworkAclEntryRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createNetworkAclEntry(request))
  def associateTransitGatewayRouteTable(
      request: zio.aws.ec2.model.AssociateTransitGatewayRouteTableRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateTransitGatewayRouteTableResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTransitGatewayRouteTable(request))
  def describeScheduledInstances(
      request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ScheduledInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScheduledInstances(request))
  def describeScheduledInstancesPaginated(
      request: zio.aws.ec2.model.DescribeScheduledInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeScheduledInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScheduledInstancesPaginated(request))
  def authorizeClientVpnIngress(
      request: zio.aws.ec2.model.AuthorizeClientVpnIngressRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AuthorizeClientVpnIngressResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.authorizeClientVpnIngress(request))
  def getTransitGatewayPrefixListReferences(
      request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayPrefixListReference.ReadOnly
  ] =
    ZStream.serviceWithStream(_.getTransitGatewayPrefixListReferences(request))
  def getTransitGatewayPrefixListReferencesPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayPrefixListReferencesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayPrefixListReferencesPaginated(request)
  )
  def detachNetworkInterface(
      request: zio.aws.ec2.model.DetachNetworkInterfaceRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.detachNetworkInterface(request))
  def importImage(request: zio.aws.ec2.model.ImportImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importImage(request))
  def describeEgressOnlyInternetGateways(
      request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EgressOnlyInternetGateway.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEgressOnlyInternetGateways(request))
  def describeEgressOnlyInternetGatewaysPaginated(
      request: zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeEgressOnlyInternetGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEgressOnlyInternetGatewaysPaginated(request))
  def confirmProductInstance(
      request: zio.aws.ec2.model.ConfirmProductInstanceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ConfirmProductInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.confirmProductInstance(request))
  def describePrincipalIdFormat(
      request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.PrincipalIdFormat.ReadOnly
  ] = ZStream.serviceWithStream(_.describePrincipalIdFormat(request))
  def describePrincipalIdFormatPaginated(
      request: zio.aws.ec2.model.DescribePrincipalIdFormatRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribePrincipalIdFormatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePrincipalIdFormatPaginated(request))
  def associateSubnetCidrBlock(
      request: zio.aws.ec2.model.AssociateSubnetCidrBlockRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateSubnetCidrBlockResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateSubnetCidrBlock(request))
  def describeClientVpnTargetNetworks(
      request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TargetNetwork.ReadOnly
  ] = ZStream.serviceWithStream(_.describeClientVpnTargetNetworks(request))
  def describeClientVpnTargetNetworksPaginated(
      request: zio.aws.ec2.model.DescribeClientVpnTargetNetworksRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeClientVpnTargetNetworksResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeClientVpnTargetNetworksPaginated(request))
  def resetEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ResetEbsDefaultKmsKeyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetEbsDefaultKmsKeyId(request))
  def disableIpamOrganizationAdminAccount(
      request: zio.aws.ec2.model.DisableIpamOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DisableIpamOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableIpamOrganizationAdminAccount(request))
  def describeIdFormat(request: zio.aws.ec2.model.DescribeIdFormatRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIdFormatResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIdFormat(request))
  def describeIpamScopes(
      request: zio.aws.ec2.model.DescribeIpamScopesRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.IpamScope.ReadOnly] =
    ZStream.serviceWithStream(_.describeIpamScopes(request))
  def describeIpamScopesPaginated(
      request: zio.aws.ec2.model.DescribeIpamScopesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeIpamScopesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeIpamScopesPaginated(request))
  def describeVpcEndpointServicePermissions(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AllowedPrincipal.ReadOnly
  ] =
    ZStream.serviceWithStream(_.describeVpcEndpointServicePermissions(request))
  def describeVpcEndpointServicePermissionsPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServicePermissionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.describeVpcEndpointServicePermissionsPaginated(request)
  )
  def describeFpgaImageAttribute(
      request: zio.aws.ec2.model.DescribeFpgaImageAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeFpgaImageAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeFpgaImageAttribute(request))
  def registerInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.RegisterInstanceEventNotificationAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerInstanceEventNotificationAttributes(request))
  def deleteNetworkInsightsAccessScopeAnalysis(
      request: zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNetworkInsightsAccessScopeAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNetworkInsightsAccessScopeAnalysis(request))
  def modifyVpcAttribute(
      request: zio.aws.ec2.model.ModifyVpcAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyVpcAttribute(request))
  def describeTrafficMirrorFilters(
      request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TrafficMirrorFilter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTrafficMirrorFilters(request))
  def describeTrafficMirrorFiltersPaginated(
      request: zio.aws.ec2.model.DescribeTrafficMirrorFiltersRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTrafficMirrorFiltersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTrafficMirrorFiltersPaginated(request))
  def describeImageAttribute(
      request: zio.aws.ec2.model.DescribeImageAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeImageAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeImageAttribute(request))
  def resetImageAttribute(
      request: zio.aws.ec2.model.ResetImageAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resetImageAttribute(request))
  def describeCapacityReservationFleets(
      request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CapacityReservationFleet.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCapacityReservationFleets(request))
  def describeCapacityReservationFleetsPaginated(
      request: zio.aws.ec2.model.DescribeCapacityReservationFleetsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeCapacityReservationFleetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCapacityReservationFleetsPaginated(request))
  def deleteNatGateway(request: zio.aws.ec2.model.DeleteNatGatewayRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteNatGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteNatGateway(request))
  def deleteTags(
      request: zio.aws.ec2.model.DeleteTagsRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteTags(request))
  def describeReservedInstancesListings(
      request: zio.aws.ec2.model.DescribeReservedInstancesListingsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeReservedInstancesListingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeReservedInstancesListings(request))
  def deleteIpamPool(request: zio.aws.ec2.model.DeleteIpamPoolRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteIpamPoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteIpamPool(request))
  def associateClientVpnTargetNetwork(
      request: zio.aws.ec2.model.AssociateClientVpnTargetNetworkRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateClientVpnTargetNetworkResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateClientVpnTargetNetwork(request))
  def copyFpgaImage(request: zio.aws.ec2.model.CopyFpgaImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CopyFpgaImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyFpgaImage(request))
  def getFlowLogsIntegrationTemplate(
      request: zio.aws.ec2.model.GetFlowLogsIntegrationTemplateRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetFlowLogsIntegrationTemplateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getFlowLogsIntegrationTemplate(request))
  def getInstanceTypesFromInstanceRequirements(
      request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.InstanceTypeInfoFromInstanceRequirements.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getInstanceTypesFromInstanceRequirements(request)
  )
  def getInstanceTypesFromInstanceRequirementsPaginated(
      request: zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetInstanceTypesFromInstanceRequirementsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getInstanceTypesFromInstanceRequirementsPaginated(request)
  )
  def unassignPrivateIpAddresses(
      request: zio.aws.ec2.model.UnassignPrivateIpAddressesRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.unassignPrivateIpAddresses(request))
  def resetSnapshotAttribute(
      request: zio.aws.ec2.model.ResetSnapshotAttributeRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.resetSnapshotAttribute(request))
  def describeAccountAttributes(
      request: zio.aws.ec2.model.DescribeAccountAttributesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributes(request))
  def acceptTransitGatewayVpcAttachment(
      request: zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptTransitGatewayVpcAttachmentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptTransitGatewayVpcAttachment(request))
  def createInstanceExportTask(
      request: zio.aws.ec2.model.CreateInstanceExportTaskRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateInstanceExportTaskResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceExportTask(request))
  def associateEnclaveCertificateIamRole(
      request: zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateEnclaveCertificateIamRoleResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateEnclaveCertificateIamRole(request))
  def createDefaultVpc(request: zio.aws.ec2.model.CreateDefaultVpcRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateDefaultVpcResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDefaultVpc(request))
  def getTransitGatewayRouteTablePropagations(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayRouteTablePropagation.ReadOnly
  ] = ZStream.serviceWithStream(
    _.getTransitGatewayRouteTablePropagations(request)
  )
  def getTransitGatewayRouteTablePropagationsPaginated(
      request: zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetTransitGatewayRouteTablePropagationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.getTransitGatewayRouteTablePropagationsPaginated(request)
  )
  def enableIpamOrganizationAdminAccount(
      request: zio.aws.ec2.model.EnableIpamOrganizationAdminAccountRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableIpamOrganizationAdminAccountResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableIpamOrganizationAdminAccount(request))
  def createTransitGateway(
      request: zio.aws.ec2.model.CreateTransitGatewayRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGateway(request))
  def createTransitGatewayConnectPeer(
      request: zio.aws.ec2.model.CreateTransitGatewayConnectPeerRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTransitGatewayConnectPeerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTransitGatewayConnectPeer(request))
  def modifyDefaultCreditSpecification(
      request: zio.aws.ec2.model.ModifyDefaultCreditSpecificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyDefaultCreditSpecificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDefaultCreditSpecification(request))
  def modifyManagedPrefixList(
      request: zio.aws.ec2.model.ModifyManagedPrefixListRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyManagedPrefixListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyManagedPrefixList(request))
  def modifyVpcTenancy(request: zio.aws.ec2.model.ModifyVpcTenancyRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyVpcTenancyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyVpcTenancy(request))
  def associateTrunkInterface(
      request: zio.aws.ec2.model.AssociateTrunkInterfaceRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AssociateTrunkInterfaceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTrunkInterface(request))
  def cancelConversionTask(
      request: zio.aws.ec2.model.CancelConversionTaskRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.cancelConversionTask(request))
  def createTrafficMirrorTarget(
      request: zio.aws.ec2.model.CreateTrafficMirrorTargetRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateTrafficMirrorTargetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createTrafficMirrorTarget(request))
  def searchTransitGatewayRoutes(
      request: zio.aws.ec2.model.SearchTransitGatewayRoutesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.SearchTransitGatewayRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchTransitGatewayRoutes(request))
  def describeVpcEndpointServices(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, StreamingOutputResult[
    Any,
    zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly,
    zio.aws.ec2.model.ServiceDetail.ReadOnly
  ]] = ZIO.serviceWithZIO(_.describeVpcEndpointServices(request))
  def describeVpcEndpointServicesPaginated(
      request: zio.aws.ec2.model.DescribeVpcEndpointServicesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeVpcEndpointServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVpcEndpointServicesPaginated(request))
  def deleteLaunchTemplateVersions(
      request: zio.aws.ec2.model.DeleteLaunchTemplateVersionsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteLaunchTemplateVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLaunchTemplateVersions(request))
  def createInstanceEventWindow(
      request: zio.aws.ec2.model.CreateInstanceEventWindowRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateInstanceEventWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createInstanceEventWindow(request))
  def createNatGateway(request: zio.aws.ec2.model.CreateNatGatewayRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateNatGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createNatGateway(request))
  def enableSerialConsoleAccess(
      request: zio.aws.ec2.model.EnableSerialConsoleAccessRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableSerialConsoleAccessResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableSerialConsoleAccess(request))
  def replaceRouteTableAssociation(
      request: zio.aws.ec2.model.ReplaceRouteTableAssociationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReplaceRouteTableAssociationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.replaceRouteTableAssociation(request))
  def modifyEbsDefaultKmsKeyId(
      request: zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyEbsDefaultKmsKeyIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEbsDefaultKmsKeyId(request))
  def provisionByoipCidr(
      request: zio.aws.ec2.model.ProvisionByoipCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ProvisionByoipCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.provisionByoipCidr(request))
  def deleteLocalGatewayRoute(
      request: zio.aws.ec2.model.DeleteLocalGatewayRouteRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteLocalGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLocalGatewayRoute(request))
  def releaseHosts(request: zio.aws.ec2.model.ReleaseHostsRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ReleaseHostsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.releaseHosts(request))
  def describeLaunchTemplates(
      request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.LaunchTemplate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeLaunchTemplates(request))
  def describeLaunchTemplatesPaginated(
      request: zio.aws.ec2.model.DescribeLaunchTemplatesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeLaunchTemplatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLaunchTemplatesPaginated(request))
  def terminateInstances(
      request: zio.aws.ec2.model.TerminateInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TerminateInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.terminateInstances(request))
  def getHostReservationPurchasePreview(
      request: zio.aws.ec2.model.GetHostReservationPurchasePreviewRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetHostReservationPurchasePreviewResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getHostReservationPurchasePreview(request))
  def modifyInstanceCreditSpecification(
      request: zio.aws.ec2.model.ModifyInstanceCreditSpecificationRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyInstanceCreditSpecificationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyInstanceCreditSpecification(request))
  def detachVolume(request: zio.aws.ec2.model.DetachVolumeRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DetachVolumeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachVolume(request))
  def createSnapshot(request: zio.aws.ec2.model.CreateSnapshotRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSnapshot(request))
  def getIpamResourceCidrs(
      request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.IpamResourceCidr.ReadOnly
  ] = ZStream.serviceWithStream(_.getIpamResourceCidrs(request))
  def getIpamResourceCidrsPaginated(
      request: zio.aws.ec2.model.GetIpamResourceCidrsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetIpamResourceCidrsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getIpamResourceCidrsPaginated(request))
  def modifyReservedInstances(
      request: zio.aws.ec2.model.ModifyReservedInstancesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ModifyReservedInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyReservedInstances(request))
  def createFpgaImage(request: zio.aws.ec2.model.CreateFpgaImageRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateFpgaImageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createFpgaImage(request))
  def deprovisionPublicIpv4PoolCidr(
      request: zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeprovisionPublicIpv4PoolCidrResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deprovisionPublicIpv4PoolCidr(request))
  def acceptVpcPeeringConnection(
      request: zio.aws.ec2.model.AcceptVpcPeeringConnectionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.AcceptVpcPeeringConnectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.acceptVpcPeeringConnection(request))
  def describeTransitGatewayRouteTables(
      request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
  ): ZStream[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.TransitGatewayRouteTable.ReadOnly
  ] = ZStream.serviceWithStream(_.describeTransitGatewayRouteTables(request))
  def describeTransitGatewayRouteTablesPaginated(
      request: zio.aws.ec2.model.DescribeTransitGatewayRouteTablesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribeTransitGatewayRouteTablesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTransitGatewayRouteTablesPaginated(request))
  def deleteClientVpnEndpoint(
      request: zio.aws.ec2.model.DeleteClientVpnEndpointRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteClientVpnEndpointResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteClientVpnEndpoint(request))
  def importInstance(request: zio.aws.ec2.model.ImportInstanceRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importInstance(request))
  def enableFastSnapshotRestores(
      request: zio.aws.ec2.model.EnableFastSnapshotRestoresRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.EnableFastSnapshotRestoresResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableFastSnapshotRestores(request))
  def getAssociatedEnclaveCertificateIamRoles(
      request: zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.GetAssociatedEnclaveCertificateIamRolesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAssociatedEnclaveCertificateIamRoles(request))
  def deregisterInstanceEventNotificationAttributes(
      request: zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeregisterInstanceEventNotificationAttributesResponse.ReadOnly
  ] =
    ZIO.serviceWithZIO(_.deregisterInstanceEventNotificationAttributes(request))
  def resetAddressAttribute(
      request: zio.aws.ec2.model.ResetAddressAttributeRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ResetAddressAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetAddressAttribute(request))
  def moveByoipCidrToIpam(
      request: zio.aws.ec2.model.MoveByoipCidrToIpamRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.MoveByoipCidrToIpamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.moveByoipCidrToIpam(request))
  def importClientVpnClientCertificateRevocationList(
      request: zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.ImportClientVpnClientCertificateRevocationListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(
    _.importClientVpnClientCertificateRevocationList(request)
  )
  def createSpotDatafeedSubscription(
      request: zio.aws.ec2.model.CreateSpotDatafeedSubscriptionRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSpotDatafeedSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSpotDatafeedSubscription(request))
  def modifyIdentityIdFormat(
      request: zio.aws.ec2.model.ModifyIdentityIdFormatRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.modifyIdentityIdFormat(request))
  def describePrefixLists(
      request: zio.aws.ec2.model.DescribePrefixListsRequest
  ): ZStream[zio.aws.ec2.Ec2, AwsError, zio.aws.ec2.model.PrefixList.ReadOnly] =
    ZStream.serviceWithStream(_.describePrefixLists(request))
  def describePrefixListsPaginated(
      request: zio.aws.ec2.model.DescribePrefixListsRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DescribePrefixListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePrefixListsPaginated(request))
  def createVpnGateway(request: zio.aws.ec2.model.CreateVpnGatewayRequest): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateVpnGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVpnGateway(request))
  def createTags(
      request: zio.aws.ec2.model.CreateTagsRequest
  ): ZIO[zio.aws.ec2.Ec2, AwsError, Unit] =
    ZIO.serviceWithZIO(_.createTags(request))
  def createSecurityGroup(
      request: zio.aws.ec2.model.CreateSecurityGroupRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.CreateSecurityGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createSecurityGroup(request))
  def deleteInstanceEventWindow(
      request: zio.aws.ec2.model.DeleteInstanceEventWindowRequest
  ): ZIO[
    zio.aws.ec2.Ec2,
    AwsError,
    zio.aws.ec2.model.DeleteInstanceEventWindowResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteInstanceEventWindow(request))
}
