package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.StreamArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStreamsResponse(
    streams: Optional[Iterable[zio.aws.dynamodbstreams.model.Stream]] =
      Optional.Absent,
    lastEvaluatedStreamArn: Optional[StreamArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
      .builder()
      .optionallyWith(
        streams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streams)
      .optionallyWith(
        lastEvaluatedStreamArn.map(value =>
          StreamArn.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedStreamArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly =
    zio.aws.dynamodbstreams.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.ListStreamsResponse =
      zio.aws.dynamodbstreams.model.ListStreamsResponse(
        streams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedStreamArn.map(value => value)
      )
    def streams: Optional[List[zio.aws.dynamodbstreams.model.Stream.ReadOnly]]
    def lastEvaluatedStreamArn: Optional[StreamArn]
    def getStreams: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.Stream.ReadOnly
    ]] = AwsError.unwrapOptionField("streams", streams)
    def getLastEvaluatedStreamArn: ZIO[Any, AwsError, StreamArn] = AwsError
      .unwrapOptionField("lastEvaluatedStreamArn", lastEvaluatedStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ) extends zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly {
    override val streams
        : Optional[List[zio.aws.dynamodbstreams.model.Stream.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streams())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodbstreams.model.Stream.wrap(item)
          }.toList
        )
    override val lastEvaluatedStreamArn: Optional[StreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastEvaluatedStreamArn())
        .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ): zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly = new Wrapper(
    impl
  )
}
