package zio.aws.dynamodbstreams.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dynamodbstreams.model.primitives.{
  PositiveLongObject,
  SequenceNumber,
  AttributeName,
  Date
}
import scala.jdk.CollectionConverters._
final case class StreamRecord(
    approximateCreationDateTime: Optional[Date] = Optional.Absent,
    keys: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = Optional.Absent,
    newImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = Optional.Absent,
    oldImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = Optional.Absent,
    sequenceNumber: Optional[SequenceNumber] = Optional.Absent,
    sizeBytes: Optional[PositiveLongObject] = Optional.Absent,
    streamViewType: Optional[zio.aws.dynamodbstreams.model.StreamViewType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.StreamRecord = {
    import StreamRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.StreamRecord
      .builder()
      .optionallyWith(
        approximateCreationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.approximateCreationDateTime)
      .optionallyWith(
        keys.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.keys)
      .optionallyWith(
        newImage.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.newImage)
      .optionallyWith(
        oldImage.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.oldImage)
      .optionallyWith(
        sequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumber)
      .optionallyWith(
        sizeBytes.map(value => PositiveLongObject.unwrap(value): java.lang.Long)
      )(_.sizeBytes)
      .optionallyWith(streamViewType.map(value => value.unwrap))(
        _.streamViewType
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly =
    zio.aws.dynamodbstreams.model.StreamRecord.wrap(buildAwsValue())
}
object StreamRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.StreamRecord =
      zio.aws.dynamodbstreams.model.StreamRecord(
        approximateCreationDateTime.map(value => value),
        keys.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        newImage.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        oldImage.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        sequenceNumber.map(value => value),
        sizeBytes.map(value => value),
        streamViewType.map(value => value)
      )
    def approximateCreationDateTime: Optional[Date]
    def keys: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def newImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def oldImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def sequenceNumber: Optional[SequenceNumber]
    def sizeBytes: Optional[PositiveLongObject]
    def streamViewType: Optional[zio.aws.dynamodbstreams.model.StreamViewType]
    def getApproximateCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "approximateCreationDateTime",
        approximateCreationDateTime
      )
    def getKeys: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("keys", keys)
    def getNewImage: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("newImage", newImage)
    def getOldImage: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("oldImage", oldImage)
    def getSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getSizeBytes: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("sizeBytes", sizeBytes)
    def getStreamViewType
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamViewType] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ) extends zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly {
    override val approximateCreationDateTime: Optional[Date] =
      zio.aws.core.internal
        .optionalFromNullable(impl.approximateCreationDateTime())
        .map(value => zio.aws.dynamodbstreams.model.primitives.Date(value))
    override val keys: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keys())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val newImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.newImage())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val oldImage: Optional[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.oldImage())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val sequenceNumber: Optional[SequenceNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumber())
        .map(value =>
          zio.aws.dynamodbstreams.model.primitives.SequenceNumber(value)
        )
    override val sizeBytes: Optional[PositiveLongObject] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeBytes())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveLongObject(value)
      )
    override val streamViewType
        : Optional[zio.aws.dynamodbstreams.model.StreamViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamViewType())
        .map(value => zio.aws.dynamodbstreams.model.StreamViewType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ): zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly = new Wrapper(impl)
}
