package zio.aws.dynamodbstreams.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dynamodbstreams.model.primitives.{
  StreamArn,
  PositiveIntegerObject,
  TableName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListStreamsRequest(
    tableName: Optional[TableName] = Optional.Absent,
    limit: Optional[PositiveIntegerObject] = Optional.Absent,
    exclusiveStartStreamArn: Optional[StreamArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartStreamArn.map(value =>
          StreamArn.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartStreamArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly =
    zio.aws.dynamodbstreams.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.ListStreamsRequest =
      zio.aws.dynamodbstreams.model.ListStreamsRequest(
        tableName.map(value => value),
        limit.map(value => value),
        exclusiveStartStreamArn.map(value => value)
      )
    def tableName: Optional[TableName]
    def limit: Optional[PositiveIntegerObject]
    def exclusiveStartStreamArn: Optional[StreamArn]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartStreamArn: ZIO[Any, AwsError, StreamArn] = AwsError
      .unwrapOptionField("exclusiveStartStreamArn", exclusiveStartStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ) extends zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly {
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val limit: Optional[PositiveIntegerObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveIntegerObject(value)
      )
    override val exclusiveStartStreamArn: Optional[StreamArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartStreamArn())
        .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ): zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
