package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.{TableName, StreamArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Stream(
    streamArn: Optional[StreamArn] = Optional.Absent,
    tableName: Optional[TableName] = Optional.Absent,
    streamLabel: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Stream = {
    import Stream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Stream
      .builder()
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(streamLabel.map(value => value: java.lang.String))(
        _.streamLabel
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Stream.ReadOnly =
    zio.aws.dynamodbstreams.model.Stream.wrap(buildAwsValue())
}
object Stream {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Stream] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Stream =
      zio.aws.dynamodbstreams.model.Stream(
        streamArn.map(value => value),
        tableName.map(value => value),
        streamLabel.map(value => value)
      )
    def streamArn: Optional[StreamArn]
    def tableName: Optional[TableName]
    def streamLabel: Optional[String]
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamLabel", streamLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Stream
  ) extends zio.aws.dynamodbstreams.model.Stream.ReadOnly {
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val streamLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamLabel())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Stream
  ): zio.aws.dynamodbstreams.model.Stream.ReadOnly = new Wrapper(impl)
}
