package zio.aws.dynamodbstreams.model
import scala.jdk.CollectionConverters._
sealed trait ShardIteratorType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.ShardIteratorType
}
object ShardIteratorType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.ShardIteratorType
  ): zio.aws.dynamodbstreams.model.ShardIteratorType = value match {
    case software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.TRIM_HORIZON =>
      val r = TRIM_HORIZON
      r
    case software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.LATEST =>
      val r = LATEST
      r
    case software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.AT_SEQUENCE_NUMBER =>
      val r = AT_SEQUENCE_NUMBER
      r
    case software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.AFTER_SEQUENCE_NUMBER =>
      val r = AFTER_SEQUENCE_NUMBER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodbstreams.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ShardIteratorType =
      software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRIM_HORIZON
      extends zio.aws.dynamodbstreams.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ShardIteratorType =
      software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.TRIM_HORIZON
  }
  case object LATEST extends zio.aws.dynamodbstreams.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ShardIteratorType =
      software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.LATEST
  }
  case object AT_SEQUENCE_NUMBER
      extends zio.aws.dynamodbstreams.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ShardIteratorType =
      software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.AT_SEQUENCE_NUMBER
  }
  case object AFTER_SEQUENCE_NUMBER
      extends zio.aws.dynamodbstreams.model.ShardIteratorType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.ShardIteratorType =
      software.amazon.awssdk.services.dynamodb.model.ShardIteratorType.AFTER_SEQUENCE_NUMBER
  }
}
