package zio.aws.dynamodbstreams.model
import scala.jdk.CollectionConverters._
sealed trait OperationType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.OperationType
}
object OperationType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.OperationType
  ): zio.aws.dynamodbstreams.model.OperationType = value match {
    case software.amazon.awssdk.services.dynamodb.model.OperationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.OperationType.INSERT =>
      val r = INSERT
      r
    case software.amazon.awssdk.services.dynamodb.model.OperationType.MODIFY =>
      val r = MODIFY
      r
    case software.amazon.awssdk.services.dynamodb.model.OperationType.REMOVE =>
      val r = REMOVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodbstreams.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.OperationType =
      software.amazon.awssdk.services.dynamodb.model.OperationType.UNKNOWN_TO_SDK_VERSION
  }
  case object INSERT extends zio.aws.dynamodbstreams.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.OperationType =
      software.amazon.awssdk.services.dynamodb.model.OperationType.INSERT
  }
  case object MODIFY extends zio.aws.dynamodbstreams.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.OperationType =
      software.amazon.awssdk.services.dynamodb.model.OperationType.MODIFY
  }
  case object REMOVE extends zio.aws.dynamodbstreams.model.OperationType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.OperationType =
      software.amazon.awssdk.services.dynamodb.model.OperationType.REMOVE
  }
}
