package zio.aws.dynamodbstreams
import zio.aws.dynamodbstreams.model.primitives.BinaryAttributeValue.Type
import java.time.Instant
import zio.Chunk
import zio.aws.dynamodbstreams.model.primitives.{
  StringAttributeValue,
  NumberAttributeValue,
  BinaryAttributeValue,
  AttributeName
}
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AttributeName extends Subtype[String]
    type AttributeName =
      zio.aws.dynamodbstreams.model.primitives.AttributeName.Type
    object BinaryAttributeValue extends Subtype[Chunk[Byte]]
    type BinaryAttributeValue =
      zio.aws.dynamodbstreams.model.primitives.BinaryAttributeValue.Type
    object BooleanAttributeValue extends Subtype[Boolean]
    type BooleanAttributeValue =
      zio.aws.dynamodbstreams.model.primitives.BooleanAttributeValue.Type
    object Date extends Subtype[Instant]
    type Date = zio.aws.dynamodbstreams.model.primitives.Date.Type
    object KeySchemaAttributeName extends Subtype[String]
    type KeySchemaAttributeName =
      zio.aws.dynamodbstreams.model.primitives.KeySchemaAttributeName.Type
    object NullAttributeValue extends Subtype[Boolean]
    type NullAttributeValue =
      zio.aws.dynamodbstreams.model.primitives.NullAttributeValue.Type
    object NumberAttributeValue extends Subtype[String]
    type NumberAttributeValue =
      zio.aws.dynamodbstreams.model.primitives.NumberAttributeValue.Type
    object PositiveIntegerObject extends Subtype[Int]
    type PositiveIntegerObject =
      zio.aws.dynamodbstreams.model.primitives.PositiveIntegerObject.Type
    object PositiveLongObject extends Subtype[Long]
    type PositiveLongObject =
      zio.aws.dynamodbstreams.model.primitives.PositiveLongObject.Type
    object SequenceNumber extends Subtype[String]
    type SequenceNumber =
      zio.aws.dynamodbstreams.model.primitives.SequenceNumber.Type
    object ShardId extends Subtype[String]
    type ShardId = zio.aws.dynamodbstreams.model.primitives.ShardId.Type
    object ShardIterator extends Subtype[String]
    type ShardIterator =
      zio.aws.dynamodbstreams.model.primitives.ShardIterator.Type
    object StreamArn extends Subtype[String]
    type StreamArn = zio.aws.dynamodbstreams.model.primitives.StreamArn.Type
    object StringAttributeValue extends Subtype[String]
    type StringAttributeValue =
      zio.aws.dynamodbstreams.model.primitives.StringAttributeValue.Type
    object TableName extends Subtype[String]
    type TableName = zio.aws.dynamodbstreams.model.primitives.TableName.Type
  }
  type AttributeMap =
    Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
  type BinarySetAttributeValue = List[BinaryAttributeValue]
  type KeySchema = List[zio.aws.dynamodbstreams.model.KeySchemaElement]
  type ListAttributeValue = List[zio.aws.dynamodbstreams.model.AttributeValue]
  type MapAttributeValue =
    Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
  type NumberSetAttributeValue = List[NumberAttributeValue]
  type RecordList = List[zio.aws.dynamodbstreams.model.Record]
  type ShardDescriptionList = List[zio.aws.dynamodbstreams.model.Shard]
  type StreamList = List[zio.aws.dynamodbstreams.model.Stream]
  type StringSetAttributeValue = List[StringAttributeValue]
}
