package zio.aws.dynamodbstreams.model
import scala.jdk.CollectionConverters._
sealed trait KeyType {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.KeyType
}
object KeyType {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.KeyType
  ): zio.aws.dynamodbstreams.model.KeyType = value match {
    case software.amazon.awssdk.services.dynamodb.model.KeyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.KeyType.HASH =>
      val r = HASH
      r
    case software.amazon.awssdk.services.dynamodb.model.KeyType.RANGE =>
      val r = RANGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodbstreams.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.KeyType =
      software.amazon.awssdk.services.dynamodb.model.KeyType.UNKNOWN_TO_SDK_VERSION
  }
  case object HASH extends zio.aws.dynamodbstreams.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.KeyType =
      software.amazon.awssdk.services.dynamodb.model.KeyType.HASH
  }
  case object RANGE extends zio.aws.dynamodbstreams.model.KeyType {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.KeyType =
      software.amazon.awssdk.services.dynamodb.model.KeyType.RANGE
  }
}
