package zio.aws.dynamodbstreams.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dynamodbstreams.model.primitives.{
  ShardId,
  TableName,
  Date,
  StreamArn
}
import scala.jdk.CollectionConverters._
final case class StreamDescription(
    streamArn: Optional[StreamArn] = Optional.Absent,
    streamLabel: Optional[String] = Optional.Absent,
    streamStatus: Optional[zio.aws.dynamodbstreams.model.StreamStatus] =
      Optional.Absent,
    streamViewType: Optional[zio.aws.dynamodbstreams.model.StreamViewType] =
      Optional.Absent,
    creationRequestDateTime: Optional[Date] = Optional.Absent,
    tableName: Optional[TableName] = Optional.Absent,
    keySchema: Optional[
      Iterable[zio.aws.dynamodbstreams.model.KeySchemaElement]
    ] = Optional.Absent,
    shards: Optional[Iterable[zio.aws.dynamodbstreams.model.Shard]] =
      Optional.Absent,
    lastEvaluatedShardId: Optional[ShardId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.StreamDescription = {
    import StreamDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.StreamDescription
      .builder()
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(streamLabel.map(value => value: java.lang.String))(
        _.streamLabel
      )
      .optionallyWith(streamStatus.map(value => value.unwrap))(_.streamStatus)
      .optionallyWith(streamViewType.map(value => value.unwrap))(
        _.streamViewType
      )
      .optionallyWith(
        creationRequestDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationRequestDateTime)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(
        lastEvaluatedShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedShardId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly =
    zio.aws.dynamodbstreams.model.StreamDescription.wrap(buildAwsValue())
}
object StreamDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.StreamDescription =
      zio.aws.dynamodbstreams.model.StreamDescription(
        streamArn.map(value => value),
        streamLabel.map(value => value),
        streamStatus.map(value => value),
        streamViewType.map(value => value),
        creationRequestDateTime.map(value => value),
        tableName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedShardId.map(value => value)
      )
    def streamArn: Optional[StreamArn]
    def streamLabel: Optional[String]
    def streamStatus: Optional[zio.aws.dynamodbstreams.model.StreamStatus]
    def streamViewType: Optional[zio.aws.dynamodbstreams.model.StreamViewType]
    def creationRequestDateTime: Optional[Date]
    def tableName: Optional[TableName]
    def keySchema: Optional[
      List[zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly]
    ]
    def shards: Optional[List[zio.aws.dynamodbstreams.model.Shard.ReadOnly]]
    def lastEvaluatedShardId: Optional[ShardId]
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamLabel", streamLabel)
    def getStreamStatus
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamStatus] =
      AwsError.unwrapOptionField("streamStatus", streamStatus)
    def getStreamViewType
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamViewType] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
    def getCreationRequestDateTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("creationRequestDateTime", creationRequestDateTime)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getShards: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.Shard.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shards)
    def getLastEvaluatedShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("lastEvaluatedShardId", lastEvaluatedShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ) extends zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly {
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
    override val streamLabel: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.streamLabel())
      .map(value => value: String)
    override val streamStatus
        : Optional[zio.aws.dynamodbstreams.model.StreamStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamStatus())
        .map(value => zio.aws.dynamodbstreams.model.StreamStatus.wrap(value))
    override val streamViewType
        : Optional[zio.aws.dynamodbstreams.model.StreamViewType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streamViewType())
        .map(value => zio.aws.dynamodbstreams.model.StreamViewType.wrap(value))
    override val creationRequestDateTime: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.creationRequestDateTime())
      .map(value => zio.aws.dynamodbstreams.model.primitives.Date(value))
    override val tableName: Optional[TableName] = zio.aws.core.internal
      .optionalFromNullable(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val keySchema: Optional[
      List[zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodbstreams.model.KeySchemaElement.wrap(item)
        }.toList
      )
    override val shards
        : Optional[List[zio.aws.dynamodbstreams.model.Shard.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shards())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodbstreams.model.Shard.wrap(item)
          }.toList
        )
    override val lastEvaluatedShardId: Optional[ShardId] = zio.aws.core.internal
      .optionalFromNullable(impl.lastEvaluatedShardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ): zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly = new Wrapper(
    impl
  )
}
