package zio.aws.dynamodbstreams
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.dynamodb.streams.{
  DynamoDbStreamsAsyncClientBuilder,
  DynamoDbStreamsAsyncClient
}
import zio.aws.dynamodbstreams.model.{
  ListStreamsRequest,
  GetShardIteratorRequest,
  GetRecordsRequest,
  DescribeStreamRequest
}
import zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.dynamodb.model.{
  GetShardIteratorResponse,
  ListStreamsResponse,
  DescribeStreamResponse,
  GetRecordsResponse
}
import scala.jdk.CollectionConverters._
trait DynamoDbStreams extends AspectSupport[DynamoDbStreams] {
  val api: DynamoDbStreamsAsyncClient
  def describeStream(
      request: DescribeStreamRequest
  ): IO[AwsError, zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly]
  def getRecords(
      request: GetRecordsRequest
  ): IO[AwsError, zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly]
  def getShardIterator(request: GetShardIteratorRequest): IO[
    AwsError,
    zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly
  ]
  def listStreams(request: ListStreamsRequest): IO[AwsError, ReadOnly]
}
object DynamoDbStreams {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DynamoDbStreams] =
    customized(identity)
  def customized(
      customization: DynamoDbStreamsAsyncClientBuilder => DynamoDbStreamsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DynamoDbStreams] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DynamoDbStreamsAsyncClientBuilder => DynamoDbStreamsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DynamoDbStreams] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DynamoDbStreamsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[DynamoDbStreamsAsyncClient, DynamoDbStreamsAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      DynamoDbStreamsAsyncClient,
      DynamoDbStreamsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new DynamoDbStreamsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class DynamoDbStreamsImpl[R](
      override val api: DynamoDbStreamsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DynamoDbStreams
      with AwsServiceBase[R] {
    override val serviceName: String = "DynamoDbStreams"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DynamoDbStreamsImpl[R1] = new DynamoDbStreamsImpl(api, newAspect, r)
    def describeStream(request: DescribeStreamRequest): IO[
      AwsError,
      zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest,
      DescribeStreamResponse
    ]("describeStream", api.describeStream)(request.buildAwsValue())
      .map(zio.aws.dynamodbstreams.model.DescribeStreamResponse.wrap)
      .provideEnvironment(r)
    def getRecords(
        request: GetRecordsRequest
    ): IO[AwsError, zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest,
        GetRecordsResponse
      ]("getRecords", api.getRecords)(request.buildAwsValue())
        .map(zio.aws.dynamodbstreams.model.GetRecordsResponse.wrap)
        .provideEnvironment(r)
    def getShardIterator(request: GetShardIteratorRequest): IO[
      AwsError,
      zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest,
      GetShardIteratorResponse
    ]("getShardIterator", api.getShardIterator)(request.buildAwsValue())
      .map(zio.aws.dynamodbstreams.model.GetShardIteratorResponse.wrap)
      .provideEnvironment(r)
    def listStreams(request: ListStreamsRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest,
        ListStreamsResponse
      ]("listStreams", api.listStreams)(request.buildAwsValue())
        .map(zio.aws.dynamodbstreams.model.ListStreamsResponse.wrap)
        .provideEnvironment(r)
  }
  def describeStream(request: DescribeStreamRequest): ZIO[
    zio.aws.dynamodbstreams.DynamoDbStreams,
    AwsError,
    zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeStream(request))
  def getRecords(request: GetRecordsRequest): ZIO[
    zio.aws.dynamodbstreams.DynamoDbStreams,
    AwsError,
    zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecords(request))
  def getShardIterator(request: GetShardIteratorRequest): ZIO[
    zio.aws.dynamodbstreams.DynamoDbStreams,
    AwsError,
    zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getShardIterator(request))
  def listStreams(
      request: ListStreamsRequest
  ): ZIO[zio.aws.dynamodbstreams.DynamoDbStreams, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listStreams(request))
}
