package zio.aws.dynamodbstreams.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.dynamodbstreams.model.primitives.{
  ShardId,
  PositiveIntegerObject,
  StreamArn
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStreamRequest(
    streamArn: StreamArn,
    limit: Optional[PositiveIntegerObject] = Optional.Absent,
    exclusiveStartShardId: Optional[ShardId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest = {
    import DescribeStreamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest
      .builder()
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartShardId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.DescribeStreamRequest.ReadOnly =
    zio.aws.dynamodbstreams.model.DescribeStreamRequest.wrap(buildAwsValue())
}
object DescribeStreamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.DescribeStreamRequest =
      zio.aws.dynamodbstreams.model.DescribeStreamRequest(
        streamArn,
        limit.map(value => value),
        exclusiveStartShardId.map(value => value)
      )
    def streamArn: StreamArn
    def limit: Optional[PositiveIntegerObject]
    def exclusiveStartShardId: Optional[ShardId]
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("exclusiveStartShardId", exclusiveStartShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest
  ) extends zio.aws.dynamodbstreams.model.DescribeStreamRequest.ReadOnly {
    override val streamArn: StreamArn =
      zio.aws.dynamodbstreams.model.primitives.StreamArn(impl.streamArn())
    override val limit: Optional[PositiveIntegerObject] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveIntegerObject(value)
      )
    override val exclusiveStartShardId: Optional[ShardId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.exclusiveStartShardId())
        .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest
  ): zio.aws.dynamodbstreams.model.DescribeStreamRequest.ReadOnly = new Wrapper(
    impl
  )
}
