package zio.aws.dynamodbstreams.model
import java.lang.Integer
import zio.aws.dynamodbstreams.model.primitives.{
  PositiveIntegerObject,
  ShardIterator
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetRecordsRequest(
    shardIterator: ShardIterator,
    limit: Option[PositiveIntegerObject] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest = {
    import GetRecordsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest
      .builder()
      .shardIterator(ShardIterator.unwrap(shardIterator): java.lang.String)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.GetRecordsRequest.ReadOnly =
    zio.aws.dynamodbstreams.model.GetRecordsRequest.wrap(buildAwsValue())
}
object GetRecordsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.GetRecordsRequest =
      zio.aws.dynamodbstreams.model
        .GetRecordsRequest(shardIterator, limit.map(value => value))
    def shardIterator: ShardIterator
    def limit: Option[PositiveIntegerObject]
    def getShardIterator: ZIO[Any, Nothing, ShardIterator] =
      ZIO.succeed(shardIterator)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest
  ) extends zio.aws.dynamodbstreams.model.GetRecordsRequest.ReadOnly {
    override val shardIterator: ShardIterator =
      zio.aws.dynamodbstreams.model.primitives
        .ShardIterator(impl.shardIterator())
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveIntegerObject(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest
  ): zio.aws.dynamodbstreams.model.GetRecordsRequest.ReadOnly = new Wrapper(
    impl
  )
}
