package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.KeySchemaAttributeName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class KeySchemaElement(
    attributeName: KeySchemaAttributeName,
    keyType: zio.aws.dynamodbstreams.model.KeyType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.KeySchemaElement = {
    import KeySchemaElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
      .builder()
      .attributeName(
        KeySchemaAttributeName.unwrap(attributeName): java.lang.String
      )
      .keyType(keyType.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly =
    zio.aws.dynamodbstreams.model.KeySchemaElement.wrap(buildAwsValue())
}
object KeySchemaElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.KeySchemaElement =
      zio.aws.dynamodbstreams.model.KeySchemaElement(attributeName, keyType)
    def attributeName: KeySchemaAttributeName
    def keyType: zio.aws.dynamodbstreams.model.KeyType
    def getAttributeName: ZIO[Any, Nothing, KeySchemaAttributeName] =
      ZIO.succeed(attributeName)
    def getKeyType: ZIO[Any, Nothing, zio.aws.dynamodbstreams.model.KeyType] =
      ZIO.succeed(keyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ) extends zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly {
    override val attributeName: KeySchemaAttributeName =
      zio.aws.dynamodbstreams.model.primitives
        .KeySchemaAttributeName(impl.attributeName())
    override val keyType: zio.aws.dynamodbstreams.model.KeyType =
      zio.aws.dynamodbstreams.model.KeyType.wrap(impl.keyType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.KeySchemaElement
  ): zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly = new Wrapper(impl)
}
