package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.ShardIterator
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetShardIteratorResponse(
    shardIterator: Option[ShardIterator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse = {
    import GetShardIteratorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse
      .builder()
      .optionallyWith(
        shardIterator.map(value =>
          ShardIterator.unwrap(value): java.lang.String
        )
      )(_.shardIterator)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly =
    zio.aws.dynamodbstreams.model.GetShardIteratorResponse.wrap(buildAwsValue())
}
object GetShardIteratorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.GetShardIteratorResponse =
      zio.aws.dynamodbstreams.model
        .GetShardIteratorResponse(shardIterator.map(value => value))
    def shardIterator: Option[ShardIterator]
    def getShardIterator: ZIO[Any, AwsError, ShardIterator] =
      AwsError.unwrapOptionField("shardIterator", shardIterator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse
  ) extends zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly {
    override val shardIterator: Option[ShardIterator] = scala
      .Option(impl.shardIterator())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.ShardIterator(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetShardIteratorResponse
  ): zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly =
    new Wrapper(impl)
}
