package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.StreamArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamsResponse(
    streams: Option[Iterable[zio.aws.dynamodbstreams.model.Stream]] = None,
    lastEvaluatedStreamArn: Option[StreamArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse = {
    import ListStreamsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
      .builder()
      .optionallyWith(
        streams.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.streams)
      .optionallyWith(
        lastEvaluatedStreamArn.map(value =>
          StreamArn.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedStreamArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly =
    zio.aws.dynamodbstreams.model.ListStreamsResponse.wrap(buildAwsValue())
}
object ListStreamsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.ListStreamsResponse =
      zio.aws.dynamodbstreams.model.ListStreamsResponse(
        streams.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedStreamArn.map(value => value)
      )
    def streams: Option[List[zio.aws.dynamodbstreams.model.Stream.ReadOnly]]
    def lastEvaluatedStreamArn: Option[StreamArn]
    def getStreams: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.Stream.ReadOnly
    ]] = AwsError.unwrapOptionField("streams", streams)
    def getLastEvaluatedStreamArn: ZIO[Any, AwsError, StreamArn] = AwsError
      .unwrapOptionField("lastEvaluatedStreamArn", lastEvaluatedStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ) extends zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly {
    override val streams
        : Option[List[zio.aws.dynamodbstreams.model.Stream.ReadOnly]] = scala
      .Option(impl.streams())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodbstreams.model.Stream.wrap(item)
        }.toList
      )
    override val lastEvaluatedStreamArn: Option[StreamArn] = scala
      .Option(impl.lastEvaluatedStreamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsResponse
  ): zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly = new Wrapper(
    impl
  )
}
