package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.{
  PositiveLongObject,
  SequenceNumber,
  AttributeName,
  Date
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StreamRecord(
    approximateCreationDateTime: Option[Date] = None,
    keys: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = None,
    newImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = None,
    oldImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue]
    ] = None,
    sequenceNumber: Option[SequenceNumber] = None,
    sizeBytes: Option[PositiveLongObject] = None,
    streamViewType: Option[zio.aws.dynamodbstreams.model.StreamViewType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.StreamRecord = {
    import StreamRecord.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.StreamRecord
      .builder()
      .optionallyWith(
        approximateCreationDateTime.map(value => Date.unwrap(value): Instant)
      )(_.approximateCreationDateTime)
      .optionallyWith(
        keys.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.keys)
      .optionallyWith(
        newImage.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.newImage)
      .optionallyWith(
        oldImage.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.oldImage)
      .optionallyWith(
        sequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumber)
      .optionallyWith(
        sizeBytes.map(value => PositiveLongObject.unwrap(value): java.lang.Long)
      )(_.sizeBytes)
      .optionallyWith(streamViewType.map(value => value.unwrap))(
        _.streamViewType
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly =
    zio.aws.dynamodbstreams.model.StreamRecord.wrap(buildAwsValue())
}
object StreamRecord {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.StreamRecord =
      zio.aws.dynamodbstreams.model.StreamRecord(
        approximateCreationDateTime.map(value => value),
        keys.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        newImage.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        oldImage.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        sequenceNumber.map(value => value),
        sizeBytes.map(value => value),
        streamViewType.map(value => value)
      )
    def approximateCreationDateTime: Option[Date]
    def keys: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def newImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def oldImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ]
    def sequenceNumber: Option[SequenceNumber]
    def sizeBytes: Option[PositiveLongObject]
    def streamViewType: Option[zio.aws.dynamodbstreams.model.StreamViewType]
    def getApproximateCreationDateTime: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField(
        "approximateCreationDateTime",
        approximateCreationDateTime
      )
    def getKeys: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("keys", keys)
    def getNewImage: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("newImage", newImage)
    def getOldImage: ZIO[Any, AwsError, Map[
      AttributeName,
      zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly
    ]] = AwsError.unwrapOptionField("oldImage", oldImage)
    def getSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
    def getSizeBytes: ZIO[Any, AwsError, PositiveLongObject] =
      AwsError.unwrapOptionField("sizeBytes", sizeBytes)
    def getStreamViewType
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamViewType] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ) extends zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly {
    override val approximateCreationDateTime: Option[Date] = scala
      .Option(impl.approximateCreationDateTime())
      .map(value => zio.aws.dynamodbstreams.model.primitives.Date(value))
    override val keys: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.keys())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val newImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.newImage())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val oldImage: Option[
      Map[AttributeName, zio.aws.dynamodbstreams.model.AttributeValue.ReadOnly]
    ] = scala
      .Option(impl.oldImage())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dynamodbstreams.model.primitives.AttributeName(
              key
            ) -> zio.aws.dynamodbstreams.model.AttributeValue.wrap(value)
          })
          .toMap
      )
    override val sequenceNumber: Option[SequenceNumber] = scala
      .Option(impl.sequenceNumber())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.SequenceNumber(value)
      )
    override val sizeBytes: Option[PositiveLongObject] = scala
      .Option(impl.sizeBytes())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveLongObject(value)
      )
    override val streamViewType
        : Option[zio.aws.dynamodbstreams.model.StreamViewType] = scala
      .Option(impl.streamViewType())
      .map(value => zio.aws.dynamodbstreams.model.StreamViewType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamRecord
  ): zio.aws.dynamodbstreams.model.StreamRecord.ReadOnly = new Wrapper(impl)
}
