package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.ShardId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Shard(
    shardId: Optional[ShardId] = Optional.Absent,
    sequenceNumberRange: Optional[
      zio.aws.dynamodbstreams.model.SequenceNumberRange
    ] = Optional.Absent,
    parentShardId: Optional[ShardId] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Shard
      .builder()
      .optionallyWith(
        shardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.shardId)
      .optionallyWith(sequenceNumberRange.map(value => value.buildAwsValue()))(
        _.sequenceNumberRange
      )
      .optionallyWith(
        parentShardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.parentShardId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Shard.ReadOnly =
    zio.aws.dynamodbstreams.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Shard =
      zio.aws.dynamodbstreams.model.Shard(
        shardId.map(value => value),
        sequenceNumberRange.map(value => value.asEditable),
        parentShardId.map(value => value)
      )
    def shardId: Optional[ShardId]
    def sequenceNumberRange
        : Optional[zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly]
    def parentShardId: Optional[ShardId]
    def getShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("shardId", shardId)
    def getSequenceNumberRange: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly
    ] = AwsError.unwrapOptionField("sequenceNumberRange", sequenceNumberRange)
    def getParentShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("parentShardId", parentShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Shard
  ) extends zio.aws.dynamodbstreams.model.Shard.ReadOnly {
    override val shardId: Optional[ShardId] = zio.aws.core.internal
      .optionalFromNullable(impl.shardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
    override val sequenceNumberRange
        : Optional[zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sequenceNumberRange())
        .map(value =>
          zio.aws.dynamodbstreams.model.SequenceNumberRange.wrap(value)
        )
    override val parentShardId: Optional[ShardId] = zio.aws.core.internal
      .optionalFromNullable(impl.parentShardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Shard
  ): zio.aws.dynamodbstreams.model.Shard.ReadOnly = new Wrapper(impl)
}
