package zio.aws.dynamodbstreams.model
import scala.jdk.CollectionConverters._
sealed trait StreamStatus {
  def unwrap: software.amazon.awssdk.services.dynamodb.model.StreamStatus
}
object StreamStatus {
  def wrap(
      value: software.amazon.awssdk.services.dynamodb.model.StreamStatus
  ): zio.aws.dynamodbstreams.model.StreamStatus = value match {
    case software.amazon.awssdk.services.dynamodb.model.StreamStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamStatus.ENABLING =>
      val r = ENABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamStatus.DISABLING =>
      val r = DISABLING
      r
    case software.amazon.awssdk.services.dynamodb.model.StreamStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dynamodbstreams.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamStatus =
      software.amazon.awssdk.services.dynamodb.model.StreamStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLING extends zio.aws.dynamodbstreams.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamStatus =
      software.amazon.awssdk.services.dynamodb.model.StreamStatus.ENABLING
  }
  case object ENABLED extends zio.aws.dynamodbstreams.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamStatus =
      software.amazon.awssdk.services.dynamodb.model.StreamStatus.ENABLED
  }
  case object DISABLING extends zio.aws.dynamodbstreams.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamStatus =
      software.amazon.awssdk.services.dynamodb.model.StreamStatus.DISABLING
  }
  case object DISABLED extends zio.aws.dynamodbstreams.model.StreamStatus {
    override def unwrap
        : software.amazon.awssdk.services.dynamodb.model.StreamStatus =
      software.amazon.awssdk.services.dynamodb.model.StreamStatus.DISABLED
  }
}
