package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.ShardIterator
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetRecordsResponse(
    records: Optional[Iterable[zio.aws.dynamodbstreams.model.Record]] =
      Optional.Absent,
    nextShardIterator: Optional[ShardIterator] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse = {
    import GetRecordsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse
      .builder()
      .optionallyWith(
        records.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.records)
      .optionallyWith(
        nextShardIterator.map(value =>
          ShardIterator.unwrap(value): java.lang.String
        )
      )(_.nextShardIterator)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly =
    zio.aws.dynamodbstreams.model.GetRecordsResponse.wrap(buildAwsValue())
}
object GetRecordsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.GetRecordsResponse =
      zio.aws.dynamodbstreams.model.GetRecordsResponse(
        records.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextShardIterator.map(value => value)
      )
    def records: Optional[List[zio.aws.dynamodbstreams.model.Record.ReadOnly]]
    def nextShardIterator: Optional[ShardIterator]
    def getRecords: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.Record.ReadOnly
    ]] = AwsError.unwrapOptionField("records", records)
    def getNextShardIterator: ZIO[Any, AwsError, ShardIterator] =
      AwsError.unwrapOptionField("nextShardIterator", nextShardIterator)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse
  ) extends zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly {
    override val records
        : Optional[List[zio.aws.dynamodbstreams.model.Record.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.records())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dynamodbstreams.model.Record.wrap(item)
          }.toList
        )
    override val nextShardIterator: Optional[ShardIterator] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nextShardIterator())
        .map(value =>
          zio.aws.dynamodbstreams.model.primitives.ShardIterator(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse
  ): zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly = new Wrapper(
    impl
  )
}
