package zio.aws.dynamodbstreams
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient
import zio.mock.{Proxy, Mock}
import zio.aws.dynamodbstreams.model.{
  ListStreamsRequest,
  GetShardIteratorRequest,
  GetRecordsRequest,
  DescribeStreamRequest
}
import zio.aws.dynamodbstreams.model.ListStreamsResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
object DynamoDbStreamsMock extends Mock[DynamoDbStreams] {
  object DescribeStream
      extends Effect[
        DescribeStreamRequest,
        AwsError,
        zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly
      ]
  object GetRecords
      extends Effect[
        GetRecordsRequest,
        AwsError,
        zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly
      ]
  object GetShardIterator
      extends Effect[
        GetShardIteratorRequest,
        AwsError,
        zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly
      ]
  object ListStreams extends Effect[ListStreamsRequest, AwsError, ReadOnly]
  val compose: URLayer[Proxy, DynamoDbStreams] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new DynamoDbStreams {
          val api: DynamoDbStreamsAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : DynamoDbStreams = this
          def describeStream(request: DescribeStreamRequest): IO[
            AwsError,
            zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly
          ] = proxy(DescribeStream, request)
          def getRecords(request: GetRecordsRequest): IO[
            AwsError,
            zio.aws.dynamodbstreams.model.GetRecordsResponse.ReadOnly
          ] = proxy(GetRecords, request)
          def getShardIterator(request: GetShardIteratorRequest): IO[
            AwsError,
            zio.aws.dynamodbstreams.model.GetShardIteratorResponse.ReadOnly
          ] = proxy(GetShardIterator, request)
          def listStreams(request: ListStreamsRequest): IO[AwsError, ReadOnly] =
            proxy(ListStreams, request)
        }
      }
    }
  }
}
