package zio.aws.dynamodbstreams.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Identity(
    principalId: Optional[String] = Optional.Absent,
    `type`: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.Identity = {
    import Identity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Identity
      .builder()
      .optionallyWith(principalId.map(value => value: java.lang.String))(
        _.principalId
      )
      .optionallyWith(`type`.map(value => value: java.lang.String))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Identity.ReadOnly =
    zio.aws.dynamodbstreams.model.Identity.wrap(buildAwsValue())
}
object Identity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Identity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Identity =
      zio.aws.dynamodbstreams.model
        .Identity(principalId.map(value => value), `type`.map(value => value))
    def principalId: Optional[String]
    def `type`: Optional[String]
    def getPrincipalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Identity
  ) extends zio.aws.dynamodbstreams.model.Identity.ReadOnly {
    override val principalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => value: String)
    override val `type`: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Identity
  ): zio.aws.dynamodbstreams.model.Identity.ReadOnly = new Wrapper(impl)
}
