package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.{
  ShardId,
  TableName,
  Date,
  StreamArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class StreamDescription(
    streamArn: Option[StreamArn] = None,
    streamLabel: Option[String] = None,
    streamStatus: Option[zio.aws.dynamodbstreams.model.StreamStatus] = None,
    streamViewType: Option[zio.aws.dynamodbstreams.model.StreamViewType] = None,
    creationRequestDateTime: Option[Date] = None,
    tableName: Option[TableName] = None,
    keySchema: Option[
      Iterable[zio.aws.dynamodbstreams.model.KeySchemaElement]
    ] = None,
    shards: Option[Iterable[zio.aws.dynamodbstreams.model.Shard]] = None,
    lastEvaluatedShardId: Option[ShardId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.StreamDescription = {
    import StreamDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.StreamDescription
      .builder()
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(streamLabel.map(value => value: java.lang.String))(
        _.streamLabel
      )
      .optionallyWith(streamStatus.map(value => value.unwrap))(_.streamStatus)
      .optionallyWith(streamViewType.map(value => value.unwrap))(
        _.streamViewType
      )
      .optionallyWith(
        creationRequestDateTime.map(value => Date.unwrap(value): Instant)
      )(_.creationRequestDateTime)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        keySchema.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.keySchema)
      .optionallyWith(
        shards.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shards)
      .optionallyWith(
        lastEvaluatedShardId.map(value =>
          ShardId.unwrap(value): java.lang.String
        )
      )(_.lastEvaluatedShardId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly =
    zio.aws.dynamodbstreams.model.StreamDescription.wrap(buildAwsValue())
}
object StreamDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.StreamDescription =
      zio.aws.dynamodbstreams.model.StreamDescription(
        streamArn.map(value => value),
        streamLabel.map(value => value),
        streamStatus.map(value => value),
        streamViewType.map(value => value),
        creationRequestDateTime.map(value => value),
        tableName.map(value => value),
        keySchema.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        shards.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastEvaluatedShardId.map(value => value)
      )
    def streamArn: Option[StreamArn]
    def streamLabel: Option[String]
    def streamStatus: Option[zio.aws.dynamodbstreams.model.StreamStatus]
    def streamViewType: Option[zio.aws.dynamodbstreams.model.StreamViewType]
    def creationRequestDateTime: Option[Date]
    def tableName: Option[TableName]
    def keySchema
        : Option[List[zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly]]
    def shards: Option[List[zio.aws.dynamodbstreams.model.Shard.ReadOnly]]
    def lastEvaluatedShardId: Option[ShardId]
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamLabel", streamLabel)
    def getStreamStatus
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamStatus] =
      AwsError.unwrapOptionField("streamStatus", streamStatus)
    def getStreamViewType
        : ZIO[Any, AwsError, zio.aws.dynamodbstreams.model.StreamViewType] =
      AwsError.unwrapOptionField("streamViewType", streamViewType)
    def getCreationRequestDateTime: ZIO[Any, AwsError, Date] = AwsError
      .unwrapOptionField("creationRequestDateTime", creationRequestDateTime)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getKeySchema: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly
    ]] = AwsError.unwrapOptionField("keySchema", keySchema)
    def getShards: ZIO[Any, AwsError, List[
      zio.aws.dynamodbstreams.model.Shard.ReadOnly
    ]] = AwsError.unwrapOptionField("shards", shards)
    def getLastEvaluatedShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("lastEvaluatedShardId", lastEvaluatedShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ) extends zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly {
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
    override val streamLabel: Option[String] =
      scala.Option(impl.streamLabel()).map(value => value: String)
    override val streamStatus
        : Option[zio.aws.dynamodbstreams.model.StreamStatus] = scala
      .Option(impl.streamStatus())
      .map(value => zio.aws.dynamodbstreams.model.StreamStatus.wrap(value))
    override val streamViewType
        : Option[zio.aws.dynamodbstreams.model.StreamViewType] = scala
      .Option(impl.streamViewType())
      .map(value => zio.aws.dynamodbstreams.model.StreamViewType.wrap(value))
    override val creationRequestDateTime: Option[Date] = scala
      .Option(impl.creationRequestDateTime())
      .map(value => zio.aws.dynamodbstreams.model.primitives.Date(value))
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val keySchema: Option[
      List[zio.aws.dynamodbstreams.model.KeySchemaElement.ReadOnly]
    ] = scala
      .Option(impl.keySchema())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodbstreams.model.KeySchemaElement.wrap(item)
        }.toList
      )
    override val shards
        : Option[List[zio.aws.dynamodbstreams.model.Shard.ReadOnly]] = scala
      .Option(impl.shards())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dynamodbstreams.model.Shard.wrap(item)
        }.toList
      )
    override val lastEvaluatedShardId: Option[ShardId] = scala
      .Option(impl.lastEvaluatedShardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.StreamDescription
  ): zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly = new Wrapper(
    impl
  )
}
