package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.SequenceNumber
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class SequenceNumberRange(
    startingSequenceNumber: Option[SequenceNumber] = None,
    endingSequenceNumber: Option[SequenceNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange = {
    import SequenceNumberRange.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange
      .builder()
      .optionallyWith(
        startingSequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.startingSequenceNumber)
      .optionallyWith(
        endingSequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.endingSequenceNumber)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly =
    zio.aws.dynamodbstreams.model.SequenceNumberRange.wrap(buildAwsValue())
}
object SequenceNumberRange {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.SequenceNumberRange =
      zio.aws.dynamodbstreams.model.SequenceNumberRange(
        startingSequenceNumber.map(value => value),
        endingSequenceNumber.map(value => value)
      )
    def startingSequenceNumber: Option[SequenceNumber]
    def endingSequenceNumber: Option[SequenceNumber]
    def getStartingSequenceNumber: ZIO[Any, AwsError, SequenceNumber] = AwsError
      .unwrapOptionField("startingSequenceNumber", startingSequenceNumber)
    def getEndingSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("endingSequenceNumber", endingSequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange
  ) extends zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly {
    override val startingSequenceNumber: Option[SequenceNumber] = scala
      .Option(impl.startingSequenceNumber())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.SequenceNumber(value)
      )
    override val endingSequenceNumber: Option[SequenceNumber] = scala
      .Option(impl.endingSequenceNumber())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.SequenceNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.SequenceNumberRange
  ): zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly = new Wrapper(
    impl
  )
}
