package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.{
  SequenceNumber,
  ShardId,
  StreamArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetShardIteratorRequest(
    streamArn: StreamArn,
    shardId: ShardId,
    shardIteratorType: zio.aws.dynamodbstreams.model.ShardIteratorType,
    sequenceNumber: Option[SequenceNumber] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest = {
    import GetShardIteratorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest
      .builder()
      .streamArn(StreamArn.unwrap(streamArn): java.lang.String)
      .shardId(ShardId.unwrap(shardId): java.lang.String)
      .shardIteratorType(shardIteratorType.unwrap)
      .optionallyWith(
        sequenceNumber.map(value =>
          SequenceNumber.unwrap(value): java.lang.String
        )
      )(_.sequenceNumber)
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodbstreams.model.GetShardIteratorRequest.ReadOnly =
    zio.aws.dynamodbstreams.model.GetShardIteratorRequest.wrap(buildAwsValue())
}
object GetShardIteratorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.GetShardIteratorRequest =
      zio.aws.dynamodbstreams.model.GetShardIteratorRequest(
        streamArn,
        shardId,
        shardIteratorType,
        sequenceNumber.map(value => value)
      )
    def streamArn: StreamArn
    def shardId: ShardId
    def shardIteratorType: zio.aws.dynamodbstreams.model.ShardIteratorType
    def sequenceNumber: Option[SequenceNumber]
    def getStreamArn: ZIO[Any, Nothing, StreamArn] = ZIO.succeed(streamArn)
    def getShardId: ZIO[Any, Nothing, ShardId] = ZIO.succeed(shardId)
    def getShardIteratorType
        : ZIO[Any, Nothing, zio.aws.dynamodbstreams.model.ShardIteratorType] =
      ZIO.succeed(shardIteratorType)
    def getSequenceNumber: ZIO[Any, AwsError, SequenceNumber] =
      AwsError.unwrapOptionField("sequenceNumber", sequenceNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest
  ) extends zio.aws.dynamodbstreams.model.GetShardIteratorRequest.ReadOnly {
    override val streamArn: StreamArn =
      zio.aws.dynamodbstreams.model.primitives.StreamArn(impl.streamArn())
    override val shardId: ShardId =
      zio.aws.dynamodbstreams.model.primitives.ShardId(impl.shardId())
    override val shardIteratorType
        : zio.aws.dynamodbstreams.model.ShardIteratorType =
      zio.aws.dynamodbstreams.model.ShardIteratorType
        .wrap(impl.shardIteratorType())
    override val sequenceNumber: Option[SequenceNumber] = scala
      .Option(impl.sequenceNumber())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.SequenceNumber(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest
  ): zio.aws.dynamodbstreams.model.GetShardIteratorRequest.ReadOnly =
    new Wrapper(impl)
}
