package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.ShardId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Shard(
    shardId: Option[ShardId] = None,
    sequenceNumberRange: Option[
      zio.aws.dynamodbstreams.model.SequenceNumberRange
    ] = None,
    parentShardId: Option[ShardId] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Shard = {
    import Shard.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Shard
      .builder()
      .optionallyWith(
        shardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.shardId)
      .optionallyWith(sequenceNumberRange.map(value => value.buildAwsValue()))(
        _.sequenceNumberRange
      )
      .optionallyWith(
        parentShardId.map(value => ShardId.unwrap(value): java.lang.String)
      )(_.parentShardId)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Shard.ReadOnly =
    zio.aws.dynamodbstreams.model.Shard.wrap(buildAwsValue())
}
object Shard {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Shard] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Shard =
      zio.aws.dynamodbstreams.model.Shard(
        shardId.map(value => value),
        sequenceNumberRange.map(value => value.asEditable),
        parentShardId.map(value => value)
      )
    def shardId: Option[ShardId]
    def sequenceNumberRange
        : Option[zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly]
    def parentShardId: Option[ShardId]
    def getShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("shardId", shardId)
    def getSequenceNumberRange: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly
    ] = AwsError.unwrapOptionField("sequenceNumberRange", sequenceNumberRange)
    def getParentShardId: ZIO[Any, AwsError, ShardId] =
      AwsError.unwrapOptionField("parentShardId", parentShardId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Shard
  ) extends zio.aws.dynamodbstreams.model.Shard.ReadOnly {
    override val shardId: Option[ShardId] = scala
      .Option(impl.shardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
    override val sequenceNumberRange
        : Option[zio.aws.dynamodbstreams.model.SequenceNumberRange.ReadOnly] =
      scala
        .Option(impl.sequenceNumberRange())
        .map(value =>
          zio.aws.dynamodbstreams.model.SequenceNumberRange.wrap(value)
        )
    override val parentShardId: Option[ShardId] = scala
      .Option(impl.parentShardId())
      .map(value => zio.aws.dynamodbstreams.model.primitives.ShardId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Shard
  ): zio.aws.dynamodbstreams.model.Shard.ReadOnly = new Wrapper(impl)
}
