package zio.aws.dynamodbstreams.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeStreamResponse(
    streamDescription: Option[zio.aws.dynamodbstreams.model.StreamDescription] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse = {
    import DescribeStreamResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse
      .builder()
      .optionallyWith(streamDescription.map(value => value.buildAwsValue()))(
        _.streamDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly =
    zio.aws.dynamodbstreams.model.DescribeStreamResponse.wrap(buildAwsValue())
}
object DescribeStreamResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.DescribeStreamResponse =
      zio.aws.dynamodbstreams.model.DescribeStreamResponse(
        streamDescription.map(value => value.asEditable)
      )
    def streamDescription
        : Option[zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly]
    def getStreamDescription: ZIO[
      Any,
      AwsError,
      zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly
    ] = AwsError.unwrapOptionField("streamDescription", streamDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse
  ) extends zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly {
    override val streamDescription
        : Option[zio.aws.dynamodbstreams.model.StreamDescription.ReadOnly] =
      scala
        .Option(impl.streamDescription())
        .map(value =>
          zio.aws.dynamodbstreams.model.StreamDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.DescribeStreamResponse
  ): zio.aws.dynamodbstreams.model.DescribeStreamResponse.ReadOnly =
    new Wrapper(impl)
}
