package zio.aws.dynamodbstreams.model
import zio.aws.dynamodbstreams.model.primitives.{TableName, StreamArn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Stream(
    streamArn: Option[StreamArn] = None,
    tableName: Option[TableName] = None,
    streamLabel: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.dynamodb.model.Stream = {
    import Stream.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.Stream
      .builder()
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(streamLabel.map(value => value: java.lang.String))(
        _.streamLabel
      )
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.Stream.ReadOnly =
    zio.aws.dynamodbstreams.model.Stream.wrap(buildAwsValue())
}
object Stream {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dynamodb.model.Stream] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.Stream =
      zio.aws.dynamodbstreams.model.Stream(
        streamArn.map(value => value),
        tableName.map(value => value),
        streamLabel.map(value => value)
      )
    def streamArn: Option[StreamArn]
    def tableName: Option[TableName]
    def streamLabel: Option[String]
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getStreamLabel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("streamLabel", streamLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.Stream
  ) extends zio.aws.dynamodbstreams.model.Stream.ReadOnly {
    override val streamArn: Option[StreamArn] = scala
      .Option(impl.streamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val streamLabel: Option[String] =
      scala.Option(impl.streamLabel()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.Stream
  ): zio.aws.dynamodbstreams.model.Stream.ReadOnly = new Wrapper(impl)
}
