package zio.aws.dynamodbstreams.model
import java.lang.Integer
import zio.aws.dynamodbstreams.model.primitives.{
  StreamArn,
  PositiveIntegerObject,
  TableName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListStreamsRequest(
    tableName: Option[TableName] = None,
    limit: Option[PositiveIntegerObject] = None,
    exclusiveStartStreamArn: Option[StreamArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest = {
    import ListStreamsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
      .builder()
      .optionallyWith(
        tableName.map(value => TableName.unwrap(value): java.lang.String)
      )(_.tableName)
      .optionallyWith(
        limit.map(value => PositiveIntegerObject.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(
        exclusiveStartStreamArn.map(value =>
          StreamArn.unwrap(value): java.lang.String
        )
      )(_.exclusiveStartStreamArn)
      .build()
  }
  def asReadOnly: zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly =
    zio.aws.dynamodbstreams.model.ListStreamsRequest.wrap(buildAwsValue())
}
object ListStreamsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dynamodbstreams.model.ListStreamsRequest =
      zio.aws.dynamodbstreams.model.ListStreamsRequest(
        tableName.map(value => value),
        limit.map(value => value),
        exclusiveStartStreamArn.map(value => value)
      )
    def tableName: Option[TableName]
    def limit: Option[PositiveIntegerObject]
    def exclusiveStartStreamArn: Option[StreamArn]
    def getTableName: ZIO[Any, AwsError, TableName] =
      AwsError.unwrapOptionField("tableName", tableName)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerObject] =
      AwsError.unwrapOptionField("limit", limit)
    def getExclusiveStartStreamArn: ZIO[Any, AwsError, StreamArn] = AwsError
      .unwrapOptionField("exclusiveStartStreamArn", exclusiveStartStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ) extends zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly {
    override val tableName: Option[TableName] = scala
      .Option(impl.tableName())
      .map(value => zio.aws.dynamodbstreams.model.primitives.TableName(value))
    override val limit: Option[PositiveIntegerObject] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.dynamodbstreams.model.primitives.PositiveIntegerObject(value)
      )
    override val exclusiveStartStreamArn: Option[StreamArn] = scala
      .Option(impl.exclusiveStartStreamArn())
      .map(value => zio.aws.dynamodbstreams.model.primitives.StreamArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest
  ): zio.aws.dynamodbstreams.model.ListStreamsRequest.ReadOnly = new Wrapper(
    impl
  )
}
